<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */
defined('ABSPATH') || exit;

get_header('shop');

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */

/**
 * Hook: woocommerce_shop_loop_header.
 *
 * @since 8.6.0
 *
 * @hooked woocommerce_product_taxonomy_archive_header - 10
 */
?>
    <div class="breadcrumbs">
        <div class="container">
            <ul>
                <li><a href="/">Promez</a></li>
                <li>|</li>
                <li><span><?php echo pll_e('Magazin') ?></span></li>
            </ul>
        </div>
    </div>
    <div class="custom_shop_header">

    </div>
    <div class="custom_shop_loop">
        <h1><?php echo pll_e('Magazin') ?></h1>
        <div class="container">

            <?php if (woocommerce_product_loop()) {

            /**
             * Hook: woocommerce_before_shop_loop.
             *
             * @hooked woocommerce_output_all_notices - 10
             * @hooked woocommerce_result_count - 20
             * @hooked woocommerce_catalog_ordering - 30
             */
            ?>
            <div class="loop_wrap">
                <div class="loop_header">
                    <div class="left_side">
                        <div class="filter">
                            <svg width="36" height="36" viewBox="0 0 36 36" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect x="0.5" y="0.5" width="35" height="35" rx="3.5" stroke="#D6D6D6"/>
                                <g clip-path="url(#clip0_26_1893)">
                                    <path d="M14.2491 18.75C14.2491 19.3153 14.0665 19.8654 13.7287 20.3186C13.3909 20.7718 12.9158 21.1038 12.3741 21.2653V26.25C12.3741 26.4489 12.2951 26.6397 12.1544 26.7803C12.0138 26.921 11.823 27 11.6241 27C11.4252 27 11.2344 26.921 11.0938 26.7803C10.9531 26.6397 10.8741 26.4489 10.8741 26.25V21.2653C10.3326 21.1037 9.8577 20.7715 9.52004 20.3184C9.18239 19.8652 9 19.3151 9 18.75C9 18.1849 9.18239 17.6348 9.52004 17.1816C9.8577 16.7285 10.3326 16.3963 10.8741 16.2347V9.75C10.8741 9.55109 10.9531 9.36032 11.0938 9.21967C11.2344 9.07902 11.4252 9 11.6241 9C11.823 9 12.0138 9.07902 12.1544 9.21967C12.2951 9.36032 12.3741 9.55109 12.3741 9.75V16.2347C12.9158 16.3962 13.3909 16.7282 13.7287 17.1814C14.0665 17.6346 14.2491 18.1847 14.2491 18.75ZM19.1241 11.7347V9.75C19.1241 9.55109 19.0451 9.36032 18.9044 9.21967C18.7638 9.07902 18.573 9 18.3741 9C18.1752 9 17.9844 9.07902 17.8438 9.21967C17.7031 9.36032 17.6241 9.55109 17.6241 9.75V11.7347C17.0826 11.8963 16.6077 12.2285 16.27 12.6816C15.9324 13.1348 15.75 13.6849 15.75 14.25C15.75 14.8151 15.9324 15.3652 16.27 15.8184C16.6077 16.2715 17.0826 16.6037 17.6241 16.7653V26.25C17.6241 26.4489 17.7031 26.6397 17.8438 26.7803C17.9844 26.921 18.1752 27 18.3741 27C18.573 27 18.7638 26.921 18.9044 26.7803C19.0451 26.6397 19.1241 26.4489 19.1241 26.25V16.7653C19.6656 16.6037 20.1405 16.2715 20.4782 15.8184C20.8158 15.3652 20.9982 14.8151 20.9982 14.25C20.9982 13.6849 20.8158 13.1348 20.4782 12.6816C20.1405 12.2285 19.6656 11.8963 19.1241 11.7347ZM25.8741 19.2347V9.75C25.8741 9.55109 25.7951 9.36032 25.6544 9.21967C25.5138 9.07902 25.323 9 25.1241 9C24.9252 9 24.7344 9.07902 24.5938 9.21967C24.4531 9.36032 24.3741 9.55109 24.3741 9.75V19.2347C23.8326 19.3963 23.3577 19.7285 23.02 20.1816C22.6824 20.6348 22.5 21.1849 22.5 21.75C22.5 22.3151 22.6824 22.8652 23.02 23.3184C23.3577 23.7715 23.8326 24.1037 24.3741 24.2653V26.25C24.3741 26.4489 24.4531 26.6397 24.5938 26.7803C24.7344 26.921 24.9252 27 25.1241 27C25.323 27 25.5138 26.921 25.6544 26.7803C25.7951 26.6397 25.8741 26.4489 25.8741 26.25V24.2653C26.4156 24.1037 26.8905 23.7715 27.2282 23.3184C27.5658 22.8652 27.7482 22.3151 27.7482 21.75C27.7482 21.1849 27.5658 20.6348 27.2282 20.1816C26.8905 19.7285 26.4156 19.3963 25.8741 19.2347Z"
                                          fill="white"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_26_1893">
                                        <rect width="24" height="24" fill="white" transform="translate(6 6)"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </div>
                        <div class="filer_modal">
                            <div class="filter_modal_header">
                                <span><?php echo pll_e('Filtrează după') ?></span>
                                <div class="close">
                                    <img src="/wp-content/themes/victor-child/assets/img/close.png" alt="close.png">
                                </div>
                            </div>
                            <?php
                            if (pll_current_language() == 'de') {
                                echo do_shortcode('[br_filters_group group_id=768]');
                            } elseif (pll_current_language() == 'en') {
                                echo do_shortcode('[br_filters_group group_id=773]');
                            } else {
                                echo do_shortcode('[br_filters_group group_id=236]');
                            }
                            ?>
                        </div>
                    </div>
                    <div class="right_side">
                        <div class="is_in_stock">
                            <input type="checkbox" id="is_in_stock">
                            <label for="is_in_stock">
                                <span><?php echo pll_e('În stoc') ?></span>
                            </label>
                        </div>
                        <?php do_action('woocommerce_before_shop_loop'); ?>
                    </div>
                </div>

                <?php woocommerce_product_loop_start();

                if (wc_get_loop_prop('total')) {
                    while (have_posts()) {
                        the_post();

                        /**
                         * Hook: woocommerce_shop_loop.
                         */
                        do_action('woocommerce_shop_loop');

                        wc_get_template_part('content', 'product');
                    }
                }

                woocommerce_product_loop_end();

                /**
                 * Hook: woocommerce_after_shop_loop.
                 *
                 * @hooked woocommerce_pagination - 10
                 */
                do_action('woocommerce_after_shop_loop');
                } else {
                    /**
                     * Hook: woocommerce_no_products_found.
                     *
                     * @hooked wc_no_products_found - 10
                     */
                    do_action('woocommerce_no_products_found');
                }

                /**
                 * Hook: woocommerce_after_main_content.
                 *
                 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                 */
                do_action('woocommerce_after_main_content');

                /**
                 * Hook: woocommerce_sidebar.
                 *
                 * @hooked woocommerce_get_sidebar - 10
                 */
                ?>
            </div>
        </div>
    </div>
<?php get_template_part('section-newsletter'); ?>

<?php get_footer('shop');
