<?php
/**
 * Displays the site header.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

$wrapper_classes = 'site-header';
$wrapper_classes .= has_custom_logo() ? ' has-logo' : '';
$wrapper_classes .= (true === get_theme_mod('display_title_and_tagline', true)) ? ' has-title-and-tagline' : '';
$wrapper_classes .= has_nav_menu('primary') ? ' has-menu' : '';
?>

<header id="masthead" class="<?php echo esc_attr($wrapper_classes); ?>">
    <div class="container">
        <div class="header_content">
            <div class="left_side">
                <div class="burger">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
                        <path d="M18 7C18 7.19891 17.921 7.38968 17.7803 7.53033C17.6397 7.67098 17.4489 7.75 17.25 7.75H0.75C0.551088 7.75 0.360322 7.67098 0.21967 7.53033C0.0790178 7.38968 0 7.19891 0 7C0 6.80109 0.0790178 6.61032 0.21967 6.46967C0.360322 6.32902 0.551088 6.25 0.75 6.25H17.25C17.4489 6.25 17.6397 6.32902 17.7803 6.46967C17.921 6.61032 18 6.80109 18 7ZM0.75 1.75H17.25C17.4489 1.75 17.6397 1.67098 17.7803 1.53033C17.921 1.38968 18 1.19891 18 1C18 0.801088 17.921 0.610322 17.7803 0.46967C17.6397 0.329018 17.4489 0.25 17.25 0.25H0.75C0.551088 0.25 0.360322 0.329018 0.21967 0.46967C0.0790178 0.610322 0 0.801088 0 1C0 1.19891 0.0790178 1.38968 0.21967 1.53033C0.360322 1.67098 0.551088 1.75 0.75 1.75ZM17.25 12.25H0.75C0.551088 12.25 0.360322 12.329 0.21967 12.4697C0.0790178 12.6103 0 12.8011 0 13C0 13.1989 0.0790178 13.3897 0.21967 13.5303C0.360322 13.671 0.551088 13.75 0.75 13.75H17.25C17.4489 13.75 17.6397 13.671 17.7803 13.5303C17.921 13.3897 18 13.1989 18 13C18 12.8011 17.921 12.6103 17.7803 12.4697C17.6397 12.329 17.4489 12.25 17.25 12.25Z"
                              fill="white"/>
                    </svg>
                    <span><?php echo pll_e('Meniu') ?></span>
                </div>
                <div class="search">
                    <?php echo do_shortcode('[fibosearch]'); ?>
                </div>
            </div>
            <?php get_template_part('template-parts/header/site-branding'); ?>
            <div class="header_actions">
                <?php global $current_user;
                wp_get_current_user();
                if (is_user_logged_in()) { ?>
                    <div class="my_account_header">
                        <svg xmlns="http://www.w3.org/2000/svg" class="my_account_header_svg" width="29" height="34"
                             viewBox="0 0 29 34"
                             fill="none">
                            <path d="M14.3517 17.5891C19.0707 17.5891 22.8962 13.7635 22.8962 9.04453C22.8962 4.32552 19.0707 0.5 14.3517 0.5C9.63264 0.5 5.80713 4.32552 5.80713 9.04453C5.80713 13.7635 9.63264 17.5891 14.3517 17.5891Z"
                                  fill="white"/>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M28.4574 33.5V27.9388C28.4574 23.7062 24.9936 20.2424 20.761 20.2424H7.94634C3.71377 20.2424 0.25 23.7062 0.25 27.9388V33.5H28.4616H28.4574Z"
                                  fill="white"/>
                        </svg>

                        <?php
                        $current_user = wp_get_current_user();
                        $prenume = $current_user->first_name;
                        if (empty($prenume)) {
                            $email = $current_user->user_email;
                            $prenume = strstr($email, '@', true);
                        } ?>
                        <!--                        <span class="label">-->
                        <?php //= $current_user->display_name; ?><!--</span>-->
                        <span class="label"><?= esc_html($prenume); ?></span>
                        <ul class="my_account_sub_menu">
                            <span><?php echo pll_e('Profil') ?></span>
                            <li><a href="<?= pll_e('/contul-meu/edit-account/') ?>"><?php echo pll_e('Setări') ?></a>
                            </li>
                            <li><a href="<?= pll_e('/contul-meu/orders/') ?>"><?php echo pll_e('Comenzi') ?></a></li>
                            <li>
                                <a href="<?= pll_e('/contul-meu/promo-codes/') ?>"><?php echo pll_e('Coduri promoționale') ?></a>
                            </li>
                            <li>
                                <a href="<?php echo wp_logout_url($redirect = '/') ?>"><?php echo pll_e('Ieși din cont') ?></a>
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_339_54604)">
                                        <path d="M14.8172 9.55781C14.8753 9.61586 14.9214 9.68479 14.9529 9.76066C14.9843 9.83654 15.0005 9.91787 15.0005 10C15.0005 10.0821 14.9843 10.1635 14.9529 10.2393C14.9214 10.3152 14.8753 10.3841 14.8172 10.4422L9.19219 16.0672C9.13412 16.1253 9.06518 16.1713 8.98931 16.2027C8.91344 16.2342 8.83212 16.2503 8.75 16.2503C8.66788 16.2503 8.58656 16.2342 8.51069 16.2027C8.43482 16.1713 8.36588 16.1253 8.30781 16.0672C8.24974 16.0091 8.20368 15.9402 8.17225 15.8643C8.14083 15.7884 8.12465 15.7071 8.12465 15.625C8.12465 15.5429 8.14083 15.4616 8.17225 15.3857C8.20368 15.3098 8.24974 15.2409 8.30781 15.1828L12.8664 10.625H2.5C2.33424 10.625 2.17527 10.5592 2.05806 10.4419C1.94085 10.3247 1.875 10.1658 1.875 10C1.875 9.83424 1.94085 9.67527 2.05806 9.55806C2.17527 9.44085 2.33424 9.375 2.5 9.375H12.8664L8.30781 4.81719C8.19054 4.69991 8.12465 4.54085 8.12465 4.375C8.12465 4.20915 8.19054 4.05009 8.30781 3.93281C8.42509 3.81554 8.58415 3.74965 8.75 3.74965C8.91585 3.74965 9.07491 3.81554 9.19219 3.93281L14.8172 9.55781ZM16.875 2.5C16.7092 2.5 16.5503 2.56585 16.4331 2.68306C16.3158 2.80027 16.25 2.95924 16.25 3.125V16.875C16.25 17.0408 16.3158 17.1997 16.4331 17.3169C16.5503 17.4342 16.7092 17.5 16.875 17.5C17.0408 17.5 17.1997 17.4342 17.3169 17.3169C17.4342 17.1997 17.5 17.0408 17.5 16.875V3.125C17.5 2.95924 17.4342 2.80027 17.3169 2.68306C17.1997 2.56585 17.0408 2.5 16.875 2.5Z"
                                              fill="#222222"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_339_54604">
                                            <rect width="20" height="20" fill="white"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </li>
                        </ul>
                    </div>

                <?php } else { ?>
                    <a href="#" class="my_account_header open_login_modal">
                        <svg xmlns="http://www.w3.org/2000/svg" width="29" height="34" viewBox="0 0 29 34" fill="none">
                            <path d="M14.3517 17.5891C19.0707 17.5891 22.8962 13.7635 22.8962 9.04453C22.8962 4.32552 19.0707 0.5 14.3517 0.5C9.63264 0.5 5.80713 4.32552 5.80713 9.04453C5.80713 13.7635 9.63264 17.5891 14.3517 17.5891Z"
                                  fill="white"/>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M28.4574 33.5V27.9388C28.4574 23.7062 24.9936 20.2424 20.761 20.2424H7.94634C3.71377 20.2424 0.25 23.7062 0.25 27.9388V33.5H28.4616H28.4574Z"
                                  fill="white"/>
                        </svg>
                        <span><?php echo pll_e('Log in'); ?></span>
                    </a>
                <?php } ?>

                <div class="cart_header">
                    <svg class="header_img" xmlns="http://www.w3.org/2000/svg" width="44" height="44"
                         viewBox="0 0 44 44" fill="none">
                        <path d="M2.82406 7.71062C2.02375 7.71062 1.375 7.06188 1.375 6.26156C1.375 5.46125 2.02375 4.8125 2.82406 4.8125H9.41931C10.1171 4.8125 10.6998 5.30576 10.8377 5.96234L12.0071 10.3259H41.0184C41.5338 10.3259 41.9774 10.5467 42.2891 10.9576C42.6007 11.3685 42.6928 11.8553 42.553 12.3518L39.372 23.6568C39.1904 24.3023 38.6586 24.7472 37.9909 24.8119L16.4464 26.8914L17.0684 29.2133H38.1C38.9003 29.2133 39.549 29.862 39.549 30.6623C39.549 31.4627 38.9003 32.1114 38.1 32.1114H15.9577V32.1094C15.3181 32.1101 14.7327 31.6828 14.5596 31.0354L8.30932 7.70997H2.82471L2.82406 7.71062ZM34.2075 33.5324C35.7689 33.5324 37.0351 34.7985 37.0351 36.3599C37.0351 37.9214 35.7689 39.1875 34.2075 39.1875C32.6461 39.1875 31.38 37.9214 31.38 36.3599C31.38 34.7985 32.6461 33.5324 34.2075 33.5324ZM19.3301 33.5324C20.8916 33.5324 22.1577 34.7985 22.1577 36.3599C22.1577 37.9214 20.8916 39.1875 19.3301 39.1875C17.7687 39.1875 16.5026 37.9214 16.5026 36.3599C16.5026 34.7985 17.7687 33.5324 19.3301 33.5324Z"
                              fill="white"/>
                    </svg>
                    <?php
                    $cart_count = WC()->cart->get_cart_contents_count();
                    function get_distinct_cart_items_count()
                    {
                        // Obține toate elementele din coș
                        $cart_items = WC()->cart->get_cart();

                        // Returnează numărul de produse distincte
                        return count($cart_items);
                    }

                    ?>
                    <span class="count"><?php echo $cart_count ?></span>
                    <?php $cart_total = WC()->cart->get_cart_total() ?>
                    <span class="toatal 111"><?php echo $cart_total ?></span>
                    <div class="mini_cart">

                        <div class="mini_cart_header">
                            <span> <span><?php echo $cart_count ?></span> <?php echo pll_e('Produse') ?></span>
                            <div class="close">
                                <img src="/wp-content/themes/victor-child/assets/img/close.png" alt="close.png">
                            </div>
                        </div>
                        <div class="prev">
                            <img src="/wp-content/themes/victor-child/assets/img/minicart_arrow.svg" alt="">
                        </div>
                        <!--                        --><?php
                        //                        if (get_distinct_cart_items_count() > 2) { ?>
                        <!--                        --><?php //} ?>

                        <div class="mini_cart_body">
                            <?php woocommerce_mini_cart(); ?>
                        </div>

                        <div class="next">
                            <img src="/wp-content/themes/victor-child/assets/img/minicart_arrow.svg" alt="">
                        </div>
                        <!--                        --><?php
                        //                        if (get_distinct_cart_items_count() > 2) { ?>
                        <!--                      -->
                        <!--                        --><?php //} ?>
                    </div>
                </div>
                <?php if (has_nav_menu('lang-menu')) : ?>
                    <nav id="lang-navigation" class="lang_navigation"
                         aria-label="<?php esc_attr_e('Primary menu', 'twentytwentyone'); ?>">
                        <?php
                        wp_nav_menu(
                            array(
                                'theme_location' => 'lang-menu',
                                'menu_class' => 'menu-wrapper',
                                'container_class' => 'lang-menu-container',
                                'items_wrap' => '<ul id="lang-menu-list" class="%2$s">%3$s</ul>',
                                'fallback_cb' => false,
                            )
                        );
                        ?>
                    </nav><!-- #site-navigation -->
                <?php endif; ?>
                <a href="<?php echo pll_e('/magazin/') ?>" class="go_to_shop"><?php echo pll_e('Magazin') ?></a>
            </div>
        </div>
    </div>
    <div class="header_sidebar">
        <div class="top_header_sidebar">
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2806 18.2193C19.3502 18.289 19.4055 18.3717 19.4432 18.4628C19.4809 18.5538 19.5003 18.6514 19.5003 18.7499C19.5003 18.8485 19.4809 18.9461 19.4432 19.0371C19.4055 19.1281 19.3502 19.2109 19.2806 19.2806C19.2109 19.3502 19.1281 19.4055 19.0371 19.4432C18.9461 19.4809 18.8485 19.5003 18.7499 19.5003C18.6514 19.5003 18.5538 19.4809 18.4628 19.4432C18.3717 19.4055 18.289 19.3502 18.2193 19.2806L11.9999 13.0602L5.78055 19.2806C5.63982 19.4213 5.44895 19.5003 5.24993 19.5003C5.05091 19.5003 4.86003 19.4213 4.7193 19.2806C4.57857 19.1398 4.49951 18.949 4.49951 18.7499C4.49951 18.5509 4.57857 18.36 4.7193 18.2193L10.9396 11.9999L4.7193 5.78055C4.57857 5.63982 4.49951 5.44895 4.49951 5.24993C4.49951 5.05091 4.57857 4.86003 4.7193 4.7193C4.86003 4.57857 5.05091 4.49951 5.24993 4.49951C5.44895 4.49951 5.63982 4.57857 5.78055 4.7193L11.9999 10.9396L18.2193 4.7193C18.36 4.57857 18.5509 4.49951 18.7499 4.49951C18.949 4.49951 19.1398 4.57857 19.2806 4.7193C19.4213 4.86003 19.5003 5.05091 19.5003 5.24993C19.5003 5.44895 19.4213 5.63982 19.2806 5.78055L13.0602 11.9999L19.2806 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
            <div class="mobile_top_header">
                <?php if (has_nav_menu('lang-menu')) : ?>
                    <nav id="lang-navigation" class="lang_navigation"
                         aria-label="<?php esc_attr_e('Primary menu', 'twentytwentyone'); ?>">
                        <?php
                        wp_nav_menu(
                            array(
                                'theme_location' => 'lang-menu',
                                'menu_class' => 'menu-wrapper',
                                'container_class' => 'lang-menu-container',
                                'items_wrap' => '<ul id="lang-menu-list" class="%2$s">%3$s</ul>',
                                'fallback_cb' => false,
                            )
                        );
                        ?>
                    </nav><!-- #site-navigation -->
                <?php endif; ?>
            </div>
        </div>
        <div class="sidebar_content">

            <div class="search">
                <?php echo do_shortcode('[fibosearch]'); ?>
            </div>
            <?php get_template_part('template-parts/header/site-nav'); ?>
            <div class="social">
                <a href="https://chat.whatsapp.com/I9azZsgOSXe7UMFsNkjvxV" target="_blank">
                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                        <path d="M0.5 35.9976L3.0305 26.7531C1.469 24.0471 0.6485 20.9796 0.65 17.8341C0.6545 8.00006 8.657 -0.00244141 18.4895 -0.00244141C23.261 -0.000941406 27.74 1.85756 31.109 5.22956C34.4765 8.60156 36.3305 13.0836 36.329 17.8506C36.3245 27.6861 28.322 35.6886 18.4895 35.6886C15.5045 35.6871 12.563 34.9386 9.9575 33.5166L0.5 35.9976ZM10.3955 30.2871C12.9095 31.7796 15.3095 32.6736 18.4835 32.6751C26.6555 32.6751 33.3125 26.0241 33.317 17.8476C33.32 9.65456 26.6945 3.01256 18.4955 3.00956C10.3175 3.00956 3.665 9.66056 3.662 17.8356C3.6605 21.1731 4.6385 23.6721 6.281 26.2866L4.7825 31.7586L10.3955 30.2871ZM27.476 22.0911C27.365 21.9051 27.068 21.7941 26.621 21.5706C26.1755 21.3471 23.984 20.2686 23.5745 20.1201C23.1665 19.9716 22.8695 19.8966 22.571 20.3436C22.274 20.7891 21.419 21.7941 21.1595 22.0911C20.9 22.3881 20.639 22.4256 20.1935 22.2021C19.748 21.9786 18.311 21.5091 16.6085 19.9896C15.284 18.8076 14.3885 17.3481 14.129 16.9011C13.8695 16.4556 14.102 16.2141 14.324 15.9921C14.525 15.7926 14.7695 15.4716 14.993 15.2106C15.2195 14.9526 15.293 14.7666 15.443 14.4681C15.5915 14.1711 15.518 13.9101 15.4055 13.6866C15.293 13.4646 14.402 11.2701 14.0315 10.3776C13.6685 9.50906 13.301 9.62606 13.028 9.61256L12.173 9.59756C11.876 9.59756 11.393 9.70856 10.985 10.1556C10.577 10.6026 9.425 11.6796 9.425 13.8741C9.425 16.0686 11.0225 18.1881 11.2445 18.4851C11.468 18.7821 14.387 23.2851 18.8585 25.2156C19.922 25.6746 20.753 25.9491 21.3995 26.1546C22.4675 26.4936 23.4395 26.4456 24.2075 26.3316C25.064 26.2041 26.8445 25.2531 27.2165 24.2121C27.5885 23.1696 27.5885 22.2771 27.476 22.0911Z"
                              fill="#727272"/>
                    </svg>
                </a>
                <a href="https://www.facebook.com/promez.ro/" target="_blank">
                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                        <g clip-path="url(#clip0_556_1302)">
                            <path d="M18.5 -0.00244141C8.55896 -0.00244141 0.5 8.05652 0.5 17.9976C0.5 26.4388 6.31184 33.5222 14.1519 35.4676V23.4984H10.4403V17.9976H14.1519V15.6273C14.1519 9.50084 16.9246 6.66116 22.9395 6.66116C24.08 6.66116 26.0478 6.88508 26.8527 7.10828V12.0943C26.4279 12.0496 25.6899 12.0273 24.7734 12.0273C21.8221 12.0273 20.6816 13.1455 20.6816 16.0521V17.9976H26.5611L25.551 23.4984H20.6816V35.8658C29.5945 34.7894 36.5007 27.2006 36.5007 17.9976C36.5 8.05652 28.441 -0.00244141 18.5 -0.00244141Z"
                                  fill="#727272"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_556_1302">
                                <rect width="36" height="36" fill="white" transform="translate(0.5 -0.00244141)"/>
                            </clipPath>
                        </defs>
                    </svg>
                </a>
                <a href="https://www.instagram.com/promez.ro/" target="_blank">
                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                        <g clip-path="url(#clip0_556_1304)">
                            <path d="M18.5 3.23896C23.3094 3.23896 23.8789 3.26006 25.7703 3.34443C27.5281 3.42178 28.4773 3.71709 29.1102 3.96318C29.9469 4.28662 30.5516 4.68037 31.1773 5.30615C31.8102 5.93896 32.1969 6.53662 32.5203 7.37334C32.7664 8.00615 33.0617 8.9624 33.1391 10.7132C33.2234 12.6116 33.2445 13.1812 33.2445 17.9835C33.2445 22.7929 33.2234 23.3624 33.1391 25.2538C33.0617 27.0116 32.7664 27.9608 32.5203 28.5937C32.1969 29.4304 31.8031 30.0351 31.1773 30.6608C30.5445 31.2937 29.9469 31.6804 29.1102 32.0038C28.4773 32.2499 27.5211 32.5452 25.7703 32.6226C23.8719 32.7069 23.3023 32.728 18.5 32.728C13.6906 32.728 13.1211 32.7069 11.2297 32.6226C9.47188 32.5452 8.52266 32.2499 7.88984 32.0038C7.05313 31.6804 6.44844 31.2866 5.82266 30.6608C5.18984 30.028 4.80312 29.4304 4.47969 28.5937C4.23359 27.9608 3.93828 27.0046 3.86094 25.2538C3.77656 23.3554 3.75547 22.7858 3.75547 17.9835C3.75547 13.1741 3.77656 12.6046 3.86094 10.7132C3.93828 8.95537 4.23359 8.00615 4.47969 7.37334C4.80312 6.53662 5.19688 5.93193 5.82266 5.30615C6.45547 4.67334 7.05313 4.28662 7.88984 3.96318C8.52266 3.71709 9.47891 3.42178 11.2297 3.34443C13.1211 3.26006 13.6906 3.23896 18.5 3.23896ZM18.5 -0.00244141C13.6133 -0.00244141 13.0016 0.0186523 11.082 0.103027C9.16953 0.187402 7.85469 0.496777 6.71563 0.939746C5.52734 1.40381 4.52188 2.01553 3.52344 3.021C2.51797 4.01943 1.90625 5.0249 1.44219 6.20615C0.999219 7.35225 0.689844 8.66006 0.605469 10.5726C0.521094 12.4991 0.5 13.1108 0.5 17.9976C0.5 22.8843 0.521094 23.496 0.605469 25.4155C0.689844 27.328 0.999219 28.6429 1.44219 29.7819C1.90625 30.9702 2.51797 31.9757 3.52344 32.9741C4.52188 33.9726 5.52734 34.5913 6.70859 35.0483C7.85469 35.4913 9.1625 35.8007 11.075 35.8851C12.9945 35.9694 13.6062 35.9905 18.493 35.9905C23.3797 35.9905 23.9914 35.9694 25.9109 35.8851C27.8234 35.8007 29.1383 35.4913 30.2773 35.0483C31.4586 34.5913 32.4641 33.9726 33.4625 32.9741C34.4609 31.9757 35.0797 30.9702 35.5367 29.789C35.9797 28.6429 36.2891 27.3351 36.3734 25.4226C36.4578 23.503 36.4789 22.8913 36.4789 18.0046C36.4789 13.1179 36.4578 12.5062 36.3734 10.5866C36.2891 8.67412 35.9797 7.35928 35.5367 6.22021C35.0938 5.0249 34.482 4.01943 33.4766 3.021C32.4781 2.02256 31.4727 1.40381 30.2914 0.946777C29.1453 0.503808 27.8375 0.194434 25.925 0.110059C23.9984 0.0186523 23.3867 -0.00244141 18.5 -0.00244141Z"
                                  fill="white"/>
                            <path d="M18.5 8.75146C13.3953 8.75146 9.25391 12.8929 9.25391 17.9976C9.25391 23.1022 13.3953 27.2437 18.5 27.2437C23.6047 27.2437 27.7461 23.1022 27.7461 17.9976C27.7461 12.8929 23.6047 8.75146 18.5 8.75146ZM18.5 23.9952C15.1883 23.9952 12.5023 21.3093 12.5023 17.9976C12.5023 14.6858 15.1883 11.9999 18.5 11.9999C21.8117 11.9999 24.4977 14.6858 24.4977 17.9976C24.4977 21.3093 21.8117 23.9952 18.5 23.9952Z"
                                  fill="white"/>
                            <path d="M30.2703 8.38589C30.2703 9.58121 29.3 10.5445 28.1117 10.5445C26.9164 10.5445 25.9531 9.57417 25.9531 8.38589C25.9531 7.19058 26.9234 6.22729 28.1117 6.22729C29.3 6.22729 30.2703 7.19761 30.2703 8.38589Z"
                                  fill="white"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_556_1304">
                                <rect width="36" height="36" fill="white" transform="translate(0.5 -0.00244141)"/>
                            </clipPath>
                        </defs>
                    </svg>
                </a>
                <a href="#">
                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                        <g clip-path="url(#clip0_556_1310)">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M36.5 17.9976C36.5 27.9387 28.4411 35.9976 18.5 35.9976C8.55888 35.9976 0.5 27.9387 0.5 17.9976C0.5 8.05643 8.55888 -0.00244141 18.5 -0.00244141C28.4411 -0.00244141 36.5 8.05643 36.5 17.9976ZM19.145 13.286C17.3943 14.0142 13.8952 15.5214 8.64784 17.8075C7.79575 18.1464 7.34939 18.4779 7.30875 18.802C7.24008 19.3498 7.92607 19.5655 8.8602 19.8592C8.98727 19.8992 9.11893 19.9406 9.25391 19.9845C10.173 20.2832 11.4092 20.6327 12.0519 20.6466C12.6349 20.6592 13.2856 20.4189 14.004 19.9256C18.9067 16.6161 21.4376 14.9433 21.5965 14.9072C21.7086 14.8818 21.8639 14.8498 21.9691 14.9433C22.0744 15.0369 22.0641 15.214 22.0529 15.2616C21.9849 15.5513 19.2922 18.0547 17.8987 19.3502C17.4643 19.7541 17.1561 20.0406 17.0931 20.106C16.952 20.2526 16.8082 20.3912 16.67 20.5245C15.8162 21.3475 15.1759 21.9648 16.7054 22.9727C17.4405 23.4571 18.0286 23.8577 18.6154 24.2573C19.2563 24.6937 19.8954 25.129 20.7224 25.6711C20.9331 25.8092 21.1343 25.9526 21.3303 26.0924C22.0761 26.624 22.7461 27.1017 23.5739 27.0255C24.0549 26.9812 24.5517 26.529 24.804 25.1801C25.4003 21.9923 26.5724 15.0852 26.8433 12.239C26.8671 11.9897 26.8372 11.6705 26.8132 11.5304C26.7893 11.3903 26.7392 11.1907 26.557 11.043C26.3414 10.868 26.0085 10.8311 25.8595 10.8337C25.1825 10.8456 24.1438 11.2068 19.145 13.286Z"
                                  fill="#727272"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_556_1310">
                                <rect width="36" height="36" fill="white" transform="translate(0.5 -0.00244141)"/>
                            </clipPath>
                        </defs>
                    </svg>
                </a>
            </div>
            <div class="images">
                <svg xmlns="http://www.w3.org/2000/svg" width="51" height="30" viewBox="0 0 51 30" fill="none">
                    <path d="M50.4548 14.9976C50.4548 23.2283 43.7625 29.9976 35.4548 29.9976C27.2241 29.9976 20.4548 23.2283 20.4548 14.9976C20.4548 6.76679 27.1471 -0.00244141 35.3779 -0.00244141C43.7625 -0.00244141 50.4548 6.76679 50.4548 14.9976Z"
                          fill="#F9B50B"/>
                    <path d="M30.3774 15.0745C30.3774 13.9976 30.2236 12.9206 30.0697 11.9206H20.839C20.9159 11.3822 21.0697 10.9206 21.2236 10.3053H29.4543C29.3005 9.76679 29.0697 9.22833 28.839 8.68987H21.839C22.0697 8.15141 22.3774 7.68987 22.6851 7.07448H27.9928C27.6851 6.53602 27.3005 5.99756 26.839 5.4591H23.9159C24.3774 4.92064 24.839 4.4591 25.4543 3.92064C22.839 1.4591 19.3005 -0.00244141 15.3774 -0.00244141C7.22358 0.228328 0.454346 6.76679 0.454346 14.9976C0.454346 23.2283 7.14665 29.9976 15.4543 29.9976C19.3774 29.9976 22.839 28.4591 25.5313 26.0745C26.0697 25.6129 26.5313 25.0745 27.0697 24.4591H23.9928C23.6082 23.9976 23.2236 23.4591 22.9159 22.9206H28.1467C28.4543 22.4591 28.762 21.9206 28.9928 21.3053H21.9928C21.762 20.8437 21.5313 20.3053 21.3774 19.6899H29.6082C30.0697 18.3053 30.3774 16.7668 30.3774 15.0745Z"
                          fill="#C8191C"/>
                    <path d="M20.7628 18.844L20.9935 17.4594C20.9166 17.4594 20.7628 17.5363 20.6089 17.5363C20.0705 17.5363 19.9935 17.2286 20.0705 17.0748L20.532 14.3055H21.3782L21.6089 12.7671H20.8397L20.9935 11.844H19.3782C19.3782 11.844 18.4551 17.0748 18.4551 17.6901C18.4551 18.6132 18.9935 19.0748 19.7628 19.0748C20.2243 19.0748 20.6089 18.9209 20.7628 18.844Z"
                          fill="white"/>
                    <path d="M21.2996 16.3051C21.2996 18.5358 22.838 19.0743 24.0688 19.0743C25.2226 19.0743 25.7611 18.8435 25.7611 18.8435L26.0688 17.3051C26.0688 17.3051 25.2226 17.6897 24.3765 17.6897C22.6073 17.6897 22.9149 16.382 22.9149 16.382H26.1457C26.1457 16.382 26.3765 15.382 26.3765 14.9205C26.3765 13.9205 25.838 12.6128 24.0688 12.6128C22.5303 12.5358 21.2996 14.3051 21.2996 16.3051ZM24.0688 13.9974C24.9149 13.9974 24.7611 14.9974 24.7611 15.0743H22.9919C23.0688 14.9974 23.2226 13.9974 24.0688 13.9974Z"
                          fill="white"/>
                    <path d="M34.1468 18.8434L34.4545 17.0742C34.4545 17.0742 33.6853 17.4588 33.0699 17.4588C31.993 17.4588 31.4545 16.6127 31.4545 15.6127C31.4545 13.6896 32.3776 12.6896 33.5314 12.6896C34.3007 12.6896 34.993 13.1511 34.993 13.1511L35.2237 11.4588C35.2237 11.4588 34.3007 11.0742 33.3776 11.0742C31.5314 11.0742 29.7622 12.6896 29.7622 15.6896C29.7622 17.6896 30.6853 18.9973 32.6084 18.9973C33.3007 19.0742 34.1468 18.8434 34.1468 18.8434Z"
                          fill="white"/>
                    <path d="M12.0701 12.5361C10.9931 12.5361 10.147 12.8438 10.147 12.8438L9.91622 14.2284C9.91622 14.2284 10.6085 13.9207 11.6855 13.9207C12.2239 13.9207 12.6855 13.9977 12.6855 14.4592C12.6855 14.7669 12.6085 14.8438 12.6085 14.8438H11.9162C10.5316 14.8438 9.07007 15.3823 9.07007 17.2284C9.07007 18.69 9.99315 18.9977 10.6085 18.9977C11.6855 18.9977 12.2239 18.3054 12.3008 18.3054L12.2239 18.9207H13.5316L14.147 14.5361C14.147 12.6131 12.6085 12.5361 12.0701 12.5361ZM12.3778 16.0746C12.3778 16.3054 12.2239 17.6131 11.3008 17.6131C10.8393 17.6131 10.6855 17.2284 10.6855 16.9977C10.6855 16.6131 10.9162 16.0746 12.147 16.0746C12.3008 16.0746 12.3778 16.0746 12.3778 16.0746Z"
                          fill="white"/>
                    <path d="M15.6848 18.9977C16.0694 18.9977 18.0694 19.0746 18.0694 16.9208C18.0694 14.9208 16.1463 15.3054 16.1463 14.5362C16.1463 14.1515 16.454 13.9977 16.9925 13.9977C17.2233 13.9977 18.0694 14.0746 18.0694 14.0746L18.3002 12.6131C18.3002 12.6131 17.7617 12.4592 16.7617 12.4592C15.6079 12.4592 14.3771 12.9208 14.3771 14.5362C14.3771 16.3823 16.3771 16.2285 16.3771 16.9208C16.3771 17.3823 15.8386 17.4592 15.454 17.4592C14.7617 17.4592 13.9925 17.2285 13.9925 17.2285L13.7617 18.69C13.9156 18.8438 14.3771 18.9977 15.6848 18.9977Z"
                          fill="white"/>
                    <path d="M47.3771 11.3057L47.0694 13.4595C47.0694 13.4595 46.454 12.6903 45.5309 12.6903C44.0694 12.6903 42.8386 14.4595 42.8386 16.5364C42.8386 17.8441 43.454 19.1518 44.8386 19.1518C45.7617 19.1518 46.3771 18.5364 46.3771 18.5364L46.3002 19.0749H47.9155L49.0694 11.4595L47.3771 11.3057ZM46.6079 15.4595C46.6079 16.3057 46.2232 17.4595 45.3002 17.4595C44.7617 17.4595 44.454 16.998 44.454 16.1518C44.454 14.8441 44.9925 14.0749 45.7617 14.0749C46.3002 14.1518 46.6079 14.5364 46.6079 15.4595Z"
                          fill="white"/>
                    <path d="M3.37635 18.921L4.29943 13.2287L4.45327 18.921H5.5302L7.60712 13.2287L6.76097 18.921H8.45327L9.76097 11.3057H7.14558L5.5302 15.998L5.45327 11.3057H3.14558L1.83789 18.921H3.37635Z"
                          fill="white"/>
                    <path d="M27.9924 18.921C28.4539 16.3056 28.5308 14.1517 29.6847 14.5363C29.8385 13.5363 30.0693 13.0748 30.2231 12.6902H29.9155C29.2231 12.6902 28.6078 13.6133 28.6078 13.6133L28.7616 12.7671H27.2231L26.2231 18.921H27.9924Z"
                          fill="white"/>
                    <path d="M37.8396 12.5361C36.7627 12.5361 35.9165 12.8438 35.9165 12.8438L35.6858 14.2284C35.6858 14.2284 36.3781 13.9207 37.455 13.9207C37.9934 13.9207 38.455 13.9977 38.455 14.4592C38.455 14.7669 38.3781 14.8438 38.3781 14.8438H37.6858C36.3011 14.8438 34.8396 15.3823 34.8396 17.2284C34.8396 18.69 35.7627 18.9977 36.3781 18.9977C37.455 18.9977 37.9934 18.3054 38.0704 18.3054L37.9934 18.9207H39.455L40.0704 14.5361C40.0704 12.6131 38.3781 12.5361 37.8396 12.5361ZM38.2242 16.0746C38.2242 16.3054 38.0704 17.6131 37.1473 17.6131C36.6858 17.6131 36.5319 17.2284 36.5319 16.9977C36.5319 16.6131 36.7627 16.0746 37.9934 16.0746C38.1473 16.0746 38.1473 16.0746 38.2242 16.0746Z"
                          fill="white"/>
                    <path d="M41.3005 18.921C41.762 16.3056 41.8389 14.1517 42.9928 14.5363C43.1466 13.5363 43.3774 13.0748 43.5313 12.6902H43.2236C42.5312 12.6902 41.9159 13.6133 41.9159 13.6133L42.0697 12.7671H40.5312L39.5312 18.921H41.3005Z"
                          fill="white"/>
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" width="103" height="26" viewBox="0 0 103 26" fill="none">
                    <path d="M39.3434 11.2121C39.0788 13.1962 37.4916 13.1962 36.0365 13.1962H35.2429L35.9043 9.36028C35.9043 9.09573 36.1688 8.96345 36.4333 8.96345H36.8302C37.8884 8.96345 38.8143 8.96346 39.3434 9.49255C39.3434 10.0217 39.3434 10.5507 39.3434 11.2121ZM38.682 5.92114H32.9942C32.5974 5.92114 32.3329 6.18569 32.2006 6.58251L29.9519 21.1327C29.9519 21.3973 30.0842 21.6618 30.481 21.6618H33.1265C33.5233 21.6618 33.7879 21.3973 33.9201 21.0004L34.5815 17.0322C34.5815 16.6354 34.9783 16.3708 35.3752 16.3708H37.227C40.9307 16.3708 43.0471 14.519 43.7084 10.9476C43.973 9.36028 43.7084 8.16981 43.0471 7.24389C41.9889 6.45024 40.5339 5.92114 38.682 5.92114Z"
                          fill="#263577"/>
                    <path d="M51.7777 16.5028C51.5132 18.0901 50.3227 19.1483 48.7354 19.1483C47.9418 19.1483 47.2804 18.8837 46.8836 18.3546C46.4868 17.8255 46.3545 17.1642 46.4868 16.5028C46.7513 14.9155 47.9418 13.8573 49.5291 13.8573C50.3227 13.8573 50.9841 14.1219 51.3809 14.6509C51.6455 15.0478 51.91 15.7091 51.7777 16.5028ZM55.4814 11.2118H52.836C52.5714 11.2118 52.4391 11.3441 52.3068 11.6086L52.1746 12.4023L52.0423 12.1377C51.5132 11.3441 50.1905 10.9473 48.8677 10.9473C45.8254 10.9473 43.3122 13.1959 42.7831 16.3705C42.5185 17.9578 42.9154 19.4128 43.8413 20.471C44.6349 21.3969 45.8254 21.7938 47.2804 21.7938C49.6614 21.7938 50.9841 20.2065 50.9841 20.2065L50.8518 21.0001C50.8518 21.2647 50.9841 21.5292 51.3809 21.5292H53.7619C54.1587 21.5292 54.4232 21.2647 54.5555 20.8679L56.0105 11.6086C56.0105 11.4764 55.8783 11.2118 55.4814 11.2118Z"
                          fill="#263577"/>
                    <path d="M69.8994 11.2119H67.1216C66.857 11.2119 66.5925 11.3442 66.4602 11.6087L62.7565 17.1643L61.1692 11.8733C61.037 11.4765 60.7724 11.3442 60.3756 11.3442H57.7301C57.4655 11.3442 57.201 11.6087 57.3333 12.0056L60.3756 20.7357L57.5978 24.7039C57.3333 24.9685 57.5978 25.4976 57.9947 25.4976H60.7724C61.037 25.4976 61.3015 25.3653 61.4338 25.1007L70.4284 12.0056C70.5607 11.6087 70.2962 11.2119 69.8994 11.2119Z"
                          fill="#263577"/>
                    <path d="M79.5551 11.2121C79.2905 13.1962 77.7032 13.1962 76.2482 13.1962H75.4546L76.1159 9.36028C76.1159 9.09573 76.3805 8.96345 76.6451 8.96345H77.0419C78.1001 8.96345 79.026 8.96346 79.5551 9.49255C79.6873 10.0217 79.6873 10.5507 79.5551 11.2121ZM78.8937 5.92114H73.2059C72.8091 5.92114 72.5445 6.18569 72.4123 6.58251L70.1636 21.1327C70.1636 21.3973 70.2959 21.6618 70.6927 21.6618H73.6027C73.8673 21.6618 74.1318 21.5295 74.1318 21.1327L74.7932 17.0322C74.7932 16.6354 75.19 16.3708 75.5868 16.3708H77.4387C81.1424 16.3708 83.2588 14.519 83.9201 10.9476C84.1847 9.36028 83.9201 8.16981 83.2588 7.24389C82.3329 6.45024 80.8778 5.92114 78.8937 5.92114Z"
                          fill="#2199D6"/>
                    <path d="M92.1215 16.5028C91.8569 18.0901 90.6665 19.1483 89.0792 19.1483C88.2855 19.1483 87.6242 18.8837 87.2274 18.3546C86.8305 17.8255 86.6982 17.1642 86.8305 16.5028C87.0951 14.9155 88.2856 13.8573 89.8728 13.8573C90.6665 13.8573 91.3279 14.1219 91.7247 14.6509C91.9892 15.0478 92.2538 15.7091 92.1215 16.5028ZM95.8252 11.2118H93.1797C92.9152 11.2118 92.7829 11.3441 92.6506 11.6086L92.5183 12.4023L92.3861 12.1377C91.857 11.3441 90.5342 10.9473 89.2115 10.9473C86.1692 10.9473 83.6559 13.1959 83.1268 16.3705C82.8623 17.9578 83.2591 19.4128 84.185 20.471C84.9787 21.3969 86.1691 21.7938 87.6242 21.7938C90.0051 21.7938 91.3278 20.2065 91.3278 20.2065L91.1956 21.0001C91.1956 21.2647 91.3279 21.5292 91.7247 21.5292H94.1056C94.5024 21.5292 94.767 21.2647 94.8993 20.8679L96.3543 11.6086C96.3543 11.4764 96.0897 11.2118 95.8252 11.2118Z"
                          fill="#2199D6"/>
                    <path d="M98.9996 6.31796L96.6187 21.1327C96.6187 21.3973 96.751 21.6618 97.1478 21.6618H99.5287C99.9255 21.6618 100.19 21.3973 100.322 21.0004L102.571 6.45024C102.571 6.18569 102.439 5.92114 102.042 5.92114H99.3964C99.2641 5.92114 99.1319 6.18569 98.9996 6.31796Z"
                          fill="#2199D6"/>
                    <path d="M6.40627 24.4395L6.80308 21.6618H5.87716H1.24756L4.42216 1.42378C4.42216 1.42378 4.42215 1.2915 4.55442 1.2915H4.6867H12.4909C15.0041 1.2915 16.8559 1.8206 17.7819 2.8788C18.1787 3.4079 18.4432 3.93699 18.5755 4.46609C18.7078 5.12746 18.7078 5.78883 18.5755 6.71475V7.24385L18.9723 7.5084C19.3692 7.64068 19.6337 7.90523 19.8983 8.16978C20.2951 8.5666 20.5596 9.0957 20.5596 9.75707C20.6919 10.4184 20.6919 11.2121 20.4274 12.138C20.1628 13.1962 19.8983 13.9898 19.5014 14.7835C19.1046 15.4449 18.5755 15.974 18.0464 16.5031C17.5173 16.8999 16.7237 17.1644 16.0623 17.429C15.2686 17.5613 14.475 17.6935 13.5491 17.6935H12.8877C12.4909 17.6935 12.0941 17.8258 11.6973 18.0904C11.4327 18.3549 11.1682 18.7517 11.0359 19.1486V19.4131L10.2422 24.3073V24.4395V24.5718C10.2422 24.5718 10.2422 24.5718 10.1099 24.5718H6.40627V24.4395Z"
                          fill="#263577"/>
                    <path d="M19.5031 6.71509C19.5031 6.84736 19.5031 6.97964 19.3708 7.11192C18.3126 12.4029 14.8735 14.1225 10.3761 14.1225H8.12746C7.59837 14.1225 7.06928 14.5193 7.06928 15.0484L5.8788 22.4557L5.61426 24.5721C5.61426 24.969 5.8788 25.2335 6.14335 25.2335H10.2439C10.773 25.2335 11.1698 24.8367 11.1698 24.4399V24.1753L11.9634 19.4134V19.1489C12.0957 18.6198 12.4925 18.3552 12.8894 18.3552H13.5507C17.519 18.3552 20.5613 16.7679 21.3549 12.1383C21.7517 10.1542 21.4872 8.56693 20.5613 7.50874C20.2967 7.24419 19.8999 6.97964 19.5031 6.71509Z"
                          fill="#2199D6"/>
                    <path d="M18.4442 6.31796C18.3119 6.31796 18.1797 6.18569 17.9151 6.18569C17.7828 6.18569 17.5183 6.05342 17.386 6.05342C16.7246 5.92114 16.0632 5.92114 15.4019 5.92114H9.31726C9.18499 5.92114 9.05271 5.92114 8.92044 6.05342C8.65589 6.18569 8.39135 6.45024 8.39135 6.71479L7.0686 14.9158V15.1804C7.20088 14.6513 7.59769 14.2544 8.12678 14.2544H10.3755C14.8728 14.2544 18.3119 12.4026 19.3701 7.24389C19.3701 7.11161 19.3701 6.97934 19.5024 6.84706C19.2378 6.71479 18.9733 6.58252 18.7087 6.45024C18.5765 6.31797 18.4442 6.31796 18.4442 6.31796Z"
                          fill="#252C5E"/>
                    <path d="M8.3913 6.7147C8.3913 6.45015 8.65584 6.1856 8.92039 6.05332C9.05266 6.05332 9.18494 5.92105 9.31722 5.92105H15.4018C16.0632 5.92105 16.8568 5.92105 17.3859 6.05332C17.5182 6.05332 17.7828 6.05333 17.9151 6.1856C18.0473 6.1856 18.1796 6.31787 18.4441 6.31787C18.5764 6.31787 18.5764 6.31788 18.7087 6.45015C18.9732 6.58243 19.2378 6.7147 19.5023 6.84697C19.7669 4.86286 19.5023 3.54011 18.4441 2.34964C17.2537 1.0269 15.1373 0.497803 12.4918 0.497803H4.68761C4.15851 0.497803 3.62941 0.894622 3.62941 1.42372L0.454834 21.794C0.454834 22.1908 0.719383 22.5876 1.11621 22.5876H5.87807L7.06856 14.9157L8.3913 6.7147Z"
                          fill="#263577"/>
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" width="82" height="26" viewBox="0 0 82 26" fill="none">
                    <path d="M76.5238 0.854248H71.4047C69.8571 0.854248 68.6666 1.33044 67.9523 2.87806L58.1904 25.14H65.0952C65.0952 25.14 66.2857 22.1638 66.5238 21.4495C67.238 21.4495 74.0238 21.4495 74.9761 21.4495C75.2142 22.2828 75.8095 25.0209 75.8095 25.0209H82L76.5238 0.854248ZM68.4285 16.4495C69.0238 15.0209 71.0476 9.66377 71.0476 9.66377C71.0476 9.78282 71.6428 8.2352 71.8809 7.40187L72.3571 9.54472C72.3571 9.54472 73.6666 15.3781 73.9047 16.5685H68.4285V16.4495Z"
                          fill="#3362AB"/>
                    <path d="M58.6668 17.1642C58.6668 22.1642 54.143 25.4976 47.1192 25.4976C44.143 25.4976 41.2859 24.9023 39.7383 24.188L40.6907 18.7118L41.524 19.069C43.6669 20.0214 45.0954 20.3785 47.7145 20.3785C49.6192 20.3785 51.643 19.6642 51.643 17.9976C51.643 16.9261 50.8097 16.2118 48.1907 15.0214C45.6907 13.8309 42.3573 11.9261 42.3573 8.47375C42.3573 3.71184 47.0002 0.497559 53.5478 0.497559C56.0478 0.497559 58.1907 0.973749 59.5002 1.56899L58.5478 6.80708L58.0716 6.33089C56.8811 5.8547 55.3335 5.37851 53.0716 5.37851C50.5716 5.49756 49.3811 6.56899 49.3811 7.52137C49.3811 8.5928 50.8097 9.42613 53.0716 10.4976C56.8811 12.2833 58.6668 14.3071 58.6668 17.1642Z"
                          fill="#3362AB"/>
                    <path d="M0.571045 1.09313L0.690093 0.616943H10.9282C12.3568 0.616943 13.4282 1.09313 13.7853 2.64075L16.0472 13.355C13.7853 7.64075 8.54724 2.9979 0.571045 1.09313Z"
                          fill="#F9B50B"/>
                    <path d="M30.4515 0.854887L20.0944 25.0216H13.0705L7.11816 4.78346C11.4039 7.52155 14.9753 11.8073 16.2848 14.7835L16.9991 17.2835L23.4277 0.73584H30.4515V0.854887Z"
                          fill="#3362AB"/>
                    <path d="M33.1906 0.73584H39.7382L35.5715 25.0216H29.0239L33.1906 0.73584Z" fill="#3362AB"/>
                </svg>
            </div>
            <?php if (has_nav_menu('privacy_policy')) : ?>
                <nav id="site-navigation" class="privacy-navigation"
                     aria-label="<?php esc_attr_e('Footer menu', 'twentytwentyone'); ?>">
                    <?php

                    wp_nav_menu(
                        array(
                            'theme_location' => 'privacy_policy',
                            'menu_class' => 'menu-wrapper',
                            'container_class' => 'privacy_policy',
                            'items_wrap' => '<ul id="privacy_policy" class="%2$s">%3$s</ul>',
                            'fallback_cb' => false,
                        )
                    );
                    ?>
                </nav><!-- #site-navigation -->
            <?php endif; ?>
        </div>
    </div>
<!--     <div id="promo-modal"
         style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background: rgba(255, 255, 255, 0.2); z-index:9999;">
        <div id="promo-content"
             style="background:#fff;  max-width:600px; margin:10% auto; position:relative; border-radius:20px; overflow: hidden">
            <?php if (pll_current_language() == 'de') {
                echo '<img src="/wp-content/themes/victor-child/assets/img/modal_de.webp" alt="modal DE" style="display: block;">';
            } elseif (pll_current_language() == 'ro') {
                echo '<img src="/wp-content/themes/victor-child/assets/img/modal_ro.webp" alt="modal Ro" style="display: block;">';
            } else {
                echo '<img src="/wp-content/themes/victor-child/assets/img/modal_eng.webp" alt="modal EN" style="display: block;">';
            } ?>
            <button id="close-promo-modal" style="position: absolute; top: 0; right: 0; cursor: pointer;">
                <svg width="72" height="52" viewBox="0 0 72 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 0H52C63.0457 0 72 8.95431 72 20V52H20C8.95431 52 0 43.0457 0 32V0Z" fill="white"></path>
                    <g clip-path="url(#clip0_1167_98972)">
                        <path d="M45.7076 34.2926C45.8005 34.3855 45.8742 34.4958 45.9245 34.6172C45.9747 34.7386 46.0006 34.8687 46.0006 35.0001C46.0006 35.1315 45.9747 35.2616 45.9245 35.383C45.8742 35.5044 45.8005 35.6147 45.7076 35.7076C45.6147 35.8005 45.5044 35.8742 45.383 35.9245C45.2616 35.9747 45.1315 36.0006 45.0001 36.0006C44.8687 36.0006 44.7386 35.9747 44.6172 35.9245C44.4958 35.8742 44.3855 35.8005 44.2926 35.7076L36.0001 27.4138L27.7076 35.7076C27.5199 35.8952 27.2654 36.0006 27.0001 36.0006C26.7347 36.0006 26.4802 35.8952 26.2926 35.7076C26.1049 35.5199 25.9995 35.2654 25.9995 35.0001C25.9995 34.7347 26.1049 34.4802 26.2926 34.2926L34.5863 26.0001L26.2926 17.7076C26.1049 17.5199 25.9995 17.2654 25.9995 17.0001C25.9995 16.7347 26.1049 16.4802 26.2926 16.2926C26.4802 16.1049 26.7347 15.9995 27.0001 15.9995C27.2654 15.9995 27.5199 16.1049 27.7076 16.2926L36.0001 24.5863L44.2926 16.2926C44.4802 16.1049 44.7347 15.9995 45.0001 15.9995C45.2654 15.9995 45.5199 16.1049 45.7076 16.2926C45.8952 16.4802 46.0006 16.7347 46.0006 17.0001C46.0006 17.2654 45.8952 17.5199 45.7076 17.7076L37.4138 26.0001L45.7076 34.2926Z"
                              fill="#222222"></path>
                    </g>
                    <defs>
                        <clipPath id="clip0_1167_98972">
                            <rect width="32" height="32" fill="white" transform="translate(20 10)"></rect>
                        </clipPath>
                    </defs>
                </svg>
            </button>
        </div>
    </div> -->

    <div id="loading-spinner" style="display:none;">
        <!--        <img src="/wp-content/themes/victor-child/assets/img/loading.svg" alt="ajax-loader.gif">-->
        <div class="loader"></div>
    </div>
</header><!-- #masthead -->

