<?php
add_action('wp_enqueue_scripts', 'theme_enqueue_styles');
function theme_enqueue_styles()
{
    wp_enqueue_style('child-style', get_stylesheet_directory_uri() . '/style.css', array('parent-style'));
    wp_enqueue_style('main-css', '/wp-content/themes/victor-child/assets/css/main.css');
    wp_enqueue_style('lightbox-css', '/wp-content/themes/victor-child/assets/css/lightbox.css');
    wp_enqueue_style('slick-css', '/wp-content/themes/victor-child/assets/css/slick.css');
    wp_enqueue_style('slick-theme-css', '/wp-content/themes/victor-child/assets/css/slick-theme.css');
    wp_enqueue_style('select-2-css', '/wp-content/themes/victor-child/assets/css/select2.min.css');
    wp_enqueue_style('datepicker', '/wp-content/themes/victor-child/assets/css/jquery-ui.css');

    wp_enqueue_script('wc-add-to-cart-ajax');
    wp_localize_script('wc-add-to-cart-ajax', 'wc_add_to_cart_params', array('ajax_url' => admin_url('admin-ajax.php'),));
    wp_enqueue_script('wc-cart-fragments');
    wp_enqueue_script('wc-add-to-cart'); // Scriptul pentru adăugarea în coș
    wp_localize_script('your-script-handle', 'custom_ajax_params', array(
        'ajax_url' => admin_url('admin-ajax.php')
    ));

    wp_enqueue_script(
        'main-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/main.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'main-ajax',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/main-ajax.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'log-in-ajax-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/log-in-ajax.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'tips-ajax-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/tips-ajax.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'lightbox-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/lightbox.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'slick-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/slick.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'select2-min-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/select2.min.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'jquery-ui-min-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/jquery-ui.min.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'stripe-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/stripe.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'coupon-ajax-js',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/coupon-ajax.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_enqueue_script(
        'check-min-order',          // ID unic
        get_stylesheet_directory_uri() . '/assets/js/min-order-reached.js',  // Calea către fișier
        array('jquery'),                    // Dependențe (dacă e nevoie)
        '1.0.0',                       // Versiune
        true                          // Încarcă în footer (true) sau header (false)
    );
    wp_localize_script('check-min-order', 'minOrderCheck', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'message_below_min' => pll__('Mindestbestellwert €60,00'),
    ]);

}


// Setează un nume personalizat pentru emailuri
add_filter('wp_mail_from_name', function ($name) {
    return 'Promez'; // aici pui ce vrei să apară
});

// Setează un email personalizat pentru trimitere
add_filter('wp_mail_from', function ($email) {
    return 'noreply@promez.eu'; // sau un email real, ex: contact@...
});

add_action('init', function () {
    pll_register_string('string1', 'Meniu');
    pll_register_string('string2', 'Profil');
    pll_register_string('string3', 'Setări');
    pll_register_string('string4', 'Comenzi');
    pll_register_string('string5', 'Coduri promoționale');
    pll_register_string('string6', 'Ieși din cont');
    pll_register_string('string7', 'Produse');
    pll_register_string('string8', 'Magazin');
    pll_register_string('string9', 'Nu sunt produse în coş');
    pll_register_string('string10', 'Mergi la magazin');
    pll_register_string('string11', 'Sondaj de Opinie');
    pll_register_string('string12', 'Vom fi recunoscători pentru recenzii!');
    pll_register_string('string13', 'Articol:');
    pll_register_string('string14', 'În stoc');
    pll_register_string('string15', 'Nu este în stock');
    pll_register_string('string16', 'Filtrează după');
    pll_register_string('string17', 'Aveți');
    pll_register_string('string18', 'produse în coș.');
    pll_register_string('string19', 'Preț per bucată:');
    pll_register_string('string20', 'Cantitate');
    pll_register_string('string21', 'încercare nereuşită!');
    pll_register_string('string22', 'Nu poți adăuga mai mult de');
    pll_register_string('string23', 'unități.');
    pll_register_string('string24', 'În coș ai deja');
    pll_register_string('string25', 'Cat te costă acest produs?');
    pll_register_string('string26', 'Mod de preparare');
    pll_register_string('string27', 'Închide');
    pll_register_string('string28', 'Ingrediente');
    pll_register_string('string29', 'Alergeni');
    pll_register_string('string30', 'Condiții de păstrare');
    pll_register_string('string31', 'Altele');
    pll_register_string('string32', 'Responsabilități');
    pll_register_string('string33', 'Cerințe');
    pll_register_string('string34', 'Beneficii');
    pll_register_string('string35', 'Oferă');
    pll_register_string('string36', 'Alătură-te echipei Promez!');
    pll_register_string('string37', 'Rețete');
    pll_register_string('string38', 'Rețetă nouă');
    pll_register_string('string39', 'Rețetă de');
    pll_register_string('string40', 'Mulțumesc pentru mesaj');
    pll_register_string('string41', 'Mesajul dvs. a fost trimis cu succes');
    pll_register_string('string42', 'LOCAȚIE');
    pll_register_string('string43', 'SUPORT');
    pll_register_string('string44', 'Toate drepturile rezervate.');
    pll_register_string('string45', 'Abonează-te la Newsletter!');
    pll_register_string('string46', 'Abonează-te la Newsletter-ul nostru și fii primul care află despre reduceri exclusive, rețete
                    delicioase și noutăți! Fie că ești un fan al gusturilor tradiționale românești sau vrei să explorezi
                    noi delicii culinare, Newsletter-ul nostru este plin de conținut pe care îl vei adora.');
    pll_register_string('string47', 'Promoție pentru prieteni!!!');
    pll_register_string('string48', 'Devin-o membru și deblochează accesul nelimitat la recompense exclusive, cu și mai multe oportunități.');
    pll_register_string('string49', '-10% REDUCERE');
    pll_register_string('string50', 'Pentru tine');
    pll_register_string('string51', 'Pentru prieten');
    pll_register_string('string52', 'Înregistrează-te');
    pll_register_string('string53', 'Copie acest link');
    pll_register_string('string54', 'Contactează-ne');
    pll_register_string('string55', 'Autentificare');
    pll_register_string('string56', 'Înregistrare');
    pll_register_string('string57', 'Pentru a te autentifica în profilul tău, creează un cont.');
    pll_register_string('string58', 'Am uitat parola');
    pll_register_string('string59', 'Te rugăm să ne scrii adresa de email la care a fost înregistrat contul tău, iar noi îți vom trimite un link de resetare a parolei.');
    pll_register_string('string60', 'Anulare');
    pll_register_string('string61', 'Trimite');
    pll_register_string('string62', 'Te rugăm să resetezi parola.');
    pll_register_string('string63', 'Parola Nouă:');
    pll_register_string('string64', 'Repetare parolă nouă');
    pll_register_string('string65', 'Resetare');
    pll_register_string('string66', 'Newsletter');
    pll_register_string('string67', 'Distribuie');
    pll_register_string('string68', 'Scrie-ne');
    pll_register_string('string69', 'Te sunăm');
    pll_register_string('string70', '/contacte/');
    pll_register_string('string71', 'Contacte');
    pll_register_string('string72', 'Chat');
    pll_register_string('string73', 'Ai întâmpinat o problemă cu comanda și ai nevoie de ajutor? Lasă-ne nr de telefon și noi te contactăm!');
    pll_register_string('string74', 'Îți multumim pentru mesaj!');
    pll_register_string('string75', 'În cel mai scurt timp un reprezentat o sa vă contacteze!');
    pll_register_string('string76', 'Mulțumesc!');
    pll_register_string('string77', 'Îți multumim pentru abonare!');
    pll_register_string('string78', 'Greutate:');
    pll_register_string('string79', 'Preț total per bucată:');
    pll_register_string('string80', 'Ai un cod de reducere?');
    pll_register_string('string81', 'Introdu codul de reducere');
    pll_register_string('string82', 'Aplică');
    pll_register_string('string83', 'Vă mulțumim, apreciem enorm!');
    pll_register_string('string84', 'Parolă');
    pll_register_string('string85', 'Confirmă Parola');
    pll_register_string('string86', 'Data Nașterii');
    pll_register_string('string87', 'Zi');
    pll_register_string('string88', 'Lună');
    pll_register_string('string89', 'An');
    pll_register_string('string90', 'Abonează-te la newsletter');
    pll_register_string('string91', 'Toate câmpurile sunt obligatorii.');
    pll_register_string('string92', 'Adresa de email nu este validă.');
    pll_register_string('string93', 'Email-ul există deja.');
    pll_register_string('string94', 'Parola trebuie să conțină cel puțin 6 caractere.');
    pll_register_string('string95', 'Parolele nu se potrivesc.');
    pll_register_string('string96', 'Înregistrare realizată cu succes!');
    pll_register_string('string97', 'Ți-ai uitat parola?');
    pll_register_string('string98', 'Autentificare reușită. Redirectionare...');
    pll_register_string('string99', 'Copie cod-ul!');
    pll_register_string('string100', 'Te rog introdu un email valid.');
    pll_register_string('string101', 'Adresa de email nu este validă.');
    pll_register_string('string102', 'Nu există niciun cont cu acest email.');
    pll_register_string('string103', 'Parola a fost resetată cu succes! Te vom redirecționa...');
    pll_register_string('string104', 'Misiune');
    pll_register_string('string105', 'Valori');
    pll_register_string('string106', 'Cumpără acum');
    pll_register_string('string107', '/magazin/');
    pll_register_string('string108', 'Mai multe rețete');
    pll_register_string('string109', '/retete');
    pll_register_string('string110', 'Pentru a vă conecta la contul dvs., introduceți datele');
    pll_register_string('string111', 'Toate rețetele');
    pll_register_string('string112', 'Grătar');
    pll_register_string('string113', 'Cuptor');
    pll_register_string('string114', 'Tigaie');
    pll_register_string('string115', 'Preparare');
    pll_register_string('string116', 'Porții');
    pll_register_string('string117', 'Link copiat!');
    pll_register_string('string118', 'Cumpără');
    pll_register_string('string119', 'Descoperă acum savoarea micilor Promez!');
    pll_register_string('string120', 'Alte rețete');
    pll_register_string('string121', 'Acum poți face cumparături după bunul plac!!!');
    pll_register_string('string122', 'Mergi la cumpărături');
    pll_register_string('string123', 'Istoria Promez');
    pll_register_string('string124', 'Loghează-te');
    pll_register_string('string125', 'Adrese');
    pll_register_string('string126', 'Detalii cont');
    pll_register_string('string127', 'Deconectare');
    pll_register_string('string128', 'Expira pe: ');
    pll_register_string('string129', 'Acest coupon vă oferă o reducere de 10% la toate produsele noastre');
    pll_register_string('string130', 'Promo code');
    pll_register_string('string131', 'Reducere 10%');
    pll_register_string('string132', 'Acest coupon a expirat');
    pll_register_string('string133', '/contact/');
    pll_register_string('string134', 'Log In');
    pll_register_string('string135', '/contul-meu/edit-account/');
    pll_register_string('string136', '/contul-meu/orders/');
    pll_register_string('string137', '/contul-meu/promo-codes/');
    pll_register_string('string138', 'Link-ul tău de referal:');
    pll_register_string('string139', 'Email-ul a fost trimis. Verifică inbox-ul pentru mai multe detalii.');
    pll_register_string('string140', 'Produsul sau cantitatea nu sunt valide.');
    pll_register_string('string141', 'Produs eliminat din coș.');
    pll_register_string('string142', 'Te rog introdu un cod de cupon.');
    pll_register_string('string143', 'Cupon aplicat cu succes.');
    pll_register_string('string144', 'Codul de cupon este invalid sau expirat.');
    pll_register_string('string145', 'Customize Toolbar…');
    pll_register_string('string146', 'Mulțumim că te-ai înregistrat! Codul tău de reducere este: ');
    pll_register_string('string147', 'Cod de reducere pentru invitație');
    pll_register_string('string148', 'Mulțumim că ai invitat un prieten! Codul tău de reducere este: ');
    pll_register_string('string149', 'Data nașterii este invalidă.');
    pll_register_string('string150', 'Te rugăm să completezi data nașterii.');
    pll_register_string('string151', 'Verifică-ți email-ul');
    pll_register_string('string152', 'Bună ziua!');
    pll_register_string('string153', 'Te rugăm să îți verifici email-ul accesând acest link:');
    pll_register_string('string154', '/verificare-reusita/');
    pll_register_string('string155', '/verificare-esuata/');
    pll_register_string('string156', 'Nu ai coduri de reducere disponibile.');
    pll_register_string('string157', 'A apărut o eroare la generarea link-ului de resetare.');
    pll_register_string('string158', 'Resetare parolă - ');
    pll_register_string('string159', 'Salut, ');
    pll_register_string('string160', 'Ai cerut să îți resetezi parola. Apasă pe link-ul de mai jos pentru a continua:');
    pll_register_string('string161', 'Dacă nu ai cerut această acțiune, te rugăm să ignori acest email.');
    pll_register_string('string162', 'Echipa ');
    pll_register_string('string163', 'Nu s-a putut trimite email-ul. Încearcă din nou.');
    pll_register_string('string164', 'Cheia de resetare este invalidă sau expirată.');
    pll_register_string('string165', 'Nu este în stoc');
    pll_register_string('string166', 'Ups! Ceva nu a mers bine!');
    pll_register_string('string167', 'Prima pagina');
    pll_register_string('string168', '/');
    pll_register_string('string169', 'Înregistrare reușită! Redirectionare...');
    pll_register_string('string170', 'Multumesc pentru inregistrare!');
    pll_register_string('string171', 'Reducerea se aplică doar costului produselor, nu și livrării.');
    pll_register_string('string172', 'Valoarea ta');
    pll_register_string('string173', 'Nu sunt produse în coş');
    pll_register_string('string174', 'Tiefkühl Expressversand');
    pll_register_string('string175', 'Eigene Produktion');
    pll_register_string('string176', 'Schockgefrostet');
    pll_register_string('string177', 'Handgemacht');
    pll_register_string('string178', 'Deine Bestellung');
    pll_register_string('string179', 'kommt sicher und gekuhlt bei dir an.');
    pll_register_string('string180', 'Îți mulțumim. Am primit comanda ta.');
    pll_register_string('string181', 'Cod de reducere disponibil:');
    pll_register_string('string182', 'Download order');
    pll_register_string('string183', 'Felicitări! Ai transport gratuit!');
    pll_register_string('string184', 'Mai adaugă în coș de');
    pll_register_string('string185', 'și beneficiezi de transport gratuit!');
    pll_register_string('string186', 'Email-ul sau parola nu sunt corecte');
    pll_register_string('string187', 'Mindestbestellwert €60,00');
    pll_register_string('string188', 'Bestellungen werden von Montag bis Donnerstag täglich um 10:00 Uhr bearbeitet. Bestellungen, die am
            Donnerstag nach 10:00 Uhr aufgegeben werden, werden am Montag bearbeitet und am Dienstag geliefert.');
    pll_register_string('string189', 'Livrarea se face exclusiv in Germania!');

});


add_filter('render_block', 'bbloomer_woocommerce_cart_block_do_actions', 9999, 2);


add_filter('woocommerce_cart_fragment_cache', '__return_false');


function bbloomer_woocommerce_cart_block_do_actions($block_content, $block)
{
    $blocks = array(
        'woocommerce/cart',
        'woocommerce/filled-cart-block',
        'woocommerce/cart-items-block',
        'woocommerce/cart-line-items-block',
        'woocommerce/cart-cross-sells-block',
        'woocommerce/cart-cross-sells-products-block',
        'woocommerce/cart-totals-block',
        'woocommerce/cart-order-summary-block',
        'woocommerce/cart-order-summary-heading-block',
        'woocommerce/cart-order-summary-coupon-form-block',
        'woocommerce/cart-order-summary-subtotal-block',
        'woocommerce/cart-order-summary-fee-block',
        'woocommerce/cart-order-summary-discount-block',
        'woocommerce/cart-order-summary-shipping-block',
        'woocommerce/cart-order-summary-taxes-block',
        'woocommerce/cart-express-payment-block',
        'woocommerce/proceed-to-checkout-block',
        'woocommerce/cart-accepted-payment-methods-block',
    );
    if (in_array($block['blockName'], $blocks)) {
        ob_start();
        do_action('bbloomer_before_' . $block['blockName']);
        echo $block_content;
        do_action('bbloomer_after_' . $block['blockName']);
        $block_content = ob_get_contents();
        ob_end_clean();
    }
    return $block_content;
}


// Woocommerce theme support
add_theme_support('woocommerce');
//add_theme_support('wc-product-gallery-zoom');
add_theme_support('wc-product-gallery-lightbox');
add_theme_support('wc-product-gallery-slider');


if (function_exists('acf_add_options_page')) {

    acf_add_options_page();
}

function register_my_menu()
{
    register_nav_menu('privacy_policy', __('Privacy Policy'));
    register_nav_menu('lang-menu', __('Lang Menu'));
    register_nav_menu('footer', __('Menu Footer'));
}

add_action('init', 'register_my_menu');


// Modifică numărul de produse afișate în secțiunea Related Products
function custom_related_products_limit($args)
{
    $args['posts_per_page'] = 8; // Schimbă acest număr după cum dorești
    return $args;
}

add_filter('woocommerce_output_related_products_args', 'custom_related_products_limit');

// Inlocuirea Descrierii produsului din cos cu categoria produsului
function replace_cart_item_description_with_category($item_data, $cart_item)
{
    // Obține produsul
    $product = $cart_item['data'];

    // Obține greutatea produsului în kilograme
    $product_weight = 0.9; // Greutatea este în kilograme în WooCommerce

    if ($product_weight > 0) {
        // Obține prețul produsului
        $product_price = $product->get_price();
        $boxPrice = $product_price / 9;
        $kgPrice = $boxPrice;
        // Calculează prețul per kilogram


        // Adaugă prețul per kilogram la item data, înlocuind descrierea
        $item_data[] = array(
            'name' => __('', 'woocommerce'),
            'value' => '900g (100g / ' . wc_price($kgPrice) . ')', // Formatăm prețul în stilul WooCommerce
        );
    }

    return $item_data;
}

add_filter('woocommerce_get_item_data', 'replace_cart_item_description_with_category', 10, 2);


// Change woocommerce breadcrumbs separator
add_filter('woocommerce_breadcrumb_defaults', 'wps_breadcrumb_delimiter');
function wps_breadcrumb_delimiter($defaults)
{
    $defaults['delimiter'] = '<div class="separator"> | </div>';
    return $defaults;
}

add_filter('woocommerce_breadcrumb_defaults', 'woo_change_breadcrumb_home_text');
/**  * Change the breadcrumb home text from "Home" to "Shop".  * @param array $defaults The default array items.  * @return array           Modified array */
function woo_change_breadcrumb_home_text($defaults)
{
    $defaults['home'] = 'PROMEZ';
    return $defaults;
}


add_filter('woocommerce_single_product_summary', 'product_content_meat');
function product_content_meat()
{ ?>
    <div class="images">
        <?php
        global $product;
        $product_id = $product->get_id();
        $tags = wp_get_post_terms($product_id, 'product_tag');

        // Verifică fiecare etichetă și afișează iconița corespunzătoare
        foreach ($tags as $tag) {
            if ($tag->slug == 'beef' || $tag->slug == 'vita' || $tag->slug == 'rindfleisch') {
                echo '<img src="/wp-content/themes/victor-child/assets/img/beef.svg" alt="Beef" class="product-icon"  loading="lazy" />';
            }
            if ($tag->slug == 'pork' || $tag->slug == 'porc' || $tag->slug == 'schweinefleisch') {
                echo '<img src="/wp-content/themes/victor-child/assets/img/pork.svg" alt="Pork" class="product-icon" loading="lazy"/>';
            }
            if ($tag->slug == 'oaie' || $tag->slug == 'lamb' || $tag->slug == 'lammfleisch') {
                echo '<img src="/wp-content/themes/victor-child/assets/img/sheep.svg" alt="Sheep" class="product-icon" loading="lazy"/>';
            }
            // Adaugă alte etichete și iconițe după nevoie
        } ?>
    </div>
    <div class="product_some_details">
        <?php
        if ($product && method_exists($product, 'get_bundled_items')) {
            $bundled_items = $product->get_bundled_items();
            if (!empty($bundled_items)) {

                $total_qty = 0;

                foreach ($bundled_items as $bundled_item) {

                    $bundled_product_qty = $bundled_item->get_quantity(); // cantitatea per bundle

                    $total_qty += $bundled_product_qty;
                } ?>

                <?php
                $total_weight = $total_qty * 0.9;
                ?>
                <p><b><?php echo pll_e('Greutate:') ?></b> <?= $total_weight ?> kg</p>
            <?php }
        } else { ?>

            <?php
            $price = $product->get_price();
            $boxPrice = $price / 9;
            $kgPrice = $boxPrice;
            ?>
            <p><b><?php echo pll_e('Greutate:') ?></b> 900g (100g
                = <?= round($kgPrice, '2'); ?> <?= get_woocommerce_currency() ?>)</p>
            <span><?php echo pll_e('Preț total per bucată:') ?></span>
        <?php } ?>
    </div>
  <?php
if ( method_exists( $product, 'get_bundled_items' ) ) {

    $bundled_items = $product->get_bundled_items();

    if ( ! empty( $bundled_items ) ) { ?>
        <div class="bundle_product_list">
            <?php foreach ( $bundled_items as $bundled_item ) :
                $bundled_product = $bundled_item->get_product();
                $bundled_post    = get_post( yit_get_base_product_id( $bundled_product ) );
                $description     = $bundled_post->post_excerpt;
                $quantity        = $bundled_item->get_quantity();
                $the_title       = $bundled_product->get_title();
                ?>
                
                <div class="bundle_product_item">
                    <div class="bundle_product_image">
                        <?php
                        $post_thumbnail_id = $bundled_product->get_image_id();
                        if ( $post_thumbnail_id ) {
                            echo wc_get_gallery_image_html( $post_thumbnail_id, true );
                        } else {
                            echo '<div class="woocommerce-product-gallery__image--placeholder">';
                            echo sprintf(
                                '<img src="%s" alt="%s" class="wp-post-image" />',
                                esc_url( wc_placeholder_img_src() ),
                                esc_html__( 'Awaiting product image', 'woocommerce' )
                            );
                            echo '</div>';
                        }
                        ?>
                    </div>
                    <div class="bundle_product_details">
                        <div class="bundle_product_title">
                            <?= esc_html( $the_title ); ?> <span> x <?= esc_html( $quantity ); ?></span>
                        </div>
                    </div>
                </div>

            <?php endforeach; ?>
        </div>
    <?php }
}
?>

<?php }

add_filter('woocommerce_before_add_to_cart_form', 'product_details_modals');
function product_details_modals()
{
    ?>
    <div class="modals_buttons">
        <a href="#cooking_mode">

            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                <path d="M4.11062 2.43751C4.445 2.02126 4.5275 1.74001 4.49312 1.61626C4.46687 1.52313 4.3425 1.47501 4.34125 1.47501C4.22807 1.43781 4.13189 1.36143 4.07003 1.25961C4.00818 1.15779 3.98471 1.03723 4.00385 0.919648C4.023 0.802062 4.0835 0.695175 4.17446 0.61824C4.26542 0.541305 4.38087 0.499376 4.5 0.500007C4.55043 0.500066 4.60056 0.50765 4.64875 0.522507C4.71125 0.541882 5.26812 0.730632 5.44812 1.32001C5.60187 1.82438 5.41375 2.41063 4.88938 3.06313C4.555 3.47938 4.4725 3.76063 4.50688 3.88438C4.53313 3.97751 4.655 4.02438 4.65625 4.02501C4.76922 4.06214 4.86526 4.13832 4.92713 4.23987C4.98899 4.34143 5.01264 4.46171 4.99383 4.57913C4.97501 4.69654 4.91496 4.80341 4.82445 4.88055C4.73395 4.95768 4.61892 5.00004 4.5 5.00001C4.44957 4.99995 4.39944 4.99236 4.35125 4.97751C4.28875 4.95813 3.73188 4.76938 3.55188 4.18001C3.39813 3.67563 3.58625 3.08938 4.11062 2.43751ZM6.05188 4.18063C6.23188 4.77001 6.78875 4.95876 6.85125 4.97813C6.89947 4.99278 6.9496 5.00015 7 5.00001C7.11892 5.00004 7.23395 4.95768 7.32445 4.88055C7.41496 4.80341 7.47501 4.69654 7.49383 4.57913C7.51264 4.46171 7.489 4.34143 7.42713 4.23987C7.36526 4.13832 7.26922 4.06214 7.15625 4.02501C7.15625 4.02501 7.03125 3.97751 7.00688 3.88438C6.9725 3.75938 7.055 3.47938 7.38937 3.06313C7.91375 2.41063 8.10187 1.82438 7.94812 1.32001C7.76812 0.730632 7.21188 0.541882 7.14875 0.522507C7.10056 0.50765 7.05043 0.500066 7 0.500007C6.8812 0.499832 6.76622 0.541961 6.67566 0.618847C6.5851 0.695733 6.52487 0.802352 6.50577 0.919604C6.48667 1.03686 6.50993 1.15708 6.57141 1.25874C6.63288 1.36039 6.72854 1.43684 6.84125 1.47438C6.84125 1.47438 6.96625 1.52251 6.99312 1.61563C7.0275 1.74063 6.945 2.02063 6.61062 2.43688C6.08625 3.08938 5.89813 3.67563 6.05188 4.18001V4.18063ZM8.55188 4.18063C8.73188 4.77001 9.28875 4.95876 9.35125 4.97813C9.39947 4.99278 9.4496 5.00015 9.5 5.00001C9.61892 5.00004 9.73395 4.95768 9.82445 4.88055C9.91496 4.80341 9.97501 4.69654 9.99383 4.57913C10.0126 4.46171 9.989 4.34143 9.92713 4.23987C9.86526 4.13832 9.76922 4.06214 9.65625 4.02501C9.65625 4.02501 9.53125 3.97751 9.50688 3.88438C9.4725 3.75938 9.555 3.47938 9.88937 3.06313C10.4137 2.41063 10.6019 1.82438 10.4481 1.32001C10.2681 0.730632 9.71188 0.541882 9.64875 0.522507C9.60056 0.50765 9.55043 0.500066 9.5 0.500007C9.3812 0.499832 9.26622 0.541961 9.17566 0.618847C9.0851 0.695733 9.02487 0.802352 9.00577 0.919604C8.98667 1.03686 9.00993 1.15708 9.07141 1.25874C9.13288 1.36039 9.22854 1.43684 9.34125 1.47438C9.34125 1.47438 9.46625 1.52251 9.49312 1.61563C9.5275 1.74063 9.445 2.02063 9.11063 2.43688C8.58625 3.08938 8.39813 3.67563 8.55188 4.18001V4.18063ZM13 6.00001H1C0.867392 6.00001 0.740215 6.05269 0.646447 6.14645C0.552678 6.24022 0.5 6.3674 0.5 6.50001C0.502197 7.68908 0.829433 8.85493 1.44632 9.87147C2.06321 10.888 2.94627 11.7166 4 12.2675V12.5C4 12.7652 4.10536 13.0196 4.29289 13.2071C4.48043 13.3946 4.73478 13.5 5 13.5H9C9.26522 13.5 9.51957 13.3946 9.70711 13.2071C9.89464 13.0196 10 12.7652 10 12.5V12.2675C11.0537 11.7166 11.9368 10.888 12.5537 9.87147C13.1706 8.85493 13.4978 7.68908 13.5 6.50001C13.5 6.3674 13.4473 6.24022 13.3536 6.14645C13.2598 6.05269 13.1326 6.00001 13 6.00001Z"
                      fill="#D6D6D6"/>
            </svg>

            <span><?php echo pll_e('Mod de preparare') ?></span>
        </a>
        <a href="#ingredients">
            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                <path d="M13.4985 4.50114H11.4635C11.9037 5.26387 12.0799 6.15055 11.9648 7.02362C11.8496 7.8967 11.4496 8.70738 10.8267 9.32989C10.2942 9.87302 9.60104 10.3874 8.83604 10.8618C8.78816 10.8909 8.73187 10.9031 8.67622 10.8964C8.62057 10.8897 8.56878 10.8645 8.52916 10.8249L6.35166 8.64739C6.3043 8.60001 6.2479 8.56263 6.18581 8.53748C6.12372 8.51232 6.0572 8.4999 5.99022 8.50095C5.92323 8.502 5.85714 8.5165 5.79587 8.54358C5.7346 8.57067 5.6794 8.6098 5.63354 8.65864C5.5453 8.75764 5.49871 8.88689 5.50348 9.01941C5.50826 9.15194 5.56403 9.2775 5.65916 9.36989L7.52666 11.2374C7.55456 11.2652 7.57548 11.2993 7.58771 11.3367C7.59994 11.3742 7.60314 11.414 7.59704 11.453C7.59095 11.4919 7.57574 11.5289 7.55264 11.5608C7.52955 11.5927 7.49923 11.6188 7.46416 11.6368C4.98229 12.9255 2.31104 13.7849 1.92229 13.9061C1.73632 13.9928 1.52821 14.0201 1.32617 13.9845C1.12414 13.9488 0.937962 13.8519 0.792894 13.7068C0.647826 13.5617 0.550887 13.3755 0.515225 13.1735C0.479563 12.9715 0.506904 12.7634 0.593539 12.5774C0.764164 12.033 2.40604 6.93552 4.64729 4.24302C4.66956 4.21637 4.69714 4.19467 4.72827 4.17927C4.7594 4.16388 4.79339 4.15514 4.82808 4.15361C4.86277 4.15208 4.8974 4.1578 4.92977 4.17039C4.96213 4.18299 4.99151 4.20219 5.01604 4.22677L7.64416 6.85552C7.69278 6.9041 7.75088 6.94213 7.81485 6.96725C7.87882 6.99237 7.94728 7.00404 8.01596 7.00152C8.08463 6.99899 8.15206 6.98234 8.21401 6.9526C8.27597 6.92285 8.33112 6.88066 8.37604 6.82864C8.45819 6.72949 8.49996 6.60301 8.49301 6.47443C8.48606 6.34585 8.4309 6.22461 8.33854 6.13489L5.75354 3.54989C5.72718 3.52364 5.70701 3.49184 5.6945 3.45681C5.68199 3.42178 5.67746 3.38439 5.68123 3.34739C5.685 3.31038 5.69699 3.27468 5.71631 3.24289C5.73563 3.21111 5.7618 3.18403 5.79291 3.16364C6.41304 2.7543 7.13493 2.52577 7.87765 2.5037C8.62038 2.48162 9.35457 2.66685 9.99791 3.03864V1.00114C9.99776 0.93254 10.0117 0.864642 10.0389 0.801669C10.0661 0.738697 10.106 0.681997 10.1561 0.635098C10.2061 0.588199 10.2653 0.552104 10.3299 0.529058C10.3946 0.506013 10.4632 0.49651 10.5317 0.50114C10.6605 0.51235 10.7803 0.571975 10.867 0.668003C10.9536 0.764031 11.0006 0.889325 10.9985 1.01864V2.79427L12.6448 1.14739C12.6912 1.10094 12.7464 1.06409 12.8071 1.03894C12.8678 1.0138 12.9328 1.00086 12.9985 1.00086C13.0642 1.00086 13.1293 1.0138 13.19 1.03894C13.2507 1.06409 13.3058 1.10094 13.3523 1.14739C13.3987 1.19385 13.4356 1.249 13.4607 1.30969C13.4859 1.37039 13.4988 1.43544 13.4988 1.50114C13.4988 1.56684 13.4859 1.63189 13.4607 1.69259C13.4356 1.75329 13.3987 1.80844 13.3523 1.85489L11.7054 3.50114H13.481C13.6104 3.49907 13.7356 3.54609 13.8317 3.63273C13.9277 3.71936 13.9873 3.83917 13.9985 3.96802C14.0031 4.03641 13.9935 4.10501 13.9704 4.16954C13.9473 4.23408 13.9112 4.29319 13.8643 4.34318C13.8175 4.39318 13.7608 4.433 13.6979 4.46017C13.6349 4.48735 13.5671 4.50129 13.4985 4.50114Z"
                      fill="#D6D6D6"/>
            </svg>
            <span><?php echo pll_e('Ingrediente') ?></span>
        </a>
        <a href="#allergens">
            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="12" viewBox="0 0 14 12" fill="none">
                <path d="M12.8334 0.5H1.83337C1.56816 0.5 1.3138 0.605357 1.12627 0.792893C0.938731 0.98043 0.833374 1.23478 0.833374 1.5V11C0.83342 11.0852 0.855246 11.169 0.89678 11.2434C0.938315 11.3178 0.998179 11.3804 1.07069 11.4252C1.1432 11.4699 1.22595 11.4954 1.31109 11.4992C1.39622 11.503 1.48091 11.485 1.55712 11.4469L3.33337 10.5588L5.10962 11.4469C5.17909 11.4816 5.2557 11.4997 5.33337 11.4997C5.41105 11.4997 5.48766 11.4816 5.55712 11.4469L7.33337 10.5588L9.10962 11.4469C9.17909 11.4816 9.2557 11.4997 9.33337 11.4997C9.41105 11.4997 9.48766 11.4816 9.55712 11.4469L11.3334 10.5588L13.1096 11.4469C13.1858 11.485 13.2705 11.503 13.3557 11.4992C13.4408 11.4954 13.5235 11.4699 13.5961 11.4252C13.6686 11.3804 13.7284 11.3178 13.77 11.2434C13.8115 11.169 13.8333 11.0852 13.8334 11V1.5C13.8334 1.23478 13.728 0.98043 13.5405 0.792893C13.3529 0.605357 13.0986 0.5 12.8334 0.5ZM9.18712 6.64625C9.23358 6.6927 9.27043 6.74786 9.29557 6.80855C9.32071 6.86925 9.33365 6.9343 9.33365 7C9.33365 7.0657 9.32071 7.13075 9.29557 7.19145C9.27043 7.25214 9.23358 7.3073 9.18712 7.35375C9.14067 7.40021 9.08552 7.43706 9.02482 7.4622C8.96413 7.48734 8.89907 7.50028 8.83337 7.50028C8.76768 7.50028 8.70262 7.48734 8.64193 7.4622C8.58123 7.43706 8.52608 7.40021 8.47962 7.35375L7.33337 6.20687L6.18712 7.35375C6.14067 7.40021 6.08552 7.43706 6.02482 7.4622C5.96413 7.48734 5.89907 7.50028 5.83337 7.50028C5.76768 7.50028 5.70262 7.48734 5.64193 7.4622C5.58123 7.43706 5.52608 7.40021 5.47962 7.35375C5.43317 7.3073 5.39632 7.25214 5.37118 7.19145C5.34604 7.13075 5.3331 7.0657 5.3331 7C5.3331 6.9343 5.34604 6.86925 5.37118 6.80855C5.39632 6.74786 5.43317 6.6927 5.47962 6.64625L6.6265 5.5L5.47962 4.35375C5.3858 4.25993 5.3331 4.13268 5.3331 4C5.3331 3.86732 5.3858 3.74007 5.47962 3.64625C5.57344 3.55243 5.70069 3.49972 5.83337 3.49972C5.96606 3.49972 6.0933 3.55243 6.18712 3.64625L7.33337 4.79313L8.47962 3.64625C8.52608 3.59979 8.58123 3.56294 8.64193 3.5378C8.70262 3.51266 8.76768 3.49972 8.83337 3.49972C8.89907 3.49972 8.96413 3.51266 9.02482 3.5378C9.08552 3.56294 9.14067 3.59979 9.18712 3.64625C9.23358 3.6927 9.27043 3.74786 9.29557 3.80855C9.32071 3.86925 9.33365 3.9343 9.33365 4C9.33365 4.0657 9.32071 4.13075 9.29557 4.19145C9.27043 4.25214 9.23358 4.3073 9.18712 4.35375L8.04025 5.5L9.18712 6.64625Z"
                      fill="white"/>
            </svg>
            <span><?php echo pll_e('Alergeni') ?></span>
        </a>
        <a href="#storage">
            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
                <path d="M13.9166 3.5C13.5705 3.5 13.2322 3.60264 12.9444 3.79493C12.6566 3.98722 12.4323 4.26053 12.2998 4.5803C12.1674 4.90007 12.1327 5.25194 12.2003 5.59141C12.2678 5.93087 12.4344 6.24269 12.6792 6.48744C12.9239 6.73218 13.2358 6.89885 13.5752 6.96637C13.9147 7.0339 14.2666 6.99924 14.5863 6.86679C14.9061 6.73434 15.1794 6.51003 15.3717 6.22225C15.564 5.93446 15.6666 5.59612 15.6666 5.25C15.6666 4.78587 15.4823 4.34075 15.1541 4.01256C14.8259 3.68437 14.3808 3.5 13.9166 3.5ZM13.9166 6C13.7683 6 13.6233 5.95601 13.4999 5.8736C13.3766 5.79119 13.2805 5.67406 13.2237 5.53701C13.167 5.39997 13.1521 5.24917 13.181 5.10368C13.21 4.9582 13.2814 4.82456 13.3863 4.71967C13.4912 4.61478 13.6248 4.54335 13.7703 4.51441C13.9158 4.48547 14.0666 4.50032 14.2036 4.55709C14.3407 4.61386 14.4578 4.70999 14.5402 4.83332C14.6226 4.95666 14.6666 5.10166 14.6666 5.25C14.6666 5.44891 14.5876 5.63968 14.447 5.78033C14.3063 5.92098 14.1155 6 13.9166 6ZM10.1666 9.13V2.5C10.1666 1.96957 9.95591 1.46086 9.58084 1.08579C9.20577 0.710714 8.69706 0.5 8.16663 0.5C7.63619 0.5 7.12749 0.710714 6.75241 1.08579C6.37734 1.46086 6.16663 1.96957 6.16663 2.5V9.13C5.55513 9.55579 5.09549 10.1656 4.85459 10.8707C4.61369 11.5758 4.60411 12.3394 4.82724 13.0504C5.05037 13.7613 5.49458 14.3825 6.09519 14.8235C6.69581 15.2645 7.4215 15.5023 8.16663 15.5023C8.91176 15.5023 9.63744 15.2645 10.2381 14.8235C10.8387 14.3825 11.2829 13.7613 11.506 13.0504C11.7291 12.3394 11.7196 11.5758 11.4787 10.8707C11.2378 10.1656 10.7781 9.55579 10.1666 9.13ZM9.16663 6.5H7.16663V2.5C7.16663 2.23478 7.27198 1.98043 7.45952 1.79289C7.64706 1.60536 7.90141 1.5 8.16663 1.5C8.43184 1.5 8.6862 1.60536 8.87373 1.79289C9.06127 1.98043 9.16663 2.23478 9.16663 2.5V6.5Z"
                      fill="#D6D6D6"/>
            </svg>
            <span><?php echo pll_e('Condiții de păstrare') ?></span>
        </a>
        <a href="#other">
            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
                <path d="M10.4166 8C10.4166 8.34612 10.314 8.68446 10.1217 8.97225C9.92941 9.26003 9.65609 9.48434 9.33632 9.61679C9.01655 9.74924 8.66469 9.7839 8.32522 9.71637C7.98575 9.64885 7.67393 9.48218 7.42919 9.23744C7.18445 8.9927 7.01778 8.68087 6.95025 8.34141C6.88273 8.00194 6.91738 7.65007 7.04984 7.3303C7.18229 7.01053 7.40659 6.73722 7.69438 6.54493C7.98216 6.35264 8.32051 6.25 8.66663 6.25C9.13076 6.25 9.57588 6.43437 9.90406 6.76256C10.2323 7.09075 10.4166 7.53587 10.4166 8ZM3.66663 6.25C3.32051 6.25 2.98216 6.35264 2.69438 6.54493C2.40659 6.73722 2.18229 7.01053 2.04984 7.3303C1.91738 7.65007 1.88273 8.00194 1.95025 8.34141C2.01778 8.68087 2.18445 8.9927 2.42919 9.23744C2.67393 9.48218 2.98575 9.64885 3.32522 9.71637C3.66469 9.7839 4.01655 9.74924 4.33632 9.61679C4.65609 9.48434 4.92941 9.26003 5.1217 8.97225C5.31399 8.68446 5.41663 8.34612 5.41663 8C5.41663 7.53587 5.23225 7.09075 4.90406 6.76256C4.57587 6.43437 4.13076 6.25 3.66663 6.25ZM13.6666 6.25C13.3205 6.25 12.9822 6.35264 12.6944 6.54493C12.4066 6.73722 12.1823 7.01053 12.0498 7.3303C11.9174 7.65007 11.8827 8.00194 11.9503 8.34141C12.0178 8.68087 12.1844 8.9927 12.4292 9.23744C12.6739 9.48218 12.9858 9.64885 13.3252 9.71637C13.6647 9.7839 14.0166 9.74924 14.3363 9.61679C14.6561 9.48434 14.9294 9.26003 15.1217 8.97225C15.314 8.68446 15.4166 8.34612 15.4166 8C15.4166 7.77019 15.3714 7.54262 15.2834 7.3303C15.1955 7.11798 15.0666 6.92507 14.9041 6.76256C14.7416 6.60006 14.5486 6.47116 14.3363 6.38321C14.124 6.29526 13.8964 6.25 13.6666 6.25Z"
                      fill="white"/>
            </svg>
            <span><?php echo pll_e('Altele') ?></span>
        </a>

    </div>
<?php }

// Adăugarea produsului în coș cu cantitatea specificată
add_action('wp_ajax_add_to_cart', 'custom_add_to_cart');
add_action('wp_ajax_nopriv_add_to_cart', 'custom_add_to_cart');

function custom_add_to_cart()
{
    $product_id = intval($_POST['product_id']);
    $quantity = intval($_POST['quantity']);

    if ($product_id && $quantity) {
        $product = wc_get_product($product_id);

        if (!$product) {
            wp_send_json_error('Produsul nu există.');
            return;
        }

        $stock_quantity = $product->get_stock_quantity(); // Stocul disponibil
        $current_quantity = 0;

        // Obținem cantitatea curentă în coș pentru acest produs
        foreach (WC()->cart->get_cart() as $cart_item) {
            if ($cart_item['product_id'] == $product_id) {
                $current_quantity = $cart_item['quantity'];
                break;
            }
        }

        $total_quantity = $current_quantity + $quantity;

        // ✅ Verificare stoc disponibil
        if ($stock_quantity !== null && $total_quantity > $stock_quantity) {
            wp_send_json_error([
                'message' => "Nu poți adăuga mai mult de <b>" . $stock_quantity . " </b> unități. În coș ai deja <b>" . $current_quantity . " </b> unități.",
                'stock_quantity' => $stock_quantity,
                'current_quantity' => $current_quantity,
                'product_id' => $product_id,
            ]);
            return;
        }

        // ✅ Dacă stocul este suficient → Adăugăm în coș
        WC()->cart->add_to_cart($product_id, $quantity);

        // Actualizăm cantitatea după adăugare
        $new_quantity = 0;
        foreach (WC()->cart->get_cart() as $cart_item) {
            if ($cart_item['product_id'] == $product_id) {
                $new_quantity += $cart_item['quantity'];
            }
        }

        // ✅ Prețul și subtotalul
        $product_price = $product->get_price();
        $subtotal = $new_quantity * $product_price;

        // ✅ Totalul coșului
        $cart_total = WC()->cart->get_cart_contents_total();
        $formatted_cart_total = wc_price($cart_total);

        // ✅ Numărul total de produse din coș
        $total_products = WC()->cart->get_cart_contents_count();


        wp_send_json_success([
            'new_quantity' => $new_quantity,
            'subtotal' => wc_price($subtotal),
            'cart_total' => $formatted_cart_total,
            'total_products' => $total_products,
        ]);
    } else {
        wp_send_json_error(pll__('Produsul sau cantitatea nu sunt valide.'));
    }
}

add_action('wp_ajax_update_cart_quantity', 'update_cart_quantity');
add_action('wp_ajax_nopriv_update_cart_quantity', 'update_cart_quantity');

function update_cart_quantity()
{
    if (isset($_REQUEST['product_id']) && isset($_REQUEST['quantity'])) {
        $product_id = intval($_REQUEST['product_id']);
        $quantity = intval($_REQUEST['quantity']);

        // Obținem coșul de cumpărături
        $cart = WC()->cart->get_cart();

        // Căutăm produsul în coș și actualizăm cantitatea
        $product_found = false; // Flag pentru a verifica dacă produsul există în coș
        $product_subtotal = 0;  // Variabila pentru subtotalul produsului

        foreach ($cart as $cart_item_key => $cart_item) {
            if ($cart_item['product_id'] == $product_id) {

                $product_found = true; // Am găsit produsul
                $product_price = $cart_item['data']->get_price();

                if ($quantity > 0) {
                    WC()->cart->set_quantity($cart_item_key, $quantity); // Actualizăm cantitatea
                    $product_subtotal = $quantity * $product_price;

                } else {
                    WC()->cart->remove_cart_item($cart_item_key); // Îndepărtăm produsul din coș dacă cantitatea este 0
                }
                break;
            }
        }

        // Dacă produsul nu a fost găsit, îl adăugăm în coș
        if (!$product_found && $quantity > 0) {
            WC()->cart->add_to_cart($product_id, $quantity);
            $product = wc_get_product($product_id);
            $product_price = $product->get_price();
            $product_subtotal = $quantity * $product_price;

        }
        $cart_total = WC()->cart->get_cart_contents_total(); // Total neformatat (fără taxe, doar suma)
        $formatted_cart_total = wc_price($cart_total); // Total formatat cu moneda

        $total_products = WC()->cart->get_cart_contents_count(); // Numărul total de produse din coș

        // Returnăm răspunsul de succes
        wp_send_json_success([
            'new_quantity' => $quantity,
            'subtotal' => wc_price($product_subtotal), // Formatăm subtotalul
            'cart_total' => $formatted_cart_total,
            'total_products' => $total_products
        ]);
    } else {
        wp_send_json_error('Parametrii lipsesc.');
    }

    wp_die();
}

// Remove item from cart
function custom_remove_product_from_cart()
{
    if (isset($_REQUEST['product_id'])) {
        $product_id = intval($_REQUEST['product_id']);

        // Obținem coșul de cumpărături
        $cart = WC()->cart->get_cart();

        // Găsim `cart_item_key` pentru produsul specificat
        foreach ($cart as $cart_item_key => $cart_item) {
            if ($cart_item['product_id'] == $product_id) {
                WC()->cart->remove_cart_item($cart_item_key); // Eliminăm produsul din coș

                $cart_total = WC()->cart->get_total('edit'); // Obține totalul coșului în format editabil
                $cart_total_display = WC()->cart->get_cart_total(); // Totalul coșului în format de afișare

                $cart_total = WC()->cart->get_cart_total(); // Obține totalul coșului în format de afișare

                $total_products = 0;
                foreach (WC()->cart->get_cart() as $cart_item_new) {
                    $total_products += $cart_item_new['quantity']; // Adunăm cantitățile
                }
                wp_send_json_success(array(
                        'message' => pll__('Produs eliminat din coș.'),
                        'cart_total' => $cart_total, // Adăugăm totalul coșului la răspuns);
                        'total_products' => $total_products, // Totalul produselor

                    )
                );
                return;
            }
        }
        wp_send_json_error();
    } else {
        wp_send_json_error('Parametrii lipsesc.');
    }

    wp_die();
}

add_action('wp_ajax_remove_product_from_cart', 'custom_remove_product_from_cart');
add_action('wp_ajax_nopriv_remove_product_from_cart', 'custom_remove_product_from_cart');


add_action('bbloomer_before_woocommerce/cart', function () {
    echo '<div class="custom_cart_header"></div>';
});

add_action('bbloomer_after_woocommerce/cart', function () {
    echo get_template_part('section-newsletter');
});

//add_action('woocommerce_before_customer_login_form', function (){
//    echo '<div class="my_account_custom_header">';
//});


// Disable Gutenberg on the back end.
add_filter('use_block_editor_for_post', '__return_false');

// Disable Gutenberg for widgets.
add_filter('use_widgets_block_editor', '__return_false');

add_action('wp_enqueue_scripts', function () {
    // Remove CSS on the front end.
    wp_dequeue_style('wp-block-library');

    // Remove Gutenberg theme.
    wp_dequeue_style('wp-block-library-theme');

    // Remove inline global CSS on the front end.
    wp_dequeue_style('global-styles');
}, 20);


remove_action('woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10);

add_action('woocommerce_review_order_before_payment', 'custom_coupon_field');
function custom_coupon_field()
{
    ?>
    <div id="custom_coupon_container" class="checkout_coupon">
        <p><?php echo pll_e('Ai un cod de reducere?') ?></p>
        <?php
        $referral_code = get_oldest_valid_unused_referral_coupon_code();
        if ($referral_code) {
            echo '<div class="notice notice-info">';
            echo pll_e("Cod de reducere disponibil:") . '<strong>' . esc_html($referral_code) . '<span class="tooltip">' . pll__('Copie cod-ul!') . '</span></strong>';
            echo '</div>';
        } ?>
        <input type="text" id="custom_coupon_code" placeholder="<?php echo pll_e('Introdu codul de reducere') ?>">
        <button id="custom_apply_coupon" type="button"><?php echo pll_e('Aplică') ?></button>
        <div id="coupon_feedback" style="margin-top: 10px; color: red; display: none;"></div>
    </div>
    <?php
}

add_action('wp_ajax_custom_apply_coupon', 'custom_apply_coupon');
add_action('wp_ajax_nopriv_custom_apply_coupon', 'custom_apply_coupon');

function custom_apply_coupon()
{
    // Verificăm nonce-ul pentru securitate
//    if (!check_ajax_referer('apply_coupon', 'security', false)) {
//        wp_send_json_error('Nonce invalid.', 403);
//    }

    // Preluăm codul cuponului
    $coupon_code = isset($_POST['coupon_code']) ? sanitize_text_field($_POST['coupon_code']) : '';

    if (empty($coupon_code)) {
        wp_send_json_error(pll__('Te rog introdu un cod de cupon.'));
    }

    // Aplicăm cuponul
    $applied = WC()->cart->apply_coupon($coupon_code);

    if ($applied) {
        wp_send_json_success(pll__('Cupon aplicat cu succes.'));
    } else {
        wp_send_json_error(pll__('Codul de cupon este invalid sau expirat.'));
    }
}

add_filter('woocommerce_get_script_data', 'add_apply_coupon_nonce');

function add_apply_coupon_nonce($params)
{
    // Verificăm dacă $params este un array valid înainte de a adăuga nonce-ul
    if (is_array($params)) {
        $params['apply_coupon_nonce'] = wp_create_nonce('apply_coupon');
    }
    return $params;
}


//function add_apply_coupon_nonce($params)
//{
//    $params['apply_coupon_nonce'] = wp_create_nonce('apply_coupon');
//    return $params;
//}

add_action('woocommerce_before_checkout_form', function () {
    echo '<div class="my_account_custom_header"> </div>';
});

// Adaugă opțiunea de tips la checkout
function add_tips_option_checkout()
{
    $saved_tips = WC()->session->get('tips_option', '0');
    $custom_tip = WC()->session->get('custom_tip_amount', '');
    ?>
    <div id="tips_option_checkout">
        <h3><?php echo pll__('Vă mulțumim, apreciem enorm!') ?></h3>
        <ul class="tips-options">
            <li>
                <label>
                    <input type="radio" name="tips_option" value="0" <?php checked($saved_tips, '0'); ?>>
                    <span>No tips</span>
                </label>
            </li>
            <?php foreach ([3, 5, 10, 15] as $percent): ?>
                <li>
                    <label>
                        <input type="radio" name="tips_option"
                               value="<?php echo $percent; ?>" <?php checked($saved_tips, (string)$percent); ?>>
                        <span><?php echo $percent; ?>%</span>
                    </label>
                </li>
            <?php endforeach; ?>
        </ul>
        <div class="custom-tip-manual">
            <label>
                <input type="number" min="0" step="0.01" name="custom_tip_amount" id="custom_tip_amount"
                       value="<?php echo esc_attr($custom_tip); ?>"
                       placeholder="<?php echo pll_e('Valoarea ta') ?> (€)"/>
                <!--                --><?php //echo get_woocommerce_currency_symbol();
                ?>
            </label>
        </div>
    </div>
    <?php
}

add_action('woocommerce_review_order_before_payment', 'add_tips_option_checkout');


// Salvăm opțiunea selectată în sesiune
function save_tips_option_in_session()
{
    if (isset($_POST['tips_option'])) {
        WC()->session->set('tips_option', sanitize_text_field($_POST['tips_option']));
    }
}

add_action('woocommerce_checkout_update_order_review', 'save_tips_option_in_session');

// Adăugăm tips-ul la total
function add_tip_to_cart($cart)
{
    if (is_admin() && !defined('DOING_AJAX')) return;

    $custom_tip = WC()->session->get('custom_tip_amount');
    $tip_percent = WC()->session->get('tips_option');

    if ($custom_tip && $custom_tip > 0) {
        $cart->add_fee(__('Tips', 'woocommerce'), $custom_tip, false);
    } elseif ($tip_percent && is_numeric($tip_percent) && $tip_percent > 0) {
        $total = $cart->get_subtotal();
//        $total_clean = floatval(str_replace(',', '.', $total));
        $tip = ($tip_percent / 100) * $total;
        $cart->add_fee(__('Tips', 'woocommerce'), $tip, true);
    }
}

add_action('woocommerce_cart_calculate_fees', 'add_tip_to_cart', 20, 1);

// Salvăm tips-ul în meta-data comenzii
function save_tip_to_order($order_id)
{
    $custom_tip = WC()->session->get('custom_tip_amount');
    $tip_percent = WC()->session->get('tips_option');

    if ($custom_tip && $custom_tip > 0) {
        update_post_meta($order_id, '_custom_tip_amount', $custom_tip);
    } elseif ($tip_percent && $tip_percent > 0) {
        $order = wc_get_order($order_id);

//        $total = $order->get_total();

        $subtotal = 0;
        foreach ($order->get_items() as $item) {
            $subtotal += $item->get_subtotal();
        }

        $tip = round(($tip_percent / 100) * $subtotal, 2);

//        $tip = ($tip_percent / 100) * $total;


        update_post_meta($order_id, '_custom_tip_percent', $tip_percent);
        update_post_meta($order_id, '_custom_tip_amount', $tip);
    }
}

add_action('woocommerce_checkout_update_order_meta', 'save_tip_to_order');

// Afișăm tips-ul în emailurile de comandă
function display_tip_in_email($order, $sent_to_admin, $plain_text, $email)
{
    $tip_amount = get_post_meta($order->get_id(), '_custom_tip_amount', true);
    if ($tip_amount && $tip_amount > 0) {
        echo '<p><strong>' . __('Tips:', 'woocommerce') . '</strong> ' . wc_price($tip_amount) . '</p>';
    }
}

add_action('woocommerce_email_customer_details', 'display_tip_in_email', 10, 4);


// Tratăm cererea AJAX pentru actualizarea tips-ului
function update_tips_via_ajax()
{
    if (isset($_POST['tips_option'])) {
        WC()->session->set('tips_option', sanitize_text_field($_POST['tips_option']));
        WC()->session->set('custom_tip_amount', '');
    }

    if (isset($_POST['custom_tip_amount'])) {
        $custom = floatval(str_replace(',', '.', $_POST['custom_tip_amount']));
        WC()->session->set('custom_tip_amount', max(0, $custom));
        WC()->session->set('tips_option', ''); // resetăm radio
    }

    wp_send_json_success();
}

add_action('wp_ajax_update_tips', 'update_tips_via_ajax');
add_action('wp_ajax_nopriv_update_tips', 'update_tips_via_ajax');

add_filter('woocommerce_registration_redirect', 'custom_redirection_after_registration', 10, 1);
function custom_redirection_after_registration($redirection_url)
{
    // Change the redirection Url
    $redirection_url = get_home_url(); // Home page

    return $redirection_url; // Always return something
}

// custom redirect after log in
add_filter('woocommerce_login_redirect', 'bbloomer_customer_login_redirect', 9999);

function bbloomer_customer_login_redirect($redirect_url)
{
    $redirect_url = pll__('/magazin/');

    return $redirect_url;
}

add_action('wp_logout', 'owp_redirect_after_logout');
function owp_redirect_after_logout()
{
    wp_redirect('/');
    exit();
}

// Referal Functional

function generate_referral_code_for_user($user_id)
{
    $referral_code = get_user_meta($user_id, 'referral_code', true);
    if (!$referral_code) {
        $referral_code = wp_generate_password(12, false); // generează un cod unic
        update_user_meta($user_id, 'referral_code', $referral_code);
    }
    return home_url('?ref=' . $referral_code);
}

// Funcția care generează shortcode-ul pentru linkul de referal
function referral_link_shortcode()
{
    $user_id = get_current_user_id();
    if ($user_id) {
        $referral_link = generate_referral_code_for_user($user_id);
        return esc_url($referral_link);
    }
    return '<p>Trebuie să te autentifici pentru a primi linkul tău de referal.</p>';
}

add_shortcode('referral_link', 'referral_link_shortcode');


// Afișează linkul de referal pe pagina de profil a utilizatorului
function display_referral_link()
{
    $user_id = get_current_user_id();
    if ($user_id) {
        $referral_link = generate_referral_code_for_user($user_id);
        echo '<p class="referal_link"><span>' . pll__('Link-ul tău de referal:') . ' </span><a href="' . esc_url($referral_link) . '">' . esc_url($referral_link) . '</a></p>';
    }
}

add_action('woocommerce_account_dashboard', 'display_referral_link');


// Salvează ID-ul utilizatorului care a trimis invitația într-un cookie
function track_referral()
{
    if (isset($_GET['ref'])) {
        $referral_code = sanitize_text_field($_GET['ref']);
        $inviter_user = get_users(array('meta_key' => 'referral_code', 'meta_value' => $referral_code));
        if ($inviter_user) {
            setcookie('referrer', $inviter_user[0]->ID, time() + 3600 * 24 * 30, COOKIEPATH, COOKIE_DOMAIN); // Stochează ID-ul utilizatorului care a invitat pentru 30 de zile
        }
    }
}

add_action('init', 'track_referral');

add_action('user_register', 'handle_referral_on_registration');

function handle_referral_on_registration($user_id)
{
    // Verificăm dacă există cookie de referal
    if (isset($_COOKIE['referrer'])) {
        $referrer_id = sanitize_text_field($_COOKIE['referrer']);

        // Salvăm meta
        update_user_meta($user_id, 'referred_by', $referrer_id);
        update_user_meta($user_id, 'referral_date', current_time('mysql'));

        // Ștergem cookie-ul
        setcookie('referrer', '', time() - 3600, COOKIEPATH, COOKIE_DOMAIN);

        // Generăm cupon pentru utilizatorul nou
        $invited_code = create_discount_code($user_id);

        // Generăm cupon pentru cel care a invitat
        $inviter_code = create_discount_code($referrer_id);

        // Trimitem emailuri
        $user = get_userdata($user_id);
        $email = $user->user_email;
        $subject = pll__('Cod de reducere pentru înregistrare');
        $message = pll__('Mulțumim că te-ai înregistrat! Codul tău de reducere este: ') . $invited_code;
        wp_mail($email, $subject, $message);

        $inviter = get_userdata($referrer_id);
        $inviter_email = $inviter->user_email;
        $inviter_subject = pll__('Cod de reducere pentru invitație');
        $inviter_message = pll__('Mulțumim că ai invitat un prieten! Codul tău de reducere este: ') . $inviter_code;
        wp_mail($inviter_email, $inviter_subject, $inviter_message);
    }
}


// La înregistrarea unui nou utilizator, salvează referal-ul
//function save_referral_on_registration($user_id)
//{
//    if (isset($_COOKIE['referrer'])) {
//        // Salvează ID-ul utilizatorului care a făcut invitația
//        update_user_meta($user_id, 'referred_by', sanitize_text_field($_COOKIE['referrer']));
//
//        // Salvează data invitației
//        update_user_meta($user_id, 'referral_date', current_time('mysql')); // Salvează data și ora curentă în format MySQL
//
//        // Șterge cookie-ul după înregistrare
//        setcookie('referrer', '', time() - 3600, COOKIEPATH, COOKIE_DOMAIN);
//    }
//}
//
//add_action('user_register', 'save_referral_on_registration');
function create_discount_code($user_id, $discount_amount = 10)
{
    // Generăm un cod unic pentru cupon
    $code = strtoupper(wp_generate_password(6, false));

    // Detalii cupon
    $coupon = array(
        'post_title' => $code,
        'post_content' => '',
        'post_status' => 'publish',
        'post_author' => 1,
        'post_type' => 'shop_coupon'
    );

    // Creăm cuponul
    $new_coupon_id = wp_insert_post($coupon);

    // Setăm detaliile reducerii
    update_post_meta($new_coupon_id, 'discount_type', 'percent');
    update_post_meta($new_coupon_id, 'coupon_amount', $discount_amount);
    update_post_meta($new_coupon_id, 'individual_use', 'yes');
    update_post_meta($new_coupon_id, 'usage_limit', '1');

    // Adăugăm data de expirare (30 de zile de la crearea cuponului)
    $expiration_date = date('Y-m-d', strtotime('+30 days'));
    update_post_meta($new_coupon_id, 'expiry_date', $expiration_date);

    // Salvăm cuponul și data de expirare în profilul utilizatorului
    $user_coupons = get_user_meta($user_id, 'referral_coupons', true);
    if (!$user_coupons) {
        $user_coupons = [];
    }

    $user_coupons[] = array(
        'code' => $code,
        'used' => false, // Marcat ca nefolosit inițial
        'expiration_date' => $expiration_date // Adăugăm data de expirare
    );

    update_user_meta($user_id, 'referral_coupons', $user_coupons);

    return $code;
}

//
//function send_referral_discount_email($user_id)
//{
//    $inviter_id = get_user_meta($user_id, 'referred_by', true);
//    if ($inviter_id) {
//        // Generează coduri pentru ambele părți
//        $invited_code = create_discount_code($user_id);
//        $inviter_code = create_discount_code($inviter_id);
//
//        // Trimite email utilizatorului invitat
//        $user = get_userdata($user_id);
//        $email = $user->user_email;
//        $subject = pll__('Cod de reducere pentru înregistrare');
//        $message = pll__('Mulțumim că te-ai înregistrat! Codul tău de reducere este: ') . $invited_code;
//        wp_mail($email, $subject, $message);
//
//        // Trimite email utilizatorului care a invitat
//        $inviter = get_userdata($inviter_id);
//        $inviter_email = $inviter->user_email;
//        $inviter_subject = pll__('Cod de reducere pentru invitație');
//        $inviter_message = pll__('Mulțumim că ai invitat un prieten! Codul tău de reducere este: ') . $inviter_code;
//        wp_mail($inviter_email, $inviter_subject, $inviter_message);
//    }
//}

//add_action('user_register', 'send_referral_discount_email');

// Returneaza codul promotional din pagina CART/CHECKOUT
function get_oldest_valid_unused_referral_coupon_code($user_id = null)
{
    if (!$user_id) {
        $user_id = get_current_user_id();
    }

    if (!$user_id) {
        return false;
    }

    $coupons = get_user_meta($user_id, 'referral_coupons', true);

    if (!is_array($coupons) || empty($coupons)) {
        return false;
    }

    $now = current_time('Y-m-d');
    $valid_unused_coupons = [];

    foreach ($coupons as $coupon) {
        // Verifică dacă e neutilizat
        if (empty($coupon['used']) && !empty($coupon['code']) && !empty($coupon['expiration_date'])) {
            // Verifică dacă e încă valabil (nu a expirat)
            if ($coupon['expiration_date'] >= $now) {
                // Verifică dacă cuponul există în baza de date și e publicat
                $coupon_post = get_page_by_title($coupon['code'], OBJECT, 'shop_coupon');
                if ($coupon_post && $coupon_post->post_status === 'publish') {
                    $valid_unused_coupons[] = $coupon;
                }
            }
        }
    }

    if (empty($valid_unused_coupons)) {
        return false;
    }

    // Sortează după data de expirare (cel mai vechi = cel mai aproape de expirare)
    usort($valid_unused_coupons, function ($a, $b) {
        return strtotime($a['expiration_date']) <=> strtotime($b['expiration_date']);
    });

    return $valid_unused_coupons[0]['code'] ?? false;
}


add_action('woocommerce_order_status_completed', 'mark_referral_coupon_as_used');

function mark_referral_coupon_as_used($order_id)
{
    $order = wc_get_order($order_id);
    $user_id = $order->get_user_id();

    if (!$user_id) {
        return;
    }

    $used_coupons = $order->get_used_coupons();
    if (empty($used_coupons)) {
        return;
    }

    $user_coupons = get_user_meta($user_id, 'referral_coupons', true);
    if (!is_array($user_coupons)) {
        return;
    }

    foreach ($user_coupons as &$coupon) {
        if (in_array($coupon['code'], $used_coupons)) {
            $coupon['used'] = true;
        }
    }

    update_user_meta($user_id, 'referral_coupons', $user_coupons);
}


function get_invited_users_by_user($inviter_id)
{
    // Obține toți utilizatorii care au fost invitați de acest utilizator
    $invited_users = get_users(array(
        'meta_key' => 'referred_by',
        'meta_value' => $inviter_id,
    ));

    return $invited_users;
}

function invited_users_list_shortcode()
{
    $user_id = get_current_user_id();

    if (!$user_id) {
        return '<p>Trebuie să fii autentificat pentru a vedea lista invitaților tăi.</p>';
    }

    $invited_users = get_invited_users_by_user($user_id);

    if (empty($invited_users)) {
        return '';
    }
    echo '<h6 class="invited_friends_title">' . pll__("Prieteni Invitați") . '</h6>';
    $output = '<ul class="invited_list">';
    foreach ($invited_users as $user) {
        $referral_date = get_user_meta($user->ID, 'referral_date', true);
        $referral_date_formatted = $referral_date ? date_i18n('d.m.Y', strtotime($referral_date)) : 'Data necunoscută';

        $output .= '<li><span>' . esc_html($user->user_email) . '</span><p>' . esc_html($referral_date_formatted) . '</p></li>';
    }
    $output .= '</ul>';

    return $output;
}

add_shortcode('invited_users_list', 'invited_users_list_shortcode');


// Custom Registration form!

function custom_registration_form()
{
    ?>
    <div id="registerModal" class="custom_modal">
        <form id="ajaxRegisterForm">
            <p class="form-row">

                <label for="first_name"><?php echo pll_e('Nume') ?></label>
                <input type="text" name="first_name"
                       value="<?php echo(isset($_POST['first_name']) ? esc_attr($_POST['first_name']) : ''); ?>">
            </p>
            <p class="form-row">

                <label for="last_name"><?php echo pll_e('Prenume') ?></label>
                <input type="text" name="last_name"
                       value="<?php echo(isset($_POST['last_name']) ? esc_attr($_POST['last_name']) : ''); ?>">
            </p>
            <p class="form-row">

                <label for="email">Email</label>
                <input type="email" name="email"
                       value="<?php echo(isset($_POST['email']) ? esc_attr($_POST['email']) : ''); ?>" required>
            </p>
            <p class="form-row">

                <label for="password"><?php echo pll_e('Parolă') ?></label>
                <input type="password" name="password" required>
            </p>
            <p class="form-row">
                <label for="confirm_password"><?php echo pll_e('Confirmă Parola') ?></label>
                <input type="password" name="confirm_password" required>
            </p>
            <p class="birthdate">
                <label for="birthdate"><?php echo pll_e('Data Nașterii') ?></label>
                <br>
                <select name="birth_day" required>
                    <option value=""><?php echo pll_e('Zi') ?></option>
                    <?php for ($i = 1; $i <= 31; $i++): ?>
                        <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                    <?php endfor; ?>
                </select>
                <select name="birth_month" required>
                    <option value=""><?php echo pll_e('Lună') ?></option>
                    <?php for ($i = 1; $i <= 12; $i++): ?>
                        <option value="<?php echo $i; ?>"><?php echo date('F', mktime(0, 0, 0, $i, 10)); ?></option>
                    <?php endfor; ?>
                </select>
                <select name="birth_year" required>
                    <option value=""><?php echo pll_e('An') ?></option>
                    <?php for ($i = date('Y'); $i >= 1900; $i--): ?>
                        <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                    <?php endfor; ?>
                </select>
            </p>
            <p class="form-row newsletter_checkbox_wrap">
                <input type="checkbox" name="subscribe_to_newsletter" id="subscribe_to_newsletter">
                <label for="subscribe_to_newsletter"><?php echo pll_e('Abonează-te la newsletter') ?></label>
            </p>
            <div id="register_error_message" style="color:red;"></div>
            <div id="registerMessage" class="modal">
                <div class="modal_header">
                    <h4><?php echo pll_e('Multumesc pentru inregistrare!') ?></h4>
                    <div class="close">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                                  fill="white"></path>
                        </svg>
                    </div>
                </div>
                <div class="modal_content">
                    <p><?php echo pll_e('Înregistrare reușită! Redirectionare...') ?></p>
                </div>
                <div class="modal_footer">
                    <span class="close"><?php echo pll_e('Închide') ?></span>
                </div>
            </div>
            <div class="buttons">
                <p>
                    <input type="submit" name="submit_registration" value="<?php echo pll_e('Înregistrare') ?>">
                </p>
            </div>
        </form>
    </div>
    <?php
}

function custom_registration_validation($email, $password, $confirm_password, $birth_day, $birth_month, $birth_year)
{
    global $reg_errors;
    $reg_errors = new WP_Error;

    if (empty($email) || empty($password) || empty($confirm_password) || empty($birth_day) || empty($birth_month) || empty($birth_year)) {
        $reg_errors->add('field', pll__('Toate câmpurile sunt obligatorii.'));
    }
    if (!is_email($email)) {
        $reg_errors->add('email_invalid', pll__('Adresa de email nu este validă.'));
    }
    if (email_exists($email)) {
        $reg_errors->add('email', pll__('Email-ul există deja.'));
    }
    if (strlen($password) < 6) {
        $reg_errors->add('password', pll__('Parola trebuie să conțină cel puțin 6 caractere.'));
    }
    if ($password !== $confirm_password) {
        $reg_errors->add('password_mismatch', pll__('Parolele nu se potrivesc.'));
    }

    return $reg_errors;
}

function custom_registration_complete()
{
    global $reg_errors, $email, $password;

    if (isset($_POST['submit_registration'])) {
        $first_name = sanitize_text_field($_POST['first_name']);
        $last_name = sanitize_text_field($_POST['last_name']);
        $email = sanitize_email($_POST['email']);
        $password = esc_attr($_POST['password']);
        $confirm_password = esc_attr($_POST['confirm_password']);

        $birth_day = intval($_POST['birth_day']);
        $birth_month = intval($_POST['birth_month']);
        $birth_year = intval($_POST['birth_year']);

        custom_registration_validation($first_name, $last_name, $email, $password, $confirm_password, $birth_day, $birth_month, $birth_year);

        if (is_wp_error($reg_errors)) {
            foreach ($reg_errors->get_error_messages() as $error) {
                echo '<div style="color:red;">' . $error . '</div>';
            }
        }

        if (1 > count($reg_errors->get_error_messages())) {
            $user_id = wp_create_user($email, $password, $email);
            if (!is_wp_error($user_id)) {
                // ✅ Salvăm nume și prenume în meta și profil
                update_user_meta($user_id, 'first_name', sanitize_text_field($_POST['first_name']));
                update_user_meta($user_id, 'last_name', sanitize_text_field($_POST['last_name']));
                wp_update_user([
                    'ID' => $user_id,
                    'first_name' => sanitize_text_field($_POST['first_name']),
                    'last_name' => sanitize_text_field($_POST['last_name']),
                ]);

                // ✅ Salvăm data nașterii
                $birth_date = sprintf('%04d-%02d-%02d', $birth_year, $birth_month, $birth_day);
                update_user_meta($user_id, 'birth_date', $birth_date);
                if (!is_wp_error($user_id)) {
                    // ... cod de update_user_meta etc.
                    wp_send_json_success(pll__('Înregistrare realizată cu succes!'));
                } else {
                    wp_send_json_error(pll__('A apărut o eroare la crearea contului.'));
                }

            }
        }
    }
}

function custom_user_registration()
{
    custom_registration_form();
    custom_registration_complete();
}

add_shortcode('custom_registration', 'custom_user_registration');

// Accesare data nasterii utilizatorilor
//$birth_date = get_user_meta($user_id, 'birth_date', true);


//Ajax Register

function ajax_register()
{
//    error_reporting(E_ALL);
//    ini_set('display_errors', 1);

    // DEBUG: vezi dacă funcția se execută
//    error_log('=== AJAX REGISTER START ===');

    $first_name = sanitize_text_field($_POST['first_name']);
    $last_name = sanitize_text_field($_POST['last_name']);
    $email = sanitize_email($_POST['email']);
    $password = esc_attr($_POST['password']);
    $confirm_password = esc_attr($_POST['confirm_password']);
    $birth_day = intval($_POST['birth_day']);
    $birth_month = intval($_POST['birth_month']);
    $birth_year = intval($_POST['birth_year']);
    $subscribe_to_newsletter = isset($_POST['subscribe_to_newsletter']) && $_POST['subscribe_to_newsletter'] == 1;

    if (email_exists($email)) {
        wp_send_json_error(pll__('Email-ul există deja.'));
    } elseif ($password !== $confirm_password) {
        wp_send_json_error(pll__('Parolele nu se potrivesc.'));
    } elseif (strlen($password) < 6) {
        wp_send_json_error(pll__('Parola trebuie să conțină cel puțin 6 caractere.'));
    } elseif ($birth_day && $birth_month && $birth_year) {
        // Verifică dacă data nașterii este validă
        if (!checkdate($birth_month, $birth_day, $birth_year)) {
            wp_send_json_error(pll__('Data nașterii este invalidă.'));
        }
    } else {
        wp_send_json_error(pll__('Te rugăm să completezi data nașterii.'));
    }

    // Crează utilizatorul
    $user_id = wp_create_user($email, $password, $email);

    if (!is_wp_error($user_id)) {
        // Salvează data nașterii ca metadată a utilizatorului
        update_user_meta($user_id, 'birth_date', "{$birth_year}-{$birth_month}-{$birth_day}");

        // Salvează statusul de "neconfirmat" al email-ului
        update_user_meta($user_id, 'email_verified', 'no');

        send_verification_email($user_id);

        update_user_meta($user_id, 'first_name', $first_name);
        update_user_meta($user_id, 'last_name', $last_name);
        wp_update_user([
            'ID' => $user_id,
            'first_name' => sanitize_text_field($_POST['first_name']),
            'last_name' => sanitize_text_field($_POST['last_name']),
        ]);

        update_user_meta($user_id, 'billing_first_name', $first_name);
        update_user_meta($user_id, 'billing_last_name', $last_name);
        update_user_meta($user_id, 'billing_email', $email);

        // Dacă checkbox-ul de abonare la newsletter este bifat

        if ($subscribe_to_newsletter) {
            $apiKey = '607de8ab8e8912621b74d9bef6ef4913-us21';
            $listId = '9431edb7bc';
            $dc = substr($apiKey, strpos($apiKey, '-') + 1);

            $data = [
                'email_address' => $email,
                'status' => 'subscribed'
            ];

            $response = wp_remote_post("https://{$dc}.api.mailchimp.com/3.0/lists/{$listId}/members", [
                'headers' => [
                    'Authorization' => 'Basic ' . base64_encode('user:' . $apiKey),
                    'Content-Type' => 'application/json',
                ],
                'body' => json_encode($data),
            ]);

            if (is_wp_error($response)) {
                // opțional: loghează eroarea dar nu oprești înregistrarea
                error_log('Mailchimp error: ' . $response->get_error_message());
            }
        }
        wp_set_current_user($user_id); // setează utilizatorul curent
        wp_set_auth_cookie($user_id, true); // setează cookie-ul de autentificare (true => persistent login)

        wp_send_json_success();
    } else {
        wp_send_json_error('Eroare la crearea contului.');
    }
}

add_action('wp_ajax_nopriv_ajax_register', 'ajax_register');
add_action('wp_ajax_ajax_register', 'ajax_register');


// Custom Log In form
function custom_login_form()
{
    if (is_user_logged_in()) {
        echo '<p>Ești deja autentificat.</p>';
    } else {
        ?>
        <div id="loginModal" class="custom_modal">
            <form id="ajaxLoginForm">
                <p class="form-row">
                    <label for="username">Email</label>
                    <input type="text" name="username" required>
                </p>
                <p class="form-row">
                    <label for="password"><?php echo pll_e('Parolă') ?></label>
                    <input type="password" name="password" required>
                </p>
                <p id="loginMessage" style="color:red;"></p>
                <div class="buttons">
                    <p>
                        <a href="#" class="lost_password">
                            <?php echo pll_e('Ți-ai uitat parola?') ?>
                        </a>
                    </p>
                    <p>
                        <input type="submit" name="submit_login" value="<?php echo pll_e('Loghează-te') ?>">
                    </p>
                </div>
            </form>
        </div>
        <?php
    }
}

function custom_login_function()
{
    if (isset($_POST['submit_login'])) {
        $username = sanitize_user($_POST['username']);
        $password = esc_attr($_POST['password']);

        $credentials = array(
            'user_login' => $username,
            'user_password' => $password,
            'remember' => true,
        );

        $user = wp_signon($credentials, false);

        if (is_wp_error($user)) {
            echo '<p style="color: red;">Autentificare eșuată: ' . $user->get_error_message() . '</p>';
        } else {
            echo '<p style="color: green;">' . pll__('Autentificare reușită. Redirectionare...') . '</p>';
            wp_redirect(home_url()); // Redirecționare către pagina principală
            exit;
        }
    }
}

function custom_user_login()
{
    ob_start();
    custom_login_form();
    custom_login_function();
    return ob_get_clean();
}

add_shortcode('custom_login', 'custom_user_login');

// Ajax Log In
function ajax_login()
{
    $info = array();
    $info['user_login'] = $_POST['username'];
    $info['user_password'] = $_POST['password'];
    $info['remember'] = true;

    $user_signon = wp_signon($info, false);
    if (is_wp_error($user_signon)) {
        wp_send_json_error(pll__('Email-ul sau parola nu sunt corecte'));
    } else {
        wp_send_json_success();
    }
}

add_action('wp_ajax_nopriv_ajax_login', 'ajax_login');
add_action('wp_ajax_ajax_login', 'ajax_login');

function send_verification_email($user_id)
{
    $user_info = get_userdata($user_id);
    $user_email = $user_info->user_email;
    $verification_token = md5(uniqid($user_id, true));

    // Salvează token-ul ca metadată pentru a-l valida ulterior
    update_user_meta($user_id, 'verification_token', $verification_token);

    // Construiește link-ul de verificare
    $verification_url = add_query_arg(
        array(
            'verify_email' => $verification_token,
            'user_id' => $user_id
        ),
        home_url()
    );

    $subject = pll__('Verifică-ți email-ul');
    $message = pll__('Bună ziua!') . "\n\n";
    $message .= pll__('Te rugăm să îți verifici email-ul accesând acest link:') . "\n\n";
    $message .= $verification_url;
    wp_mail($user_email, $subject, $message);
}

function verify_user_email()
{
    if (isset($_GET['verify_email']) && isset($_GET['user_id'])) {
        $user_id = $_GET['user_id'];
        $verification_token = $_GET['verify_email'];

        // Verifică dacă token-ul se potrivește
        $saved_token = get_user_meta($user_id, 'verification_token', true);

        if ($saved_token === $verification_token) {
            // Marchează utilizatorul ca verificat
            update_user_meta($user_id, 'email_verified', 'yes');
            delete_user_meta($user_id, 'verification_token'); // Șterge token-ul

            wp_redirect(home_url(pll__('/verificare-reusita/'))); // Redirecționează utilizatorul pe o pagină de succes
            exit;
        } else {
            wp_redirect(home_url(pll__('/verificare-esuata/'))); // Redirecționează utilizatorul pe o pagină de eroare
            exit;
        }
    }
}

add_action('init', 'verify_user_email');


function remove_excerpt_more_link($more)
{
    return ''; // Elimină textul „Read more”
}

add_filter('excerpt_more', 'remove_excerpt_more_link');


// Adăugare tab personalizat în pagina My Account
function add_promo_codes_tab($items)
{
    $items['promo-codes'] = __('Coduri promoționale', 'text-domain');
    return $items;
}

add_filter('woocommerce_account_menu_items', 'add_promo_codes_tab');

// Conținutul tab-ului Coduri promoționale
function promo_codes_content()
{

    $user_id = get_current_user_id();
    if (!$user_id) {
        return;
    }

    $user_coupons = get_user_meta($user_id, 'referral_coupons', true);

    if ($user_coupons && is_array($user_coupons)) {
        echo '<ul class="promo_codes">';

        foreach ($user_coupons as $index => $coupon) {
            $expiration_date = isset($coupon['expiration_date']) ? strtotime($coupon['expiration_date']) : null;
            $current_date = time();
            $days_left = $expiration_date ? ceil(($expiration_date - $current_date) / (60 * 60 * 24)) : null;

            // Verifică dacă mai sunt 7 zile sau mai puțin și adaugă clasa "expiring-soon" dacă e cazul
//            $class = ($days_left !== null && $days_left <= 7 && $days_left >= 0) ? 'expiring-soon' : '';
            $class = '';
            if ($days_left !== null) {
                if ($days_left < 0) {
                    $class = 'expired';
                } elseif ($days_left <= 7) {
                    $class = 'expiring-soon';
                }
            }

            echo '<li class="' . esc_attr($class) . '">';
//            var_dump($coupon);
            echo '<h3>' . pll__('Reducere 10%') . '</h3>';
            echo '<p class="expire_date">' . pll__('Expira pe: ') . $coupon['expiration_date'] . '</p>';
            if ($days_left !== null) {
                if ($days_left < 0) {
                    echo '<p class="expired_text">' . pll__('Acest coupon a expirat') . '</p>';
                } else {
                    echo '<p class="label_text">' . pll__('Acest coupon vă oferă o reducere de 10% la toate produsele noastre') . '</p>';
                }
            }
            ?>
            <p class="form-row">
                <label for=""><?php echo pll_e('Promo code') ?></label>
                <input type="text" readonly value="<?= $coupon['code'] ?>" class="coupon_code_account">
                <button class="copy_icon">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_458_18927)">
                            <path d="M15 14.375V3.125C15 2.95924 14.9342 2.80027 14.8169 2.68306C14.6997 2.56585 14.5408 2.5 14.375 2.5L3.125 2.5C2.95924 2.5 2.80027 2.56585 2.68306 2.68306C2.56585 2.80027 2.5 2.95924 2.5 3.125V14.375C2.5 14.5408 2.56585 14.6997 2.68306 14.8169C2.80027 14.9342 2.95924 15 3.125 15H14.375C14.5408 15 14.6997 14.9342 14.8169 14.8169C14.9342 14.6997 15 14.5408 15 14.375ZM3.75 13.75V3.75L13.75 3.75V13.75H3.75ZM16.875 17.5H5.625C5.45924 17.5 5.30027 17.4342 5.18306 17.3169C5.06585 17.1997 5 17.0408 5 16.875C5 16.7092 5.06585 16.5503 5.18306 16.4331C5.30027 16.3158 5.45924 16.25 5.625 16.25H16.25V5.625C16.25 5.45924 16.3158 5.30027 16.4331 5.18306C16.5503 5.06585 16.7092 5 16.875 5C17.0408 5 17.1997 5.06585 17.3169 5.18306C17.4342 5.30027 17.5 5.45924 17.5 5.625V16.875C17.5 17.0408 17.4342 17.1997 17.3169 17.3169C17.1997 17.4342 17.0408 17.5 16.875 17.5Z"
                                  fill="#ffffff"></path>
                        </g>
                        <defs>
                            <clipPath id="clip0_458_18927">
                                <rect width="20" height="20" fill="white" transform="matrix(0 1 -1 0 20 0)"></rect>
                            </clipPath>
                        </defs>
                    </svg>
                    <span class="tooltiptext" id="myTooltipCoupon"><?php echo pll_e('Copie cod-ul!') ?></span>
                </button>
            </p>
            <?php
//            if ($coupon['used']) {
//                echo ' - <em>Folosit</em>';
//            } else {
//                echo ' - <strong>Nefolosit</strong>';
//                // Afișează timpul rămas dacă există o dată de expirare
//                if ($expiration_date) {
//                    echo ' - Expiră în ' . absint($days_left) . ' zile';
//                }
//            }

            echo '</li>';
        }

        echo '</ul>';
    } else {
        echo '<p>' . pll__('Nu ai coduri de reducere disponibile.') . '</p>';
    }

    function mark_coupon_as_used($coupon_code)
    {
        $user_id = get_current_user_id();
        if (!$user_id) {
            return;
        }

        $user_coupons = get_user_meta($user_id, 'referral_coupons', true);

        if ($user_coupons && is_array($user_coupons)) {
            foreach ($user_coupons as $index => $coupon) {
                if ($coupon['code'] === $coupon_code && !$coupon['used']) {
                    $user_coupons[$index]['used'] = true; // Marchează cuponul ca folosit
                    break;
                }
            }

            update_user_meta($user_id, 'referral_coupons', $user_coupons);
        }
    }

}

add_action('woocommerce_account_promo-codes_endpoint', 'promo_codes_content');

// Creează endpoint-ul pentru tab-ul Coduri promoționale
function add_promo_codes_endpoint()
{
    add_rewrite_endpoint('promo-codes', EP_ROOT | EP_PAGES);
}

add_action('init', 'add_promo_codes_endpoint');

// Rezolvă problema cu permalinks
function flush_rewrite_rules_on_activation()
{
    add_promo_codes_endpoint();
    flush_rewrite_rules();
}

register_activation_hook(__FILE__, 'flush_rewrite_rules_on_activation');


function custom_change_document_title($title)
{
    if (is_account_page() && is_wc_endpoint_url('promo-codes')) {
        $title = __('Coduri promoționale - Contul Meu', 'text-domain');
    }
    return $title;
}

add_filter('pre_get_document_title', 'custom_change_document_title');

function custom_my_account_menu_order($menu_links)
{
    // Scoate și reordonează link-urile de navigare
    $new_order = array(
        'dashboard' => pll__('Dashboard'),
        'orders' => pll__('Comenzi'),
        'promo-codes' => pll__('Coduri promoționale'), // Endpoint personalizat
        'edit-address' => pll__('Adrese'),
        'edit-account' => pll__('Detalii cont'),
        'customer-logout' => pll__('Deconectare'),
    );

    // Returnează ordinea personalizată
    return $new_order;
}

add_filter('woocommerce_account_menu_items', 'custom_my_account_menu_order');

remove_action('woocommerce_checkout_before_customer_details', array(WC_Stripe_Payment_Request::instance(), 'display_payment_request_button_html'), 1); //removes the button
remove_action('woocommerce_checkout_before_customer_details', array(WC_Stripe_Payment_Request::instance(), 'display_payment_request_button_separator_html'), 2); // removes the separator under button


add_action('woocommerce_review_order_before_submit', array(WC_Stripe_Payment_Request::instance(), 'display_payment_request_button_html'), 1); // adds the button before payments
//add_action('woocommerce_review_order_before_submit', array(WC_Stripe_Payment_Request::instance(), 'display_payment_request_button_separator_html'), 2); // adds separator before payments after button

add_action('template_redirect', function () {
    // Verifică dacă utilizatorul încearcă să acceseze pagina de logare
    if (is_account_page() && !is_user_logged_in()) {
        // Redirecționează utilizatorul către homepage (sau alt URL)
        wp_redirect(home_url('/?open_login_modal=1'));
        exit;
    }
});


// Request reset password and Send Email

add_action('wp_ajax_reset_password_request', 'handle_reset_password_request');
add_action('wp_ajax_nopriv_reset_password_request', 'handle_reset_password_request');

function handle_reset_password_request()
{
    // Verifică dacă există un email în request
    if (!isset($_POST['email']) || empty($_POST['email'])) {
        wp_send_json_error(['message' => pll__('Te rog introdu un email valid.')]);
    }

    $email = sanitize_email($_POST['email']);
    if (!is_email($email)) {
        wp_send_json_error(['message' => pll__('Adresa de email nu este validă.')]);
    }

    // Verifică dacă email-ul este înregistrat
    $user = get_user_by('email', $email);
    if (!$user) {
        wp_send_json_error(['message' => pll__('Nu există niciun cont cu acest email.')]);
    }

    // Generare link resetare parolă
    $reset_key = get_password_reset_key($user);
    if (is_wp_error($reset_key)) {
        wp_send_json_error(['message' => pll__('A apărut o eroare la generarea link-ului de resetare.')]);
    }

    $reset_url = home_url("?action=reset_password&key=$reset_key&login=" . rawurlencode($user->user_login));


    // Trimite email-ul
    $subject = pll__('Resetare parolă - ') . get_bloginfo('name');
    $message = pll__('Salut, ') . $user->user_login . "!\n\n";
    $message .= pll__('Ai cerut să îți resetezi parola. Apasă pe link-ul de mai jos pentru a continua:') . "\n\n";
    $message .= $reset_url . "\n\n";
    $message .= pll__('Dacă nu ai cerut această acțiune, te rugăm să ignori acest email.') . "\n\n";
    $message .= pll__('Echipa ') . get_bloginfo('name');

    $headers = ['Content-Type: text/plain; charset=UTF-8'];

    $mail_sent = wp_mail($email, $subject, $message, $headers);

    if (!$mail_sent) {
        wp_send_json_error(['message' => pll__('Nu s-a putut trimite email-ul. Încearcă din nou.')]);
    }

    // Răspuns de succes
    wp_send_json_success(['message' => pll__('Email-ul a fost trimis. Verifică inbox-ul pentru mai multe detalii.')]);
}


add_action('wp_ajax_reset_password', 'handle_reset_password');
add_action('wp_ajax_nopriv_reset_password', 'handle_reset_password');

function handle_reset_password()
{
    // Verificăm parametrii
    if (!isset($_POST['password'], $_POST['key'], $_POST['login'])) {
        wp_send_json_error(['message' => 'Parametrii lipsesc.']);
    }

    $password = sanitize_text_field($_POST['password']);
    $confirm_password = sanitize_text_field($_POST['confirmPassword']);
    $key = sanitize_text_field($_POST['key']);
    $login = sanitize_text_field($_POST['login']);

    if (strlen($password) < 6) {
        wp_send_json_error(['message' => pll__('Parola trebuie să conțină cel puțin 6 caractere.')]);
    }

    // Verificăm utilizatorul și cheia de resetare
    $user = check_password_reset_key($key, $login);
    if (is_wp_error($user)) {
        wp_send_json_error(['message' => pll__('Cheia de resetare este invalidă sau expirată.')]);
    }

    // Resetăm parola
    reset_password($user, $password);

    wp_send_json_success(['message' => pll__('Parola a fost resetată cu succes! Te vom redirecționa...')]);
}


add_action('init', function () {
    // Reîncărcăm domeniile de traducere pentru pluginuri și teme
    load_plugin_textdomain('woocommerce', false, dirname(plugin_basename(__FILE__)) . '/languages');
    load_plugin_textdomain('acf', false, dirname(plugin_basename(__FILE__)) . '/languages');
}, 11);


add_action('woocommerce_admin_order_item_headers', 'adauga_titlu_sku_in_admin', 20);
add_action('woocommerce_admin_order_item_values', 'afiseaza_sku_in_comanda_admin', 20, 3);

function adauga_titlu_sku_in_admin()
{
    echo '<th class="sku">SKU</th>';
}

function afiseaza_sku_in_comanda_admin($product_object, $item, $item_id)
{
    // Afișăm doar pentru produse (line_item)
    if ($item->get_type() !== 'line_item') {
        echo '<td class="sku">—</td>';
        return;
    }

    $product = $item->get_product();
    if ($product && is_object($product)) {
        $sku = $product->get_sku();
        echo '<td class="sku">' . esc_html($sku ?: '—') . '</td>';
    } else {
        echo '<td class="sku">—</td>';
    }
}

// add_action('init', 'update_capabilitati_depozit_manager');
// function update_capabilitati_depozit_manager()
// {
//     $role = get_role('depozit_manager');
//     if ($role) {
//         $role->add_cap('read');
//         $role->add_cap('edit_shop_orders');
//         $role->add_cap('read_shop_order');
//         $role->add_cap('manage_woocommerce');
//         $role->add_cap('edit_posts');
// 		$role->add_cap('delete_shop_orders');
//         $role->add_cap('delete_shop_order');
//         $role->add_cap('edit_shop_order');
//         $role->add_cap('edit_others_shop_orders');
//         $role->add_cap('publish_shop_orders');
//     }
// }

add_action('admin_head', 'ascunde_itemi_meniu_pentru_depozit_manager');
function ascunde_itemi_meniu_pentru_depozit_manager()
{
    if (current_user_can('depozit_manager')) {
        echo '<style>
            #menu-posts, #toplevel_page_yith_plugin_panel,             /* Postări */
            #menu-comments,           /* Comentarii */
            #toplevel_page_wpcf7,              /* Media */
            #toplevel_page_wc-admin,  /* Analytics (WooCommerce Dashboard) */
            #toplevel_page_woo-jtl-connector,              /* Unelte */
            #toplevel_page_admin-page-wc-settings-tab-checkout-from-PAYMENTS_MENU_ITEM,         /* Aspect */
            #toplevel_page_wc-admin-path--analytics-overview,            /* Pluginuri */
            #toplevel_page_woocommerce-marketing,           /* Setări */
            #menu-tools,              /* Utilizatori */
            #toplevel_page_acf-options,              /* Pagini */
            .update-plugins,          /* Bulele roșii cu update */
            .wp-menu-separator        /* Separator */
            {
                display: none !important;
            }
        </style>';
    }
}

add_action('admin_head', 'ascunde_itemi_meniu_pentru_shop_manager');
function ascunde_itemi_meniu_pentru_shop_manager()
{
    if (current_user_can('shop_manager')) {
        echo '<style>
            #menu-posts, #toplevel_page_yith_plugin_panel, #toplevel_page_wpseo_workouts, #toplevel_page_wp-mail-smtp, #toplevel_page_edit-post_type-acf-field-group,             /* Postări */
            #menu-comments,  #menu-settings, #menu-users, #menu-appearance, #toplevel_page_raport-gheata, #toplevel_page_admin-page-wc-settings-tab-checkout,         /* Comentarii */
            #toplevel_page_wpcf7, #toplevel_page_berocket_account, #menu-posts-product, #menu-pages, #menu-media,           
            #toplevel_page_wc-admin,  
            #toplevel_page_woo-jtl-connector, 
            #toplevel_page_admin-page-wc-settings-tab-checkout-from-PAYMENTS_MENU_ITEM,   
            #toplevel_page_wc-admin-path--analytics-overview,     
            #toplevel_page_woocommerce-marketing,     
            #menu-tools,  
            #toplevel_page_acf-options,    
            .update-plugins, .wp-menu-separator, #toplevel_page_duplicator, #toplevel_page_mlang, #toplevel_page_elfsight-whatsapp-chat, #toplevel_page_mailchimp-for-wp        /* Separator */
            {
                display: none !important;
            }
        </style>';
    }
}


add_filter('wpo_wcpdf_simple_template_default_table_headers', 'custom_invoice_table_headers', 10, 2);

function custom_invoice_table_headers($headers, $document)
{
    unset($headers['product']);
    unset($headers['quantity']);
    unset($headers['price']);

    // Exemplu: redenumește coloana 'product' și elimină 'nr-art'
    $headers['position'] = __('Pos.', 'woocommerce-pdf-invoices-packing-slips');
    $headers['quantity'] = __('Menge', 'woocommerce-pdf-invoices-packing-slips');
    $headers['nr-art'] = __('Artikel', 'woocommerce-pdf-invoices-packing-slips');
    $headers['product'] = __('Produkt', 'woocommerce-pdf-invoices-packing-slips');
    $headers['tva'] = __('MwSt.', 'woocommerce-pdf-invoices-packing-slips');
    $headers['price'] = __('E.-Preis', 'woocommerce-pdf-invoices-packing-slips');
    $headers['subtotal'] = __('G.-Preis', 'woocommerce-pdf-invoices-packing-slips');

    return $headers;
}

add_filter('wpo_wcpdf_document_language', function ($lang) {
    return 'de'; // forțăm întotdeauna limba germană pentru factură
});


// Ajax check if min order reached

add_action('wp_ajax_check_cart_minimum', 'check_cart_minimum_ajax');
add_action('wp_ajax_nopriv_check_cart_minimum', 'check_cart_minimum_ajax');

function check_cart_minimum_ajax()
{
    if (!WC()->cart) {
        wc_load_cart(); // fallback dacă cumva nu e încărcat
    }

    WC()->cart->calculate_totals(); // foarte important!

    $minimum = 60;
    $subtotal = WC()->cart->subtotal;

    wp_send_json([
        'value' => $subtotal,
        'min_reached' => $subtotal >= $minimum,
        'subtotal' => wc_price($subtotal),
    ]);
}

//
//add_action('woocommerce_checkout_process', 'min_order_am');
//add_action('woocommerce_before_cart', 'min_order_am');
//
//function min_order_am()
//{
//    $minimum = 60;
//
//    if (WC()->cart->subtotal < $minimum) {
//
//        if (is_cart()) {
//
//            wc_print_notice(
//                sprintf('Der Warenkorbwert beträgt %s — der Mindestbestellwert muss %s betragen.',
//                    wc_price(WC()->cart->subtotal),
//                    wc_price($minimum)
//                ), 'error'
//            );
//
//        } else {
//
//            wc_add_notice(
//                sprintf('Der Warenkorbwert beträgt %s — der Mindestbestellwert muss %s betragen.',
//                    wc_price(WC()->cart->subtotal),
//                    wc_price($minimum)
//                ), 'error'
//            );
//
//        }
//    }
//}

// Calculare ce BOX este nevoie pentru ambalare!
function get_optimal_boxes_for_caserole($total_caserole)
{
    $boxes = [
        ['name' => 'B7/ 20l', 'capacity' => 7, 'price' => 4.93],
        ['name' => 'B14/ 39l', 'capacity' => 14, 'price' => 6.79],
        ['name' => 'B20/ 60l', 'capacity' => 20, 'price' => 15.79],
    ];

    $best = [
        'total_cost' => PHP_INT_MAX,
        'combo' => [],
        'total_capacity' => 0,
    ];

    for ($b20 = 0; $b20 <= ceil($total_caserole / 20); $b20++) {
        for ($b14 = 0; $b14 <= ceil($total_caserole / 14); $b14++) {
            for ($b7 = 0; $b7 <= ceil($total_caserole / 7); $b7++) {
                $total = $b20 * 20 + $b14 * 14 + $b7 * 7;

                if ($total >= $total_caserole) {
                    $cost = $b20 * 15.79 + $b14 * 6.79 + $b7 * 4.93;
                    if ($cost < $best['total_cost']) {
                        $best['total_cost'] = $cost;
                        $best['combo'] = [
                            'B20 / 60l' => $b20,
                            'B14 / 39l' => $b14,
                            'B7 / 20l' => $b7,
                        ];
                        $best['total_capacity'] = $total;
                    }
                }
            }
        }
    }

    return $best;
}

// End calculare Box pentru comanda!


// add_action('woocommerce_admin_order_data_after_order_details', 'afiseaza_cutii_depozit_in_admin');
// function afiseaza_cutii_depozit_in_admin($order)
// {
//     $numar_caserole = 0;
//     $bundle_details = []; // salvăm lista produselor incluse în bundle

//     foreach ($order->get_items() as $item) {
//         $product = $item->get_product();
//         $qty = $item->get_quantity();

//         // 🔍 Verificăm dacă produsul este BUNDLE
//         if ($product && method_exists($product, 'get_bundled_items')) {

//             $bundled_items = $product->get_bundled_items();

//             if (!empty($bundled_items)) {

//                 $bundle_title = $product->get_title();

//                 foreach ($bundled_items as $bundled_item) {

//                     $bundled_product = $bundled_item->get_product();
//                     $bundled_product_qty = $bundled_item->get_quantity(); // cantitate per bundle
//                     $total_qty = $bundled_product_qty * $qty;   // cantitate finală

//                     // 🟦 Adăugăm caserole la total
//                     $numar_caserole += $total_qty;

//                     // 🟪 Salvăm lista detaliată pentru depozit
//                     $bundle_details[$bundle_title][] = [
//                         'name' => $bundled_product->get_name(),
//                         'qty' => $total_qty,
//                     ];
//                 }

//                 continue; // trecem mai departe, nu mai calculăm ca produs simplu
//             }
//         }

//         // 🔹 Produs normal → 1 produs = 1 caserolă
//         $numar_caserole += $qty;
//     }

//     if ($numar_caserole <= 0) return;

//     // -----------------------------
//     // CALCUL CUTII
//     // -----------------------------
//     $cutii = get_optimal_boxes_for_caserole($numar_caserole);
//     $combo = $cutii['combo'];

//     $capacities = [
//         'B7/ 20l' => 7,
//         'B14/ 39l' => 14,
//         'B20/ 60l' => 20,
//     ];

//     $cutii_folosite = array_filter($combo);

//     $cutia_minima = null;
//     $capacitate_minima = PHP_INT_MAX;

//     foreach ($cutii_folosite as $tip => $cant) {
//         if (isset($capacities[$tip]) && $capacities[$tip] < $capacitate_minima) {
//             $capacitate_minima = $capacities[$tip];
//             $cutia_minima = $tip;
//         }
//     }

//     // -----------------------------
//     // OUTPUT ÎN ADMIN
//     // -----------------------------
//     echo '<p style="margin: 10px; display: block; font-size: 20px; line-height: 2;"><strong>Verpackungs Typ:</strong><br>';
//     echo "Aufläufe insgesamt: <strong>$numar_caserole</strong><br>";

//     foreach ($combo as $tip => $cant) {
//         if ($cant > 0) {
//             $nota = '';
//             if (count($cutii_folosite) > 1 && $tip === $cutia_minima) {
//                 $nota = ' <span style="font-size: 16px; color: #888;">(Immer voll)</span>';
//             }
//             echo "<b style='font-weight: 700; font-size: 20px;'>$cant x $tip</b>$nota<br>";
//         }
//     }

//     echo '</p>';

//     // -----------------------------
//     // LISTA PRODUCTIEI DE BUNDLE (CHECKLIST)
//     // -----------------------------
// //    if (!empty($bundle_details)) {
// //
// //        echo '<div style="margin: 20px 0; padding: 15px; border: 2px solid #333; background: #fafafa;">';
// //        echo '<h3 style="margin-top:0;">📦 Bundle Produkte (für Montage)</h3>';
// //
// //        foreach ($bundle_details as $bundle_name => $items) {
// //
// //            echo "<p><strong>$bundle_name</strong><br>";
// //
// //            foreach ($items as $prod) {
// //                echo "- {$prod['name']} x <b>{$prod['qty']}</b><br>";
// //            }
// //
// //            echo "</p>";
// //        }
// //
// //        echo '</div>';
// //    }
// }

add_action('woocommerce_admin_order_data_after_order_details', 'afiseaza_cutii_depozit_in_admin');
function afiseaza_cutii_depozit_in_admin($order)
{
    $numar_caserole = 0;
    $bundle_details = []; // salvăm lista produselor incluse în bundle

    foreach ($order->get_items() as $item) {
        $product = $item->get_product();
        $qty = $item->get_quantity();

        // 🔍 Verificăm dacă produsul este BUNDLE
        if ($product && method_exists($product, 'get_bundled_items')) {

            $bundled_items = $product->get_bundled_items();

            if (!empty($bundled_items)) {

                $bundle_title = $product->get_title();

                foreach ($bundled_items as $bundled_item) {

                    $bundled_product = $bundled_item->get_product();
                    $bundled_product_qty = $bundled_item->get_quantity(); // cantitate per bundle
                    $total_qty = $bundled_product_qty * $qty;   // cantitate finală

                    // 🟦 Adăugăm caserole la total
                    $numar_caserole += $total_qty;

                    // 🟪 Salvăm lista detaliată pentru depozit
                    $bundle_details[$bundle_title][] = [
                        'name' => $bundled_product->get_name(),
                        'qty' => $total_qty,
                    ];
                }

                continue; // trecem mai departe, nu mai calculăm ca produs simplu
            }
        }

        // 🔹 Produs normal → 1 produs = 1 caserolă
        $numar_caserole += $qty;
    }

    if ($numar_caserole <= 0) return;

    // -----------------------------
    // CALCUL CUTII
    // -----------------------------
    $cutii = get_optimal_boxes_for_caserole($numar_caserole);
    $combo = $cutii['combo'];

    $capacities = [
        'B7/ 20l' => 7,
        'B14/ 39l' => 14,
        'B20/ 60l' => 20,
    ];

    $cutii_folosite = array_filter($combo);

    $cutia_minima = null;
    $capacitate_minima = PHP_INT_MAX;

    foreach ($cutii_folosite as $tip => $cant) {
        if (isset($capacities[$tip]) && $capacities[$tip] < $capacitate_minima) {
            $capacitate_minima = $capacities[$tip];
            $cutia_minima = $tip;
        }
    }

    // -----------------------------
    // OUTPUT ÎN ADMIN
    // -----------------------------
    echo '<p style="margin: 10px; display: block; font-size: 20px; line-height: 2;"><strong>Verpackungs Typ:</strong><br>';
    echo "Aufläufe insgesamt: <strong>$numar_caserole</strong><br>";

    foreach ($combo as $tip => $cant) {
        if ($cant > 0) {
            $nota = '';
            if (count($cutii_folosite) > 1 && $tip === $cutia_minima) {
                $nota = ' <span style="font-size: 16px; color: #888;">(Immer voll)</span>';
            }
            echo "<b style='font-weight: 700; font-size: 20px;'>$cant x $tip</b>$nota<br>";
        }
    }

    echo '</p>';

    // -----------------------------
    // LISTA PRODUCTIEI DE BUNDLE (CHECKLIST)
    // -----------------------------
//    if (!empty($bundle_details)) {
//
//        echo '<div style="margin: 20px 0; padding: 15px; border: 2px solid #333; background: #fafafa;">';
//        echo '<h3 style="margin-top:0;">📦 Bundle Produkte (für Montage)</h3>';
//
//        foreach ($bundle_details as $bundle_name => $items) {
//
//            echo "<p><strong>$bundle_name</strong><br>";
//
//            foreach ($items as $prod) {
//                echo "- {$prod['name']} x <b>{$prod['qty']}</b><br>";
//            }
//
//            echo "</p>";
//        }
//
//        echo '</div>';
//    }
}
add_action('woocommerce_after_order_itemmeta', 'afiseaza_bundle_in_admin_order_items', 10, 3);
function afiseaza_bundle_in_admin_order_items($item_id, $item, $product)
{
    if (!$product || !method_exists($product, 'get_bundled_items')) {
        return; // nu e bundle
    }

    $bundled_items = $product->get_bundled_items();
    if (empty($bundled_items)) {
        return;
    }

    $qty_bundle = $item->get_quantity();

    echo '<div style="margin: 8px 0 0 15px; padding: 8px; border-left: 3px solid #0073aa; background: #f1f1f1;">';
    echo '<strong>📦 Conținut Bundle:</strong><br>';

    foreach ($bundled_items as $bundled_item) {

        $bundled_product = $bundled_item->get_product();
        $qty_per_bundle = $bundled_item->get_quantity();
        $total_qty = $qty_per_bundle;

        if (!$bundled_product) continue;

        $sku = $bundled_product->get_sku();
        $sku_text = $sku ? " SKU: $sku" : "";

        echo "<p style=' font-size: 16px;'><b style='display: block;'> {$bundled_product->get_name()}</b><b style='color: #888;'>{$sku_text}</b> × <strong>{$total_qty}</strong><br> </p>";
    }

    echo '</div>';
}



// add_action('woocommerce_admin_order_data_after_order_details', 'afiseaza_cutii_depozit_in_admin');
// function afiseaza_cutii_depozit_in_admin($order)
// {
//     $numar_caserole = 0;

//     foreach ($order->get_items() as $item) {
//         $numar_caserole += $item->get_quantity(); // fiecare produs = 1 caserolă
//     }

//     if ($numar_caserole > 0) {
//         $cutii = get_optimal_boxes_for_caserole($numar_caserole);
//         $combo = $cutii['combo'];

//         // Definim capacitatea cutiilor (pentru sortare)
//         $capacities = [
//             'B7/ 20l' => 7,
//             'B14/ 39l' => 14,
//             'B20/ 60l' => 20,
//         ];

//         // Filtrăm doar cutiile folosite (> 0)
//         $cutii_folosite = array_filter($combo);

//         // Găsim cutia cea mai mică dintre cele folosite
//         $cutia_minima = null;
//         $capacitate_minima = PHP_INT_MAX;
//         foreach ($cutii_folosite as $tip => $cant) {
//             if (isset($capacities[$tip]) && $capacities[$tip] < $capacitate_minima) {
//                 $capacitate_minima = $capacities[$tip];
//                 $cutia_minima = $tip;
//             }
//         }

//         echo '<p style="margin: 10px; display: block; font-size: 20px; line-height: 2;"><strong>Verpackungs Typ:</strong><br>';
//         echo "Aufläufe insgesamt: <strong>$numar_caserole</strong><br>";

//         foreach ($combo as $tip => $cant) {
//             if ($cant > 0) {
//                 $nota = '';
//                 if (count($cutii_folosite) > 1 && $tip === $cutia_minima) {
//                     $nota = ' <span style="font-size: 16px; color: #888;">(Immer voll)</span>';
//                 }
//                 echo "<b style='font-weight: 700; font-size: 20px;'>$cant x $tip</b>$nota<br>";
//             }
//         }

//         echo '</p>';
//     }
// }


// Evidenta Stocului de Cutii Termoizolatoare
add_action('woocommerce_order_status_processing', 'scade_cutii_din_stocuri_si_trimite_email');
function scade_cutii_din_stocuri_si_trimite_email($order_id)
{
    $order = wc_get_order($order_id);

    // Evităm scăderea dublă
    if (get_post_meta($order_id, '_cutii_deducted', true)) {
        return;
    }

    $numar_caserole = 0;
    foreach ($order->get_items() as $item) {
        $numar_caserole += $item->get_quantity();
    }

    $cutii = get_optimal_boxes_for_caserole($numar_caserole);

    $b7_stoc = (int)get_field('box_stock_b7', 'option');
    $b14_stoc = (int)get_field('box_stock_b14', 'option');
    $b20_stoc = (int)get_field('box_stock_b20', 'option');

    // Stocuri după scădere
    $b7_nou = max($b7_stoc - $cutii['combo']['B7'], 0);
    $b14_nou = max($b14_stoc - $cutii['combo']['B14'], 0);
    $b20_nou = max($b20_stoc - $cutii['combo']['B20'], 0);

    update_field('box_stock_b7', $b7_nou, 'option');
    update_field('box_stock_b14', $b14_nou, 'option');
    update_field('box_stock_b20', $b20_nou, 'option');

    update_post_meta($order_id, '_cutii_deducted', '1');

    // Verificăm dacă trebuie trimis email (dacă scade sub 20 și NU am notificat deja)
    $notificare_trimisa = get_field('cutii_notificare_trimisa', 'option');

    if (!$notificare_trimisa && ($b7_nou <= 20 || $b14_nou <= 20 || $b20_nou <= 20)) {
        $to = 'info@promez.ro'; // modifică adresa ta de email
        $subject = '⚠️ Stoc cutii scăzut';
        $message = "Stocurile de cutii au scăzut:\n\n" .
            "B7: $b7_nou bucăți\n" .
            "B14: $b14_nou bucăți\n" .
            "B20: $b20_nou bucăți\n\n" .
            "Te rugăm să verifici depozitul.";

        wp_mail($to, $subject, $message);

        // Marcam ca notificarea a fost trimisă
        update_field('cutii_notificare_trimisa', true, 'option');
    }
}

// END Evidenta stocului de cutii termoizolatoare!

add_filter('wc_order_statuses', 'filtreaza_statusuri_pentru_depozit');
function filtreaza_statusuri_pentru_depozit($order_statuses)
{
    if (current_user_can('depozit_manager')) {
        // Statusurile permise
        $allowed = [
            'wc-processing',
            'wc-completed',
        ];

        // Filtrăm statusurile
        foreach ($order_statuses as $key => $label) {
            if (!in_array($key, $allowed)) {
                unset($order_statuses[$key]);
            }
        }
    }

    return $order_statuses;
}

// add_action('admin_init', 'blocheaza_actiuni_bulk_depozit');
// function blocheaza_actiuni_bulk_depozit()
// {
//     if (current_user_can('depozit_manager') && isset($_REQUEST['action'])) {
//         $actiunile_blocate = [
//             'trash',
//             'mark_on-hold',
//             'mark_pending',
//             'mark_cancelled',
//             'mark_failed',
//         ];

//         $actiunile = [$_REQUEST['action'], $_REQUEST['action2']];
//         foreach ($actiunile as $act) {
//             if (in_array($act, $actiunile_blocate)) {
//                 wp_die('Nu ai permisiunea să efectuezi această acțiune.');
//             }
//         }
//     }
// }

add_action('woocommerce_refund_created', 'blocheaza_refund_pentru_depozit', 10, 2);
function blocheaza_refund_pentru_depozit($refund, $args)
{
    if (current_user_can('depozit_manager')) {
        wp_die('Nu ai permisiunea să faci refund la comenzi.');
    }
}


// End Afisare ce box este nevoie in admin

add_action('trimite_email_gheata_carbonica', 'calculeaza_si_trimite_gheata');

function calculeaza_si_trimite_gheata()
{

    $tz = wp_timezone();
    $now = new DateTime('now', $tz);
    $day_of_week = (int)$now->format('w'); // 0 = duminică, 1 = luni, ..., 6 = sâmbătă

    if (in_array($day_of_week, [0, 5, 6])) {
        error_log("Funcția calculeaza_si_trimite_gheata() NU se execută azi (ziua: $day_of_week)");
        return;
    }
    if ($day_of_week === 1) {
        // Luni dimineața: comenzile de Joi(4) Vineri (5), Sâmbătă (6), Duminică (0)
        $start = (clone $now)->modify('-4 days')->setTime(6, 01, 0);
        $end = (clone $now)->modify('-1 second')->setTime(6, 01);
    } else {
        // Restul zilelor: comenzile de ieri
        $start = (clone $now)->modify('-1 day')->setTime(6, 01, 0);
        $end = (clone $now)->modify('-1 second')->setTime(6, 01);
    }

//    // Interval: de la 05:00 cu o zi în urmă, până la 04:59:59 azi
//    $start = (clone $now)->modify('-1 day')->setTime(5, 0, 0);
//    $end = (clone $now)->setTime(4, 59, 59);

    $args = [
        'limit' => -1,
        'status' => ['processing'],
        'date_created' => $start->format('Y-m-d H:i:s') . '...' . $end->format('Y-m-d H:i:s'),
        'type' => 'shop_order',
        'exclude' => wc_get_orders(['status' => 'trash', 'return' => 'ids']),
    ];

    $orders = wc_get_orders($args);
    $total_caserole = 0;


    foreach ($orders as $order) {
        $order_id = $order->get_id();
        $order_total = 0;

        foreach ($order->get_items() as $item) {
            // evităm transportul sau alte taxe adăugate ca iteme
            if (!is_a($item, 'WC_Order_Item_Product')) continue;

            $qty = $item->get_quantity();
            $order_total += $qty;
            error_log("Comanda #$order_id - Produs: " . $item->get_name() . ", Cantitate: $qty");
        }

        error_log("Total caserole comanda #$order_id: $order_total");
        $total_caserole += $order_total;
    }
    error_log("Total caserole toate comenzile: $total_caserole");
    $date = the_date('d.m.Y');
    $total_gheata = $total_caserole * 0.5;

    // === Generare număr factură ===
    $an = $now->format('Y');
    $luna = $now->format('m');
    $istoric = get_field('istoric_comenzi_gheata', 'options') ?: [];

    $nr_curent = 1;

    foreach ($istoric as $item) {
        if (strpos($item['factura'], "PROMEZ-$an-$luna") === 0) {
            $nr_curent++;
        }
    }

    $nr_format = str_pad($nr_curent, 3, '0', STR_PAD_LEFT);
    $nr_factura = "PROMEZ-$an-$luna$nr_format";

// === Salvare istoric comenzi gheata ===
    $istoric[] = [
        'data' => $now->format('Y-m-d'),
        'factura' => $nr_factura,
        'cantitae_comanda' => $total_gheata,
        'comenzi_incluse' => implode(',', wp_list_pluck($orders, 'id')),
    ];
    update_field('istoric_comenzi_gheata', $istoric, 'options');

    if (get_field('email_comanda_gheata', 'options')) {
        $to = 'info@trockeneis24.eu, smauch@spedition-rieber.de, victor@zazitex.com, support@promez.de';
//        $to = 'lcdima1993@gmail.com';
    } else {
        $to = 'victor@zazitex.com';
    }
//    $to = 'info@trockeneis24.eu, smauch@spedition-rieber.de, victor@zazitex.com, support@promez.de';

    $subject = 'Bestellung Trockeneis – ' . $nr_factura . ' (automatisch generiert)';
    $message = '<p>Sehr geehrte Damen und Herren,</p>';
    $message .= '<p>dies ist eine automatisch generierte E-Mail aus unserem Bestellsystem. Im Anhang finden Sie unsere nächste Bestellung:</p>';

    $message .= '<p><b>Bestellnummer:</b> ' . $nr_factura . '<br>';
    $message .= '<b>Produkt:</b> Trockeneis-Scheiben, 210x125x25 mm<br>';
//    $message .= '<b>Menge:</b> ' . round($total_gheata) . ' kg<br>';
    $message .= '<b>Menge:</b> 25 kg<br>';
    $message .= '<b>Liefertermin:</b> FIX ' . $date . '<br>';
    $message .= '<b>Gewünschte Lieferzeit:</b> 07:00 AM sharp<br>';
    $message .= '<b>Lieferadresse:</b><br>
                 Spedition Rieber<br>
                 Julius-Schlegel-Straße 2<br>
                 D-88525 Dürmentingen<br>
                 Ansprechpartner vor Ort: Stefanie Mauch, +49 (0) 7371 / 9502-51</p>';

    $message .= '<p><b>Hinweis zur Handhabung:</b><br>
                 Bitte stellen Sie sicher, dass die Ware transportsicher und in optimalem Zustand verpackt wird.</p>';

    $message .= '<p>Bei dringenden Angelegenheiten oder Notfällen wenden Sie sich bitte an Ihre Kontaktperson bei der Firma Kragman GmbH.</p>';

    $message .= '<p><b>Hinweis:</b><br>
                 Diese E-Mail kann vertrauliche und/oder rechtlich geschützte Informationen enthalten.<br>
                 Der Inhalt ist ausschließlich für den vorgesehenen Empfänger bestimmt.<br>
                 Jegliche Art der Nutzung oder Weitergabe fehlgeleiteter E-Mails ist untersagt.</p>';

    $headers = ['Content-Type: text/html; charset=UTF-8'];

    wp_mail($to, $subject, $message, $headers);


    // === Salvare total gheață în ACF repeater ===
    $acum = new DateTime('now', wp_timezone());
    $luna_curenta = $acum->format('Y-m');

    $rows = get_field('total_gheata_lunara', 'options') ?: [];
    $gasit = false;

// Verificăm dacă există deja intrarea pentru luna curentă
    foreach ($rows as &$row) {
        if ($row['luna'] === $luna_curenta) {
            $row['cantitate'] += round($total_gheata);
            $gasit = true;
            break;
        }
    }

// Dacă nu există, o adăugăm
    if (!$gasit) {
        $rows[] = [
            'luna' => $luna_curenta,
            'cantitate' => round($total_gheata),
        ];
    }

// Salvăm în ACF
    update_field('total_gheata_lunara', $rows, 'options');

    error_log("=== END calcul gheata ===");
}

add_shortcode('afisare_gheata_lunara', function () {
    $rows = get_field('total_gheata_lunara', 'options');
    if (!$rows) return 'Nu există date înregistrate.';

    $output = '<table style="width:100%;  border-collapse:collapse;" border="1">';
    $output .= '<tr><th>Luna</th><th>Gheață totală (kg)</th></tr>';

    foreach ($rows as $row) {
        $output .= '<tr>';
        $output .= '<td>' . esc_html($row['luna']) . '</td>';
        $output .= '<td>' . round(esc_html($row['cantitate'])) . ' kg</td>';
        $output .= '</tr>';
    }

    $output .= '</table>';


    return $output;
});

add_action('admin_menu', function () {
    add_menu_page(
        'Raport Gheață Carbonică',
        'Gheață Carbonică',
        'manage_options',
        'raport-gheata',
        'afiseaza_raport_gheata_callback',
        'dashicons-chart-line',
        59
    );
});


function afiseaza_raport_gheata_callback()
{
    ?>
    <div class="wrap">
        <h1>Raport Gheață Carbonică</h1>

        <h2>Total lunar de gheață (kg)</h2>
        <p>Mai jos ai cantitatea totală de gheață pe lunile înregistrate:</p>
        <?php echo do_shortcode('[afisare_gheata_lunara]'); ?>

        <h2 style="margin-top: 40px;">Istoric comenzi gheață trimise</h2>
        <?php
        $istoric = get_field('istoric_comenzi_gheata', 'options');

        if ($istoric):
            echo '<table>';
            echo '<tr><th>Data</th><th>Factura</th><th>Cantitate (kg)</th><th>Comenzi incluse</th></tr>';

            foreach ($istoric as $entry) {
                echo '<tr>';
                echo '<td>' . esc_html($entry['data']) . '</td>';
                echo '<td>' . esc_html($entry['factura']) . '</td>';
                echo '<td>' . round(esc_html($entry['cantitae_comanda'])) . ' kg</td>';
                echo '<td><details><summary>Vezi</summary><pre>' . esc_html($entry['comenzi_incluse']) . '</pre></details></td>';
                echo '</tr>';
            }

            echo '</table>';
        else:
            echo '<p>Nu există comenzi de gheață înregistrate.</p>';
        endif;
        ?>

        <style>
            table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 20px;
            }

            th, td {
                border: 1px solid #ccc;
                padding: 8px;
                text-align: left;
            }

            th {
                background: #f7f7f7;
            }

            details summary {
                cursor: pointer;
                color: #0073aa;
            }

            pre {
                margin: 0;
                font-size: 13px;
                white-space: pre-wrap;
                word-break: break-word;
            }
        </style>
    </div>
    <?php
}

add_action('init', function () {
    if (isset($_GET['reset_gheata']) && current_user_can('manage_options')) {
//        delete_field('total_gheata_lunara', 'options');
//        delete_field('istoric_comenzi_gheata', 'options');
        exit('Statistica de gheață a fost ștearsă cu succes!');
    }
});

add_filter('woocommerce_package_rates', 'oculta_livrarea_contra_cost_daca_e_gratuita', 100, 2);

function oculta_livrarea_contra_cost_daca_e_gratuita($rates, $package)
{
    $gratuita = false;

    // Verificăm dacă livrarea gratuită este disponibilă
    foreach ($rates as $rate_id => $rate) {
        if ($rate->method_id === 'free_shipping') {
            $gratuita = true;
            break;
        }
    }

    // Dacă există livrare gratuită, eliminăm celelalte opțiuni
    if ($gratuita) {
        foreach ($rates as $rate_id => $rate) {
            if ($rate->method_id !== 'free_shipping') {
                unset($rates[$rate_id]);
            }
        }
    }

    return $rates;
}

add_filter('woocommerce_cart_tax_totals', 'traducere_denumire_taxe_dupa_limba', 20, 1);

function traducere_denumire_taxe_dupa_limba($tax_totals)
{
    if (!function_exists('pll_current_language')) {
        return $tax_totals; // Asigură-te că Polylang e activ
    }

    $limba = pll_current_language(); // sau apply_filters( 'wpml_current_language', NULL ) pentru WPML

    foreach ($tax_totals as $key => $tax) {
        // Verifică numele original al taxei (de ex: "MWST.")
        if ($tax->label === 'MwSt.') {
            if ($limba === 'ro') {
                $tax->label = 'TVA';
            } elseif ($limba === 'en') {
                $tax->label = 'VAT';
            }
        }
    }

    return $tax_totals;
}


add_action('init', function () {
    if (isset($_GET['test_gheata']) && current_user_can('manage_options')) {
        do_action('trimite_email_gheata_carbonica');
        exit('Funcția <strong>calculeaza_si_trimite_gheata()</strong> a fost apelată manual. Verifică logurile, emailul și datele din admin.');
    }
});


add_image_size('slider_hd', 1920, 0, false); // păstrează proporțiile


add_action('template_redirect', function () {
    if (!is_user_logged_in() || is_admin() || WC()->is_rest_api_request()) {
        return;
    }

    $coupon_code = 'first15';
    $user_id = get_current_user_id();

    // Verifică dacă cuponul există
    $coupon_id = wc_get_coupon_id_by_code($coupon_code);
    if (!$coupon_id) {
        return;
    }

    // Verificăm dacă userul a mai folosit cuponul
    if (!has_user_used_coupon($user_id, $coupon_code) && !WC()->cart->has_discount($coupon_code)) {
        WC()->cart->apply_coupon($coupon_code);
    }
});


function has_user_used_coupon($user_id, $coupon_code)
{
    if (!$user_id) return false;

    $orders = wc_get_orders([
        'customer_id' => $user_id,
        'limit' => -1,
        'status' => ['completed', 'processing', 'on-hold'],
        'return' => 'ids',
    ]);

    foreach ($orders as $order_id) {
        $order = wc_get_order($order_id);
        foreach ($order->get_coupon_codes() as $used_coupon) {
            if (strtolower($used_coupon) === strtolower($coupon_code)) {
                return true;
            }
        }
    }

    return false;
}

// modificare format data Invoice
add_filter('wpo_wcpdf_date_format', function ($format, $document_type, $order) {
    // Schimbă formatul aici – de ex. 'd.m.Y' pentru 22.07.2025
    return 'd.m.Y';
}, 10, 3);

// verificare modal First15
add_action('wp_footer', function () {
    // Nu rulăm în admin sau pentru crawlere
    if (is_admin() || wp_doing_ajax()) return;

    $show_modal = true;

    if (is_user_logged_in()) {
        $user_id = get_current_user_id();
        $orders = wc_get_orders([
            'customer_id' => $user_id,
            'limit' => 1,
            'status' => ['wc-processing', 'wc-completed']
        ]);

        if (!empty($orders)) {
            $show_modal = false; // Are deja cel puțin o comandă
        }
    }

    // Injectăm variabila JS globală
    echo '<script>window.showPromoModal = ' . ($show_modal ? 'true' : 'false') . ';</script>';
});


//  Critical CSS
function insert_critical_css()
{
    if (!is_admin()) {
        ?>
        <style>
            @charset "UTF-8";
            @font-face {
                font-family: Antonio;
                font-style: normal;
                font-weight: 100 700;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Antonio Cyrillic.woff') format("woff2")
            }

            @font-face {
                font-family: "Nunito Sans";
                font-style: normal;
                font-weight: 200 1000;
                font-stretch: 100%;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Nunito Sans 200 cyr ext.woff2') format("woff2");
                unicode-range: U+0460-052F, U+1C80-1C8A, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F
            }

            @font-face {
                font-family: "Nunito Sans";
                font-style: normal;
                font-weight: 200 1000;
                font-stretch: 100%;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Nunito sans 200 cyr.woff2') format("woff2");
                unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116
            }

            @font-face {
                font-family: "Nunito Sans";
                font-style: normal;
                font-weight: 200 1000;
                font-stretch: 100%;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Nunito sans 200 vietnamese.woff2') format("woff2");
                unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB
            }

            @font-face {
                font-family: "Nunito Sans";
                font-style: normal;
                font-weight: 200 1000;
                font-stretch: 100%;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Nunito sans 200 latin ext.woff2') format("woff2");
                unicode-range: U+0100-02BA, U+02BD-02C5, U+02C7-02CC, U+02CE-02D7, U+02DD-02FF, U+0304, U+0308, U+0329, U+1D00-1DBF, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF
            }

            @font-face {
                font-family: "Nunito Sans";
                font-style: normal;
                font-weight: 200 1000;
                font-stretch: 100%;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Nunito sans 200 latin.woff2') format("woff2");
                unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
            }

            @font-face {
                font-family: Onest;
                font-style: normal;
                font-weight: 100 900;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Onest cyr ext.woff2') format("woff2");
                unicode-range: U+0460-052F, U+1C80-1C8A, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F
            }

            @font-face {
                font-family: Onest;
                font-style: normal;
                font-weight: 100 900;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Onest cyr.woff2') format("woff2");
                unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116
            }

            @font-face {
                font-family: Onest;
                font-style: normal;
                font-weight: 100 900;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Onest latin-ext.woff2') format("woff2");
                unicode-range: U+0100-02BA, U+02BD-02C5, U+02C7-02CC, U+02CE-02D7, U+02DD-02FF, U+0304, U+0308, U+0329, U+1D00-1DBF, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF
            }

            @font-face {
                font-family: Onest;
                font-style: normal;
                font-weight: 100 900;
                font-display: swap;
                src: url('https://promez.de/wp-content/themes/victor-child/assets/fonts/Onest Latin.woff2') format("woff2");
                unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
            }

            .wpcf7 .screen-reader-response {
                position: absolute;
                overflow: hidden;
                clip: rect(1px, 1px, 1px, 1px);
                clip-path: inset(50%);
                height: 1px;
                width: 1px;
                margin: -1px;
                padding: 0;
                border: 0;
                word-wrap: normal !important
            }

            .wpcf7 .hidden-fields-container {
                display: none
            }

            .wpcf7 form .wpcf7-response-output {
                margin: 2em .5em 1em;
                padding: .2em 1em;
                border: 2px solid #00a0d2
            }

            .wpcf7 form.init .wpcf7-response-output {
                display: none
            }

            .wpcf7-form-control-wrap {
                position: relative
            }

            .wpcf7-list-item {
                display: inline-block;
                margin: 0 0 0 1em
            }

            .wpcf7-list-item-label::after, .wpcf7-list-item-label::before {
                content: " "
            }

            .wpcf7 input[type=tel] {
                direction: ltr
            }

            :root {
                --woocommerce: #720eec;
                --wc-green: #7ad03a;
                --wc-red: #a00;
                --wc-orange: #ffba00;
                --wc-blue: #2ea2cc;
                --wc-primary: #720eec;
                --wc-primary-text: #fcfbfe;
                --wc-secondary: #e9e6ed;
                --wc-secondary-text: #515151;
                --wc-highlight: #958e09;
                --wc-highligh-text: white;
                --wc-content-bg: #fff;
                --wc-subtext: #767676;
                --wc-form-border-color: rgba(32, 7, 7, 0.8);
                --wc-form-border-radius: 4px;
                --wc-form-border-width: 1px
            }

            .screen-reader-text {
                clip: rect(1px, 1px, 1px, 1px);
                height: 1px;
                overflow: hidden;
                position: absolute !important;
                width: 1px;
                word-wrap: normal !important
            }

            .dgwt-wcas-search-wrapp {
                position: relative;
                line-height: 100%;
                display: block;
                color: #444;
                min-width: 230px;
                width: 100%;
                text-align: left;
                margin: 0 auto;
                -webkit-box-sizing: border-box;
                -moz-box-sizing: border-box;
                box-sizing: border-box
            }

            .dgwt-wcas-search-wrapp * {
                -webkit-box-sizing: border-box;
                -moz-box-sizing: border-box;
                box-sizing: border-box
            }

            .dgwt-wcas-search-form {
                margin: 0;
                padding: 0;
                width: 100%
            }

            input[type=search].dgwt-wcas-search-input {
                -webkit-box-shadow: none;
                box-shadow: none;
                margin: 0;
                -webkit-appearance: textfield;
                text-align: left
            }

            [type=search].dgwt-wcas-search-input::-ms-clear {
                display: none
            }

            [type=search].dgwt-wcas-search-input::-webkit-search-decoration {
                -webkit-appearance: none
            }

            [type=search].dgwt-wcas-search-input::-webkit-search-cancel-button {
                display: none
            }

            .dgwt-wcas-style-pirx .dgwt-wcas-sf-wrapp button.dgwt-wcas-search-submit:before {
                display: none
            }

            button.dgwt-wcas-search-submit {
                position: relative
            }

            .dgwt-wcas-ico-magnifier {
                bottom: 0;
                left: 0;
                margin: auto;
                position: absolute;
                right: 0;
                top: 0;
                height: 65%;
                display: block
            }

            .dgwt-wcas-preloader {
                height: 100%;
                position: absolute;
                right: 0;
                top: 0;
                width: 40px;
                z-index: -1;
                background-repeat: no-repeat;
                background-position: right 15px center;
                background-size: auto 44%
            }

            .dgwt-wcas-voice-search {
                position: absolute;
                right: 0;
                top: 0;
                height: 100%;
                width: 40px;
                z-index: 1;
                opacity: .5;
                align-items: center;
                justify-content: center;
                display: none
            }

            .screen-reader-text {
                clip: rect(1px, 1px, 1px, 1px);
                height: 1px;
                overflow: hidden;
                position: absolute !important;
                width: 1px
            }

            .dgwt-wcas-sf-wrapp:after, .dgwt-wcas-sf-wrapp:before {
                content: "";
                display: table
            }

            .dgwt-wcas-sf-wrapp:after {
                clear: both
            }

            .dgwt-wcas-sf-wrapp {
                zoom: 1;
                width: 100%;
                max-width: 100vw;
                margin: 0;
                position: relative;
                background: 0 0
            }

            .dgwt-wcas-sf-wrapp input[type=search].dgwt-wcas-search-input {
                width: 100%;
                height: 40px;
                font-size: 14px;
                line-height: 100%;
                padding: 10px 15px;
                margin: 0;
                background: #fff;
                border: 1px solid #ddd;
                border-radius: 3px;
                -webkit-border-radius: 3px;
                -webkit-appearance: none;
                box-sizing: border-box
            }

            .dgwt-wcas-sf-wrapp input[type=search].dgwt-wcas-search-input::-webkit-input-placeholder {
                color: #999;
                font-weight: 400;
                font-style: italic;
                line-height: normal
            }

            .dgwt-wcas-sf-wrapp input[type=search].dgwt-wcas-search-input:-moz-placeholder {
                color: #999;
                font-weight: 400;
                font-style: italic;
                line-height: normal
            }

            .dgwt-wcas-sf-wrapp input[type=search].dgwt-wcas-search-input::-moz-placeholder {
                color: #999;
                font-weight: 400;
                font-style: italic;
                line-height: normal
            }

            .dgwt-wcas-sf-wrapp input[type=search].dgwt-wcas-search-input:-ms-input-placeholder {
                color: #999;
                font-weight: 400;
                font-style: italic;
                line-height: normal
            }

            .dgwt-wcas-sf-wrapp button.dgwt-wcas-search-submit {
                overflow: visible;
                position: absolute;
                border: 0;
                padding: 0 15px;
                margin: 0;
                height: 40px;
                min-width: 50px;
                width: auto;
                line-height: 100%;
                min-height: 100%;
                right: 0;
                left: auto;
                top: 0;
                bottom: auto;
                color: #fff;
                text-transform: uppercase;
                background-color: #333;
                border-radius: 0 2px 2px 0;
                -webkit-border-radius: 0 2px 2px 0;
                text-shadow: 0 -1px 0 rgba(0, 0, 0, .3);
                -webkit-box-shadow: none;
                box-shadow: none;
                -webkit-appearance: none
            }

            .dgwt-wcas-sf-wrapp .dgwt-wcas-search-submit:before {
                content: '';
                position: absolute;
                border-width: 8px 8px 8px 0;
                border-style: solid solid solid none;
                border-color: transparent #333;
                top: 12px;
                left: -6px
            }

            .dgwt-wcas-sf-wrapp .dgwt-wcas-search-submit::-moz-focus-inner {
                border: 0;
                padding: 0
            }

            .dgwt-wcas-has-submit .dgwt-wcas-search-submit svg path {
                fill: #fff
            }

            .dgwt-wcas-style-pirx .dgwt-wcas-sf-wrapp {
                background: #fff;
                padding: 10px;
                border-radius: 10px
            }

            .dgwt-wcas-style-pirx .dgwt-wcas-sf-wrapp input[type=search].dgwt-wcas-search-input {
                padding: 13px 24px 13px 48px;
                line-height: 24px;
                font-size: 17px;
                border: 2px solid transparent;
                border-radius: 30px;
                height: auto;
                font-family: Roboto, sans-serif;
                background-color: #eee
            }

            .dgwt-wcas-style-pirx .dgwt-wcas-sf-wrapp button.dgwt-wcas-search-submit {
                background: 0 0;
                border-radius: 100%;
                border: 0;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 0;
                margin: 0;
                position: absolute;
                min-height: 33px;
                min-width: 33px;
                height: 33px;
                width: 33px;
                left: 23px;
                top: 21px
            }

            .dgwt-wcas-style-pirx .dgwt-wcas-sf-wrapp button.dgwt-wcas-search-submit svg {
                width: 18px;
                height: 18px
            }

            .dgwt-wcas-style-pirx .dgwt-wcas-preloader {
                margin-right: 35px
            }

            .dgwt-wcas-style-pirx.dgwt-wcas-has-submit .dgwt-wcas-search-submit svg path {
                fill: #111
            }

            .dgwt-wcas-style-pirx .dgwt-wcas-voice-search {
                right: 20px;
                top: 1px;
                opacity: 1
            }

            body {
                margin: 0;
                font-family: "Nunito Sans", sans-serif !important
            }

            h2, h3, h4 {
                margin-top: 0;
                font-family: Onest, sans-serif !important
            }

            * {
                box-sizing: border-box
            }

            a {
                text-decoration: none !important
            }

            .container {
                max-width: 1230px;
                width: 100%;
                margin: 0 auto;
                padding: 0 15px
            }

            .container_fluid {
                max-width: 1920px;
                width: 100%;
                margin: 0 auto !important
            }

            a, b, body, div, fieldset, footer, form, h2, h3, h4, header, html, iframe, img, label, li, nav, p, span, ul {
                margin: 0;
                padding: 0;
                border: 0;
                font-size: 100%;
                font: inherit;
                vertical-align: baseline
            }

            footer, header, nav {
                display: block
            }

            body {
                line-height: 1
            }

            ul {
                list-style: none
            }

            button, input {
                margin: 0;
                padding: 0;
                border: none;
                background: 0 0;
                font-family: inherit;
                font-size: inherit;
                line-height: inherit
            }

            img {
                max-width: 100%;
                height: auto
            }

            a {
                text-decoration: none;
                color: inherit
            }

            .woocommerce button {
                background: 0 0;
                border: none;
                padding: 0;
                color: inherit
            }

            header.site-header {
                background: rgba(34, 34, 34, .8);
                padding: 9px 0;
                position: fixed;
                top: 0;
                right: 0;
                left: 0;
                z-index: 22
            }

            @media screen and (max-width: 991px) {
                header.site-header {
                    padding: 5px 0
                }

                header.site-header .search .dgwt-wcas-search-wrapp .dgwt-wcas-search-form {
                    max-width: 150px
                }
            }

            header.site-header .search {
                display: flex;
                justify-content: flex-start;
                align-items: center
            }

            @media screen and (max-width: 768px) {
                header.site-header .search {
                    display: none
                }

                header.site-header .header_content .left_side .burger span {
                    display: none
                }
            }

            header.site-header .search .dgwt-wcas-search-wrapp .dgwt-wcas-search-form .dgwt-wcas-sf-wrapp {
                padding: 0;
                background: 0 0
            }

            header.site-header .search .dgwt-wcas-search-wrapp .dgwt-wcas-search-form .dgwt-wcas-sf-wrapp input[type=search] {
                border-radius: 4px 0 0 4px;
                border: 0;
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%;
                height: 44px;
                width: 0;
                padding: 12px 0
            }

            header.site-header .search .dgwt-wcas-search-wrapp .dgwt-wcas-search-form .dgwt-wcas-sf-wrapp .dgwt-wcas-preloader {
                margin-right: 0;
                right: 15px !important;
                display: none !important
            }

            header.site-header .search .dgwt-wcas-search-wrapp .dgwt-wcas-search-form .dgwt-wcas-sf-wrapp button.dgwt-wcas-search-submit {
                height: 44px;
                border-radius: 4px;
                background: var(--Red, #f20030);
                padding: 10px;
                width: 44px;
                top: 0;
                left: -1px;
                right: auto
            }

            header.site-header .search .dgwt-wcas-search-wrapp .dgwt-wcas-search-form .dgwt-wcas-sf-wrapp button.dgwt-wcas-search-submit svg path {
                fill: white
            }

            header.site-header .header_content {
                display: flex;
                justify-content: space-between;
                align-items: center
            }

            header.site-header .header_content .left_side {
                display: flex;
                justify-content: flex-start;
                align-items: center
            }

            header.site-header .header_content .left_side .burger {
                display: flex;
                justify-content: flex-start;
                align-items: center;
                margin-right: 65px
            }

            header.site-header .header_content .left_side .burger svg {
                margin-right: 12px
            }

            header.site-header .header_content .left_side .burger span {
                color: var(--White, #fff);
                font-family: Antonio, sans-serif;
                font-size: 23px;
                font-style: normal;
                font-weight: 700;
                line-height: 120%
            }

            header.site-header .header_content .site-logo {
                position: absolute;
                left: calc(50% - 90px);
                top: 10px;
                max-width: 180px
            }

            @media screen and (max-width: 1200px) {
                header.site-header .header_content .site-logo {
                    max-width: 160px;
                    left: calc(50% - 80px)
                }
            }

            header.site-header .header_content .header_actions {
                display: flex;
                justify-content: flex-end;
                align-items: center;
                position: relative
            }

            header.site-header .header_content .header_actions > a {
                margin-left: 24px;
                display: flex;
                align-items: center;
                padding: 5px 7px;
                position: relative
            }

            header.site-header .header_content .header_actions > a span {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 700;
                margin-left: 5px
            }

            header.site-header .header_content .header_actions > a.go_to_shop {
                border-radius: 8px;
                background: var(--White, #f80);
                border: 2px solid var(--White, #fff);
                padding: 10px 20px;
                color: var(--Black, #fff);
                text-align: center;
                font-family: Antonio;
                font-size: 20px;
                font-weight: 700;
                line-height: 120%
            }

            @media screen and (max-width: 768px) {
                header.site-header .header_content .site-logo {
                    top: 5px
                }

                header.site-header .header_content .header_actions > a.go_to_shop {
                    padding: 8px 15px;
                    font-size: 16px;
                    display: none
                }
            }

            header.site-header .header_content .header_actions .my_account_header {
                margin-left: 24px;
                align-items: center;
                padding: 5px 7px;
                position: relative;
                text-align: center
            }

            header.site-header .header_content .header_actions .my_account_header svg {
                height: 44px
            }

            header.site-header .header_content .header_actions .my_account_header span {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 700;
                display: block
            }

            header.site-header .header_content .header_actions .lang_navigation {
                margin: 0 20px;
                padding: 0
            }

            @media screen and (max-width: 580px) {
                header.site-header {
                    padding: 0 0 5px
                }

                header.site-header .header_content {
                    padding-top: 5px
                }

                header.site-header .header_content .header_actions .lang_navigation {
                    display: none
                }
            }

            header.site-header .header_content .header_actions .lang_navigation .lang-menu-container li.pll-parent-menu-item.menu-item-has-children {
                position: relative;
                width: 64px
            }

            header.site-header .header_content .header_actions .lang_navigation .lang-menu-container li.pll-parent-menu-item.menu-item-has-children:before {
                content: "";
                position: absolute;
                right: 0;
                width: 20px;
                height: 20px;
                display: block;
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/next.png');
                background-repeat: no-repeat;
                background-position: center;
                background-size: contain;
                transform: rotate(90deg);
                top: 10px
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_content .site-logo {
                    max-width: 110px;
                    left: calc(50% - 55px)
                }

                header.site-header .header_content .header_actions > a {
                    margin-left: 0
                }

                header.site-header .header_content .header_actions .lang_navigation {
                    padding: 0
                }

                header.site-header .header_content .header_actions .lang_navigation .lang-menu-container li.pll-parent-menu-item.menu-item-has-children:before {
                    width: 15px;
                    height: 15px;
                    top: 13px;
                    right: -20px
                }
            }

            header.site-header .header_content .header_actions .lang_navigation .lang-menu-container li.pll-parent-menu-item ul.sub-menu {
                opacity: 0;
                visibility: hidden;
                position: absolute;
                left: 0;
                top: 100%;
                padding: 10px 0;
                width: 64px
            }

            header.site-header .header_content .header_actions .lang_navigation .lang-menu-container li.pll-parent-menu-item ul.sub-menu li {
                margin-bottom: 10px
            }

            header.site-header .header_content .header_actions .cart_header {
                margin-left: 24px;
                padding: 5px 7px;
                position: relative;
                text-align: center
            }

            header.site-header .header_content .header_actions .cart_header span.count {
                width: 22px;
                height: 22px;
                border-radius: 50%;
                background: var(--Red, #f20030);
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 600;
                line-height: 22px;
                display: flex;
                align-items: center;
                justify-content: center;
                position: absolute;
                top: 0;
                right: 0
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_content .header_actions .cart_header {
                    margin-left: 10px;
                    padding: 5px 0
                }

                header.site-header .header_content .header_actions .cart_header span.count {
                    top: 7px;
                    right: -6px;
                    font-size: 9px;
                    width: 18px;
                    height: 18px
                }
            }

            @media screen and (max-width: 768px) {
                header.site-header .header_content .header_actions .cart_header svg {
                    display: none
                }

                header.site-header .header_content .header_actions .cart_header span.count {
                    display: none
                }
            }

            header.site-header .header_content .header_actions .cart_header span.toatal {
                font-size: 12px;
                color: #fff;
                text-align: center;
                display: block;
                font-family: "Nunito Sans"
            }

            header.site-header .header_content .header_actions .cart_header .mini_cart {
                position: absolute;
                top: calc(100% + 25px);
                width: 413px;
                right: -258px;
                padding: 25px 15px;
                border-radius: 8px;
                background: var(--White, #fff);
                display: none;
                z-index: 16;
                max-height: calc(100vh - 150px);
                overflow-y: auto
            }

            header.site-header .header_content .header_actions .cart_header .mini_cart:before {
                content: "";
                width: 0;
                height: 0;
                display: block;
                position: absolute;
                top: -10px;
                left: 123px;
                border-top: 0;
                border-bottom: 10px solid #fff;
                border-left: 10px solid transparent;
                border-right: 10px solid transparent
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_content .header_actions .cart_header .mini_cart {
                    right: -217px
                }

                header.site-header .header_content .header_actions .cart_header .mini_cart:before {
                    left: 171px
                }
            }

            @media screen and (max-width: 768px) {
                header.site-header .header_content .header_actions .cart_header span.toatal {
                    display: none
                }

                header.site-header .header_content .header_actions .cart_header .mini_cart {
                    max-width: 350px;
                    right: 0
                }

                header.site-header .header_content .header_actions .cart_header .mini_cart:before {
                    display: none
                }
            }

            header.site-header .header_content .header_actions .cart_header .mini_cart .mini_cart_header {
                margin-bottom: 20px;
                display: flex;
                justify-content: space-between;
                align-items: center
            }

            header.site-header .header_content .header_actions .cart_header .mini_cart .mini_cart_header span {
                color: var(--Black, #222);
                font-family: Antonio, sans-serif;
                font-size: 32px;
                font-style: normal;
                font-weight: 700;
                line-height: 120%
            }

            header.site-header .header_content .header_actions .cart_header .mini_cart .next, header.site-header .header_content .header_actions .cart_header .mini_cart .prev {
                text-align: center;
                margin-bottom: 15px
            }

            @media screen and (max-height: 768px) {
                header.site-header .header_content .header_actions .cart_header .mini_cart .next, header.site-header .header_content .header_actions .cart_header .mini_cart .prev {
                    display: none !important
                }
            }

            header.site-header .header_content .header_actions .cart_header .mini_cart .next {
                margin-bottom: 0;
                transform: rotate(180deg);
                bottom: 156px;
                width: 100%;
                position: absolute;
                left: 0
            }

            header.site-header .header_sidebar {
                position: fixed;
                max-width: 640px;
                width: 100%;
                background: var(--Black, #222);
                padding: 0 0 25px;
                top: 0;
                left: -100%;
                bottom: 0;
                z-index: 10
            }

            header.site-header .header_sidebar .top_header_sidebar {
                display: flex;
                align-items: center;
                justify-content: space-between;
                padding: 25px 25px 25px 200px;
                border-bottom: 1px solid var(--Grey-secondary, #d6d6d6);
                height: 91px
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_sidebar .top_header_sidebar {
                    padding: 25px 16px
                }
            }

            header.site-header .header_sidebar .top_header_sidebar .close {
                display: flex;
                justify-content: flex-start;
                align-items: center
            }

            header.site-header .header_sidebar .top_header_sidebar .mobile_top_header .lang_navigation {
                margin-right: 20px;
                display: none
            }

            header.site-header .header_sidebar .top_header_sidebar .mobile_top_header .lang_navigation .lang-menu-container {
                max-width: 20px
            }

            header.site-header .header_sidebar .top_header_sidebar .mobile_top_header .lang_navigation .lang-menu-container li.pll-parent-menu-item.menu-item-has-children {
                position: relative
            }

            header.site-header .header_sidebar .top_header_sidebar .mobile_top_header .lang_navigation .lang-menu-container li.pll-parent-menu-item.menu-item-has-children:before {
                content: "";
                position: absolute;
                right: -19px;
                width: 15px;
                height: 15px;
                display: block;
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/next.png');
                background-repeat: no-repeat;
                background-position: center;
                background-size: contain;
                transform: rotate(90deg);
                top: 7px
            }

            header.site-header .header_sidebar .top_header_sidebar .mobile_top_header .lang_navigation .lang-menu-container li.pll-parent-menu-item ul.sub-menu {
                display: none;
                position: absolute;
                left: -9px;
                top: 100%;
                z-index: 9;
                width: 40px;
                padding: 5px;
                background: #fff;
                text-align: center;
                border-radius: 5px
            }

            header.site-header .header_sidebar .top_header_sidebar .mobile_top_header .lang_navigation .lang-menu-container li.pll-parent-menu-item ul.sub-menu li {
                max-width: 20px;
                text-align: center;
                margin: 0 auto 10px
            }

            header.site-header .header_sidebar .sidebar_content {
                height: calc(100vh - 95px);
                overflow-y: auto;
                padding-bottom: 20px
            }

            header.site-header .header_sidebar .sidebar_content::-webkit-scrollbar {
                width: 7px
            }

            header.site-header .header_sidebar .sidebar_content::-webkit-scrollbar-track {
                box-shadow: inset 0 0 5px grey;
                border-radius: 10px;
                background: #d6d6d6
            }

            header.site-header .header_sidebar .sidebar_content::-webkit-scrollbar-thumb {
                background: #727272;
                border-radius: 10px
            }

            header.site-header .header_sidebar .sidebar_content .search {
                padding: 0 25px 0 200px;
                margin-top: 25px
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_sidebar .sidebar_content .search {
                    display: block;
                    padding: 0 16px
                }
            }

            header.site-header .header_sidebar .sidebar_content .search .dgwt-wcas-search-wrapp form.dgwt-wcas-search-form {
                max-width: 100%
            }

            header.site-header .header_sidebar .sidebar_content .search .dgwt-wcas-search-wrapp form.dgwt-wcas-search-form .dgwt-wcas-sf-wrapp input[type=search] {
                width: calc(100% - 44px);
                padding-left: 10px
            }

            header.site-header .header_sidebar .sidebar_content .search .dgwt-wcas-search-wrapp form.dgwt-wcas-search-form .dgwt-wcas-sf-wrapp button {
                left: auto;
                right: 0;
                border-radius: 0 4px 4px 0
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation {
                margin-top: 15px;
                padding-left: 200px;
                padding-right: 25px
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_sidebar .sidebar_content .primary-navigation {
                    padding: 0 16px
                }
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li {
                margin-bottom: 20px;
                padding-bottom: 20px;
                border-bottom: 1px solid #727272;
                padding-left: 15px
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children {
                padding-bottom: 0;
                position: relative
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children > a {
                margin-bottom: 20px;
                display: block;
                width: fit-content
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children button {
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/arrow-right.svg') no-repeat;
                position: absolute;
                right: 0;
                width: 20px;
                height: 20px;
                background-position: center;
                top: 5px;
                display: block;
                transform: rotate(90deg)
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children button span {
                display: none
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children ul {
                display: none
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children ul li {
                padding: 10px 15px;
                margin-bottom: 5px
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children ul li:last-of-type {
                border: 0
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.menu-item-has-children ul li a {
                font-size: 16px;
                color: #fff
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.current-menu-item {
                border-bottom: 1px solid #f20030
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li.current-menu-item a {
                color: #f20030
            }

            header.site-header .header_sidebar .sidebar_content .primary-navigation ul li a {
                color: var(--White, #fff);
                font-family: Antonio;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%
            }

            header.site-header .header_sidebar .sidebar_content .social {
                display: flex;
                justify-content: center;
                margin-left: 200px;
                padding-right: 25px;
                align-items: center;
                margin-top: 30px;
                padding-bottom: 30px;
                margin-bottom: 20px;
                border-bottom: 1px solid #727272
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_sidebar .sidebar_content .social {
                    padding: 16px;
                    margin-left: 16px
                }
            }

            header.site-header .header_sidebar .sidebar_content .social a {
                margin: 0 12px
            }

            header.site-header .header_sidebar .sidebar_content .social a svg path {
                fill: #727272
            }

            header.site-header .header_sidebar .sidebar_content .images {
                margin-left: 200px;
                padding-right: 25px;
                border-bottom: 1px solid #727272;
                padding-bottom: 20px;
                margin-bottom: 32px;
                display: flex;
                justify-content: center
            }

            header.site-header .header_sidebar .sidebar_content .images svg {
                margin: 0 8px
            }

            header.site-header .header_sidebar .sidebar_content .privacy_policy {
                padding-left: 200px;
                padding-right: 25px
            }

            header.site-header .header_sidebar .sidebar_content .privacy_policy ul {
                display: flex;
                justify-content: center
            }

            header.site-header .header_sidebar .sidebar_content .privacy_policy ul li {
                margin: 0 4px
            }

            header.site-header .header_sidebar .sidebar_content .privacy_policy ul li a {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 400;
                line-height: 120%;
                padding: 5px;
                border-bottom: 1px solid #fff
            }

            .why_promez_wrap {
                padding-top: 100px;
                padding-bottom: 100px
            }

            .why_promez_wrap h2 {
                color: var(--Black, #222);
                text-align: center;
                font-family: Onest;
                font-size: 64px;
                font-weight: 600;
                line-height: 115%;
                margin-bottom: 50px
            }

            @media screen and (max-width: 991px) {
                header.site-header .header_sidebar .sidebar_content .images {
                    margin-left: 16px
                }

                header.site-header .header_sidebar .sidebar_content .privacy_policy {
                    padding-left: 16px
                }

                .why_promez_wrap {
                    padding: 50px 0
                }

                .why_promez_wrap h2 {
                    font-size: 45px
                }
            }

            @media screen and (max-width: 768px) {
                header.site-header .header_sidebar {
                    overflow-y: scroll;
                    padding-bottom: 100px
                }

                header.site-header .header_sidebar .sidebar_content .privacy_policy ul {
                    flex-wrap: wrap
                }

                header.site-header .header_sidebar .sidebar_content .privacy_policy ul li {
                    margin: 0 10px 10px
                }

                .why_promez_wrap h2 {
                    font-size: 32px;
                    margin-bottom: 25px;
                    font-weight: 700
                }
            }

            .why_promez_wrap .why_promez {
                display: flex;
                justify-content: space-between
            }

            .why_promez_wrap .why_promez .block {
                max-width: calc(25% - 11px);
                width: 100%;
                text-align: center;
                border-radius: 20px;
                border: 1px solid var(--Black, #222);
                padding: 25px 15px
            }

            .why_promez_wrap .why_promez .block img {
                margin: 0 auto 25px
            }

            .why_promez_wrap .why_promez .block span {
                display: block;
                color: var(--Black, #222);
                font-family: Antonio;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%;
                border-top: 1px solid #222;
                padding-top: 25px;
                margin-bottom: 20px;
                text-align: left
            }

            @media screen and (max-width: 768px) {
                .why_promez_wrap .why_promez .block span {
                    font-size: 23px
                }
            }

            .why_promez_wrap .why_promez .block p {
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 120%;
                text-align: left
            }

            .mission_wrap {
                background: #222;
                padding: 100px 0
            }

            .mission_wrap h2 {
                color: var(--White, #fff);
                text-align: center;
                font-family: Onest;
                font-size: 64px;
                font-weight: 600;
                line-height: 115%;
                margin-bottom: 50px
            }

            @media screen and (max-width: 991px) {
                .why_promez_wrap .why_promez .block {
                    max-width: 100%;
                    height: 100%
                }

                .mission_wrap {
                    padding: 50px 0
                }

                .mission_wrap h2 {
                    font-size: 45px
                }
            }

            @media screen and (max-width: 768px) {
                .why_promez_wrap .why_promez .block p {
                    font-size: 12px
                }

                .mission_wrap h2 {
                    font-size: 32px
                }
            }

            .mission_wrap .mission {
                display: flex;
                justify-content: space-between;
                background: #dc002c;
                padding: 50px;
                border-radius: 20px
            }

            .mission_wrap .mission .left_side {
                max-width: calc(50% - 20px);
                width: 100%;
                align-self: center
            }

            @media screen and (max-width: 991px) {
                .mission_wrap .mission {
                    flex-wrap: wrap;
                    padding: 25px 16px
                }

                .mission_wrap .mission .left_side {
                    max-width: 100%
                }
            }

            .mission_wrap .mission .left_side h3 {
                color: var(--White, #fff);
                font-family: Onest;
                font-size: 45px;
                font-weight: 600;
                line-height: 120%;
                margin-bottom: 25px
            }

            @media screen and (max-width: 768px) {
                .mission_wrap .mission .left_side h3 {
                    font-size: 32px;
                    margin-bottom: 15px;
                    font-family: Antonio, sans-serif !important
                }
            }

            .mission_wrap .mission .left_side p {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                margin-bottom: 25px
            }

            .mission_wrap .mission .left_side ul {
                display: flex;
                justify-content: space-between
            }

            .mission_wrap .mission .left_side ul li {
                width: calc(50% - 8px);
                border-radius: 8px;
                border: 2px solid var(--White, #fff);
                padding: 15px;
                color: var(--White, #fff);
                text-align: center;
                font-family: Antonio;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%
            }

            .mission_wrap .mission .left_side ul li.active {
                background: #fff;
                color: #cd0029
            }

            .mission_wrap .mission .right_side {
                max-width: calc(50% - 20px);
                width: 100%
            }

            .mission_wrap .mission .right_side .tab_content {
                display: none;
                background-size: cover;
                background-position: center;
                border-radius: 16px;
                height: 100%
            }

            .mission_wrap .mission .right_side .tab_content.active {
                display: block
            }

            .mission_wrap .mission .right_side .tab_content .descriere {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 1.3;
                border-radius: 16px;
                padding: 15px 0;
                max-width: 55%;
                margin-left: auto
            }

            .mission_wrap .mission .right_side .tab_content .descriere b {
                font-weight: 700
            }

            .company_history_wrap {
                background: #d6d6d6;
                padding: 100px 0
            }

            .company_history_wrap h2 {
                color: var(--Black, #222);
                text-align: center;
                font-family: Onest;
                font-size: 64px;
                font-weight: 600;
                line-height: 115%;
                margin-bottom: 50px
            }

            .company_history_wrap .top_slider .slide {
                display: flex;
                justify-content: space-between;
                flex-wrap: wrap;
                padding-bottom: 50px
            }

            .company_history_wrap .top_slider .slide .slide_image {
                width: 100%;
                margin-bottom: 25px;
                position: relative
            }

            .company_history_wrap .top_slider .slide .slide_image span {
                position: absolute;
                color: var(--White, #fff);
                font-family: Antonio;
                font-size: 170px;
                font-weight: 700;
                line-height: 120%;
                bottom: -14px;
                right: 25px
            }

            .company_history_wrap .top_slider .slide .slide_title {
                max-width: calc(50% - 12px);
                width: 100%;
                color: var(--Black, #222);
                font-family: Onest;
                font-size: 45px;
                font-weight: 600;
                line-height: 120%
            }

            @media screen and (max-width: 991px) {
                .mission_wrap .mission .right_side {
                    max-width: 100%;
                    margin-top: 15px
                }

                .mission_wrap .mission .right_side .tab_content .descriere {
                    height: auto
                }

                .company_history_wrap {
                    padding: 50px 0
                }

                .company_history_wrap h2 {
                    font-size: 45px
                }

                .company_history_wrap .top_slider .slide .slide_image span {
                    font-size: 90px;
                    bottom: 0
                }

                .company_history_wrap .top_slider .slide .slide_title {
                    font-size: 32px
                }
            }

            @media screen and (max-width: 768px) {
                .mission_wrap .mission .left_side p {
                    margin-bottom: 15px
                }

                .mission_wrap .mission .left_side ul li {
                    font-size: 16px
                }

                .company_history_wrap h2 {
                    font-size: 32px;
                    margin-bottom: 20px
                }

                .company_history_wrap .top_slider .slide {
                    padding-bottom: 25px
                }

                .company_history_wrap .top_slider .slide .slide_image {
                    margin-bottom: 20px;
                    height: 111px;
                    display: flex
                }

                .company_history_wrap .top_slider .slide .slide_image img {
                    object-fit: cover;
                    border-radius: 16px
                }

                .company_history_wrap .top_slider .slide .slide_image span {
                    font-size: 64px
                }

                .company_history_wrap .top_slider .slide .slide_title {
                    max-width: 100%;
                    margin-bottom: 15px;
                    font-size: 23px
                }
            }

            .company_history_wrap .top_slider .slide .slide_description {
                max-width: calc(50% - 12px);
                width: 100%;
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                align-self: center
            }

            .company_history_wrap .nav_slide_wrap {
                padding: 0 70px;
                position: relative
            }

            .company_history_wrap .nav_slide_wrap .nav_slide .slide span {
                margin-bottom: 15px;
                color: var(--Black, #222);
                font-family: Antonio;
                font-size: 45px;
                font-weight: 700;
                line-height: 120%;
                display: block
            }

            .company_history_wrap .nav_slide_wrap .nav_slide .slide .slide_title {
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%
            }

            .company_history_wrap .nav_slide_wrap .custom_arrows_history .arrow {
                position: absolute;
                top: calc(50% - 30px)
            }

            .company_history_wrap .nav_slide_wrap .custom_arrows_history .arrow.prev_arrow_history {
                left: 0
            }

            .company_history_wrap .nav_slide_wrap .custom_arrows_history .arrow.next_arrow_history {
                left: auto;
                right: 0
            }

            .home_product_wrap {
                background: #222;
                padding: 100px 0
            }

            .home_product_wrap h2 {
                color: var(--White, #fff);
                text-align: center;
                font-family: Onest;
                font-size: 64px;
                font-weight: 600;
                line-height: 115%;
                margin-bottom: 25px
            }

            @media screen and (max-width: 991px) {
                .company_history_wrap .nav_slide_wrap {
                    padding: 0 45px
                }

                .company_history_wrap .nav_slide_wrap .nav_slide .slide span {
                    font-size: 32px
                }

                .home_product_wrap {
                    padding: 50px 0
                }

                .home_product_wrap h2 {
                    font-size: 45px
                }
            }

            @media screen and (max-width: 768px) {
                .company_history_wrap .top_slider .slide .slide_description {
                    font-size: 12px;
                    max-width: 100%
                }

                .company_history_wrap .nav_slide_wrap {
                    padding: 0 20px
                }

                .company_history_wrap .nav_slide_wrap .custom_arrows_history .arrow {
                    max-width: 25px
                }

                .company_history_wrap .nav_slide_wrap .custom_arrows_history .arrow svg {
                    max-width: 100%
                }

                .home_product_wrap h2 {
                    font-size: 32px
                }

                .home_product_wrap p {
                    padding: 0 15px
                }
            }

            .home_product_wrap p {
                color: var(--White, #fff);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 120%;
                max-width: 590px;
                margin: 0 auto 50px
            }

            .home_product_wrap .home_products {
                display: flex;
                justify-content: space-between;
                flex-wrap: wrap
            }

            .home_product_wrap .home_products .featured_product {
                max-width: calc(33.3333333333% - 16px);
                width: 100%;
                padding-bottom: 15px;
                margin-bottom: 15px;
                padding: 15px
            }

            @media screen and (max-width: 991px) {
                .home_product_wrap .home_products .featured_product {
                    max-width: calc(50% - 12px)
                }
            }

            .home_product_wrap .home_products .featured_product a.img_wrap {
                display: flex;
                height: 265px;
                width: 100%;
                overflow: hidden;
                position: relative;
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/prod_bg.webp');
                background-size: cover;
                border-radius: 5px
            }

            .home_product_wrap .home_products .featured_product a.img_wrap img {
                object-fit: contain;
                height: auto !important
            }

            @media screen and (max-width: 580px) {
                header.site-header .header_sidebar .top_header_sidebar .mobile_top_header .lang_navigation {
                    display: block
                }

                .company_history_wrap .nav_slide_wrap .nav_slide .slide .slide_title {
                    word-wrap: break-word
                }

                .home_product_wrap .home_products .featured_product {
                    max-width: 100%;
                    border-radius: 16px;
                    background: rgba(255, 255, 255, .1);
                    margin-bottom: 25px
                }

                .home_product_wrap .home_products .featured_product a.img_wrap {
                    height: 305px
                }

                .home_product_wrap .home_products .featured_product a.img_wrap img {
                    height: 100% !important;
                    object-fit: contain
                }
            }

            .home_product_wrap .home_products .featured_product h4 {
                color: var(--White, #fff);
                font-family: Antonio, sans-serif !important;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%;
                margin: 15px 0;
                text-transform: uppercase
            }

            @media screen and (max-width: 768px) {
                .home_product_wrap .home_products .featured_product h4 {
                    font-size: 24px
                }
            }

            .home_product_wrap .home_products .featured_product p {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%;
                text-align: left;
                padding: 0;
                margin: 0 0 25px;
                display: -webkit-box;
                -webkit-line-clamp: 3;
                -webkit-box-orient: vertical;
                overflow: hidden;
                text-overflow: ellipsis
            }

            .home_product_wrap .home_products .featured_product a.button {
                border-radius: 8px;
                background: var(--White, #fff);
                width: calc(100% - 30px);
                font-family: Antonio;
                color: var(--Black, #222);
                text-align: center;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%;
                padding: 15px;
                display: block;
                opacity: 0;
                visibility: hidden;
                height: auto;
                margin: 0 15px
            }

            @media screen and (max-width: 580px) {
                .home_product_wrap .home_products .featured_product a.button {
                    visibility: visible;
                    opacity: 1
                }
            }

            .home_product_wrap .all_products {
                border-radius: 8px;
                border: 2px solid var(--White, #fff);
                background: var(--Orange, #f80);
                color: var(--White, #fff);
                text-align: center;
                font-family: Antonio;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%;
                padding: 17px 145px;
                display: block;
                width: fit-content;
                margin: 50px auto 0
            }

            @media screen and (max-width: 600px) {
                .home_product_wrap .all_products {
                    width: calc(100% - 30px)
                }
            }

            .home_recipes_wrap {
                padding: 100px 0
            }

            .home_recipes_wrap h2 {
                color: var(--Black, #222);
                text-align: center;
                font-family: Onest;
                font-size: 64px;
                font-weight: 600;
                line-height: 115%;
                margin-bottom: 15px;
                padding: 0 15px
            }

            @media screen and (max-width: 991px) {
                .home_recipes_wrap {
                    padding: 50px 0
                }

                .home_recipes_wrap h2 {
                    font-size: 45px
                }
            }

            @media screen and (max-width: 768px) {
                .home_product_wrap .all_products {
                    margin: 0 auto;
                    padding: 17px 100px
                }

                .home_recipes_wrap h2 {
                    font-size: 32px
                }
            }

            .home_recipes_wrap p {
                max-width: 610px;
                margin: 0 auto 25px;
                color: var(--Black, #222);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%;
                padding: 0 15px
            }

            .home_recipes_wrap .home_recipes {
                padding: 0 0 50px 200px
            }

            @media screen and (max-width: 1024px) {
                .home_recipes_wrap .home_recipes {
                    padding: 0 0 50px
                }
            }

            .home_recipes_wrap .home_recipes .blog_post {
                width: 100%;
                padding: 15px;
                border-radius: 20px;
                border: 2px solid transparent;
                margin-bottom: 25px
            }

            .home_recipes_wrap .home_recipes .blog_post .img_wrap {
                width: 100%;
                height: 305px;
                overflow: hidden;
                border-radius: 5px;
                position: relative;
                display: block
            }

            .home_recipes_wrap .home_recipes .blog_post .img_wrap img {
                max-width: 100%;
                position: absolute;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
                width: 100%;
                height: 100% !important;
                object-fit: cover
            }

            .home_recipes_wrap .home_recipes .blog_post h4 {
                color: var(--Black, #222);
                font-family: Antonio, sans-serif !important;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%;
                margin: 15px 0
            }

            .home_recipes_wrap .home_recipes .blog_post .short_desc p {
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%;
                text-align: left;
                display: -webkit-box;
                -webkit-line-clamp: 3;
                -webkit-box-orient: vertical;
                overflow: hidden;
                text-overflow: ellipsis;
                padding: 0
            }

            .home_recipes_wrap .home_recipes .blog_post .short_desc a {
                display: none
            }

            .home_recipes_wrap .home_recipes .blog_post .recipe_by {
                border-radius: 5px;
                border: 1px solid var(--Grey, #727272);
                padding: 5px 10px;
                width: fit-content;
                margin-top: 15px
            }

            .home_recipes_wrap .home_recipes .blog_post .recipe_by p {
                margin-bottom: 0;
                text-align: left;
                padding: 0
            }

            .home_recipes_wrap .home_recipes .blog_post .recipe_by span {
                margin-top: 0;
                display: block;
                color: var(--Grey, #727272);
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 700;
                line-height: 120%
            }

            .home_recipes_wrap .more_recipes {
                border-radius: 8px;
                border: 2px solid var(--White, #f80);
                background: var(--Orange, #f80);
                width: fit-content;
                display: block;
                padding: 15px 117px;
                color: var(--White, #fff);
                text-align: center;
                font-family: Antonio;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%;
                margin: 0 auto
            }

            footer.site-footer {
                background: #222;
                padding: 50px 0 25px
            }

            footer.site-footer .footer_logos {
                display: flex;
                justify-content: center;
                align-items: center;
                margin-bottom: 23px
            }

            footer.site-footer .footer_logos img {
                max-width: 125px;
                margin: 0 12px;
                display: block
            }

            footer.site-footer .footer_menu {
                margin-bottom: 23px
            }

            footer.site-footer .footer_menu .footer-menu-container ul {
                display: flex;
                justify-content: center
            }

            footer.site-footer .footer_menu .footer-menu-container ul li {
                margin: 0 12px
            }

            @media screen and (max-width: 768px) {
                .home_recipes_wrap .more_recipes {
                    padding: 15px 50px
                }

                footer.site-footer {
                    padding: 50px 0 105px
                }

                footer.site-footer .footer_logos img {
                    max-width: calc(33.3333333333% - 10px)
                }

                footer.site-footer .footer_menu .footer-menu-container ul {
                    flex-wrap: wrap
                }

                footer.site-footer .footer_menu .footer-menu-container ul li {
                    margin: 10px
                }
            }

            footer.site-footer .footer_menu .footer-menu-container ul li a {
                color: var(--White, #fff);
                font-family: Antonio;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%
            }

            footer.site-footer .social {
                display: flex;
                justify-content: center
            }

            footer.site-footer .social a {
                margin: 0 12px
            }

            footer.site-footer .social a svg path {
                fill: #727272
            }

            footer.site-footer .bottom_footer {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-top: 25px
            }

            @media screen and (max-width: 991px) {
                .home_recipes_wrap .home_recipes .blog_post .img_wrap {
                    height: 205px
                }

                .home_recipes_wrap .home_recipes .blog_post h4 {
                    font-size: 23px
                }

                footer.site-footer .bottom_footer {
                    flex-wrap: wrap;
                    justify-content: center
                }
            }

            footer.site-footer .bottom_footer .copyright {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%;
                max-width: calc(33.3333333333% - 10px);
                width: 100%
            }

            @media screen and (max-width: 991px) {
                footer.site-footer .bottom_footer .copyright {
                    max-width: 100%;
                    order: 2;
                    margin-bottom: 10px;
                    text-align: center
                }
            }

            footer.site-footer .bottom_footer .images {
                display: flex;
                justify-content: center;
                max-width: calc(33.3333333333% - 10px);
                width: 100%
            }

            @media screen and (max-width: 991px) {
                footer.site-footer .bottom_footer .images {
                    max-width: 100%;
                    order: 1;
                    margin-bottom: 20px
                }
            }

            footer.site-footer .bottom_footer .images svg {
                margin: 0 12px
            }

            footer.site-footer .bottom_footer .privacy-navigation {
                max-width: calc(33.3333333333% - 10px);
                width: 100%
            }

            footer.site-footer .bottom_footer .privacy-navigation ul {
                display: flex;
                justify-content: flex-end
            }

            @media screen and (max-width: 991px) {
                footer.site-footer .bottom_footer .privacy-navigation {
                    max-width: 100%;
                    order: 3
                }

                footer.site-footer .bottom_footer .privacy-navigation ul {
                    justify-content: center
                }
            }

            footer.site-footer .bottom_footer .privacy-navigation ul li {
                margin: 0 4px
            }

            footer.site-footer .bottom_footer .privacy-navigation ul li a {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 400;
                line-height: 120%;
                border-bottom: 1px solid #fff
            }

            footer.site-footer .back_to_top {
                position: fixed;
                bottom: 10px;
                right: -5px;
                display: none
            }

            footer.site-footer .back_to_top svg {
                max-width: 80px
            }

            .main_slider_wrap {
                position: relative
            }

            .main_slider_wrap .main_slider {
                height: calc(100vh - 90px);
                overflow: hidden;
                margin-bottom: 0 !important
            }

            @media screen and (max-width: 1200px) {
                .main_slider_wrap .main_slider {
                    height: 600px
                }
            }

            .main_slider_wrap .main_slider a {
                position: relative;
                height: calc(100vh - 80px);
                display: block;
                overflow: hidden
            }

            .main_slider_wrap .main_slider a img {
                position: absolute;
                left: 50%;
                top: 50%;
                width: 100%;
                height: 100%;
                transform: translate(-50%, -50%);
                object-fit: cover
            }

            .main_slider_wrap .custom_arrows {
                position: absolute;
                top: 50%;
                width: 100%;
                display: flex;
                justify-content: space-between;
                max-width: 1920px;
                padding: 0 30px;
                left: 50%;
                transform: translateX(-50%)
            }

            .main_slider_wrap .custom_arrows .arrow_next {
                transform: rotate(180deg)
            }

            .fixed_icons {
                position: fixed;
                right: 0;
                bottom: 90px;
                display: flex;
                flex-direction: column;
                z-index: 9
            }

            @media screen and (max-width: 768px) {
                footer.site-footer .back_to_top {
                    bottom: 75px;
                    right: 10px
                }

                .main_slider_wrap .main_slider {
                    height: 50vh
                }

                .main_slider_wrap .main_slider a {
                    height: 50vh
                }

                .main_slider_wrap .custom_arrows {
                    padding: 0 15px
                }

                .fixed_icons {
                    bottom: 15px;
                    left: 5px;
                    right: 5px;
                    flex-direction: row;
                    background: #222;
                    justify-content: space-around;
                    border-radius: 10px;
                    padding: 10px;
                    background: var(--Black, #222);
                    box-shadow: 0 5px 15px 0 rgba(255, 255, 255, .35);
                    z-index: 21
                }
            }

            .fixed_icons .block {
                position: relative;
                display: flex;
                justify-content: flex-end;
                align-items: center;
                margin-bottom: 25px
            }

            .fixed_icons .block.mobile_block {
                display: none
            }

            @media screen and (max-width: 768px) {
                .fixed_icons .block {
                    margin-bottom: 0
                }

                .fixed_icons .block.mobile_block {
                    display: block;
                    align-self: center
                }

                .fixed_icons .block.mobile_block .cart_header {
                    display: flex;
                    flex-direction: column;
                    align-items: center;
                    position: relative;
                    z-index: 9
                }
            }

            .fixed_icons .block.mobile_block .cart_header svg {
                height: 24px;
                margin-bottom: 5px
            }

            .fixed_icons .block.mobile_block .cart_header span {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-weight: 600;
                line-height: 120%;
                text-align: center;
                font-size: 11px
            }

            .fixed_icons .block.mobile_block .cart_header span.count {
                position: absolute;
                top: 0;
                right: 0;
                background: #f20030;
                border-radius: 50%;
                width: 16px;
                height: 16px;
                line-height: 16px
            }

            .fixed_icons .block .label_icon {
                margin-left: 15px;
                border-radius: 20px 0 0 20px;
                background: var(--Brown, #6a5e55);
                width: 68px;
                height: 68px;
                text-align: center;
                display: flex;
                justify-content: center;
                align-items: center;
                position: relative
            }

            .fixed_icons .block .label_icon .tooltip {
                position: absolute;
                background: #fff;
                top: -25px;
                right: 10%;
                border-radius: 5px;
                padding: 10px;
                width: 110px;
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 600;
                line-height: 120%;
                display: none
            }

            .fixed_icons .block .label_icon .tooltip:after {
                content: "";
                width: 0;
                height: 0;
                display: block;
                border-top: 10px solid #fff;
                border-right: 10px solid transparent;
                border-left: 10px solid transparent;
                border-bottom: 0;
                top: 100%;
                position: absolute;
                right: 15px
            }

            @media screen and (max-width: 768px) {
                .fixed_icons .block .label_icon {
                    margin-left: 0;
                    flex-direction: column;
                    background: 0 0;
                    width: auto;
                    padding: 0 3px;
                    height: 49px;
                    z-index: 99
                }

                .fixed_icons .block .label_icon svg {
                    margin-bottom: 5px;
                    max-width: 24px;
                    height: 24px
                }

                .fixed_icons .block .label_icon .tooltip {
                    display: block;
                    position: initial;
                    color: var(--White, #fff);
                    font-family: "Nunito Sans";
                    font-weight: 600;
                    line-height: 120%;
                    background: 0 0;
                    padding: 0;
                    width: auto
                }

                .fixed_icons .block .label_icon .tooltip:after {
                    display: none
                }
            }

            .fixed_icons .block .icons {
                display: none
            }

            .fixed_icons .block .icons .mobile_wrap {
                display: flex;
                justify-content: center;
                flex-wrap: wrap
            }

            @media screen and (max-width: 768px) {
                .fixed_icons .block .icons .mobile_wrap .wrap_soc {
                    margin: 0;
                    text-align: center;
                    display: flex;
                    flex-wrap: wrap;
                    justify-content: center
                }
            }

            .fixed_icons .block .icons .mobile_wrap .wrap_soc a {
                width: 56px;
                height: 56px;
                border-radius: 50%;
                background: #fff;
                display: flex;
                justify-content: center;
                align-items: center;
                margin-left: 15px
            }

            @media screen and (max-width: 786px) {
                .fixed_icons .block .icons .mobile_wrap .wrap_soc a {
                    margin: 0 10px
                }
            }

            .sale_fore_signup {
                position: fixed;
                bottom: 90px;
                left: 30px;
                z-index: 9
            }

            .sale_fore_signup .close {
                position: absolute;
                top: -20px;
                right: -20px;
                display: none
            }

            .sale_fore_signup .close svg path {
                fill: #222222
            }

            .sale_fore_signup .modal_sale {
                background: var(--White, #fff);
                width: 340px;
                position: relative;
                padding: 25px 15px;
                box-shadow: 0 5px 15px 0 rgba(0, 0, 0, .5);
                border-radius: 10px;
                overflow: hidden;
                display: none;
                background-image: url("data:image/svg+xml,%3csvg width='100%25' height='100%25' xmlns='http://www.w3.org/2000/svg'%3e%3crect width='100%25' height='100%25' fill='none' rx='10' ry='10' stroke='%2300A814FF' stroke-width='4' stroke-dasharray='15' stroke-dashoffset='86' stroke-linecap='butt'/%3e%3c/svg%3e")
            }

            .sale_fore_signup .modal_sale .modal_header {
                width: 100%;
                position: relative;
                z-index: 2
            }

            .sale_fore_signup .modal_sale .modal_header h3 {
                color: var(--Black, #222);
                text-align: center;
                font-family: "Nunito Sans" !important;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%;
                margin-bottom: 10px
            }

            .sale_fore_signup .modal_sale .modal_content {
                position: relative;
                z-index: 1
            }

            .sale_fore_signup .modal_sale .modal_content:after {
                content: "";
                width: 180px;
                height: 210px;
                display: block;
                background: #f2fcf3;
                border-radius: 0 100% 0 0;
                position: absolute;
                z-index: -1;
                left: -13px;
                bottom: -22px
            }

            .sale_fore_signup .modal_sale .modal_content:before {
                content: "";
                width: 140px;
                height: 173px;
                display: block;
                background: #f2fcf3;
                border-radius: 73% 0 0 83%;
                position: absolute;
                z-index: -8;
                right: -13px;
                top: -60px
            }

            .sale_fore_signup .modal_sale .modal_content p {
                color: var(--Black, #222);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 400;
                line-height: 120%;
                margin-bottom: 15px
            }

            .sale_fore_signup .modal_sale .modal_content .sales {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 15px
            }

            .sale_fore_signup .modal_sale .modal_content .sales .block {
                border-radius: 5px;
                border: 1px solid var(--Green-added, #00a814);
                padding: 15px 5px;
                max-width: 49%;
                width: 100%
            }

            .sale_fore_signup .modal_sale .modal_content .sales .block .sales_count {
                color: var(--Green-added, #00a814);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                margin-bottom: 5px
            }

            @media screen and (max-width: 768px) {
                .sale_fore_signup {
                    left: 5px;
                    bottom: 80px
                }

                .sale_fore_signup .modal_sale .modal_content p {
                    margin-bottom: 10px
                }

                .sale_fore_signup .modal_sale .modal_content .sales {
                    margin-bottom: 10px
                }

                .sale_fore_signup .modal_sale .modal_content .sales .block {
                    padding: 10px
                }

                .sale_fore_signup .modal_sale .modal_content .sales .block .sales_count {
                    font-size: 18px;
                    margin-bottom: 0
                }
            }

            .sale_fore_signup .modal_sale .modal_content .sales .block span {
                color: var(--Grey, #727272);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 600;
                line-height: 120%;
                display: block
            }

            .sale_fore_signup .modal_sale .modal_content a.button {
                width: 100%;
                display: block;
                border-radius: 8px;
                background: var(--Red, #00a814);
                padding: 11px 20px;
                color: var(--White, #fff);
                text-align: center;
                font-family: Antonio, sans-serif !important;
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                margin: 15px 0
            }

            .sale_fore_signup .modal_sale .modal_content img {
                display: block;
                margin: 0 auto;
                width: 100%
            }

            .sale_fore_signup .icon svg {
                display: none;
                margin-left: -17px
            }

            @media screen and (max-width: 768px) {
                .sale_fore_signup .modal_sale .modal_content img {
                    display: none
                }

                .sale_fore_signup .icon svg {
                    max-width: 78px
                }
            }

            .sale_fore_signup .icon svg.default {
                display: block
            }

            .ticker-wrapper {
                width: 100%;
                overflow: hidden;
                background: #f80;
                color: #fff;
                padding: 10px 0;
                position: relative
            }

            .ticker-wrapper .ticker-track {
                display: flex;
                width: max-content;
                animation: 30s linear infinite ticker-scroll
            }

            .ticker-wrapper .ticker-track .ticker-content {
                display: flex
            }

            .ticker-wrapper .ticker-track .ticker-content .ticker-item {
                display: flex;
                align-items: center;
                margin-right: 20px;
                white-space: nowrap;
                font-weight: 700;
                font-size: 20px;
                font-family: Antonio, sans-serif
            }

            .ticker-wrapper .ticker-track .ticker-content .ticker-item svg {
                margin-right: 20px;
                width: 40px;
                height: 40px
            }

            @keyframes ticker-scroll {
                0% {
                    transform: translateX(0)
                }
                100% {
                    transform: translateX(-50%)
                }
            }

            .contact_bar_wrap {
                background: var(--Red, #f20030);
                padding: 10px 0
            }

            .contact_bar_wrap .contact_bar {
                display: flex;
                justify-content: space-between;
                align-items: center
            }

            .contact_bar_wrap .contact_bar .block {
                opacity: 0;
                transform: translateY(20px);
                max-width: 33.3333333333%
            }

            .contact_bar_wrap .contact_bar .block .label {
                color: var(--White, #fff);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                margin-bottom: 5px
            }

            .contact_bar_wrap .contact_bar .block a, .contact_bar_wrap .contact_bar .block p {
                color: var(--White, #fff);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 400;
                line-height: 120%
            }

            .contact_bar_wrap .contact_bar .block a svg {
                display: none
            }

            @media screen and (max-width: 500px) {
                .contact_bar_wrap .contact_bar .block a span {
                    display: none
                }

                .contact_bar_wrap .contact_bar .block a svg {
                    display: block
                }

                .contact_bar_wrap .contact_bar .block.mobile_hide {
                    max-width: 15%
                }

                .contact_bar_wrap .contact_bar .block.mobile_hide .label {
                    display: none
                }
            }

            .newsletter_wrap {
                padding: 100px 0;
                position: relative;
                background: #de002c;
                background-repeat: no-repeat;
                background-position: right
            }

            .newsletter_wrap .newsletter {
                display: flex;
                justify-content: space-between;
                align-items: center
            }

            .newsletter_wrap .left_side {
                max-width: 40%;
                width: 100%
            }

            .newsletter_wrap .left_side h3 {
                margin-bottom: 20px;
                color: var(--White, #fff);
                font-family: Onest;
                font-size: 45px;
                font-weight: 600;
                line-height: 120%
            }

            @media screen and (max-width: 991px) {
                .newsletter_wrap {
                    padding: 50px 0
                }

                .newsletter_wrap .newsletter {
                    flex-wrap: wrap
                }

                .newsletter_wrap .left_side {
                    max-width: 100%
                }

                .newsletter_wrap .left_side h3 {
                    font-size: 32px
                }
            }

            .newsletter_wrap .left_side p {
                margin-bottom: 20px;
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%
            }

            .newsletter_wrap .left_side .form form .mc4wp-form-fields {
                position: relative
            }

            .newsletter_wrap .left_side .form form .mc4wp-form-fields input[type=email] {
                border-radius: 8px;
                border: 1px solid var(--Grey, #727272);
                background: #fff;
                padding: 15px 46px 15px 16px;
                width: 100%
            }

            .login_modal {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                backdrop-filter: blur(10px);
                justify-content: center;
                align-items: center;
                display: none;
                z-index: 21;
                background-position: center;
                background-size: cover
            }

            .log_in_page {
                padding: 0;
                max-width: 800px;
                margin: 0 auto;
                position: relative;
                width: 100%
            }

            .log_in_page .close {
                right: 40px;
                top: 11px;
                position: absolute;
                z-index: 1
            }

            .log_in_page .forms {
                border-radius: 8px;
                background: rgba(255, 255, 255, .6);
                backdrop-filter: blur(10px)
            }

            .log_in_page .forms .forms_header {
                padding: 25px;
                border-bottom: 1px solid #222
            }

            .log_in_page .forms .forms_header ul {
                display: flex;
                justify-content: space-around;
                align-items: center;
                position: relative
            }

            .log_in_page .forms .forms_header ul:before {
                content: "";
                width: 1px;
                height: 28px;
                display: block;
                left: 50%;
                background: #222;
                position: absolute
            }

            .log_in_page .forms .forms_header ul li {
                color: var(--Grey, #727272);
                text-align: center;
                font-family: Antonio, sans-serif;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%
            }

            .log_in_page .forms .forms_header ul li.active {
                color: var(--Black, #222)
            }

            .log_in_page .forms .form_content {
                padding: 25px
            }

            @media screen and (max-width: 768px) {
                .contact_bar_wrap .contact_bar .block .label {
                    font-size: 12px
                }

                .log_in_page .forms .forms_header ul li {
                    font-size: 18px
                }

                .log_in_page .forms .form_content {
                    padding: 15px 10px
                }
            }

            .log_in_page .forms .form_content .tab.log_in_tab {
                width: 100%
            }

            .log_in_page .forms .form_content .tab.register_tab {
                display: none;
                width: 100%
            }

            .log_in_page .forms .form_content .subtitle {
                color: var(--Black, #222);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                margin-bottom: 25px;
                margin-top: 25px
            }

            .log_in_page .forms .form_content form {
                border: 0;
                padding: 0;
                margin: 0;
                text-align: left;
                border-radius: 0
            }

            .log_in_page .forms .form_content form p {
                position: relative;
                margin-bottom: 15px
            }

            .log_in_page .forms .form_content form p label {
                position: absolute;
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                left: 16px;
                top: calc(50% - 9px)
            }

            .log_in_page .forms .form_content form p input {
                border-radius: 4px;
                border: 1px solid var(--Grey, #727272);
                padding: 16px;
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                width: 100%
            }

            .log_in_page .forms .form_content form p.birthdate label {
                position: initial
            }

            .log_in_page .forms .form_content form p.birthdate select {
                border-radius: 4px;
                border: 1px solid var(--Grey, #727272);
                padding: 16px;
                background: 0 0
            }

            .log_in_page .forms .form_content form p.newsletter_checkbox_wrap input {
                display: none
            }

            .log_in_page .forms .form_content form p.newsletter_checkbox_wrap label {
                position: relative;
                padding-left: 28px;
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                left: 0
            }

            .log_in_page .forms .form_content form p.newsletter_checkbox_wrap label:before {
                content: "";
                position: absolute;
                left: 0;
                width: 18px;
                height: 18px;
                border-radius: 4px;
                border: 1px solid #f20030;
                display: block;
                top: 0
            }

            .log_in_page .forms .form_content form p.newsletter_checkbox_wrap label:after {
                content: "";
                width: 20px;
                height: 20px;
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/standart_linear.svg') #f20030;
                background-size: contain;
                background-position: center;
                position: absolute;
                border-radius: 4px;
                top: 0;
                left: 0;
                opacity: 0;
                visibility: hidden;
                display: none
            }

            .log_in_page .forms .form_content form .buttons {
                display: flex;
                justify-content: center;
                align-items: center
            }

            .log_in_page .forms .form_content form .buttons p {
                margin: 0 15px
            }

            .log_in_page .forms .form_content form .buttons input[type=submit] {
                border-radius: 6px;
                border: 1px solid var(--White, #fff);
                background: var(--White, #f80);
                padding: 11px 20px;
                color: var(--Black, #fff);
                text-align: center;
                font-family: Antonio, sans-serif;
                font-size: 16px;
                font-style: normal;
                font-weight: 700;
                line-height: 120%
            }

            .log_in_page .forms .form_content form .buttons .lost_password {
                padding: 11px 5px;
                color: var(--Black, #222);
                text-align: center;
                font-family: Antonio, sans-serif;
                font-size: 16px;
                font-style: normal;
                font-weight: 700;
                line-height: 120%;
                margin-top: 15px;
                width: fit-content
            }

            .newsletter_modal_overlay {
                position: fixed;
                width: 100%;
                height: 100vh;
                left: 0;
                top: 0;
                right: 0;
                bottom: 0;
                background: rgba(255, 255, 255, .2);
                z-index: 99;
                display: none
            }

            .newsletter_modal_overlay .newsletter_modal {
                max-width: 740px;
                margin: 0 auto;
                position: absolute;
                top: 50%;
                transform: translate(-50%, -50%);
                left: 50%;
                background: #222;
                border-radius: 20px;
                display: flex
            }

            @media screen and (max-width: 1200px) {
                .newsletter_modal_overlay .newsletter_modal {
                    transform: translate(-33%, -50%);
                    left: 40%
                }
            }

            .newsletter_modal_overlay .newsletter_modal .mobile_modal_header {
                display: none;
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                width: 100%;
                padding: 15px;
                border-bottom: 1px solid var(--Grey-secondary, #d6d6d6)
            }

            .newsletter_modal_overlay .newsletter_modal .left_side {
                padding: 50px 20px 50px 25px;
                max-width: 50%;
                width: 100%
            }

            @media screen and (max-width: 991px) {
                .newsletter_modal_overlay .newsletter_modal {
                    flex-wrap: wrap
                }

                .newsletter_modal_overlay .newsletter_modal .left_side {
                    max-width: 100%;
                    order: 1;
                    padding: 25px 20px
                }
            }

            .newsletter_modal_overlay .newsletter_modal .left_side h2 {
                color: var(--White, #fff);
                font-family: Antonio, sans-serif !important;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%;
                margin-bottom: 20px
            }

            @media screen and (max-width: 768px) {
                .log_in_page .forms .form_content form .buttons p {
                    margin: 0 5px
                }

                .newsletter_modal_overlay {
                    z-index: 24;
                    top: 0
                }

                .newsletter_modal_overlay .newsletter_modal {
                    transform: none;
                    left: 0;
                    height: 100%;
                    top: 0;
                    width: 100%;
                    display: flex;
                    flex-direction: column;
                    justify-content: center;
                    border-radius: 0
                }

                .newsletter_modal_overlay .newsletter_modal .mobile_modal_header {
                    display: block
                }

                .newsletter_modal_overlay .newsletter_modal .left_side h2 {
                    font-size: 23px;
                    text-align: center
                }

                .newsletter_modal_overlay .newsletter_modal .left_side p {
                    display: none
                }
            }

            .newsletter_modal_overlay .newsletter_modal .left_side p {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%;
                margin-bottom: 20px
            }

            .newsletter_modal_overlay .newsletter_modal .left_side .mailchimp form .mc4wp-form-fields {
                position: relative
            }

            .newsletter_modal_overlay .newsletter_modal .left_side .mailchimp form .mc4wp-form-fields input[type=email] {
                border-radius: 8px;
                border: 1px solid var(--Grey, #727272);
                background: #fff;
                padding: 15px 46px 15px 16px;
                width: 100%
            }

            @media screen and (max-width: 768px) {
                .newsletter_modal_overlay .newsletter_modal .left_side .mailchimp form .mc4wp-form-fields input[type=email] {
                    border-radius: 4px;
                    border: 1px solid var(--Grey, #727272);
                    background: 0 0;
                    color: var(--White, #fff);
                    font-family: "Nunito Sans";
                    font-size: 16px;
                    font-weight: 600;
                    line-height: 120%
                }

                .newsletter_modal_overlay .newsletter_modal .right_side {
                    display: none
                }
            }

            .newsletter_modal_overlay .newsletter_modal .left_side .mailchimp form .mc4wp-form-fields button {
                width: 20px;
                height: 20px;
                right: 10px;
                top: 16px;
                bottom: 16px;
                position: absolute;
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/arrow-right.svg');
                background-position: center;
                background-repeat: no-repeat
            }

            .newsletter_modal_overlay .newsletter_modal .right_side {
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/newletter_modal_bg.png');
                max-width: 50%;
                width: 100%;
                background-size: cover;
                background-repeat: no-repeat;
                border-radius: 0 20px 20px 0;
                position: relative
            }

            @media screen and (max-width: 991px) {
                .newsletter_modal_overlay .newsletter_modal .right_side {
                    max-width: 100%;
                    height: 200px;
                    order: 0;
                    border-radius: 20px 20px 0 0
                }
            }

            .newsletter_modal_overlay .newsletter_modal .right_side .close {
                position: absolute;
                top: 0;
                right: 0;
                background: #fff;
                padding: 7px 20px;
                border-radius: 0 20px
            }

            .request_call_overlay {
                position: fixed;
                width: 100%;
                height: 100vh;
                left: 0;
                top: 0;
                right: 0;
                bottom: 0;
                background: rgba(255, 255, 255, .2);
                z-index: 99;
                display: none
            }

            .request_call_overlay .request_call {
                max-width: 900px;
                margin: 0 auto;
                width: 100%;
                position: absolute;
                top: 50%;
                transform: translate(-50%, -50%);
                left: 50%;
                background: #222;
                border-radius: 20px;
                display: flex
            }

            .request_call_overlay .request_call .modal_header {
                display: none
            }

            @media screen and (max-width: 768px) {
                .request_call_overlay {
                    z-index: 25
                }

                .request_call_overlay .request_call {
                    top: 0;
                    left: 0;
                    transform: none;
                    height: 100%;
                    border-radius: 0;
                    padding-top: 50px
                }

                .request_call_overlay .request_call .modal_header {
                    display: block;
                    position: absolute;
                    left: 0;
                    top: 0;
                    right: 0;
                    padding: 16px;
                    border-bottom: 1px solid #d6d6d6
                }
            }

            .request_call_overlay .request_call .left_side {
                max-width: 50%;
                width: 100%;
                padding: 50px 25px
            }

            @media screen and (max-width: 768px) {
                .request_call_overlay .request_call .left_side {
                    max-width: 100%
                }

                .request_call_overlay .request_call .right_side {
                    display: none
                }
            }

            .request_call_overlay .request_call .left_side h2 {
                color: var(--White, #fff);
                font-family: Antonio, sans-serif !important;
                font-size: 45px;
                font-weight: 700;
                line-height: 120%;
                margin-bottom: 20px
            }

            .request_call_overlay .request_call .left_side p {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 400;
                line-height: 120%;
                margin-bottom: 20px
            }

            .request_call_overlay .request_call .left_side .form {
                position: relative
            }

            .request_call_overlay .request_call .left_side .form form p br {
                display: none
            }

            .request_call_overlay .request_call .left_side .form form p label {
                position: relative
            }

            .request_call_overlay .request_call .left_side .form form p label .limba_label {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 400;
                line-height: 120%;
                position: absolute;
                top: 22px;
                left: 16px;
                width: 100px
            }

            .request_call_overlay .request_call .left_side .form form p label span input {
                border-radius: 4px;
                border: 1px solid var(--Grey, #727272);
                padding: 16px;
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                width: 100%
            }

            .request_call_overlay .request_call .left_side .form form p label span input.wpcf7-country_code {
                padding: 16px 16px 16px 50px
            }

            .request_call_overlay .request_call .left_side .form form p label .wpcf7-form-control-wrap {
                margin-top: 15px;
                display: block;
                padding-bottom: 10px
            }

            .request_call_overlay .request_call .left_side .form form p label .wpcf7-acceptance .wpcf7-list-item {
                margin-left: 0
            }

            .request_call_overlay .request_call .left_side .form form p label .wpcf7-acceptance .wpcf7-list-item label {
                display: flex;
                justify-content: flex-start;
                align-items: center
            }

            .request_call_overlay .request_call .left_side .form form p label .wpcf7-acceptance .wpcf7-list-item label input {
                width: auto;
                height: auto;
                display: none
            }

            .request_call_overlay .request_call .left_side .form form p label .wpcf7-acceptance .wpcf7-list-item label span.wpcf7-list-item-label {
                padding-left: 28px;
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 11px;
                font-weight: 600;
                line-height: 120%
            }

            .request_call_overlay .request_call .left_side .form form p label .wpcf7-acceptance .wpcf7-list-item label span.wpcf7-list-item-label:before {
                content: "";
                position: absolute;
                left: 0;
                width: 18px;
                height: 18px;
                border-radius: 4px;
                border: 1px solid #f20030;
                display: block;
                top: 10px
            }

            .request_call_overlay .request_call .left_side .form form p label .wpcf7-acceptance .wpcf7-list-item label span.wpcf7-list-item-label:after {
                content: "";
                width: 20px;
                height: 20px;
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/standart_linear.svg') #f20030;
                background-size: contain;
                background-position: center;
                position: absolute;
                border-radius: 4px;
                top: 10px;
                left: 0;
                display: none
            }

            .request_call_overlay .request_call .left_side .form form input[type=submit] {
                width: 100%;
                border-radius: 8px;
                border: 2px solid var(--White, #fff);
                background: var(--Orange, #f80);
                padding: 15px 30px;
                color: var(--White, #fff);
                text-align: center;
                font-family: Antonio, sans-serif;
                font-size: 23px;
                font-weight: 700;
                line-height: 120%;
                margin-top: 15px
            }

            .request_call_overlay .request_call .left_side .form form .wpcf7-response-output {
                color: #d21f30;
                position: absolute;
                max-width: 100%;
                right: 0;
                left: 0;
                bottom: -70px
            }

            .request_call_overlay .request_call .right_side {
                position: relative;
                overflow: hidden;
                max-width: 50%;
                width: 100%;
                border-radius: 0 20px 20px 0
            }

            .request_call_overlay .request_call .right_side img {
                position: absolute;
                top: 50%;
                transform: translate(-50%, -50%);
                left: 50%;
                width: 100%;
                height: 100%;
                object-fit: cover
            }

            .request_call_overlay .request_call .right_side .close {
                z-index: 6;
                position: absolute;
                top: 0;
                right: 0
            }

            .mobile_modal_overlay {
                display: none
            }

            @media screen and (max-width: 768px) {
                .mobile_modal_overlay {
                    background: #222;
                    position: fixed;
                    top: 0;
                    bottom: 0;
                    left: 0;
                    right: 0;
                    z-index: 23;
                    flex-direction: column;
                    justify-content: center;
                    align-items: center
                }
            }

            .mobile_modal_overlay .modal_header {
                position: absolute;
                left: 0;
                top: 0;
                right: 0;
                padding: 16px;
                border-bottom: 1px solid var(--Grey-secondary, #d6d6d6)
            }

            .mobile_modal_overlay .modal_content {
                display: flex;
                justify-content: center;
                flex-wrap: wrap
            }

            .mobile_modal_overlay .modal_content h3 {
                color: var(--White, #fff);
                text-align: center;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%;
                margin-bottom: 25px;
                width: 100%
            }

            .mobile_modal_overlay .modal_content a {
                margin: 0 10px;
                display: block;
                text-align: center
            }

            .mobile_modal_overlay .modal_content a span {
                color: var(--White, #fff);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                display: block;
                margin-top: 10px
            }

            .modal {
                border-radius: 8px;
                background: var(--Black, #222);
                position: fixed;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                z-index: 999;
                max-width: 590px;
                width: 100%;
                display: none
            }

            @media screen and (max-width: 590px) {
                .modal {
                    max-width: calc(100% - 30px)
                }
            }

            .modal .modal_header {
                padding: 25px;
                display: flex;
                justify-content: space-between;
                align-items: center
            }

            .modal .modal_header h4 {
                color: var(--White, #fff);
                font-family: Antonio, sans-serif !important;
                font-size: 23px;
                font-style: normal;
                font-weight: 700;
                line-height: 120%
            }

            .modal .modal_content {
                border-top: 1px solid #727272;
                border-bottom: 1px solid #727272;
                padding: 25px
            }

            .modal .modal_content p {
                color: var(--White, #fff);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                text-align: left
            }

            .modal .modal_footer {
                padding: 15px 25px;
                text-align: center
            }

            .modal .modal_footer span {
                border-radius: 6px;
                border: 1px solid var(--White, #fff);
                background: var(--White, #fff);
                display: block;
                width: fit-content;
                text-align: center;
                color: var(--Black, #222);
                font-family: Antonio, sans-serif;
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                padding: 11px 20px;
                margin: 0 auto
            }

            .request_reset_modal {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                backdrop-filter: blur(10px);
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/log_in.jpg');
                justify-content: center;
                align-items: center;
                display: none;
                z-index: 8;
                background-position: center;
                background-size: cover
            }

            .request_reset_modal .request_reset {
                position: absolute;
                border-radius: 8px;
                background: rgba(255, 255, 255, .6);
                backdrop-filter: blur(10px);
                max-width: 600px;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                width: 100%
            }

            .request_reset_modal .request_reset h2 {
                color: var(--Black, #222);
                text-align: center;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%;
                font-family: Antonio, sans-serif !important;
                padding: 25px;
                border-bottom: 1px solid #727272;
                margin-bottom: 25px
            }

            .request_reset_modal .request_reset .close {
                position: absolute;
                top: 25px;
                right: 25px
            }

            .request_reset_modal .request_reset .form_content p {
                color: var(--Black, #222);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                margin-bottom: 25px;
                padding: 0 25px
            }

            .request_reset_modal .request_reset .form_content form input {
                border-radius: 4px;
                border: 1px solid var(--Grey, #727272);
                padding: 16px;
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                margin: 25px auto;
                max-width: 288px;
                display: block;
                width: 100%
            }

            .request_reset_modal .request_reset .form_content form .form_footer {
                border-top: 1px solid #727272;
                display: flex;
                justify-content: center;
                align-items: center;
                padding: 25px 0
            }

            .request_reset_modal .request_reset .form_content form .form_footer button, .request_reset_modal .request_reset .form_content form .form_footer span {
                padding: 11px 20px;
                border-radius: 6px;
                border: 1px solid var(--White, #fff);
                background: var(--White, #fff);
                color: var(--Black, #222);
                text-align: center;
                font-family: Antonio, sans-serif;
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                margin: 0 5px
            }

            .request_reset_modal .request_reset .form_content form .form_footer span {
                background: 0 0;
                border: 0
            }

            .reset_modal {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                backdrop-filter: blur(10px);
                background: url('https://promez.de/wp-content/themes/victor-child/assets/img/log_in.jpg');
                justify-content: center;
                align-items: center;
                display: none;
                z-index: 8;
                background-position: center;
                background-size: cover
            }

            .reset_modal .reset {
                position: absolute;
                border-radius: 8px;
                background: rgba(255, 255, 255, .6);
                backdrop-filter: blur(10px);
                max-width: 600px;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                width: 100%
            }

            .reset_modal .reset h2 {
                color: var(--Black, #222);
                text-align: center;
                font-size: 32px;
                font-weight: 700;
                line-height: 120%;
                font-family: Antonio, sans-serif !important;
                padding: 25px;
                border-bottom: 1px solid #727272;
                margin-bottom: 25px
            }

            .reset_modal .reset .close {
                position: absolute;
                top: 25px;
                right: 25px
            }

            .reset_modal .reset .form_content p {
                color: var(--Black, #222);
                text-align: center;
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 600;
                line-height: 120%;
                margin-bottom: 25px;
                padding: 0 25px
            }

            .reset_modal .reset .form_content form input {
                border-radius: 4px;
                border: 1px solid var(--Grey, #727272);
                padding: 16px;
                color: var(--Black, #222);
                font-family: "Nunito Sans";
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                margin: 25px auto;
                max-width: 288px;
                display: block;
                width: 100%
            }

            .reset_modal .reset .form_content form .form_footer {
                border-top: 1px solid #727272;
                display: flex;
                justify-content: center;
                align-items: center;
                padding: 25px 0
            }

            .reset_modal .reset .form_content form .form_footer button, .reset_modal .reset .form_content form .form_footer span {
                padding: 11px 20px;
                border-radius: 6px;
                border: 1px solid var(--White, #fff);
                background: var(--White, #fff);
                color: var(--Black, #222);
                text-align: center;
                font-family: Antonio, sans-serif;
                font-size: 16px;
                font-weight: 700;
                line-height: 120%;
                margin: 0 5px
            }

            .reset_modal .reset .form_content form .form_footer span {
                background: 0 0;
                border: 0
            }

            .dgwt-wcas-ico-magnifier {
                max-width: 20px
            }

            .dgwt-wcas-search-wrapp {
                max-width: 600px
            }

            .screen-reader-text {
                clip: rect(1px, 1px, 1px, 1px);
                word-wrap: normal !important;
                border: 0;
                clip-path: inset(50%);
                height: 1px;
                margin: -1px;
                overflow: hidden;
                overflow-wrap: normal !important;
                padding: 0;
                position: absolute !important;
                width: 1px
            }
        </style>
        <?php
    }
}

add_action('wp_head', 'insert_critical_css', 1);


// Defer NonCritical CSS
function defer_non_critical_css()
{
    if (!is_admin()) {
        global $wp_styles;
        foreach ($wp_styles->queue as $handle) {
            wp_style_add_data($handle, 'media', 'print');
        }
        add_action('wp_footer', function () {
            echo "
            <script>
            document.addEventListener('DOMContentLoaded', function() {
              document.querySelectorAll('link[rel=stylesheet][media=print]').forEach(function(link) {
                link.onload = function() { this.media = 'all'; };
              });
            });
            </script>
            ";
        }, 100);
    }
}

add_action('wp_enqueue_scripts', 'defer_non_critical_css', 100);


add_action('load-edit.php', function () {
    // ID-ul userului pentru care vrei mereu "All languages"
    $target_user_id = 34; // schimbă cu ID-ul real

    if (get_current_user_id() === $target_user_id) {
        // Forțează mereu lang = all
        if (isset($_GET['lang']) && $_GET['lang'] !== '') {
            $_GET['lang'] = '';
        }
        add_filter('request', function ($vars) {
            if (isset($vars['lang']) && $vars['lang'] !== '') {
                $vars['lang'] = '';
            }
            return $vars;
        });
    }
});

add_action('admin_head', function () {
    $target_user_id = 34; // schimbă cu ID-ul real al userului
    if (get_current_user_id() === $target_user_id) {
        echo '<style>
            #wp-admin-bar-languages { display: none !important; }
        </style>';
    }
});


add_action('wp', function () {
    if (is_cart() || is_checkout()) {
        add_action('wp_head', function () {
            ?>
            <style>
                .custom-notice {
                    background: #ffffe0;
                    border: 1px solid #ffcc00;
                    padding: 15px;
                    margin-bottom: 20px;
                    font-weight: bold;
                    text-align: center;
                }
            </style>
            <?php
        });

        add_action('woocommerce_before_main_content', function () {
            echo '<div class="custom-notice">Mesajul tău personalizat pentru Coș și Finalizare!</div>';
        }, 5);
    }
});

add_filter('wc_stripe_upe_params', function ($stripe_params) {

    // Affects block checkout
    $stripe_params['blocksAppearance'] = (object)['theme' => 'night'];

    // Affects shortcode checkout
    $stripe_params['appearance'] = (object)['theme' => 'night'];

    return $stripe_params;
});


// Filtrare comenzi dupa agent-ul de vanzari!

// Ascundem meniuri inutile pentru Agent Vânzări
add_action('admin_menu', function () {
    $user = wp_get_current_user();

    if (in_array('sales_agent', (array)$user->roles, true)) {
        // ascundem toate meniurile default
        remove_menu_page('index.php');                  // Dashboard
        remove_menu_page('edit.php');                   // Posts
        remove_menu_page('upload.php');                 // Media
        remove_menu_page('edit.php?post_type=page');    // Pages
        remove_menu_page('edit-comments.php');          // Comments
        remove_menu_page('edit.php?post_type=product'); // Products
        remove_menu_page('woocommerce');                // Woo general
        remove_menu_page('plugins.php');                // Plugins
        remove_menu_page('themes.php');                 // Appearance
        remove_menu_page('users.php');                  // Users
        remove_menu_page('tools.php');                  // Tools
        remove_menu_page('options-general.php');        // Settings
    }
}, 999);

add_filter( 'wpo_wcpdf_order_items_data', function( $items, $order, $document_type ) {

    foreach ( $items as $item_id => $item ) {

        // Preluăm meta pentru item-ul curent
        $bundled_by = wc_get_order_item_meta( $item_id, '_bundled_by', true );
        $line_total = isset( $item['order_price'] ) ? floatval($item['order_price']) : 0;

        /*
         * Regulă:
         * Dacă item-ul este copil de bundle (are _bundled_by)
         * ȘI are preț 0 → atunci îl eliminăm (nu îl arătăm în PDF)
         */
        if ( !empty($bundled_by) && $line_total == 0 ) {
            unset( $items[$item_id] );
        }
    }

    return $items;
}, 10, 3 );

