<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */
?>
</main><!-- #main -->
</div><!-- #primary -->
</div><!-- #content -->
<?php
$show_title = (true === get_theme_mod('display_title_and_tagline', true));

?>
<footer id="colophon" class="site-footer">
    <div class="container">
        <div class="footer_logos">
            <img src="/wp-content/themes/victor-child/assets/img/logo.svg" alt="" loading="lazy">
            <img src="/wp-content/themes/victor-child/assets/img/ifs_2.svg" alt="" loading="lazy">
            <img src="/wp-content/themes/victor-child/assets/img/ifs.svg" alt="" loading="lazy">
        </div>
        <div class="footer_menu">
            <?php if (has_nav_menu('footer')) : ?>
                <nav id="site-navigation" class="primary-navigation"
                     aria-label="<?php esc_attr_e('Footer menu', 'twentytwentyone'); ?>">
                    <!--        <div class="close">-->
                    <!--            <img src="/wp-content/themes/victor-child/assets/img/close.png" alt="">-->
                    <!--        </div>-->
                    <?php
                    wp_nav_menu(
                        array(
                            'theme_location' => 'footer',
                            'menu_class' => 'menu-wrapper',
                            'container_class' => 'footer-menu-container',
                            'items_wrap' => '<ul id="footer_menu" class="%2$s">%3$s</ul>',
                            'fallback_cb' => false,
                        )
                    );
                    ?>
                </nav><!-- #site-navigation -->
            <?php endif; ?>
        </div>
        <div class="social">
            <a href="https://chat.whatsapp.com/I9azZsgOSXe7UMFsNkjvxV" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                    <path d="M0.5 35.9976L3.0305 26.7531C1.469 24.0471 0.6485 20.9796 0.65 17.8341C0.6545 8.00006 8.657 -0.00244141 18.4895 -0.00244141C23.261 -0.000941406 27.74 1.85756 31.109 5.22956C34.4765 8.60156 36.3305 13.0836 36.329 17.8506C36.3245 27.6861 28.322 35.6886 18.4895 35.6886C15.5045 35.6871 12.563 34.9386 9.9575 33.5166L0.5 35.9976ZM10.3955 30.2871C12.9095 31.7796 15.3095 32.6736 18.4835 32.6751C26.6555 32.6751 33.3125 26.0241 33.317 17.8476C33.32 9.65456 26.6945 3.01256 18.4955 3.00956C10.3175 3.00956 3.665 9.66056 3.662 17.8356C3.6605 21.1731 4.6385 23.6721 6.281 26.2866L4.7825 31.7586L10.3955 30.2871ZM27.476 22.0911C27.365 21.9051 27.068 21.7941 26.621 21.5706C26.1755 21.3471 23.984 20.2686 23.5745 20.1201C23.1665 19.9716 22.8695 19.8966 22.571 20.3436C22.274 20.7891 21.419 21.7941 21.1595 22.0911C20.9 22.3881 20.639 22.4256 20.1935 22.2021C19.748 21.9786 18.311 21.5091 16.6085 19.9896C15.284 18.8076 14.3885 17.3481 14.129 16.9011C13.8695 16.4556 14.102 16.2141 14.324 15.9921C14.525 15.7926 14.7695 15.4716 14.993 15.2106C15.2195 14.9526 15.293 14.7666 15.443 14.4681C15.5915 14.1711 15.518 13.9101 15.4055 13.6866C15.293 13.4646 14.402 11.2701 14.0315 10.3776C13.6685 9.50906 13.301 9.62606 13.028 9.61256L12.173 9.59756C11.876 9.59756 11.393 9.70856 10.985 10.1556C10.577 10.6026 9.425 11.6796 9.425 13.8741C9.425 16.0686 11.0225 18.1881 11.2445 18.4851C11.468 18.7821 14.387 23.2851 18.8585 25.2156C19.922 25.6746 20.753 25.9491 21.3995 26.1546C22.4675 26.4936 23.4395 26.4456 24.2075 26.3316C25.064 26.2041 26.8445 25.2531 27.2165 24.2121C27.5885 23.1696 27.5885 22.2771 27.476 22.0911Z"
                          fill="#727272"/>
                </svg>
            </a>
            <a href="https://www.facebook.com/promez.ro/" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                    <g clip-path="url(#clip0_556_1302)">
                        <path d="M18.5 -0.00244141C8.55896 -0.00244141 0.5 8.05652 0.5 17.9976C0.5 26.4388 6.31184 33.5222 14.1519 35.4676V23.4984H10.4403V17.9976H14.1519V15.6273C14.1519 9.50084 16.9246 6.66116 22.9395 6.66116C24.08 6.66116 26.0478 6.88508 26.8527 7.10828V12.0943C26.4279 12.0496 25.6899 12.0273 24.7734 12.0273C21.8221 12.0273 20.6816 13.1455 20.6816 16.0521V17.9976H26.5611L25.551 23.4984H20.6816V35.8658C29.5945 34.7894 36.5007 27.2006 36.5007 17.9976C36.5 8.05652 28.441 -0.00244141 18.5 -0.00244141Z"
                              fill="#727272"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_556_1302">
                            <rect width="36" height="36" fill="white" transform="translate(0.5 -0.00244141)"/>
                        </clipPath>
                    </defs>
                </svg>
            </a>
            <a href="https://www.instagram.com/promez.ro/" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                    <g clip-path="url(#clip0_556_1304)">
                        <path d="M18.5 3.23896C23.3094 3.23896 23.8789 3.26006 25.7703 3.34443C27.5281 3.42178 28.4773 3.71709 29.1102 3.96318C29.9469 4.28662 30.5516 4.68037 31.1773 5.30615C31.8102 5.93896 32.1969 6.53662 32.5203 7.37334C32.7664 8.00615 33.0617 8.9624 33.1391 10.7132C33.2234 12.6116 33.2445 13.1812 33.2445 17.9835C33.2445 22.7929 33.2234 23.3624 33.1391 25.2538C33.0617 27.0116 32.7664 27.9608 32.5203 28.5937C32.1969 29.4304 31.8031 30.0351 31.1773 30.6608C30.5445 31.2937 29.9469 31.6804 29.1102 32.0038C28.4773 32.2499 27.5211 32.5452 25.7703 32.6226C23.8719 32.7069 23.3023 32.728 18.5 32.728C13.6906 32.728 13.1211 32.7069 11.2297 32.6226C9.47188 32.5452 8.52266 32.2499 7.88984 32.0038C7.05313 31.6804 6.44844 31.2866 5.82266 30.6608C5.18984 30.028 4.80312 29.4304 4.47969 28.5937C4.23359 27.9608 3.93828 27.0046 3.86094 25.2538C3.77656 23.3554 3.75547 22.7858 3.75547 17.9835C3.75547 13.1741 3.77656 12.6046 3.86094 10.7132C3.93828 8.95537 4.23359 8.00615 4.47969 7.37334C4.80312 6.53662 5.19688 5.93193 5.82266 5.30615C6.45547 4.67334 7.05313 4.28662 7.88984 3.96318C8.52266 3.71709 9.47891 3.42178 11.2297 3.34443C13.1211 3.26006 13.6906 3.23896 18.5 3.23896ZM18.5 -0.00244141C13.6133 -0.00244141 13.0016 0.0186523 11.082 0.103027C9.16953 0.187402 7.85469 0.496777 6.71563 0.939746C5.52734 1.40381 4.52188 2.01553 3.52344 3.021C2.51797 4.01943 1.90625 5.0249 1.44219 6.20615C0.999219 7.35225 0.689844 8.66006 0.605469 10.5726C0.521094 12.4991 0.5 13.1108 0.5 17.9976C0.5 22.8843 0.521094 23.496 0.605469 25.4155C0.689844 27.328 0.999219 28.6429 1.44219 29.7819C1.90625 30.9702 2.51797 31.9757 3.52344 32.9741C4.52188 33.9726 5.52734 34.5913 6.70859 35.0483C7.85469 35.4913 9.1625 35.8007 11.075 35.8851C12.9945 35.9694 13.6062 35.9905 18.493 35.9905C23.3797 35.9905 23.9914 35.9694 25.9109 35.8851C27.8234 35.8007 29.1383 35.4913 30.2773 35.0483C31.4586 34.5913 32.4641 33.9726 33.4625 32.9741C34.4609 31.9757 35.0797 30.9702 35.5367 29.789C35.9797 28.6429 36.2891 27.3351 36.3734 25.4226C36.4578 23.503 36.4789 22.8913 36.4789 18.0046C36.4789 13.1179 36.4578 12.5062 36.3734 10.5866C36.2891 8.67412 35.9797 7.35928 35.5367 6.22021C35.0938 5.0249 34.482 4.01943 33.4766 3.021C32.4781 2.02256 31.4727 1.40381 30.2914 0.946777C29.1453 0.503808 27.8375 0.194434 25.925 0.110059C23.9984 0.0186523 23.3867 -0.00244141 18.5 -0.00244141Z"
                              fill="white"/>
                        <path d="M18.5 8.75146C13.3953 8.75146 9.25391 12.8929 9.25391 17.9976C9.25391 23.1022 13.3953 27.2437 18.5 27.2437C23.6047 27.2437 27.7461 23.1022 27.7461 17.9976C27.7461 12.8929 23.6047 8.75146 18.5 8.75146ZM18.5 23.9952C15.1883 23.9952 12.5023 21.3093 12.5023 17.9976C12.5023 14.6858 15.1883 11.9999 18.5 11.9999C21.8117 11.9999 24.4977 14.6858 24.4977 17.9976C24.4977 21.3093 21.8117 23.9952 18.5 23.9952Z"
                              fill="white"/>
                        <path d="M30.2703 8.38589C30.2703 9.58121 29.3 10.5445 28.1117 10.5445C26.9164 10.5445 25.9531 9.57417 25.9531 8.38589C25.9531 7.19058 26.9234 6.22729 28.1117 6.22729C29.3 6.22729 30.2703 7.19761 30.2703 8.38589Z"
                              fill="white"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_556_1304">
                            <rect width="36" height="36" fill="white" transform="translate(0.5 -0.00244141)"/>
                        </clipPath>
                    </defs>
                </svg>
            </a>
            <a href="#" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                    <g clip-path="url(#clip0_556_1310)">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                              d="M36.5 17.9976C36.5 27.9387 28.4411 35.9976 18.5 35.9976C8.55888 35.9976 0.5 27.9387 0.5 17.9976C0.5 8.05643 8.55888 -0.00244141 18.5 -0.00244141C28.4411 -0.00244141 36.5 8.05643 36.5 17.9976ZM19.145 13.286C17.3943 14.0142 13.8952 15.5214 8.64784 17.8075C7.79575 18.1464 7.34939 18.4779 7.30875 18.802C7.24008 19.3498 7.92607 19.5655 8.8602 19.8592C8.98727 19.8992 9.11893 19.9406 9.25391 19.9845C10.173 20.2832 11.4092 20.6327 12.0519 20.6466C12.6349 20.6592 13.2856 20.4189 14.004 19.9256C18.9067 16.6161 21.4376 14.9433 21.5965 14.9072C21.7086 14.8818 21.8639 14.8498 21.9691 14.9433C22.0744 15.0369 22.0641 15.214 22.0529 15.2616C21.9849 15.5513 19.2922 18.0547 17.8987 19.3502C17.4643 19.7541 17.1561 20.0406 17.0931 20.106C16.952 20.2526 16.8082 20.3912 16.67 20.5245C15.8162 21.3475 15.1759 21.9648 16.7054 22.9727C17.4405 23.4571 18.0286 23.8577 18.6154 24.2573C19.2563 24.6937 19.8954 25.129 20.7224 25.6711C20.9331 25.8092 21.1343 25.9526 21.3303 26.0924C22.0761 26.624 22.7461 27.1017 23.5739 27.0255C24.0549 26.9812 24.5517 26.529 24.804 25.1801C25.4003 21.9923 26.5724 15.0852 26.8433 12.239C26.8671 11.9897 26.8372 11.6705 26.8132 11.5304C26.7893 11.3903 26.7392 11.1907 26.557 11.043C26.3414 10.868 26.0085 10.8311 25.8595 10.8337C25.1825 10.8456 24.1438 11.2068 19.145 13.286Z"
                              fill="#727272"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_556_1310">
                            <rect width="36" height="36" fill="white" transform="translate(0.5 -0.00244141)"/>
                        </clipPath>
                    </defs>
                </svg>
            </a>
        </div>
        <div class="bottom_footer">
            <?php $year = date('Y'); ?>
            <div class="copyright">©<?= $year ?> Promez. <?php echo pll_e('Toate drepturile rezervate.') ?></div>
            <div class="images">
                <svg xmlns="http://www.w3.org/2000/svg" width="51" height="30" viewBox="0 0 51 30" fill="none">
                    <path d="M50.4548 14.9976C50.4548 23.2283 43.7625 29.9976 35.4548 29.9976C27.2241 29.9976 20.4548 23.2283 20.4548 14.9976C20.4548 6.76679 27.1471 -0.00244141 35.3779 -0.00244141C43.7625 -0.00244141 50.4548 6.76679 50.4548 14.9976Z"
                          fill="#F9B50B"/>
                    <path d="M30.3774 15.0745C30.3774 13.9976 30.2236 12.9206 30.0697 11.9206H20.839C20.9159 11.3822 21.0697 10.9206 21.2236 10.3053H29.4543C29.3005 9.76679 29.0697 9.22833 28.839 8.68987H21.839C22.0697 8.15141 22.3774 7.68987 22.6851 7.07448H27.9928C27.6851 6.53602 27.3005 5.99756 26.839 5.4591H23.9159C24.3774 4.92064 24.839 4.4591 25.4543 3.92064C22.839 1.4591 19.3005 -0.00244141 15.3774 -0.00244141C7.22358 0.228328 0.454346 6.76679 0.454346 14.9976C0.454346 23.2283 7.14665 29.9976 15.4543 29.9976C19.3774 29.9976 22.839 28.4591 25.5313 26.0745C26.0697 25.6129 26.5313 25.0745 27.0697 24.4591H23.9928C23.6082 23.9976 23.2236 23.4591 22.9159 22.9206H28.1467C28.4543 22.4591 28.762 21.9206 28.9928 21.3053H21.9928C21.762 20.8437 21.5313 20.3053 21.3774 19.6899H29.6082C30.0697 18.3053 30.3774 16.7668 30.3774 15.0745Z"
                          fill="#C8191C"/>
                    <path d="M20.7628 18.844L20.9935 17.4594C20.9166 17.4594 20.7628 17.5363 20.6089 17.5363C20.0705 17.5363 19.9935 17.2286 20.0705 17.0748L20.532 14.3055H21.3782L21.6089 12.7671H20.8397L20.9935 11.844H19.3782C19.3782 11.844 18.4551 17.0748 18.4551 17.6901C18.4551 18.6132 18.9935 19.0748 19.7628 19.0748C20.2243 19.0748 20.6089 18.9209 20.7628 18.844Z"
                          fill="white"/>
                    <path d="M21.2996 16.3051C21.2996 18.5358 22.838 19.0743 24.0688 19.0743C25.2226 19.0743 25.7611 18.8435 25.7611 18.8435L26.0688 17.3051C26.0688 17.3051 25.2226 17.6897 24.3765 17.6897C22.6073 17.6897 22.9149 16.382 22.9149 16.382H26.1457C26.1457 16.382 26.3765 15.382 26.3765 14.9205C26.3765 13.9205 25.838 12.6128 24.0688 12.6128C22.5303 12.5358 21.2996 14.3051 21.2996 16.3051ZM24.0688 13.9974C24.9149 13.9974 24.7611 14.9974 24.7611 15.0743H22.9919C23.0688 14.9974 23.2226 13.9974 24.0688 13.9974Z"
                          fill="white"/>
                    <path d="M34.1468 18.8434L34.4545 17.0742C34.4545 17.0742 33.6853 17.4588 33.0699 17.4588C31.993 17.4588 31.4545 16.6127 31.4545 15.6127C31.4545 13.6896 32.3776 12.6896 33.5314 12.6896C34.3007 12.6896 34.993 13.1511 34.993 13.1511L35.2237 11.4588C35.2237 11.4588 34.3007 11.0742 33.3776 11.0742C31.5314 11.0742 29.7622 12.6896 29.7622 15.6896C29.7622 17.6896 30.6853 18.9973 32.6084 18.9973C33.3007 19.0742 34.1468 18.8434 34.1468 18.8434Z"
                          fill="white"/>
                    <path d="M12.0701 12.5361C10.9931 12.5361 10.147 12.8438 10.147 12.8438L9.91622 14.2284C9.91622 14.2284 10.6085 13.9207 11.6855 13.9207C12.2239 13.9207 12.6855 13.9977 12.6855 14.4592C12.6855 14.7669 12.6085 14.8438 12.6085 14.8438H11.9162C10.5316 14.8438 9.07007 15.3823 9.07007 17.2284C9.07007 18.69 9.99315 18.9977 10.6085 18.9977C11.6855 18.9977 12.2239 18.3054 12.3008 18.3054L12.2239 18.9207H13.5316L14.147 14.5361C14.147 12.6131 12.6085 12.5361 12.0701 12.5361ZM12.3778 16.0746C12.3778 16.3054 12.2239 17.6131 11.3008 17.6131C10.8393 17.6131 10.6855 17.2284 10.6855 16.9977C10.6855 16.6131 10.9162 16.0746 12.147 16.0746C12.3008 16.0746 12.3778 16.0746 12.3778 16.0746Z"
                          fill="white"/>
                    <path d="M15.6848 18.9977C16.0694 18.9977 18.0694 19.0746 18.0694 16.9208C18.0694 14.9208 16.1463 15.3054 16.1463 14.5362C16.1463 14.1515 16.454 13.9977 16.9925 13.9977C17.2233 13.9977 18.0694 14.0746 18.0694 14.0746L18.3002 12.6131C18.3002 12.6131 17.7617 12.4592 16.7617 12.4592C15.6079 12.4592 14.3771 12.9208 14.3771 14.5362C14.3771 16.3823 16.3771 16.2285 16.3771 16.9208C16.3771 17.3823 15.8386 17.4592 15.454 17.4592C14.7617 17.4592 13.9925 17.2285 13.9925 17.2285L13.7617 18.69C13.9156 18.8438 14.3771 18.9977 15.6848 18.9977Z"
                          fill="white"/>
                    <path d="M47.3771 11.3057L47.0694 13.4595C47.0694 13.4595 46.454 12.6903 45.5309 12.6903C44.0694 12.6903 42.8386 14.4595 42.8386 16.5364C42.8386 17.8441 43.454 19.1518 44.8386 19.1518C45.7617 19.1518 46.3771 18.5364 46.3771 18.5364L46.3002 19.0749H47.9155L49.0694 11.4595L47.3771 11.3057ZM46.6079 15.4595C46.6079 16.3057 46.2232 17.4595 45.3002 17.4595C44.7617 17.4595 44.454 16.998 44.454 16.1518C44.454 14.8441 44.9925 14.0749 45.7617 14.0749C46.3002 14.1518 46.6079 14.5364 46.6079 15.4595Z"
                          fill="white"/>
                    <path d="M3.37635 18.921L4.29943 13.2287L4.45327 18.921H5.5302L7.60712 13.2287L6.76097 18.921H8.45327L9.76097 11.3057H7.14558L5.5302 15.998L5.45327 11.3057H3.14558L1.83789 18.921H3.37635Z"
                          fill="white"/>
                    <path d="M27.9924 18.921C28.4539 16.3056 28.5308 14.1517 29.6847 14.5363C29.8385 13.5363 30.0693 13.0748 30.2231 12.6902H29.9155C29.2231 12.6902 28.6078 13.6133 28.6078 13.6133L28.7616 12.7671H27.2231L26.2231 18.921H27.9924Z"
                          fill="white"/>
                    <path d="M37.8396 12.5361C36.7627 12.5361 35.9165 12.8438 35.9165 12.8438L35.6858 14.2284C35.6858 14.2284 36.3781 13.9207 37.455 13.9207C37.9934 13.9207 38.455 13.9977 38.455 14.4592C38.455 14.7669 38.3781 14.8438 38.3781 14.8438H37.6858C36.3011 14.8438 34.8396 15.3823 34.8396 17.2284C34.8396 18.69 35.7627 18.9977 36.3781 18.9977C37.455 18.9977 37.9934 18.3054 38.0704 18.3054L37.9934 18.9207H39.455L40.0704 14.5361C40.0704 12.6131 38.3781 12.5361 37.8396 12.5361ZM38.2242 16.0746C38.2242 16.3054 38.0704 17.6131 37.1473 17.6131C36.6858 17.6131 36.5319 17.2284 36.5319 16.9977C36.5319 16.6131 36.7627 16.0746 37.9934 16.0746C38.1473 16.0746 38.1473 16.0746 38.2242 16.0746Z"
                          fill="white"/>
                    <path d="M41.3005 18.921C41.762 16.3056 41.8389 14.1517 42.9928 14.5363C43.1466 13.5363 43.3774 13.0748 43.5313 12.6902H43.2236C42.5312 12.6902 41.9159 13.6133 41.9159 13.6133L42.0697 12.7671H40.5312L39.5312 18.921H41.3005Z"
                          fill="white"/>
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" width="103" height="26" viewBox="0 0 103 26" fill="none">
                    <path d="M39.3434 11.2121C39.0788 13.1962 37.4916 13.1962 36.0365 13.1962H35.2429L35.9043 9.36028C35.9043 9.09573 36.1688 8.96345 36.4333 8.96345H36.8302C37.8884 8.96345 38.8143 8.96346 39.3434 9.49255C39.3434 10.0217 39.3434 10.5507 39.3434 11.2121ZM38.682 5.92114H32.9942C32.5974 5.92114 32.3329 6.18569 32.2006 6.58251L29.9519 21.1327C29.9519 21.3973 30.0842 21.6618 30.481 21.6618H33.1265C33.5233 21.6618 33.7879 21.3973 33.9201 21.0004L34.5815 17.0322C34.5815 16.6354 34.9783 16.3708 35.3752 16.3708H37.227C40.9307 16.3708 43.0471 14.519 43.7084 10.9476C43.973 9.36028 43.7084 8.16981 43.0471 7.24389C41.9889 6.45024 40.5339 5.92114 38.682 5.92114Z"
                          fill="#263577"/>
                    <path d="M51.7777 16.5028C51.5132 18.0901 50.3227 19.1483 48.7354 19.1483C47.9418 19.1483 47.2804 18.8837 46.8836 18.3546C46.4868 17.8255 46.3545 17.1642 46.4868 16.5028C46.7513 14.9155 47.9418 13.8573 49.5291 13.8573C50.3227 13.8573 50.9841 14.1219 51.3809 14.6509C51.6455 15.0478 51.91 15.7091 51.7777 16.5028ZM55.4814 11.2118H52.836C52.5714 11.2118 52.4391 11.3441 52.3068 11.6086L52.1746 12.4023L52.0423 12.1377C51.5132 11.3441 50.1905 10.9473 48.8677 10.9473C45.8254 10.9473 43.3122 13.1959 42.7831 16.3705C42.5185 17.9578 42.9154 19.4128 43.8413 20.471C44.6349 21.3969 45.8254 21.7938 47.2804 21.7938C49.6614 21.7938 50.9841 20.2065 50.9841 20.2065L50.8518 21.0001C50.8518 21.2647 50.9841 21.5292 51.3809 21.5292H53.7619C54.1587 21.5292 54.4232 21.2647 54.5555 20.8679L56.0105 11.6086C56.0105 11.4764 55.8783 11.2118 55.4814 11.2118Z"
                          fill="#263577"/>
                    <path d="M69.8994 11.2119H67.1216C66.857 11.2119 66.5925 11.3442 66.4602 11.6087L62.7565 17.1643L61.1692 11.8733C61.037 11.4765 60.7724 11.3442 60.3756 11.3442H57.7301C57.4655 11.3442 57.201 11.6087 57.3333 12.0056L60.3756 20.7357L57.5978 24.7039C57.3333 24.9685 57.5978 25.4976 57.9947 25.4976H60.7724C61.037 25.4976 61.3015 25.3653 61.4338 25.1007L70.4284 12.0056C70.5607 11.6087 70.2962 11.2119 69.8994 11.2119Z"
                          fill="#263577"/>
                    <path d="M79.5551 11.2121C79.2905 13.1962 77.7032 13.1962 76.2482 13.1962H75.4546L76.1159 9.36028C76.1159 9.09573 76.3805 8.96345 76.6451 8.96345H77.0419C78.1001 8.96345 79.026 8.96346 79.5551 9.49255C79.6873 10.0217 79.6873 10.5507 79.5551 11.2121ZM78.8937 5.92114H73.2059C72.8091 5.92114 72.5445 6.18569 72.4123 6.58251L70.1636 21.1327C70.1636 21.3973 70.2959 21.6618 70.6927 21.6618H73.6027C73.8673 21.6618 74.1318 21.5295 74.1318 21.1327L74.7932 17.0322C74.7932 16.6354 75.19 16.3708 75.5868 16.3708H77.4387C81.1424 16.3708 83.2588 14.519 83.9201 10.9476C84.1847 9.36028 83.9201 8.16981 83.2588 7.24389C82.3329 6.45024 80.8778 5.92114 78.8937 5.92114Z"
                          fill="#2199D6"/>
                    <path d="M92.1215 16.5028C91.8569 18.0901 90.6665 19.1483 89.0792 19.1483C88.2855 19.1483 87.6242 18.8837 87.2274 18.3546C86.8305 17.8255 86.6982 17.1642 86.8305 16.5028C87.0951 14.9155 88.2856 13.8573 89.8728 13.8573C90.6665 13.8573 91.3279 14.1219 91.7247 14.6509C91.9892 15.0478 92.2538 15.7091 92.1215 16.5028ZM95.8252 11.2118H93.1797C92.9152 11.2118 92.7829 11.3441 92.6506 11.6086L92.5183 12.4023L92.3861 12.1377C91.857 11.3441 90.5342 10.9473 89.2115 10.9473C86.1692 10.9473 83.6559 13.1959 83.1268 16.3705C82.8623 17.9578 83.2591 19.4128 84.185 20.471C84.9787 21.3969 86.1691 21.7938 87.6242 21.7938C90.0051 21.7938 91.3278 20.2065 91.3278 20.2065L91.1956 21.0001C91.1956 21.2647 91.3279 21.5292 91.7247 21.5292H94.1056C94.5024 21.5292 94.767 21.2647 94.8993 20.8679L96.3543 11.6086C96.3543 11.4764 96.0897 11.2118 95.8252 11.2118Z"
                          fill="#2199D6"/>
                    <path d="M98.9996 6.31796L96.6187 21.1327C96.6187 21.3973 96.751 21.6618 97.1478 21.6618H99.5287C99.9255 21.6618 100.19 21.3973 100.322 21.0004L102.571 6.45024C102.571 6.18569 102.439 5.92114 102.042 5.92114H99.3964C99.2641 5.92114 99.1319 6.18569 98.9996 6.31796Z"
                          fill="#2199D6"/>
                    <path d="M6.40627 24.4395L6.80308 21.6618H5.87716H1.24756L4.42216 1.42378C4.42216 1.42378 4.42215 1.2915 4.55442 1.2915H4.6867H12.4909C15.0041 1.2915 16.8559 1.8206 17.7819 2.8788C18.1787 3.4079 18.4432 3.93699 18.5755 4.46609C18.7078 5.12746 18.7078 5.78883 18.5755 6.71475V7.24385L18.9723 7.5084C19.3692 7.64068 19.6337 7.90523 19.8983 8.16978C20.2951 8.5666 20.5596 9.0957 20.5596 9.75707C20.6919 10.4184 20.6919 11.2121 20.4274 12.138C20.1628 13.1962 19.8983 13.9898 19.5014 14.7835C19.1046 15.4449 18.5755 15.974 18.0464 16.5031C17.5173 16.8999 16.7237 17.1644 16.0623 17.429C15.2686 17.5613 14.475 17.6935 13.5491 17.6935H12.8877C12.4909 17.6935 12.0941 17.8258 11.6973 18.0904C11.4327 18.3549 11.1682 18.7517 11.0359 19.1486V19.4131L10.2422 24.3073V24.4395V24.5718C10.2422 24.5718 10.2422 24.5718 10.1099 24.5718H6.40627V24.4395Z"
                          fill="#263577"/>
                    <path d="M19.5031 6.71509C19.5031 6.84736 19.5031 6.97964 19.3708 7.11192C18.3126 12.4029 14.8735 14.1225 10.3761 14.1225H8.12746C7.59837 14.1225 7.06928 14.5193 7.06928 15.0484L5.8788 22.4557L5.61426 24.5721C5.61426 24.969 5.8788 25.2335 6.14335 25.2335H10.2439C10.773 25.2335 11.1698 24.8367 11.1698 24.4399V24.1753L11.9634 19.4134V19.1489C12.0957 18.6198 12.4925 18.3552 12.8894 18.3552H13.5507C17.519 18.3552 20.5613 16.7679 21.3549 12.1383C21.7517 10.1542 21.4872 8.56693 20.5613 7.50874C20.2967 7.24419 19.8999 6.97964 19.5031 6.71509Z"
                          fill="#2199D6"/>
                    <path d="M18.4442 6.31796C18.3119 6.31796 18.1797 6.18569 17.9151 6.18569C17.7828 6.18569 17.5183 6.05342 17.386 6.05342C16.7246 5.92114 16.0632 5.92114 15.4019 5.92114H9.31726C9.18499 5.92114 9.05271 5.92114 8.92044 6.05342C8.65589 6.18569 8.39135 6.45024 8.39135 6.71479L7.0686 14.9158V15.1804C7.20088 14.6513 7.59769 14.2544 8.12678 14.2544H10.3755C14.8728 14.2544 18.3119 12.4026 19.3701 7.24389C19.3701 7.11161 19.3701 6.97934 19.5024 6.84706C19.2378 6.71479 18.9733 6.58252 18.7087 6.45024C18.5765 6.31797 18.4442 6.31796 18.4442 6.31796Z"
                          fill="#252C5E"/>
                    <path d="M8.3913 6.7147C8.3913 6.45015 8.65584 6.1856 8.92039 6.05332C9.05266 6.05332 9.18494 5.92105 9.31722 5.92105H15.4018C16.0632 5.92105 16.8568 5.92105 17.3859 6.05332C17.5182 6.05332 17.7828 6.05333 17.9151 6.1856C18.0473 6.1856 18.1796 6.31787 18.4441 6.31787C18.5764 6.31787 18.5764 6.31788 18.7087 6.45015C18.9732 6.58243 19.2378 6.7147 19.5023 6.84697C19.7669 4.86286 19.5023 3.54011 18.4441 2.34964C17.2537 1.0269 15.1373 0.497803 12.4918 0.497803H4.68761C4.15851 0.497803 3.62941 0.894622 3.62941 1.42372L0.454834 21.794C0.454834 22.1908 0.719383 22.5876 1.11621 22.5876H5.87807L7.06856 14.9157L8.3913 6.7147Z"
                          fill="#263577"/>
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" width="82" height="26" viewBox="0 0 82 26" fill="none">
                    <path d="M76.5238 0.854248H71.4047C69.8571 0.854248 68.6666 1.33044 67.9523 2.87806L58.1904 25.14H65.0952C65.0952 25.14 66.2857 22.1638 66.5238 21.4495C67.238 21.4495 74.0238 21.4495 74.9761 21.4495C75.2142 22.2828 75.8095 25.0209 75.8095 25.0209H82L76.5238 0.854248ZM68.4285 16.4495C69.0238 15.0209 71.0476 9.66377 71.0476 9.66377C71.0476 9.78282 71.6428 8.2352 71.8809 7.40187L72.3571 9.54472C72.3571 9.54472 73.6666 15.3781 73.9047 16.5685H68.4285V16.4495Z"
                          fill="#3362AB"/>
                    <path d="M58.6668 17.1642C58.6668 22.1642 54.143 25.4976 47.1192 25.4976C44.143 25.4976 41.2859 24.9023 39.7383 24.188L40.6907 18.7118L41.524 19.069C43.6669 20.0214 45.0954 20.3785 47.7145 20.3785C49.6192 20.3785 51.643 19.6642 51.643 17.9976C51.643 16.9261 50.8097 16.2118 48.1907 15.0214C45.6907 13.8309 42.3573 11.9261 42.3573 8.47375C42.3573 3.71184 47.0002 0.497559 53.5478 0.497559C56.0478 0.497559 58.1907 0.973749 59.5002 1.56899L58.5478 6.80708L58.0716 6.33089C56.8811 5.8547 55.3335 5.37851 53.0716 5.37851C50.5716 5.49756 49.3811 6.56899 49.3811 7.52137C49.3811 8.5928 50.8097 9.42613 53.0716 10.4976C56.8811 12.2833 58.6668 14.3071 58.6668 17.1642Z"
                          fill="#3362AB"/>
                    <path d="M0.571045 1.09313L0.690093 0.616943H10.9282C12.3568 0.616943 13.4282 1.09313 13.7853 2.64075L16.0472 13.355C13.7853 7.64075 8.54724 2.9979 0.571045 1.09313Z"
                          fill="#F9B50B"/>
                    <path d="M30.4515 0.854887L20.0944 25.0216H13.0705L7.11816 4.78346C11.4039 7.52155 14.9753 11.8073 16.2848 14.7835L16.9991 17.2835L23.4277 0.73584H30.4515V0.854887Z"
                          fill="#3362AB"/>
                    <path d="M33.1906 0.73584H39.7382L35.5715 25.0216H29.0239L33.1906 0.73584Z" fill="#3362AB"/>
                </svg>
            </div>

            <?php if (has_nav_menu('privacy_policy')) : ?>
                <nav id="site-navigation" class="privacy-navigation"
                     aria-label="<?php esc_attr_e('Footer menu', 'twentytwentyone'); ?>">
                    <!--        <div class="close">-->
                    <!--            <img src="/wp-content/themes/victor-child/assets/img/close.png" alt="">-->
                    <!--        </div>-->
                    <?php
                    wp_nav_menu(
                        array(
                            'theme_location' => 'privacy_policy',
                            'menu_class' => 'menu-wrapper',
                            'container_class' => 'privacy_policy',
                            'items_wrap' => '<ul id="privacy_policy" class="%2$s">%3$s</ul>',
                            'fallback_cb' => false,
                        )
                    );
                    ?>
                </nav><!-- #site-navigation -->
            <?php endif; ?>
        </div>
    </div>
    <div class="back_to_top">
        <svg width="110" height="110" viewBox="0 0 110 110" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g filter="url(#filter0_d_513_112685)">
                <rect x="15" y="10" width="80" height="80" rx="40" fill="#F20030"/>
                <g clip-path="url(#clip0_513_112685)">
                    <path d="M75.0776 60.703C74.9035 60.8774 74.6967 61.0157 74.4691 61.11C74.2414 61.2044 73.9974 61.2529 73.751 61.2529C73.5046 61.2529 73.2607 61.2044 73.033 61.11C72.8054 61.0157 72.5986 60.8774 72.4245 60.703L55.001 43.2773L37.5776 60.703C37.2258 61.0549 36.7486 61.2525 36.251 61.2525C35.7535 61.2525 35.2763 61.0549 34.9245 60.703C34.5727 60.3512 34.375 59.874 34.375 59.3765C34.375 58.8789 34.5727 58.4017 34.9245 58.0499L53.6745 39.2999C53.8486 39.1256 54.0554 38.9873 54.283 38.8929C54.5107 38.7986 54.7546 38.75 55.001 38.75C55.2474 38.75 55.4914 38.7986 55.7191 38.8929C55.9467 38.9873 56.1535 39.1256 56.3276 39.2999L75.0776 58.0499C75.2519 58.224 75.3902 58.4308 75.4846 58.6585C75.579 58.8861 75.6275 59.1301 75.6275 59.3765C75.6275 59.6229 75.579 59.8669 75.4846 60.0945C75.3902 60.3221 75.2519 60.5289 75.0776 60.703Z"
                          fill="white"/>
                </g>
            </g>
            <defs>
                <filter id="filter0_d_513_112685" x="0" y="0" width="110" height="110" filterUnits="userSpaceOnUse"
                        color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                    <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                   result="hardAlpha"/>
                    <feOffset dy="5"/>
                    <feGaussianBlur stdDeviation="7.5"/>
                    <feColorMatrix type="matrix" values="0 0 0 0 0.94902 0 0 0 0 0 0 0 0 0 0.188235 0 0 0 1 0"/>
                    <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_513_112685"/>
                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_513_112685" result="shape"/>
                </filter>
                <clipPath id="clip0_513_112685">
                    <rect width="60" height="60" fill="white" transform="translate(25 20)"/>
                </clipPath>
            </defs>
        </svg>
    </div>
    <div class="newsletter_modal_overlay ">
        <div class="newsletter_modal">
            <div class="mobile_modal_header">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_847_43425)">
                        <path d="M21.0001 12.0004C21.0001 12.1993 20.9211 12.3901 20.7804 12.5307C20.6398 12.6714 20.449 12.7504 20.2501 12.7504H5.56041L11.0307 18.2198C11.1004 18.2895 11.1557 18.3722 11.1934 18.4632C11.2311 18.5543 11.2505 18.6519 11.2505 18.7504C11.2505 18.849 11.2311 18.9465 11.1934 19.0376C11.1557 19.1286 11.1004 19.2114 11.0307 19.281C10.961 19.3507 10.8783 19.406 10.7873 19.4437C10.6962 19.4814 10.5986 19.5008 10.5001 19.5008C10.4016 19.5008 10.304 19.4814 10.2129 19.4437C10.1219 19.406 10.0392 19.3507 9.96948 19.281L3.21948 12.531C3.14974 12.4614 3.09443 12.3787 3.05668 12.2876C3.01894 12.1966 2.99951 12.099 2.99951 12.0004C2.99951 11.9019 3.01894 11.8043 3.05668 11.7132C3.09443 11.6222 3.14974 11.5394 3.21948 11.4698L9.96948 4.71979C10.1102 4.57906 10.3011 4.5 10.5001 4.5C10.6991 4.5 10.89 4.57906 11.0307 4.71979C11.1715 4.86052 11.2505 5.05139 11.2505 5.25042C11.2505 5.44944 11.1715 5.64031 11.0307 5.78104L5.56041 11.2504H20.2501C20.449 11.2504 20.6398 11.3294 20.7804 11.4701C20.9211 11.6107 21.0001 11.8015 21.0001 12.0004Z"
                              fill="white"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_847_43425">
                            <rect width="24" height="24" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>

            </div>
            <div class="left_side">

                <h2><?php echo pll_e('Abonează-te la newsletter') ?></h2>
                <p><?php echo pll_e('Abonează-te la Newsletter-ul nostru și fii primul care află despre reduceri exclusive, rețete
                    delicioase și noutăți! Fie că ești un fan al gusturilor tradiționale românești sau vrei să explorezi
                    noi delicii culinare, Newsletter-ul nostru este plin de conținut pe care îl vei adora.') ?></p>
                <div class="mailchimp">
                    <?php echo do_shortcode('[mc4wp_form id=143]') ?>
                </div>
            </div>
            <div class="right_side">
                <div class="close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                        <path d="M25.7076 24.2926C25.8005 24.3855 25.8742 24.4958 25.9245 24.6172C25.9747 24.7386 26.0006 24.8687 26.0006 25.0001C26.0006 25.1315 25.9747 25.2616 25.9245 25.383C25.8742 25.5044 25.8005 25.6147 25.7076 25.7076C25.6147 25.8005 25.5044 25.8742 25.383 25.9245C25.2616 25.9747 25.1315 26.0006 25.0001 26.0006C24.8687 26.0006 24.7386 25.9747 24.6172 25.9245C24.4958 25.8742 24.3855 25.8005 24.2926 25.7076L16.0001 17.4138L7.70757 25.7076C7.51993 25.8952 7.26543 26.0006 7.00007 26.0006C6.7347 26.0006 6.48021 25.8952 6.29257 25.7076C6.10493 25.5199 5.99951 25.2654 5.99951 25.0001C5.99951 24.7347 6.10493 24.4802 6.29257 24.2926L14.5863 16.0001L6.29257 7.70757C6.10493 7.51993 5.99951 7.26543 5.99951 7.00007C5.99951 6.7347 6.10493 6.48021 6.29257 6.29257C6.48021 6.10493 6.7347 5.99951 7.00007 5.99951C7.26543 5.99951 7.51993 6.10493 7.70757 6.29257L16.0001 14.5863L24.2926 6.29257C24.4802 6.10493 24.7347 5.99951 25.0001 5.99951C25.2654 5.99951 25.5199 6.10493 25.7076 6.29257C25.8952 6.48021 26.0006 6.7347 26.0006 7.00007C26.0006 7.26543 25.8952 7.51993 25.7076 7.70757L17.4138 16.0001L25.7076 24.2926Z"
                              fill="#222222"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>
    <div class="sale_fore_signup">
        <div class="close">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clip-path="url(#clip0_351_39585)">
                    <path d="M19.2806 18.2188C19.3502 18.2885 19.4055 18.3712 19.4432 18.4623C19.4809 18.5533 19.5003 18.6509 19.5003 18.7494C19.5003 18.848 19.4809 18.9456 19.4432 19.0366C19.4055 19.1277 19.3502 19.2104 19.2806 19.2801C19.2109 19.3498 19.1281 19.405 19.0371 19.4427C18.9461 19.4804 18.8485 19.4999 18.7499 19.4999C18.6514 19.4999 18.5538 19.4804 18.4628 19.4427C18.3717 19.405 18.289 19.3498 18.2193 19.2801L11.9999 13.0598L5.78055 19.2801C5.63982 19.4208 5.44895 19.4999 5.24993 19.4999C5.05091 19.4999 4.86003 19.4208 4.7193 19.2801C4.57857 19.1393 4.49951 18.9485 4.49951 18.7494C4.49951 18.5504 4.57857 18.3595 4.7193 18.2188L10.9396 11.9994L4.7193 5.78007C4.57857 5.63934 4.49951 5.44846 4.49951 5.24944C4.49951 5.05042 4.57857 4.85955 4.7193 4.71882C4.86003 4.57808 5.05091 4.49902 5.24993 4.49902C5.44895 4.49902 5.63982 4.57808 5.78055 4.71882L11.9999 10.9391L18.2193 4.71882C18.36 4.57808 18.5509 4.49902 18.7499 4.49902C18.949 4.49902 19.1398 4.57808 19.2806 4.71882C19.4213 4.85955 19.5003 5.05042 19.5003 5.24944C19.5003 5.44846 19.4213 5.63934 19.2806 5.78007L13.0602 11.9994L19.2806 18.2188Z"
                          fill="white"/>
                </g>
                <defs>
                    <clipPath id="clip0_351_39585">
                        <rect width="24" height="24" fill="white"/>
                    </clipPath>
                </defs>
            </svg>
        </div>
        <div class="modal_sale">
            <div class="modal_header">
                <h3><?php echo pll_e('Promoție pentru prieteni!!!') ?></h3>

            </div>
            <div class="modal_content">
                <p><?php echo pll_e('Devin-o membru și deblochează accesul nelimitat la recompense exclusive, cu și mai multe oportunități.') ?></p>
                <div class="sales">
                    <div class="block">
                        <div class="sales_count"><?php echo pll_e('-10% REDUCERE') ?></div>
                        <span><?php echo pll_e('Pentru tine') ?></span>
                    </div>
                    <div class="block">
                        <div class="sales_count"><?php echo pll_e('-10% REDUCERE') ?></div>
                        <span><?php echo pll_e('Pentru prieten') ?></span>
                    </div>
                </div>
                <?php
                if (!is_user_logged_in()) { ?>
                    <img src="/wp-content/themes/victor-child/assets/img/Content.png" alt="Content.png" loading="lazy">

                    <a href="#" class="button open_login_modal"><?php echo pll_e('Înregistrează-te') ?></a>

                <?php } else { ?>
                    <div class="coupon_code_wrap">
                        <input readonly type="text" value="<?php echo do_shortcode('[referral_link]') ?>"
                               id="coupon_code">
                        <button>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_458_18927)">
                                    <path d="M15 14.375V3.125C15 2.95924 14.9342 2.80027 14.8169 2.68306C14.6997 2.56585 14.5408 2.5 14.375 2.5L3.125 2.5C2.95924 2.5 2.80027 2.56585 2.68306 2.68306C2.56585 2.80027 2.5 2.95924 2.5 3.125V14.375C2.5 14.5408 2.56585 14.6997 2.68306 14.8169C2.80027 14.9342 2.95924 15 3.125 15H14.375C14.5408 15 14.6997 14.9342 14.8169 14.8169C14.9342 14.6997 15 14.5408 15 14.375ZM3.75 13.75V3.75L13.75 3.75V13.75H3.75ZM16.875 17.5H5.625C5.45924 17.5 5.30027 17.4342 5.18306 17.3169C5.06585 17.1997 5 17.0408 5 16.875C5 16.7092 5.06585 16.5503 5.18306 16.4331C5.30027 16.3158 5.45924 16.25 5.625 16.25H16.25V5.625C16.25 5.45924 16.3158 5.30027 16.4331 5.18306C16.5503 5.06585 16.7092 5 16.875 5C17.0408 5 17.1997 5.06585 17.3169 5.18306C17.4342 5.30027 17.5 5.45924 17.5 5.625V16.875C17.5 17.0408 17.4342 17.1997 17.3169 17.3169C17.1997 17.4342 17.0408 17.5 16.875 17.5Z"
                                          fill="#727272"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_458_18927">
                                        <rect width="20" height="20" fill="white" transform="matrix(0 1 -1 0 20 0)"/>
                                    </clipPath>
                                </defs>
                            </svg>
                            <span class="tooltiptext" id="myTooltip"><?php echo pll_e('Copie acest link') ?></span>
                        </button>
                    </div>
                    <div class="share_buttons">
                        <a href="https://api.whatsapp.com/send?text=<?php echo do_shortcode('[referral_link]') ?>"
                           target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M0 24L1.687 17.837C0.646 16.033 0.099 13.988 0.1 11.891C0.103 5.335 5.438 0 11.993 0C15.174 0.001 18.16 1.24 20.406 3.488C22.651 5.736 23.887 8.724 23.886 11.902C23.883 18.459 18.548 23.794 11.993 23.794C10.003 23.793 8.042 23.294 6.305 22.346L0 24ZM6.597 20.193C8.273 21.188 9.873 21.784 11.989 21.785C17.437 21.785 21.875 17.351 21.878 11.9C21.88 6.438 17.463 2.01 11.997 2.008C6.545 2.008 2.11 6.442 2.108 11.892C2.107 14.117 2.759 15.783 3.854 17.526L2.855 21.174L6.597 20.193ZM17.984 14.729C17.91 14.605 17.712 14.531 17.414 14.382C17.117 14.233 15.656 13.514 15.383 13.415C15.111 13.316 14.913 13.266 14.714 13.564C14.516 13.861 13.946 14.531 13.773 14.729C13.6 14.927 13.426 14.952 13.129 14.803C12.832 14.654 11.874 14.341 10.739 13.328C9.856 12.54 9.259 11.567 9.086 11.269C8.913 10.972 9.068 10.811 9.216 10.663C9.35 10.53 9.513 10.316 9.662 10.142C9.813 9.97 9.862 9.846 9.962 9.647C10.061 9.449 10.012 9.275 9.937 9.126C9.862 8.978 9.268 7.515 9.021 6.92C8.779 6.341 8.534 6.419 8.352 6.41L7.782 6.4C7.584 6.4 7.262 6.474 6.99 6.772C6.718 7.07 5.95 7.788 5.95 9.251C5.95 10.714 7.015 12.127 7.163 12.325C7.312 12.523 9.258 15.525 12.239 16.812C12.948 17.118 13.502 17.301 13.933 17.438C14.645 17.664 15.293 17.632 15.805 17.556C16.376 17.471 17.563 16.837 17.811 16.143C18.059 15.448 18.059 14.853 17.984 14.729Z"
                                      fill="#D6D6D6"/>
                            </svg>
                        </a>

                        <!--                        <a href="https://m.me/mybusinesspage?link=-->
                        <?php //echo do_shortcode('[referral_link]') ?><!--"-->
                        <!--                           target="_blank">-->
                        <!--                            <button style="background-color: #0084FF; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer;">-->
                        <!--                                Trimite pe Messenger-->
                        <!--                            </button>-->
                        <!--                        </a>-->
                        <a href="https://twitter.com/intent/tweet?text=<?php echo do_shortcode('[referral_link]') ?>"
                           target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M18.3263 1.90332H21.6998L14.3297 10.3268L23 21.7893H16.2112L10.894 14.8374L4.80995 21.7893H1.43443L9.31743 12.7794L1 1.90332H7.96111L12.7674 8.25765L18.3263 1.90332ZM17.1423 19.7701H19.0116L6.94539 3.81645H4.93946L17.1423 19.7701Z"
                                      fill="#727272"/>
                            </svg>
                        </a>
                        <a href="https://t.me/share/url?url=<?php echo do_shortcode('[referral_link]') ?>"
                           target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <g clip-path="url(#clip0_351_39605)">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M24 12C24 18.6274 18.6274 24 12 24C5.37258 24 0 18.6274 0 12C0 5.37258 5.37258 0 12 0C18.6274 0 24 5.37258 24 12ZM12.43 8.85893C11.2628 9.3444 8.93014 10.3492 5.43189 11.8733C4.86383 12.0992 4.56626 12.3202 4.53917 12.5363C4.49339 12.9015 4.95071 13.0453 5.57347 13.2411C5.65818 13.2678 5.74595 13.2954 5.83594 13.3246C6.44864 13.5238 7.27283 13.7568 7.70129 13.766C8.08994 13.7744 8.52373 13.6142 9.00264 13.2853C12.2712 11.079 13.9584 9.96381 14.0643 9.93977C14.139 9.92281 14.2426 9.90148 14.3128 9.96385C14.3829 10.0262 14.376 10.1443 14.3686 10.176C14.3233 10.3691 12.5281 12.0381 11.5991 12.9018C11.3095 13.171 11.1041 13.362 11.0621 13.4056C10.968 13.5033 10.8721 13.5958 10.78 13.6846C10.2108 14.2333 9.78391 14.6448 10.8036 15.3168C11.2936 15.6397 11.6858 15.9067 12.077 16.1731C12.5042 16.4641 12.9303 16.7543 13.4816 17.1157C13.6221 17.2077 13.7562 17.3034 13.8869 17.3965C14.3841 17.751 14.8307 18.0694 15.3826 18.0186C15.7032 17.9891 16.0345 17.6876 16.2027 16.7884C16.6002 14.6631 17.3816 10.0585 17.5622 8.16097C17.578 7.99473 17.5581 7.78197 17.5422 7.68857C17.5262 7.59518 17.4928 7.46211 17.3714 7.3636C17.2276 7.24694 17.0056 7.22234 16.9064 7.22408C16.455 7.23203 15.7626 7.47282 12.43 8.85893Z"
                                          fill="#D6D6D6"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_351_39605">
                                        <rect width="24" height="24" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </a>
                    </div>
                    <img src="/wp-content/themes/victor-child/assets/img/Content.png" alt="Content.png" loading="lazy">
                    <?php echo do_shortcode('[invited_users_list]') ?>
                <?php } ?>
            </div>
        </div>
        <div class="icon">
            <svg class="default" width="108" height="108" viewBox="0 0 108 108" fill="none"
                 xmlns="http://www.w3.org/2000/svg">
                <g filter="url(#filter0_d_295_36254)">
                    <rect x="15" y="10" width="78" height="78" rx="20" fill="#00E20F"/>
                    <g clip-path="url(#clip0_295_36254)">
                        <path d="M70.5 40.0026H63.9225C63.9956 39.9407 64.0706 39.8807 64.1419 39.8151C64.7113 39.3092 65.1703 38.6912 65.49 37.9998C65.8097 37.3085 65.9833 36.5585 66 35.797C66.0246 34.9639 65.8787 34.1345 65.5712 33.3598C65.2638 32.5852 64.8012 31.8815 64.2119 31.2921C63.6226 30.7026 62.9191 30.2398 62.1445 29.9321C61.3699 29.6244 60.5406 29.4782 59.7075 29.5026C58.9456 29.519 58.1954 29.6925 57.5036 30.0123C56.8119 30.332 56.1936 30.7911 55.6875 31.3607C54.9872 32.1724 54.4178 33.0884 54 34.0757C53.5822 33.0884 53.0128 32.1724 52.3125 31.3607C51.8064 30.7911 51.1881 30.332 50.4964 30.0123C49.8046 29.6925 49.0544 29.519 48.2925 29.5026C47.4594 29.4782 46.6301 29.6244 45.8555 29.9321C45.0809 30.2398 44.3774 30.7026 43.7881 31.2921C43.1988 31.8815 42.7362 32.5852 42.4288 33.3598C42.1213 34.1345 41.9754 34.9639 42 35.797C42.0167 36.5585 42.1903 37.3085 42.51 37.9998C42.8297 38.6912 43.2887 39.3092 43.8581 39.8151C43.9294 39.877 44.0044 39.937 44.0775 40.0026H37.5C36.7044 40.0026 35.9413 40.3187 35.3787 40.8813C34.8161 41.4439 34.5 42.207 34.5 43.0026V49.0026C34.5 49.7983 34.8161 50.5613 35.3787 51.1239C35.9413 51.6865 36.7044 52.0026 37.5 52.0026V64.0026C37.5 64.7983 37.8161 65.5613 38.3787 66.1239C38.9413 66.6865 39.7044 67.0026 40.5 67.0026H51.75C51.9489 67.0026 52.1397 66.9236 52.2803 66.7829C52.421 66.6423 52.5 66.4515 52.5 66.2526V49.0026H37.5V43.0026H52.5V49.0026H55.5V43.0026H70.5V49.0026H55.5V66.2526C55.5 66.4515 55.579 66.6423 55.7197 66.7829C55.8603 66.9236 56.0511 67.0026 56.25 67.0026H67.5C68.2957 67.0026 69.0587 66.6865 69.6213 66.1239C70.1839 65.5613 70.5 64.7983 70.5 64.0026V52.0026C71.2957 52.0026 72.0587 51.6865 72.6213 51.1239C73.1839 50.5613 73.5 49.7983 73.5 49.0026V43.0026C73.5 42.207 73.1839 41.4439 72.6213 40.8813C72.0587 40.3187 71.2957 40.0026 70.5 40.0026ZM45.8456 37.5651C45.5834 37.3276 45.373 37.0385 45.2278 36.7158C45.0826 36.3931 45.0057 36.0439 45.0019 35.6901C44.9924 35.2756 45.0657 34.8633 45.2176 34.4774C45.3695 34.0916 45.5969 33.7399 45.8864 33.4431C46.1759 33.1462 46.5218 32.9101 46.9037 32.7486C47.2856 32.5871 47.696 32.5035 48.1106 32.5026H48.2025C48.5563 32.5064 48.9055 32.5834 49.2282 32.7286C49.5508 32.8738 49.84 33.0841 50.0775 33.3464C51.6506 35.1239 52.2056 38.0714 52.4006 39.8939C50.5706 39.7007 47.625 39.1457 45.8456 37.5651ZM62.1581 37.5651C60.3787 39.1401 57.4256 39.6951 55.5956 39.8901C55.8187 37.9195 56.4375 35.0339 57.9375 33.3482C58.175 33.086 58.4642 32.8756 58.7868 32.7304C59.1095 32.5852 59.4587 32.5083 59.8125 32.5045H59.9044C60.3191 32.5071 60.7291 32.5924 61.1104 32.7555C61.4916 32.9186 61.8365 33.1561 62.1249 33.4542C62.4132 33.7523 62.6391 34.1049 62.7893 34.4914C62.9396 34.878 63.0112 35.2906 63 35.7051C62.9939 36.0565 62.9157 36.4029 62.7702 36.7229C62.6248 37.0428 62.4152 37.3295 62.1544 37.5651H62.1581Z"
                              fill="white"/>
                    </g>
                </g>
                <defs>
                    <filter id="filter0_d_295_36254" x="0" y="0" width="108" height="108" filterUnits="userSpaceOnUse"
                            color-interpolation-filters="sRGB">
                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                       result="hardAlpha"/>
                        <feOffset dy="5"/>
                        <feGaussianBlur stdDeviation="7.5"/>
                        <feColorMatrix type="matrix"
                                       values="0 0 0 0 0.184314 0 0 0 0 0.843137 0 0 0 0 0.231373 0 0 0 0.7 0"/>
                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_295_36254"/>
                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_295_36254" result="shape"/>
                    </filter>
                    <clipPath id="clip0_295_36254">
                        <rect width="48" height="48" fill="white" transform="translate(30 25)"/>
                    </clipPath>
                </defs>
            </svg>
            <svg class="hover" width="108" height="108" viewBox="0 0 108 108" fill="none"
                 xmlns="http://www.w3.org/2000/svg">
                <g filter="url(#filter0_d_295_36257)">
                    <rect x="15" y="10" width="78" height="78" rx="20" fill="#00E20F"/>
                    <g clip-path="url(#clip0_295_36257)">
                        <path d="M63.9225 40.0026H70.5C71.2957 40.0026 72.0587 40.3187 72.6213 40.8813C73.1839 41.4439 73.5 42.207 73.5 43.0026V49.0026C73.5 49.7983 73.1839 50.5613 72.6213 51.1239C72.0587 51.6865 71.2957 52.0026 70.5 52.0026V64.0026C70.5 64.7983 70.1839 65.5613 69.6213 66.1239C69.0587 66.6865 68.2957 67.0026 67.5 67.0026H56.25C56.0511 67.0026 55.8603 66.9236 55.7197 66.7829C55.579 66.6423 55.5 66.4515 55.5 66.2526V49.0026H52.5V66.2526C52.5 66.4515 52.421 66.6423 52.2803 66.7829C52.1397 66.9236 51.9489 67.0026 51.75 67.0026H40.5C39.7044 67.0026 38.9413 66.6865 38.3787 66.1239C37.8161 65.5613 37.5 64.7983 37.5 64.0026V52.0026C36.7044 52.0026 35.9413 51.6865 35.3787 51.1239C34.8161 50.5613 34.5 49.7983 34.5 49.0026V43.0026C34.5 42.207 34.8161 41.4439 35.3787 40.8813C35.9413 40.3187 36.7044 40.0026 37.5 40.0026H44.0775C44.0044 39.937 43.9294 39.877 43.8581 39.8151C43.2887 39.3092 42.8297 38.6912 42.51 37.9998C42.1903 37.3085 42.0167 36.5585 42 35.797C41.9754 34.9639 42.1213 34.1345 42.4288 33.3598C42.7362 32.5852 43.1988 31.8815 43.7881 31.2921C44.3774 30.7026 45.0809 30.2398 45.8555 29.9321C46.6301 29.6244 47.4594 29.4782 48.2925 29.5026C49.0544 29.519 49.8046 29.6925 50.4964 30.0123C51.1881 30.332 51.8064 30.7911 52.3125 31.3607C53.0128 32.1724 53.5822 33.0884 54 34.0757C54.4178 33.0884 54.9872 32.1724 55.6875 31.3607C56.1936 30.7911 56.8119 30.332 57.5036 30.0123C58.1954 29.6925 58.9456 29.519 59.7075 29.5026C60.5406 29.4782 61.3699 29.6244 62.1445 29.9321C62.9191 30.2398 63.6226 30.7026 64.2119 31.2921C64.8012 31.8815 65.2638 32.5852 65.5712 33.3598C65.8787 34.1345 66.0246 34.9639 66 35.797C65.9833 36.5585 65.8097 37.3085 65.49 37.9998C65.1703 38.6912 64.7113 39.3092 64.1419 39.8151C64.0706 39.8807 63.9956 39.9407 63.9225 40.0026Z"
                              fill="white"/>
                    </g>
                </g>
                <defs>
                    <filter id="filter0_d_295_36257" x="0" y="0" width="108" height="108" filterUnits="userSpaceOnUse"
                            color-interpolation-filters="sRGB">
                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                       result="hardAlpha"/>
                        <feOffset dy="5"/>
                        <feGaussianBlur stdDeviation="7.5"/>
                        <feColorMatrix type="matrix"
                                       values="0 0 0 0 0.184314 0 0 0 0 0.843137 0 0 0 0 0.231373 0 0 0 0.7 0"/>
                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_295_36257"/>
                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_295_36257" result="shape"/>
                    </filter>
                    <clipPath id="clip0_295_36257">
                        <rect width="48" height="48" fill="white" transform="translate(30 25)"/>
                    </clipPath>
                </defs>
            </svg>
            <svg class="active" width="108" height="108" viewBox="0 0 108 108" fill="none"
                 xmlns="http://www.w3.org/2000/svg">
                <g filter="url(#filter0_d_295_36260)">
                    <rect x="15" y="10" width="78" height="78" rx="20" fill="white"/>
                    <g clip-path="url(#clip0_295_36260)">
                        <path d="M63.9225 40.0026H70.5C71.2957 40.0026 72.0587 40.3187 72.6213 40.8813C73.1839 41.4439 73.5 42.207 73.5 43.0026V49.0026C73.5 49.7983 73.1839 50.5613 72.6213 51.1239C72.0587 51.6865 71.2957 52.0026 70.5 52.0026V64.0026C70.5 64.7983 70.1839 65.5613 69.6213 66.1239C69.0587 66.6865 68.2957 67.0026 67.5 67.0026H56.25C56.0511 67.0026 55.8603 66.9236 55.7197 66.7829C55.579 66.6423 55.5 66.4515 55.5 66.2526V49.0026H52.5V66.2526C52.5 66.4515 52.421 66.6423 52.2803 66.7829C52.1397 66.9236 51.9489 67.0026 51.75 67.0026H40.5C39.7044 67.0026 38.9413 66.6865 38.3787 66.1239C37.8161 65.5613 37.5 64.7983 37.5 64.0026V52.0026C36.7044 52.0026 35.9413 51.6865 35.3787 51.1239C34.8161 50.5613 34.5 49.7983 34.5 49.0026V43.0026C34.5 42.207 34.8161 41.4439 35.3787 40.8813C35.9413 40.3187 36.7044 40.0026 37.5 40.0026H44.0775C44.0044 39.937 43.9294 39.877 43.8581 39.8151C43.2887 39.3092 42.8297 38.6912 42.51 37.9998C42.1903 37.3085 42.0167 36.5585 42 35.797C41.9754 34.9639 42.1213 34.1345 42.4288 33.3598C42.7362 32.5852 43.1988 31.8815 43.7881 31.2921C44.3774 30.7026 45.0809 30.2398 45.8555 29.9321C46.6301 29.6244 47.4594 29.4782 48.2925 29.5026C49.0544 29.519 49.8046 29.6925 50.4964 30.0123C51.1881 30.332 51.8064 30.7911 52.3125 31.3607C53.0128 32.1724 53.5822 33.0884 54 34.0757C54.4178 33.0884 54.9872 32.1724 55.6875 31.3607C56.1936 30.7911 56.8119 30.332 57.5036 30.0123C58.1954 29.6925 58.9456 29.519 59.7075 29.5026C60.5406 29.4782 61.3699 29.6244 62.1445 29.9321C62.9191 30.2398 63.6226 30.7026 64.2119 31.2921C64.8012 31.8815 65.2638 32.5852 65.5712 33.3598C65.8787 34.1345 66.0246 34.9639 66 35.797C65.9833 36.5585 65.8097 37.3085 65.49 37.9998C65.1703 38.6912 64.7113 39.3092 64.1419 39.8151C64.0706 39.8807 63.9956 39.9407 63.9225 40.0026Z"
                              fill="#00E20F"/>
                    </g>
                </g>
                <defs>
                    <filter id="filter0_d_295_36260" x="0" y="0" width="108" height="108" filterUnits="userSpaceOnUse"
                            color-interpolation-filters="sRGB">
                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                       result="hardAlpha"/>
                        <feOffset dy="5"/>
                        <feGaussianBlur stdDeviation="7.5"/>
                        <feColorMatrix type="matrix"
                                       values="0 0 0 0 0.184314 0 0 0 0 0.843137 0 0 0 0 0.231373 0 0 0 0.7 0"/>
                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_295_36260"/>
                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_295_36260" result="shape"/>
                    </filter>
                    <clipPath id="clip0_295_36260">
                        <rect width="48" height="48" fill="white" transform="translate(30 25)"/>
                    </clipPath>
                </defs>
            </svg>

        </div>
    </div>
    <div class="fixed_icons">
        <div class="block">
            <div class="icons">
                <div class="mobile_wrap">
                    <div class="wrap_soc">
                        <a href="https://chat.whatsapp.com/I9azZsgOSXe7UMFsNkjvxV" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                 fill="none">
                                <path d="M0 32L2.24933 23.7827C0.861333 21.3773 0.132 18.6507 0.133333 15.8547C0.137333 7.11333 7.25067 0 15.9907 0C20.232 0.00133333 24.2133 1.65333 27.208 4.65067C30.2013 7.648 31.8493 11.632 31.848 15.8693C31.844 24.612 24.7307 31.7253 15.9907 31.7253C13.3373 31.724 10.7227 31.0587 8.40667 29.7947L0 32ZM8.796 26.924C11.0307 28.2507 13.164 29.0453 15.9853 29.0467C23.2493 29.0467 29.1667 23.1347 29.1707 15.8667C29.1733 8.584 23.284 2.68 15.996 2.67733C8.72667 2.67733 2.81333 8.58933 2.81067 15.856C2.80933 18.8227 3.67867 21.044 5.13867 23.368L3.80667 28.232L8.796 26.924ZM23.9787 19.6387C23.88 19.4733 23.616 19.3747 23.2187 19.176C22.8227 18.9773 20.8747 18.0187 20.5107 17.8867C20.148 17.7547 19.884 17.688 19.6187 18.0853C19.3547 18.4813 18.5947 19.3747 18.364 19.6387C18.1333 19.9027 17.9013 19.936 17.5053 19.7373C17.1093 19.5387 15.832 19.1213 14.3187 17.7707C13.1413 16.72 12.3453 15.4227 12.1147 15.0253C11.884 14.6293 12.0907 14.4147 12.288 14.2173C12.4667 14.04 12.684 13.7547 12.8827 13.5227C13.084 13.2933 13.1493 13.128 13.2827 12.8627C13.4147 12.5987 13.3493 12.3667 13.2493 12.168C13.1493 11.9707 12.3573 10.02 12.028 9.22667C11.7053 8.45467 11.3787 8.55867 11.136 8.54667L10.376 8.53333C10.112 8.53333 9.68267 8.632 9.32 9.02933C8.95733 9.42667 7.93333 10.384 7.93333 12.3347C7.93333 14.2853 9.35333 16.1693 9.55067 16.4333C9.74933 16.6973 12.344 20.7 16.3187 22.416C17.264 22.824 18.0027 23.068 18.5773 23.2507C19.5267 23.552 20.3907 23.5093 21.0733 23.408C21.8347 23.2947 23.4173 22.4493 23.748 21.524C24.0787 20.5973 24.0787 19.804 23.9787 19.6387Z"
                                      fill="#6A5E55"/>
                            </svg>
                        </a>
                    </div>
                    <div class="wrap_soc">
                        <a href="#" class="newsletter_open">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                 fill="none">
                                <path d="M28 6H4C3.73478 6 3.48043 6.10536 3.29289 6.29289C3.10536 6.48043 3 6.73478 3 7V24C3 24.5304 3.21071 25.0391 3.58579 25.4142C3.96086 25.7893 4.46957 26 5 26H27C27.5304 26 28.0391 25.7893 28.4142 25.4142C28.7893 25.0391 29 24.5304 29 24V7C29 6.73478 28.8946 6.48043 28.7071 6.29289C28.5196 6.10536 28.2652 6 28 6ZM16 16.6437L6.57125 8H25.4287L16 16.6437ZM12.3387 16L5 22.7262V9.27375L12.3387 16ZM13.8188 17.3563L15.3188 18.7375C15.5032 18.9069 15.7446 19.0008 15.995 19.0008C16.2454 19.0008 16.4868 18.9069 16.6712 18.7375L18.1712 17.3563L25.4212 24H6.57125L13.8188 17.3563ZM19.6612 16L27 9.2725V22.7275L19.6612 16Z"
                                      fill="#6A5E55"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="label_icon" id="newsletter">
                <svg xmlns="http://www.w3.org/2000/svg" width="38" height="28" viewBox="0 0 38 28" fill="none">
                    <path d="M34.9997 0.666656H8.33301C7.62576 0.666656 6.94749 0.947608 6.44739 1.4477C5.94729 1.9478 5.66634 2.62608 5.66634 3.33332V23.3333C5.66634 23.6869 5.52587 24.0261 5.27582 24.2761C5.02577 24.5262 4.68663 24.6667 4.33301 24.6667C3.97939 24.6667 3.64025 24.5262 3.3902 24.2761C3.14015 24.0261 2.99967 23.6869 2.99967 23.3333V7.33332C2.99967 6.9797 2.8592 6.64056 2.60915 6.39051C2.3591 6.14047 2.01996 5.99999 1.66634 5.99999C1.31272 5.99999 0.973581 6.14047 0.723532 6.39051C0.473484 6.64056 0.333008 6.9797 0.333008 7.33332V23.3517C0.337856 24.4093 0.761422 25.4221 1.51104 26.1682C2.26066 26.9144 3.27531 27.3333 4.33301 27.3333H33.6663C34.7272 27.3333 35.7446 26.9119 36.4948 26.1618C37.2449 25.4116 37.6663 24.3942 37.6663 23.3333V3.33332C37.6663 2.62608 37.3854 1.9478 36.8853 1.4477C36.3852 0.947608 35.7069 0.666656 34.9997 0.666656ZM28.333 18H14.9997C14.6461 18 14.3069 17.8595 14.0569 17.6095C13.8068 17.3594 13.6663 17.0203 13.6663 16.6667C13.6663 16.313 13.8068 15.9739 14.0569 15.7238C14.3069 15.4738 14.6461 15.3333 14.9997 15.3333H28.333C28.6866 15.3333 29.0258 15.4738 29.2758 15.7238C29.5259 15.9739 29.6663 16.313 29.6663 16.6667C29.6663 17.0203 29.5259 17.3594 29.2758 17.6095C29.0258 17.8595 28.6866 18 28.333 18ZM28.333 12.6667H14.9997C14.6461 12.6667 14.3069 12.5262 14.0569 12.2761C13.8068 12.0261 13.6663 11.6869 13.6663 11.3333C13.6663 10.9797 13.8068 10.6406 14.0569 10.3905C14.3069 10.1405 14.6461 9.99999 14.9997 9.99999H28.333C28.6866 9.99999 29.0258 10.1405 29.2758 10.3905C29.5259 10.6406 29.6663 10.9797 29.6663 11.3333C29.6663 11.6869 29.5259 12.0261 29.2758 12.2761C29.0258 12.5262 28.6866 12.6667 28.333 12.6667Z"
                          fill="white"/>
                </svg>
                <div class="tooltip">Newsletter</div>
            </div>
        </div>
        <div class="block">
            <div class="icons">
                <div class="mobile_wrap">
                    <div class="wrap_soc">
                        <?php $siteURL = get_site_url() ?>
                        <a href="https://api.whatsapp.com/send?text=<?= urlencode($siteURL) ?>" target="_blank">
                            <svg width="56" height="56" viewBox="0 0 56 56" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect width="56.0001" height="56" rx="28" fill="#00A814"/>
                                <path d="M10 46L12.5305 36.7555C10.969 34.0495 10.1485 30.982 10.15 27.8365C10.1545 18.0025 18.157 10 27.9895 10C32.761 10.0015 37.24 11.86 40.609 15.232C43.9765 18.604 45.8305 23.086 45.829 27.853C45.8245 37.6885 37.822 45.691 27.9895 45.691C25.0045 45.6895 22.063 44.941 19.4575 43.519L10 46ZM19.8955 40.2895C22.4095 41.782 24.8095 42.676 27.9835 42.6775C36.1555 42.6775 42.8125 36.0265 42.817 27.85C42.82 19.657 36.1945 13.015 27.9955 13.012C19.8175 13.012 13.165 19.663 13.162 27.838C13.1605 31.1755 14.1385 33.6745 15.781 36.289L14.2825 41.761L19.8955 40.2895ZM36.976 32.0935C36.865 31.9075 36.568 31.7965 36.121 31.573C35.6755 31.3495 33.484 30.271 33.0745 30.1225C32.6665 29.974 32.3695 29.899 32.071 30.346C31.774 30.7915 30.919 31.7965 30.6595 32.0935C30.4 32.3905 30.139 32.428 29.6935 32.2045C29.248 31.981 27.811 31.5115 26.1085 29.992C24.784 28.81 23.8885 27.3505 23.629 26.9035C23.3695 26.458 23.602 26.2165 23.824 25.9945C24.025 25.795 24.2695 25.474 24.493 25.213C24.7195 24.955 24.793 24.769 24.943 24.4705C25.0915 24.1735 25.018 23.9125 24.9055 23.689C24.793 23.467 23.902 21.2725 23.5315 20.38C23.1685 19.5115 22.801 19.6285 22.528 19.615L21.673 19.6C21.376 19.6 20.893 19.711 20.485 20.158C20.077 20.605 18.925 21.682 18.925 23.8765C18.925 26.071 20.5225 28.1905 20.7445 28.4875C20.968 28.7845 23.887 33.2875 28.3585 35.218C29.422 35.677 30.253 35.9515 30.8995 36.157C31.9675 36.496 32.9395 36.448 33.7075 36.334C34.564 36.2065 36.3445 35.2555 36.7165 34.2145C37.0885 33.172 37.0885 32.2795 36.976 32.0935Z"
                                      fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="wrap_soc">
                        <?php $siteURL = get_site_url() ?>
                        <a href="https://t.me/share/url?url=<?= urlencode($siteURL) ?>"
                           target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 52 52"
                                 fill="none">
                                <path d="M52 26C52 40.3594 40.3594 52 26 52C11.6406 52 0 40.3594 0 26C0 11.6406 11.6406 0 26 0C40.3594 0 52 11.6406 52 26ZM26.9319 19.1945C24.403 20.2463 19.3488 22.4234 11.7692 25.7256C10.5384 26.2151 9.89369 26.6939 9.835 27.1621C9.7358 27.9533 10.7267 28.2649 12.076 28.6892C12.2595 28.7469 12.4497 28.8067 12.6447 28.8701C13.9722 29.3016 15.7579 29.8064 16.6863 29.8265C17.5283 29.8447 18.4682 29.4975 19.5059 28.785C26.5876 24.0046 30.2433 21.5884 30.4728 21.5363C30.6347 21.4995 30.8591 21.4533 31.0111 21.5884C31.1631 21.7236 31.1482 21.9795 31.1321 22.0481C31.0339 22.4666 27.1444 26.0826 25.1316 27.9539C24.5041 28.5373 24.059 28.9511 23.968 29.0456C23.7641 29.2573 23.5564 29.4576 23.3568 29.6501C22.1235 30.839 21.1986 31.7305 23.408 33.1865C24.4697 33.8861 25.3193 34.4647 26.1669 35.0419C27.0925 35.6723 28.0158 36.301 29.2103 37.084C29.5146 37.2835 29.8053 37.4907 30.0884 37.6925C31.1656 38.4605 32.1334 39.1505 33.3291 39.0404C34.0238 38.9765 34.7415 38.3232 35.1059 36.3748C35.9673 31.7702 37.6603 21.7934 38.0516 17.6822C38.0859 17.322 38.0428 16.8611 38.0081 16.6587C37.9735 16.4563 37.9011 16.168 37.6381 15.9546C37.3266 15.7018 36.8457 15.6485 36.6306 15.6523C35.6527 15.6695 34.1523 16.1912 26.9319 19.1945Z"
                                      fill="url(#paint0_linear_801_1259)"/>
                                <defs>
                                    <linearGradient id="paint0_linear_801_1259" x1="26" y1="0" x2="26" y2="52"
                                                    gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#88C6FF"/>
                                        <stop offset="1" stop-color="#0085FF"/>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="label_icon" id="share">
                <svg xmlns="http://www.w3.org/2000/svg" width="31" height="37" viewBox="0 0 31 37" fill="none">
                    <path d="M30.6766 30.3553C30.6767 31.2311 30.4851 32.0962 30.1152 32.89C29.7454 33.6839 29.2063 34.3871 28.5357 34.9504C27.8651 35.5136 27.0794 35.9233 26.2337 36.1506C25.3879 36.3778 24.5027 36.4172 23.6401 36.2659C22.7775 36.1147 21.9585 35.7764 21.2406 35.2749C20.5227 34.7734 19.9232 34.1208 19.4844 33.363C19.0455 32.6051 18.7778 31.7604 18.7002 30.8881C18.6225 30.0158 18.7368 29.1371 19.0349 28.3137L10.2016 22.6387C9.35791 23.4662 8.28867 24.0262 7.12797 24.2484C5.96728 24.4705 4.76683 24.345 3.67721 23.8875C2.5876 23.43 1.65735 22.6609 1.00317 21.6767C0.348982 20.6926 0 19.5371 0 18.3553C0 17.1736 0.348982 16.0181 1.00317 15.034C1.65735 14.0498 2.5876 13.2807 3.67721 12.8232C4.76683 12.3657 5.96728 12.2402 7.12797 12.4623C8.28867 12.6845 9.35791 13.2445 10.2016 14.072L19.0349 8.40534C18.5291 7.01542 18.5531 5.48785 19.1024 4.11453C19.6517 2.74121 20.6878 1.61843 22.0126 0.960728C23.3374 0.303026 24.8581 0.15652 26.2841 0.549205C27.7102 0.941889 28.9415 1.84623 29.7429 3.08943C30.5443 4.33262 30.8595 5.8275 30.6283 7.28843C30.3972 8.74935 29.6358 10.0739 28.4898 11.0089C27.3437 11.944 25.8933 12.424 24.4157 12.3572C22.9381 12.2905 21.5369 11.6816 20.4799 10.647L11.6466 16.322C12.124 17.6413 12.124 19.0861 11.6466 20.4053L20.4799 26.0803C21.3233 25.2549 22.3913 24.6966 23.5504 24.4751C24.7095 24.2536 25.9082 24.3788 26.9965 24.8351C28.0847 25.2914 29.0143 26.0584 29.6689 27.0403C30.3235 28.0222 30.674 29.1753 30.6766 30.3553Z"
                          fill="white"/>
                </svg>
                <div class="tooltip"><?php echo pll_e('Distribuie') ?></div>
            </div>
        </div>
        <div class="block">
            <div class="icons">
                <div class="mobile_wrap">
                    <div class="wrap_soc">
                        <a href="#request_call">
                            <svg width="32" height="32" viewBox="0 0 32 32" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_1175_8508)">
                                    <path d="M18.913 3.95862C18.9512 3.81585 19.0171 3.682 19.1071 3.56472C19.197 3.44744 19.3091 3.34903 19.4371 3.27512C19.5651 3.2012 19.7064 3.15323 19.8529 3.13393C19.9995 3.11464 20.1484 3.12441 20.2911 3.16268C22.3767 3.70683 24.2795 4.79709 25.8036 6.32117C27.3276 7.84525 28.4179 9.74806 28.962 11.8336C29.0003 11.9764 29.0101 12.1253 28.9908 12.2718C28.9715 12.4183 28.9235 12.5596 28.8496 12.6876C28.7757 12.8156 28.6773 12.9277 28.56 13.0177C28.4427 13.1076 28.3089 13.1736 28.1661 13.2117C28.0711 13.2367 27.9733 13.2495 27.875 13.2497C27.6271 13.2497 27.3861 13.1678 27.1896 13.0168C26.993 12.8657 26.8518 12.654 26.788 12.4144C26.3442 10.7119 25.4544 9.15852 24.2103 7.91443C22.9662 6.67035 21.4128 5.78054 19.7103 5.33675C19.5674 5.29871 19.4334 5.23287 19.316 5.143C19.1986 5.05313 19.1 4.94099 19.0259 4.81299C18.9519 4.68499 18.9038 4.54365 18.8844 4.39705C18.865 4.25045 18.8747 4.10147 18.913 3.95862ZM18.5853 9.83675C20.5245 10.3542 21.7705 11.6002 22.288 13.5394C22.3518 13.779 22.493 13.9907 22.6896 14.1418C22.8861 14.2928 23.1271 14.3747 23.375 14.3747C23.4733 14.3745 23.5711 14.3617 23.6661 14.3367C23.8089 14.2986 23.9427 14.2326 24.06 14.1427C24.1773 14.0527 24.2757 13.9406 24.3496 13.8126C24.4235 13.6846 24.4715 13.5433 24.4908 13.3968C24.5101 13.2503 24.5003 13.1014 24.462 12.9586C23.742 10.2642 21.8605 8.38268 19.1661 7.66268C18.8778 7.58567 18.5707 7.62633 18.3124 7.77573C18.0541 7.92513 17.8657 8.17103 17.7887 8.45932C17.7117 8.74762 17.7523 9.05471 17.9017 9.31303C18.0511 9.57134 18.297 9.75973 18.5853 9.83675ZM30.1081 23.2453C29.8574 25.1509 28.9216 26.8999 27.4755 28.1659C26.0294 29.4319 24.1719 30.1282 22.25 30.1247C11.0844 30.1247 2.00001 21.0403 2.00001 9.87472C1.99657 7.95278 2.69285 6.09531 3.95883 4.64922C5.2248 3.20314 6.97388 2.26733 8.87939 2.01659C9.36124 1.95775 9.84921 2.05633 10.2704 2.29761C10.6917 2.53889 11.0236 2.90993 11.2166 3.35534L14.1866 9.98581V10.0027C14.3344 10.3436 14.3954 10.7159 14.3642 11.0862C14.3331 11.4565 14.2107 11.8133 14.008 12.1247C13.9827 12.1627 13.956 12.1978 13.9278 12.233L11 15.7036C12.0533 17.8439 14.292 20.063 16.4605 21.1191L19.8833 18.2067C19.9169 18.1785 19.9521 18.1522 19.9888 18.128C20.3 17.9204 20.658 17.7937 21.0305 17.7594C21.4029 17.725 21.7781 17.784 22.122 17.9311L22.1403 17.9396L28.7652 20.9082C29.2114 21.1005 29.5833 21.4321 29.8254 21.8534C30.0675 22.2747 30.1667 22.763 30.1081 23.2453ZM27.875 22.9641C27.875 22.9641 27.8652 22.9641 27.8595 22.9641L21.2502 20.0039L17.8259 22.9163C17.7927 22.9444 17.758 22.9707 17.7219 22.995C17.3981 23.211 17.0238 23.3394 16.6356 23.3675C16.2474 23.3956 15.8586 23.3225 15.507 23.1553C12.8731 21.8827 10.2477 19.2769 8.97361 16.6711C8.8049 16.3222 8.72919 15.9356 8.75383 15.5487C8.77847 15.1619 8.90261 14.788 9.11423 14.4633C9.13808 14.4252 9.16489 14.389 9.19439 14.355L12.125 10.8802L9.17189 4.27081C9.17133 4.2652 9.17133 4.25955 9.17189 4.25393C7.80818 4.43182 6.55609 5.10073 5.65009 6.13538C4.74409 7.17003 4.24633 8.49946 4.25001 9.87472C4.25522 14.647 6.15332 19.2224 9.52785 22.5969C12.9024 25.9714 17.4777 27.8695 22.25 27.8747C23.6244 27.8794 24.9535 27.3834 25.9888 26.4794C27.024 25.5753 27.6945 24.3252 27.875 22.9627V22.9641Z"
                                          fill="#6A5E55"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1175_8508">
                                        <rect width="32" height="32" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </a>
                    </div>
                    <!--                    <div class="wrap_soc">-->
                    <!--                        <a href="#">-->
                    <!--                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"-->
                    <!--                                 fill="none">-->
                    <!--                                <path d="M17.5 16C17.5 16.2967 17.412 16.5867 17.2472 16.8334C17.0824 17.08 16.8481 17.2723 16.574 17.3858C16.2999 17.4994 15.9983 17.5291 15.7074 17.4712C15.4164 17.4133 15.1491 17.2704 14.9393 17.0607C14.7296 16.8509 14.5867 16.5836 14.5288 16.2926C14.4709 16.0017 14.5006 15.7001 14.6142 15.426C14.7277 15.1519 14.92 14.9176 15.1666 14.7528C15.4133 14.588 15.7033 14.5 16 14.5C16.3978 14.5 16.7794 14.658 17.0607 14.9393C17.342 15.2207 17.5 15.6022 17.5 16ZM10.5 14.5C10.2033 14.5 9.91332 14.588 9.66664 14.7528C9.41997 14.9176 9.22771 15.1519 9.11418 15.426C9.00065 15.7001 8.97094 16.0017 9.02882 16.2926C9.0867 16.5836 9.22956 16.8509 9.43934 17.0607C9.64912 17.2704 9.91639 17.4133 10.2074 17.4712C10.4983 17.5291 10.7999 17.4994 11.074 17.3858C11.3481 17.2723 11.5824 17.08 11.7472 16.8334C11.912 16.5867 12 16.2967 12 16C12 15.6022 11.842 15.2207 11.5607 14.9393C11.2794 14.658 10.8978 14.5 10.5 14.5ZM21.5 14.5C21.2033 14.5 20.9133 14.588 20.6666 14.7528C20.42 14.9176 20.2277 15.1519 20.1142 15.426C20.0007 15.7001 19.9709 16.0017 20.0288 16.2926C20.0867 16.5836 20.2296 16.8509 20.4393 17.0607C20.6491 17.2704 20.9164 17.4133 21.2074 17.4712C21.4983 17.5291 21.7999 17.4994 22.074 17.3858C22.3481 17.2723 22.5824 17.08 22.7472 16.8334C22.912 16.5867 23 16.2967 23 16C23 15.6022 22.842 15.2207 22.5607 14.9393C22.2794 14.658 21.8978 14.5 21.5 14.5ZM29 16C29.0005 18.2444 28.4199 20.4507 27.3147 22.4042C26.2095 24.3576 24.6174 25.9917 22.6934 27.1473C20.7693 28.3029 18.5788 28.9407 16.3352 28.9985C14.0915 29.0564 11.8711 28.5324 9.89 27.4775L5.63375 28.8963C5.28136 29.0138 4.9032 29.0308 4.54166 28.9455C4.18012 28.8602 3.84948 28.6759 3.58681 28.4132C3.32414 28.1505 3.13982 27.8199 3.0545 27.4583C2.96918 27.0968 2.98623 26.7186 3.10375 26.3663L4.5225 22.11C3.59519 20.3665 3.07725 18.4347 3.008 16.4612C2.93875 14.4877 3.32001 12.5243 4.12284 10.7202C4.92567 8.91601 6.12897 7.31844 7.6414 6.04875C9.15383 4.77905 10.9356 3.8706 12.8516 3.39235C14.7675 2.9141 16.7672 2.87862 18.699 3.28859C20.6307 3.69857 22.4436 4.54324 24.0001 5.75847C25.5566 6.97371 26.8158 8.52757 27.6822 10.3021C28.5485 12.0767 28.9992 14.0253 29 16ZM27 16C26.9995 14.3127 26.6109 12.648 25.8641 11.1349C25.1174 9.62183 24.0325 8.3008 22.6935 7.27405C21.3545 6.2473 19.7973 5.54235 18.1422 5.21374C16.4872 4.88514 14.7787 4.94168 13.149 5.37901C11.5194 5.81633 10.0121 6.6227 8.74394 7.73575C7.47577 8.84879 6.48065 10.2387 5.83558 11.7978C5.1905 13.357 4.91277 15.0437 5.02387 16.7274C5.13496 18.4111 5.63191 20.0466 6.47625 21.5075C6.54712 21.6302 6.59112 21.7665 6.60534 21.9074C6.61956 22.0483 6.60368 22.1907 6.55875 22.325L5 27L9.675 25.4413C9.77683 25.4065 9.88367 25.3888 9.99125 25.3888C10.1669 25.3891 10.3393 25.4356 10.4912 25.5238C12.1635 26.4913 14.0611 27.0013 15.9931 27.0025C17.925 27.0038 19.8232 26.4961 21.4967 25.5307C23.1702 24.5653 24.5599 23.1762 25.526 21.5031C26.492 19.83 27.0004 17.932 27 16Z"-->
                    <!--                                      fill="#6A5E55"/>-->
                    <!--                            </svg>-->
                    <!--                        </a>-->
                    <!--                    </div>-->
                    <div class="wrap_soc">
                        <a href="<?php pll_e('/contact/') ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                 fill="none">
                                <path d="M28.7075 7.29249L24.7075 3.29249C24.6146 3.19952 24.5043 3.12576 24.3829 3.07543C24.2615 3.02511 24.1314 2.99921 24 2.99921C23.8686 2.99921 23.7385 3.02511 23.6171 3.07543C23.4957 3.12576 23.3854 3.19952 23.2925 3.29249L11.2925 15.2925C11.1997 15.3854 11.1261 15.4958 11.0759 15.6171C11.0257 15.7385 10.9999 15.8686 11 16V20C11 20.2652 11.1054 20.5196 11.2929 20.7071C11.4804 20.8946 11.7348 21 12 21H16C16.1314 21.0001 16.2615 20.9743 16.3829 20.9241C16.5042 20.8739 16.6146 20.8003 16.7075 20.7075L28.7075 8.70749C28.8005 8.61462 28.8742 8.50433 28.9246 8.38293C28.9749 8.26154 29.0008 8.13141 29.0008 7.99999C29.0008 7.86858 28.9749 7.73845 28.9246 7.61705C28.8742 7.49566 28.8005 7.38537 28.7075 7.29249ZM15.5863 19H13V16.4137L21 8.41374L23.5863 11L15.5863 19ZM25 9.58624L22.4138 6.99999L24 5.41374L26.5863 7.99999L25 9.58624ZM28 16V26C28 26.5304 27.7893 27.0391 27.4142 27.4142C27.0391 27.7893 26.5304 28 26 28H6C5.46957 28 4.96086 27.7893 4.58579 27.4142C4.21071 27.0391 4 26.5304 4 26V5.99999C4 5.46956 4.21071 4.96085 4.58579 4.58578C4.96086 4.21071 5.46957 3.99999 6 3.99999H16C16.2652 3.99999 16.5196 4.10535 16.7071 4.29289C16.8946 4.48042 17 4.73478 17 4.99999C17 5.26521 16.8946 5.51956 16.7071 5.7071C16.5196 5.89464 16.2652 5.99999 16 5.99999H6V26H26V16C26 15.7348 26.1054 15.4804 26.2929 15.2929C26.4804 15.1054 26.7348 15 27 15C27.2652 15 27.5196 15.1054 27.7071 15.2929C27.8946 15.4804 28 15.7348 28 16Z"
                                      fill="#6A5E55"/>
                            </svg>
                        </a>
                    </div>
                    <div class="wrap_soc">
                        <a href="#" id="open-whatsapp" class="open-whatsapp">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                 fill="none">
                                <path d="M0 32L2.24933 23.7827C0.861333 21.3773 0.132 18.6507 0.133333 15.8547C0.137333 7.11333 7.25067 0 15.9907 0C20.232 0.00133333 24.2133 1.65333 27.208 4.65067C30.2013 7.648 31.8493 11.632 31.848 15.8693C31.844 24.612 24.7307 31.7253 15.9907 31.7253C13.3373 31.724 10.7227 31.0587 8.40667 29.7947L0 32ZM8.796 26.924C11.0307 28.2507 13.164 29.0453 15.9853 29.0467C23.2493 29.0467 29.1667 23.1347 29.1707 15.8667C29.1733 8.584 23.284 2.68 15.996 2.67733C8.72667 2.67733 2.81333 8.58933 2.81067 15.856C2.80933 18.8227 3.67867 21.044 5.13867 23.368L3.80667 28.232L8.796 26.924ZM23.9787 19.6387C23.88 19.4733 23.616 19.3747 23.2187 19.176C22.8227 18.9773 20.8747 18.0187 20.5107 17.8867C20.148 17.7547 19.884 17.688 19.6187 18.0853C19.3547 18.4813 18.5947 19.3747 18.364 19.6387C18.1333 19.9027 17.9013 19.936 17.5053 19.7373C17.1093 19.5387 15.832 19.1213 14.3187 17.7707C13.1413 16.72 12.3453 15.4227 12.1147 15.0253C11.884 14.6293 12.0907 14.4147 12.288 14.2173C12.4667 14.04 12.684 13.7547 12.8827 13.5227C13.084 13.2933 13.1493 13.128 13.2827 12.8627C13.4147 12.5987 13.3493 12.3667 13.2493 12.168C13.1493 11.9707 12.3573 10.02 12.028 9.22667C11.7053 8.45467 11.3787 8.55867 11.136 8.54667L10.376 8.53333C10.112 8.53333 9.68267 8.632 9.32 9.02933C8.95733 9.42667 7.93333 10.384 7.93333 12.3347C7.93333 14.2853 9.35333 16.1693 9.55067 16.4333C9.74933 16.6973 12.344 20.7 16.3187 22.416C17.264 22.824 18.0027 23.068 18.5773 23.2507C19.5267 23.552 20.3907 23.5093 21.0733 23.408C21.8347 23.2947 23.4173 22.4493 23.748 21.524C24.0787 20.5973 24.0787 19.804 23.9787 19.6387Z"
                                      fill="#6A5E55"/>
                            </svg>
                            <?php echo do_shortcode('[elfsight_whatsapp_chat id="1"]') ?>

                        </a>
                    </div>
                </div>
            </div>
            <div class="label_icon" id="contacts">
                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                    <path d="M20.0063 4.76345e-07C16.553 -0.000753075 13.1584 0.892563 10.1527 2.593C7.14714 4.29343 4.63298 6.74305 2.85497 9.70343C1.07696 12.6638 0.0956853 16.0341 0.00665053 19.4862C-0.0823843 22.9383 0.723857 26.3547 2.3469 29.4028L0.163997 35.9515C-0.0168196 36.4937 -0.0430602 37.0756 0.0882159 37.6318C0.219492 38.1881 0.503097 38.6968 0.907243 39.101C1.31139 39.5051 1.82011 39.7887 2.37638 39.92C2.93265 40.0513 3.51448 40.025 4.05668 39.8442L10.6054 37.6613C13.2879 39.0881 16.2602 39.885 19.2967 39.9915C22.3331 40.0981 25.354 39.5115 28.1299 38.2762C30.9058 37.041 33.3638 35.1896 35.3174 32.8625C37.2709 30.5355 38.6687 27.794 39.4045 24.8461C40.1404 21.8982 40.195 18.8214 39.5642 15.8493C38.9334 12.8771 37.6338 10.0878 35.764 7.69288C33.8942 5.298 31.5034 3.36055 28.7731 2.02761C26.0428 0.69466 23.0446 0.00124672 20.0063 4.76345e-07ZM11.5439 22.3098C11.0875 22.3098 10.6413 22.1745 10.2617 21.9209C9.88219 21.6673 9.58638 21.3068 9.4117 20.8851C9.23702 20.4634 9.19132 19.9994 9.28037 19.5517C9.36942 19.104 9.58923 18.6927 9.91199 18.37C10.2348 18.0472 10.646 17.8274 11.0937 17.7384C11.5414 17.6493 12.0054 17.695 12.4271 17.8697C12.8489 18.0444 13.2093 18.3402 13.4629 18.7197C13.7165 19.0992 13.8518 19.5455 13.8518 20.0019C13.8518 20.614 13.6087 21.201 13.1759 21.6339C12.7431 22.0667 12.156 22.3098 11.5439 22.3098ZM20.0063 22.3098C19.5498 22.3098 19.1036 22.1745 18.7241 21.9209C18.3445 21.6673 18.0487 21.3068 17.8741 20.8851C17.6994 20.4634 17.6537 19.9994 17.7427 19.5517C17.8318 19.104 18.0516 18.6927 18.3743 18.37C18.6971 18.0472 19.1083 17.8274 19.556 17.7384C20.0037 17.6493 20.4678 17.695 20.8895 17.8697C21.3112 18.0444 21.6716 18.3402 21.9252 18.7197C22.1788 19.0992 22.3142 19.5455 22.3142 20.0019C22.3142 20.614 22.071 21.201 21.6382 21.6339C21.2054 22.0667 20.6184 22.3098 20.0063 22.3098ZM28.4686 22.3098C28.0122 22.3098 27.566 22.1745 27.1864 21.9209C26.8069 21.6673 26.5111 21.3068 26.3364 20.8851C26.1617 20.4634 26.116 19.9994 26.2051 19.5517C26.2941 19.104 26.5139 18.6927 26.8367 18.37C27.1595 18.0472 27.5707 17.8274 28.0184 17.7384C28.4661 17.6493 28.9301 17.695 29.3518 17.8697C29.7736 18.0444 30.134 18.3402 30.3876 18.7197C30.6412 19.0992 30.7766 19.5455 30.7766 20.0019C30.7766 20.614 30.5334 21.201 30.1006 21.6339C29.6678 22.0667 29.0807 22.3098 28.4686 22.3098Z"
                          fill="white"/>
                </svg>
                <div class="tooltip"><?php echo pll_e('Contactează-ne') ?></div>
            </div>
        </div>
        <div class="block mobile_block">
            <div class="cart_header">
                <svg xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 44 44" fill="none"
                     class="header_img">
                    <path d="M2.82406 7.71062C2.02375 7.71062 1.375 7.06188 1.375 6.26156C1.375 5.46125 2.02375 4.8125 2.82406 4.8125H9.41931C10.1171 4.8125 10.6998 5.30576 10.8377 5.96234L12.0071 10.3259H41.0184C41.5338 10.3259 41.9774 10.5467 42.2891 10.9576C42.6007 11.3685 42.6928 11.8553 42.553 12.3518L39.372 23.6568C39.1904 24.3023 38.6586 24.7472 37.9909 24.8119L16.4464 26.8914L17.0684 29.2133H38.1C38.9003 29.2133 39.549 29.862 39.549 30.6623C39.549 31.4627 38.9003 32.1114 38.1 32.1114H15.9577V32.1094C15.3181 32.1101 14.7327 31.6828 14.5596 31.0354L8.30932 7.70997H2.82471L2.82406 7.71062ZM34.2075 33.5324C35.7689 33.5324 37.0351 34.7985 37.0351 36.3599C37.0351 37.9214 35.7689 39.1875 34.2075 39.1875C32.6461 39.1875 31.38 37.9214 31.38 36.3599C31.38 34.7985 32.6461 33.5324 34.2075 33.5324ZM19.3301 33.5324C20.8916 33.5324 22.1577 34.7985 22.1577 36.3599C22.1577 37.9214 20.8916 39.1875 19.3301 39.1875C17.7687 39.1875 16.5026 37.9214 16.5026 36.3599C16.5026 34.7985 17.7687 33.5324 19.3301 33.5324Z"
                          fill="white"/>
                </svg>
                <?php $cart_count = WC()->cart->get_cart_contents_count();
                $cart_total = WC()->cart->get_cart_total()
                ?>
                <span class="count"><?php echo $cart_count ?></span>
                <span class="toatal"><?php echo $cart_total ?></span>
            </div>
        </div>
    </div>
    <div class="login_modal">
        <div class="log_in_page">
            <div class="close">
                <img src="/wp-content/themes/victor-child/assets/img/close.png" alt="close.png" loading="lazy">
            </div>
            <div class="container">
                <div class="forms">
                    <div class="form_content">
                        <div class="forms_header">
                            <ul>
                                <li class="log_in_tab active">Log in</li>
                                <li class="register_tab"><?php echo pll_e('Înregistrare') ?></li>
                            </ul>
                        </div>
                        <div class="tab log_in_tab">
                            <p class="subtitle subtitle_log_in"><?php echo pll_e('Pentru a te autentifica în profilul tău, creează un cont.') ?></p>
                            <?php echo do_shortcode('[custom_login]') ?>
                        </div>
                        <div class="tab register_tab">
                            <p class="subtitle subtitle_register"><?php echo pll_e('Pentru a te autentifica în profilul tău, creează un cont.') ?></p>
                            <?php echo do_shortcode('[custom_registration]') ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="request_reset_modal">
        <div class="request_reset">
            <h2><?php echo pll_e('Am uitat parola') ?></h2>
            <div class="close">
                <img src="/wp-content/themes/victor-child/assets/img/close.png" alt="close.png" loading="lazy">
            </div>
            <div class="form_content">
                <p class="subtitle subtitle_log_in"><?php echo pll_e('Te rugăm să ne scrii adresa de email la care a fost înregistrat contul tău, iar noi îți vom trimite un link de resetare a parolei.') ?></p>
                <form id="reset-password-form">
                    <input type="email" placeholder="E-mail" id="reset-email" name="reset-email" required>
                    <div class="form_footer">
                        <span><?php echo pll_e('Anulare') ?></span>
                        <button type="submit"><?php echo pll_e('Trimite') ?></button>
                    </div>
                </form>
                <p id="reset-password-message"></p>
            </div>
        </div>
    </div>

    <div class="reset_modal">
        <div class="reset">
            <h2><?php echo pll_e('Am uitat parola') ?></h2>
            <div class="close">
                <img src="/wp-content/themes/victor-child/assets/img/close.png" alt="close.png" loading="lazy">
            </div>
            <div class="form_content">
                <p class="subtitle subtitle_log_in"><?php echo pll_e('Te rugăm să resetezi parola.') ?></p>
                <form id="new-password-form">
                    <input type="hidden" id="reset-key" name="reset-key">
                    <input type="hidden" id="reset-login" name="reset-login">
                    <input type="password" placeholder="<?php echo pll_e('Parola Nouă:') ?>" id="new-password"
                           name="new-password" required>
                    <input type="password" placeholder="<?php echo pll_e('Repetare parolă nouă') ?>"
                           id="confirm-password" name="confirm-password" required>
                    <div class="form_footer">
                        <span><?php echo pll_e('Anulare') ?></span>
                        <button type="submit"><?php echo pll_e('Resetare') ?></button>
                    </div>
                </form>
                <p id="reset-password-message"></p>
            </div>
        </div>
    </div>


    <div class="mobile_modal_overlay" data-id="newsletter">
        <div class="modal_header">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clip-path="url(#clip0_1167_99073)">
                    <path d="M19.2806 18.2198C19.3502 18.2895 19.4055 18.3722 19.4432 18.4632C19.4809 18.5543 19.5003 18.6519 19.5003 18.7504C19.5003 18.849 19.4809 18.9465 19.4432 19.0376C19.4055 19.1286 19.3502 19.2114 19.2806 19.281C19.2109 19.3507 19.1281 19.406 19.0371 19.4437C18.9461 19.4814 18.8485 19.5008 18.7499 19.5008C18.6514 19.5008 18.5538 19.4814 18.4628 19.4437C18.3717 19.406 18.289 19.3507 18.2193 19.281L11.9999 13.0607L5.78055 19.281C5.63982 19.4218 5.44895 19.5008 5.24993 19.5008C5.05091 19.5008 4.86003 19.4218 4.7193 19.281C4.57857 19.1403 4.49951 18.9494 4.49951 18.7504C4.49951 18.5514 4.57857 18.3605 4.7193 18.2198L10.9396 12.0004L4.7193 5.78104C4.57857 5.64031 4.49951 5.44944 4.49951 5.25042C4.49951 5.05139 4.57857 4.86052 4.7193 4.71979C4.86003 4.57906 5.05091 4.5 5.24993 4.5C5.44895 4.5 5.63982 4.57906 5.78055 4.71979L11.9999 10.9401L18.2193 4.71979C18.36 4.57906 18.5509 4.5 18.7499 4.5C18.949 4.5 19.1398 4.57906 19.2806 4.71979C19.4213 4.86052 19.5003 5.05139 19.5003 5.25042C19.5003 5.44944 19.4213 5.64031 19.2806 5.78104L13.0602 12.0004L19.2806 18.2198Z"
                          fill="white"/>
                </g>
                <defs>
                    <clipPath id="clip0_1167_99073">
                        <rect width="24" height="24" fill="white"/>
                    </clipPath>
                </defs>
            </svg>
        </div>
        <div class="modal_content">
            <h3><?php echo pll_e('Newsletter') ?></h3>
            <a href="https://chat.whatsapp.com/I9azZsgOSXe7UMFsNkjvxV" target="_blank">
                <svg width="73" height="72" viewBox="0 0 73 72" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect x="0.5" width="72.0001" height="72" rx="36" fill="#00A814"/>
                    <path d="M13.3569 59.1431L16.6104 47.2574C14.6028 43.7782 13.5479 39.8343 13.5498 35.7901C13.5556 23.1464 23.8445 12.8574 36.4863 12.8574C42.6211 12.8594 48.3798 15.2489 52.7114 19.5843C57.041 23.9197 59.4247 29.6823 59.4228 35.8113C59.417 48.4569 49.1281 58.7459 36.4863 58.7459C32.6484 58.7439 28.8665 57.7816 25.5166 55.9533L13.3569 59.1431ZM26.0797 51.8011C29.312 53.72 32.3977 54.8694 36.4786 54.8714C46.9854 54.8714 55.5444 46.3201 55.5502 35.8074C55.5541 25.2736 47.0356 16.7339 36.494 16.73C25.9794 16.73 17.4262 25.2813 17.4224 35.792C17.4204 40.0831 18.6779 43.2961 20.7896 46.6576L18.863 53.693L26.0797 51.8011ZM48.0404 41.2634C47.8976 41.0242 47.5158 40.8815 46.9411 40.5941C46.3683 40.3068 43.5506 38.9201 43.0241 38.7292C42.4996 38.5383 42.1177 38.4419 41.7339 39.0166C41.3521 39.5894 40.2528 40.8815 39.9191 41.2634C39.5855 41.6452 39.2499 41.6934 38.6771 41.4061C38.1044 41.1187 36.2568 40.5151 34.0679 38.5614C32.3649 37.0417 31.2136 35.1652 30.8799 34.5905C30.5463 34.0177 30.8452 33.7072 31.1306 33.4218C31.3891 33.1653 31.7034 32.7526 31.9908 32.417C32.282 32.0853 32.3765 31.8461 32.5694 31.4624C32.7603 31.0805 32.6658 30.7449 32.5211 30.4576C32.3765 30.1721 31.2309 27.3506 30.7546 26.2031C30.2879 25.0865 29.8154 25.2369 29.4644 25.2196L28.3651 25.2003C27.9832 25.2003 27.3622 25.343 26.8376 25.9177C26.3131 26.4924 24.8319 27.8771 24.8319 30.6986C24.8319 33.5201 26.8859 36.2452 27.1713 36.6271C27.4586 37.0089 31.2116 42.7985 36.9607 45.2806C38.3281 45.8707 39.3965 46.2236 40.2277 46.4879C41.6009 46.9237 42.8506 46.862 43.838 46.7154C44.9392 46.5515 47.2284 45.3288 47.7067 43.9904C48.185 42.65 48.185 41.5025 48.0404 41.2634Z"
                          fill="white"/>
                </svg>
                <span>WhatsApp</span>
            </a>
            <a href="#" id="opne_newsletter_modal">
                <svg width="73" height="72" viewBox="0 0 73 72" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect x="0.5" width="72" height="72" rx="36" fill="white"/>
                    <g clip-path="url(#clip0_847_43405)">
                        <path d="M51.2272 23.7266H21.7727C21.4472 23.7266 21.135 23.8559 20.9049 24.086C20.6747 24.3162 20.5454 24.6283 20.5454 24.9538V45.8175C20.5454 46.4685 20.804 47.0928 21.2643 47.5531C21.7246 48.0134 22.349 48.272 23 48.272H50C50.6509 48.272 51.2753 48.0134 51.7356 47.5531C52.1959 47.0928 52.4545 46.4685 52.4545 45.8175V24.9538C52.4545 24.6283 52.3252 24.3162 52.095 24.086C51.8649 23.8559 51.5527 23.7266 51.2272 23.7266ZM36.5 36.7893L24.9283 26.1811H48.0716L36.5 36.7893ZM32.0066 35.9993L23 44.2542V27.7443L32.0066 35.9993ZM33.823 37.6638L35.6639 39.3589C35.8903 39.5668 36.1865 39.6821 36.4938 39.6821C36.8012 39.6821 37.0973 39.5668 37.3238 39.3589L39.1647 37.6638L48.0624 45.8175H24.9283L33.823 37.6638ZM40.9933 35.9993L50 27.7428V44.2558L40.9933 35.9993Z"
                              fill="#6A5E55"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_847_43405">
                            <rect width="39.2727" height="39.2727" fill="white" transform="translate(16.8638 16.3633)"/>
                        </clipPath>
                    </defs>
                </svg>
                <span>E-Mail</span>
            </a>
        </div>
    </div>
    <div class="mobile_modal_overlay" data-id="share">
        <div class="modal_header">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clip-path="url(#clip0_1167_99073)">
                    <path d="M19.2806 18.2198C19.3502 18.2895 19.4055 18.3722 19.4432 18.4632C19.4809 18.5543 19.5003 18.6519 19.5003 18.7504C19.5003 18.849 19.4809 18.9465 19.4432 19.0376C19.4055 19.1286 19.3502 19.2114 19.2806 19.281C19.2109 19.3507 19.1281 19.406 19.0371 19.4437C18.9461 19.4814 18.8485 19.5008 18.7499 19.5008C18.6514 19.5008 18.5538 19.4814 18.4628 19.4437C18.3717 19.406 18.289 19.3507 18.2193 19.281L11.9999 13.0607L5.78055 19.281C5.63982 19.4218 5.44895 19.5008 5.24993 19.5008C5.05091 19.5008 4.86003 19.4218 4.7193 19.281C4.57857 19.1403 4.49951 18.9494 4.49951 18.7504C4.49951 18.5514 4.57857 18.3605 4.7193 18.2198L10.9396 12.0004L4.7193 5.78104C4.57857 5.64031 4.49951 5.44944 4.49951 5.25042C4.49951 5.05139 4.57857 4.86052 4.7193 4.71979C4.86003 4.57906 5.05091 4.5 5.24993 4.5C5.44895 4.5 5.63982 4.57906 5.78055 4.71979L11.9999 10.9401L18.2193 4.71979C18.36 4.57906 18.5509 4.5 18.7499 4.5C18.949 4.5 19.1398 4.57906 19.2806 4.71979C19.4213 4.86052 19.5003 5.05139 19.5003 5.25042C19.5003 5.44944 19.4213 5.64031 19.2806 5.78104L13.0602 12.0004L19.2806 18.2198Z"
                          fill="white"/>
                </g>
                <defs>
                    <clipPath id="clip0_1167_99073">
                        <rect width="24" height="24" fill="white"/>
                    </clipPath>
                </defs>
            </svg>
        </div>
        <div class="modal_content">
            <?php $siteURL = get_site_url() ?>
            <h3><?php echo pll_e('Distribuie') ?></h3>
            <a href="https://api.whatsapp.com/send?text=<?= urlencode($siteURL) ?>" target="_blank">
                <svg width="72" height="72" viewBox="0 0 56 56" fill="none"
                     xmlns="http://www.w3.org/2000/svg">
                    <rect width="56.0001" height="56" rx="28" fill="#00A814"/>
                    <path d="M10 46L12.5305 36.7555C10.969 34.0495 10.1485 30.982 10.15 27.8365C10.1545 18.0025 18.157 10 27.9895 10C32.761 10.0015 37.24 11.86 40.609 15.232C43.9765 18.604 45.8305 23.086 45.829 27.853C45.8245 37.6885 37.822 45.691 27.9895 45.691C25.0045 45.6895 22.063 44.941 19.4575 43.519L10 46ZM19.8955 40.2895C22.4095 41.782 24.8095 42.676 27.9835 42.6775C36.1555 42.6775 42.8125 36.0265 42.817 27.85C42.82 19.657 36.1945 13.015 27.9955 13.012C19.8175 13.012 13.165 19.663 13.162 27.838C13.1605 31.1755 14.1385 33.6745 15.781 36.289L14.2825 41.761L19.8955 40.2895ZM36.976 32.0935C36.865 31.9075 36.568 31.7965 36.121 31.573C35.6755 31.3495 33.484 30.271 33.0745 30.1225C32.6665 29.974 32.3695 29.899 32.071 30.346C31.774 30.7915 30.919 31.7965 30.6595 32.0935C30.4 32.3905 30.139 32.428 29.6935 32.2045C29.248 31.981 27.811 31.5115 26.1085 29.992C24.784 28.81 23.8885 27.3505 23.629 26.9035C23.3695 26.458 23.602 26.2165 23.824 25.9945C24.025 25.795 24.2695 25.474 24.493 25.213C24.7195 24.955 24.793 24.769 24.943 24.4705C25.0915 24.1735 25.018 23.9125 24.9055 23.689C24.793 23.467 23.902 21.2725 23.5315 20.38C23.1685 19.5115 22.801 19.6285 22.528 19.615L21.673 19.6C21.376 19.6 20.893 19.711 20.485 20.158C20.077 20.605 18.925 21.682 18.925 23.8765C18.925 26.071 20.5225 28.1905 20.7445 28.4875C20.968 28.7845 23.887 33.2875 28.3585 35.218C29.422 35.677 30.253 35.9515 30.8995 36.157C31.9675 36.496 32.9395 36.448 33.7075 36.334C34.564 36.2065 36.3445 35.2555 36.7165 34.2145C37.0885 33.172 37.0885 32.2795 36.976 32.0935Z"
                          fill="white"/>
                </svg>
            </a>
            <a href="https://t.me/share/url?url=<?= urlencode($siteURL) ?>"
               target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="75" height="70" viewBox="0 0 52 52" fill="none">
                    <path d="M52 26C52 40.3594 40.3594 52 26 52C11.6406 52 0 40.3594 0 26C0 11.6406 11.6406 0 26 0C40.3594 0 52 11.6406 52 26ZM26.9319 19.1945C24.403 20.2463 19.3488 22.4234 11.7692 25.7256C10.5384 26.2151 9.89369 26.6939 9.835 27.1621C9.7358 27.9533 10.7267 28.2649 12.076 28.6892C12.2595 28.7469 12.4497 28.8067 12.6447 28.8701C13.9722 29.3016 15.7579 29.8064 16.6863 29.8265C17.5283 29.8447 18.4682 29.4975 19.5059 28.785C26.5876 24.0046 30.2433 21.5884 30.4728 21.5363C30.6347 21.4995 30.8591 21.4533 31.0111 21.5884C31.1631 21.7236 31.1482 21.9795 31.1321 22.0481C31.0339 22.4666 27.1444 26.0826 25.1316 27.9539C24.5041 28.5373 24.059 28.9511 23.968 29.0456C23.7641 29.2573 23.5564 29.4576 23.3568 29.6501C22.1235 30.839 21.1986 31.7305 23.408 33.1865C24.4697 33.8861 25.3193 34.4647 26.1669 35.0419C27.0925 35.6723 28.0158 36.301 29.2103 37.084C29.5146 37.2835 29.8053 37.4907 30.0884 37.6925C31.1656 38.4605 32.1334 39.1505 33.3291 39.0404C34.0238 38.9765 34.7415 38.3232 35.1059 36.3748C35.9673 31.7702 37.6603 21.7934 38.0516 17.6822C38.0859 17.322 38.0428 16.8611 38.0081 16.6587C37.9735 16.4563 37.9011 16.168 37.6381 15.9546C37.3266 15.7018 36.8457 15.6485 36.6306 15.6523C35.6527 15.6695 34.1523 16.1912 26.9319 19.1945Z"
                          fill="rgb(59, 161, 255)"></path>
                    <defs>
                        <linearGradient id="paint0_linear_801_1259" x1="26" y1="0" x2="26" y2="52"
                                        gradientUnits="userSpaceOnUse">
                            <stop stop-color="#88C6FF"></stop>
                            <stop offset="1" stop-color="#0085FF"></stop>
                        </linearGradient>
                    </defs>
                </svg>
            </a>
        </div>
    </div>
    <div class="mobile_modal_overlay" data-id="contacts">
        <div class="modal_header">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clip-path="url(#clip0_1167_99073)">
                    <path d="M19.2806 18.2198C19.3502 18.2895 19.4055 18.3722 19.4432 18.4632C19.4809 18.5543 19.5003 18.6519 19.5003 18.7504C19.5003 18.849 19.4809 18.9465 19.4432 19.0376C19.4055 19.1286 19.3502 19.2114 19.2806 19.281C19.2109 19.3507 19.1281 19.406 19.0371 19.4437C18.9461 19.4814 18.8485 19.5008 18.7499 19.5008C18.6514 19.5008 18.5538 19.4814 18.4628 19.4437C18.3717 19.406 18.289 19.3507 18.2193 19.281L11.9999 13.0607L5.78055 19.281C5.63982 19.4218 5.44895 19.5008 5.24993 19.5008C5.05091 19.5008 4.86003 19.4218 4.7193 19.281C4.57857 19.1403 4.49951 18.9494 4.49951 18.7504C4.49951 18.5514 4.57857 18.3605 4.7193 18.2198L10.9396 12.0004L4.7193 5.78104C4.57857 5.64031 4.49951 5.44944 4.49951 5.25042C4.49951 5.05139 4.57857 4.86052 4.7193 4.71979C4.86003 4.57906 5.05091 4.5 5.24993 4.5C5.44895 4.5 5.63982 4.57906 5.78055 4.71979L11.9999 10.9401L18.2193 4.71979C18.36 4.57906 18.5509 4.5 18.7499 4.5C18.949 4.5 19.1398 4.57906 19.2806 4.71979C19.4213 4.86052 19.5003 5.05139 19.5003 5.25042C19.5003 5.44944 19.4213 5.64031 19.2806 5.78104L13.0602 12.0004L19.2806 18.2198Z"
                          fill="white"/>
                </g>
                <defs>
                    <clipPath id="clip0_1167_99073">
                        <rect width="24" height="24" fill="white"/>
                    </clipPath>
                </defs>
            </svg>
        </div>
        <div class="modal_content">
            <h3><?php echo pll_e('Scrie-ne') ?></h3>
            <a href="#request_call">
                <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="60" height="60" rx="30" fill="white"/>
                    <g clip-path="url(#clip0_1167_98656)">
                        <path d="M32.6665 16.6434C32.7074 16.4905 32.778 16.3471 32.8744 16.2214C32.9708 16.0957 33.0909 15.9903 33.2281 15.9111C33.3652 15.8319 33.5166 15.7805 33.6736 15.7599C33.8305 15.7392 33.9901 15.7496 34.143 15.7907C36.3776 16.3737 38.4163 17.5418 40.0492 19.1747C41.6822 20.8077 42.8503 22.8464 43.4333 25.0809C43.4743 25.2339 43.4848 25.3934 43.4641 25.5504C43.4435 25.7074 43.392 25.8588 43.3129 25.9959C43.2337 26.133 43.1282 26.2532 43.0026 26.3496C42.8769 26.4459 42.7335 26.5166 42.5805 26.5575C42.4787 26.5843 42.3739 26.5979 42.2686 26.5982C42.003 26.5982 41.7448 26.5104 41.5342 26.3486C41.3236 26.1867 41.1724 25.9599 41.104 25.7032C40.6285 23.8791 39.6751 22.2148 38.3422 20.8818C37.0092 19.5489 35.3449 18.5955 33.5208 18.12C33.3677 18.0793 33.2241 18.0087 33.0983 17.9124C32.9724 17.8161 32.8668 17.696 32.7875 17.5588C32.7081 17.4217 32.6566 17.2703 32.6358 17.1132C32.6151 16.9561 32.6255 16.7965 32.6665 16.6434ZM32.3154 22.9414C34.3931 23.4959 35.7281 24.8308 36.2825 26.9086C36.3509 27.1652 36.5022 27.3921 36.7128 27.554C36.9234 27.7158 37.1816 27.8035 37.4472 27.8035C37.5525 27.8033 37.6573 27.7896 37.7591 27.7629C37.9121 27.7219 38.0555 27.6513 38.1811 27.5549C38.3068 27.4586 38.4122 27.3384 38.4914 27.2013C38.5706 27.0642 38.622 26.9128 38.6427 26.7558C38.6634 26.5988 38.6529 26.4392 38.6119 26.2863C37.8405 23.3995 35.8245 21.3835 32.9377 20.6121C32.6288 20.5296 32.2998 20.5731 32.023 20.7332C31.7462 20.8933 31.5444 21.1567 31.4619 21.4656C31.3793 21.7745 31.4229 22.1035 31.583 22.3803C31.7431 22.6571 32.0065 22.8589 32.3154 22.9414ZM44.6613 37.3078C44.3926 39.3494 43.39 41.2234 41.8406 42.5798C40.2912 43.9362 38.3011 44.6822 36.2419 44.6785C24.2787 44.6785 14.5454 34.9453 14.5454 22.9821C14.5417 20.9229 15.2878 18.9328 16.6442 17.3834C18.0005 15.834 19.8746 14.8314 21.9162 14.5627C22.4325 14.4997 22.9553 14.6053 23.4066 14.8638C23.8579 15.1223 24.2135 15.5198 24.4203 15.9971L27.6025 23.1011V23.1192C27.7608 23.4845 27.8262 23.8834 27.7928 24.2801C27.7594 24.6768 27.6283 25.0591 27.4111 25.3928C27.384 25.4335 27.3554 25.4712 27.3252 25.5088L24.1883 29.2274C25.3168 31.5206 27.7155 33.8981 30.0388 35.0297L33.7061 31.9093C33.7421 31.879 33.7798 31.8508 33.8191 31.8249C34.1525 31.6025 34.5361 31.4668 34.9352 31.43C35.3343 31.3931 35.7363 31.4564 36.1047 31.614L36.1243 31.623L43.2224 34.8037C43.7004 35.0097 44.099 35.365 44.3583 35.8164C44.6177 36.2678 44.724 36.791 44.6613 37.3078ZM42.2686 37.0064C42.2686 37.0064 42.2581 37.0064 42.2521 37.0064L35.1706 33.8348L31.5018 36.9552C31.4662 36.9854 31.429 37.0135 31.3903 37.0396C31.0434 37.271 30.6424 37.4085 30.2264 37.4386C29.8105 37.4687 29.3939 37.3904 29.0172 37.2114C26.1952 35.8478 23.3822 33.0559 22.0171 30.264C21.8364 29.8901 21.7553 29.4759 21.7817 29.0614C21.8081 28.647 21.9411 28.2464 22.1678 27.8985C22.1934 27.8576 22.2221 27.8188 22.2537 27.7825L25.3936 24.0594L22.2296 16.9779C22.229 16.9719 22.229 16.9659 22.2296 16.9599C20.7685 17.1504 19.4269 17.8671 18.4562 18.9757C17.4855 20.0842 16.9522 21.5086 16.9561 22.9821C16.9617 28.0953 18.9954 32.9974 22.611 36.613C26.2265 40.2286 31.1287 42.2622 36.2419 42.2678C37.7144 42.2729 39.1384 41.7414 40.2476 40.7728C41.3568 39.8042 42.0753 38.4648 42.2686 37.0049V37.0064Z"
                              fill="#6A5E55"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_1167_98656">
                            <rect width="40.9091" height="40.9091" fill="white" transform="translate(9.54541 9.54492)"/>
                        </clipPath>
                    </defs>
                </svg>
                <span><?php echo pll_e('Te sunăm') ?></span>
            </a>
            <a href="#" id="open-whatsapp" class="open-whatsapp">
                <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="60.0001" height="60" rx="30" fill="white"/>
                    <path d="M13.6357 46.364L15.9362 37.9599C14.5167 35.4999 13.7707 32.7113 13.7721 29.8517C13.7762 20.9117 21.0512 13.6367 29.9898 13.6367C34.3276 13.6381 38.3994 15.3276 41.4621 18.3931C44.5235 21.4585 46.2089 25.5331 46.2076 29.8667C46.2035 38.8081 38.9285 46.0831 29.9898 46.0831C27.2762 46.0817 24.6021 45.4013 22.2335 44.1085L13.6357 46.364ZM22.6317 41.1726C24.9171 42.5294 27.0989 43.3422 29.9844 43.3435C37.4135 43.3435 43.4653 37.2972 43.4694 29.864C43.4721 22.4158 37.4489 16.3776 29.9953 16.3749C22.5607 16.3749 16.513 22.4213 16.5103 29.8531C16.5089 32.8872 17.398 35.159 18.8912 37.5358L17.5289 42.5104L22.6317 41.1726ZM38.1594 33.7217C38.0585 33.5526 37.7885 33.4517 37.3821 33.2485C36.9771 33.0454 34.9848 32.0649 34.6126 31.9299C34.2417 31.7949 33.9717 31.7267 33.7003 32.1331C33.4303 32.5381 32.653 33.4517 32.4171 33.7217C32.1812 33.9917 31.9439 34.0258 31.5389 33.8226C31.1339 33.6194 29.8276 33.1926 28.2798 31.8113C27.0757 30.7367 26.2617 29.4099 26.0257 29.0035C25.7898 28.5985 26.0012 28.379 26.203 28.1772C26.3857 27.9958 26.608 27.704 26.8112 27.4667C27.0171 27.2322 27.0839 27.0631 27.2203 26.7917C27.3553 26.5217 27.2885 26.2844 27.1862 26.0813C27.0839 25.8794 26.2739 23.8844 25.9371 23.0731C25.6071 22.2835 25.273 22.3899 25.0248 22.3776L24.2476 22.364C23.9776 22.364 23.5385 22.4649 23.1676 22.8713C22.7967 23.2776 21.7494 24.2567 21.7494 26.2517C21.7494 28.2467 23.2017 30.1735 23.4035 30.4435C23.6067 30.7135 26.2603 34.8072 30.3253 36.5622C31.2921 36.9794 32.0476 37.229 32.6353 37.4158C33.6062 37.724 34.4898 37.6804 35.188 37.5767C35.9667 37.4608 37.5853 36.5963 37.9235 35.6499C38.2617 34.7022 38.2617 33.8908 38.1594 33.7217Z"
                          fill="#6A5E55"/>
                </svg>
                <span>WhatsApp</span>
            </a>
            <a href="<?php echo pll_e('/contacte/') ?>">
                <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="60" height="60" rx="30" fill="white"/>
                    <g clip-path="url(#clip0_847_43867)">
                        <path d="M42.9961 21.0959L38.9052 17.005C38.8102 16.9099 38.6974 16.8345 38.5732 16.783C38.4491 16.7316 38.316 16.7051 38.1816 16.7051C38.0472 16.7051 37.9141 16.7316 37.79 16.783C37.6658 16.8345 37.553 16.9099 37.458 17.005L25.1853 29.2778C25.0903 29.3728 25.0151 29.4856 24.9637 29.6098C24.9124 29.7339 24.886 29.867 24.8861 30.0013V34.0922C24.8861 34.3635 24.9939 34.6236 25.1857 34.8154C25.3775 35.0072 25.6376 35.115 25.9089 35.115H29.9998C30.1341 35.1151 30.2672 35.0887 30.3913 35.0374C30.5155 34.9861 30.6283 34.9108 30.7234 34.8158L42.9961 22.5431C43.0912 22.4481 43.1666 22.3353 43.2181 22.2112C43.2695 22.087 43.296 21.9539 43.296 21.8195C43.296 21.6851 43.2695 21.552 43.2181 21.4279C43.1666 21.3037 43.0912 21.1909 42.9961 21.0959ZM29.5766 33.0695H26.9316V30.4245L35.1134 22.2427L37.7584 24.8877L29.5766 33.0695ZM39.2043 23.4418L36.5593 20.7968L38.1816 19.1745L40.8266 21.8195L39.2043 23.4418ZM42.2725 30.0013V40.2286C42.2725 40.7711 42.057 41.2914 41.6734 41.675C41.2898 42.0586 40.7695 42.2741 40.2271 42.2741H19.7725C19.23 42.2741 18.7097 42.0586 18.3262 41.675C17.9426 41.2914 17.7271 40.7711 17.7271 40.2286V19.7741C17.7271 19.2316 17.9426 18.7113 18.3262 18.3277C18.7097 17.9441 19.23 17.7286 19.7725 17.7286H29.9998C30.271 17.7286 30.5312 17.8364 30.723 18.0282C30.9148 18.22 31.0225 18.4801 31.0225 18.7513C31.0225 19.0226 30.9148 19.2827 30.723 19.4745C30.5312 19.6663 30.271 19.7741 29.9998 19.7741H19.7725V40.2286H40.2271V30.0013C40.2271 29.7301 40.3348 29.47 40.5266 29.2782C40.7184 29.0864 40.9785 28.9786 41.2498 28.9786C41.521 28.9786 41.7812 29.0864 41.973 29.2782C42.1648 29.47 42.2725 29.7301 42.2725 30.0013Z"
                              fill="#6A5E55"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_847_43867">
                            <rect width="32.7273" height="32.7273" fill="white" transform="translate(13.6362 13.6367)"/>
                        </clipPath>
                    </defs>
                </svg>
                <span><?php echo pll_e('Contacte') ?></span>
            </a>
        </div>
    </div>
    <div class="request_call_overlay">
        <div class="request_call">
            <div class="modal_header">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_847_43383)">
                        <path d="M19.2806 18.2198C19.3502 18.2895 19.4055 18.3722 19.4432 18.4632C19.4809 18.5543 19.5003 18.6519 19.5003 18.7504C19.5003 18.849 19.4809 18.9465 19.4432 19.0376C19.4055 19.1286 19.3502 19.2114 19.2806 19.281C19.2109 19.3507 19.1281 19.406 19.0371 19.4437C18.9461 19.4814 18.8485 19.5008 18.7499 19.5008C18.6514 19.5008 18.5538 19.4814 18.4628 19.4437C18.3717 19.406 18.289 19.3507 18.2193 19.281L11.9999 13.0607L5.78055 19.281C5.63982 19.4218 5.44895 19.5008 5.24993 19.5008C5.05091 19.5008 4.86003 19.4218 4.7193 19.281C4.57857 19.1403 4.49951 18.9494 4.49951 18.7504C4.49951 18.5514 4.57857 18.3605 4.7193 18.2198L10.9396 12.0004L4.7193 5.78104C4.57857 5.64031 4.49951 5.44944 4.49951 5.25042C4.49951 5.05139 4.57857 4.86052 4.7193 4.71979C4.86003 4.57906 5.05091 4.5 5.24993 4.5C5.44895 4.5 5.63982 4.57906 5.78055 4.71979L11.9999 10.9401L18.2193 4.71979C18.36 4.57906 18.5509 4.5 18.7499 4.5C18.949 4.5 19.1398 4.57906 19.2806 4.71979C19.4213 4.86052 19.5003 5.05139 19.5003 5.25042C19.5003 5.44944 19.4213 5.64031 19.2806 5.78104L13.0602 12.0004L19.2806 18.2198Z"
                              fill="white"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_847_43383">
                            <rect width="24" height="24" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
            </div>
            <div class="left_side">
                <h2><?php echo pll_e('Te sunăm') ?></h2>
                <p><?php echo pll_e('Ai întâmpinat o problemă cu comanda și ai nevoie de ajutor? Lasă-ne nr de telefon și noi te contactăm!') ?></p>
                <div class="form">
                    <?php echo do_shortcode('[contact-form-7 id="f54d469" title="Call back"]') ?>
                </div>
            </div>
            <div class="right_side">
                <img src="/wp-content/themes/victor-child/assets/img/request_call.webp" alt="" loading="lazy">
                <div class="close">
                    <svg width="72" height="52" viewBox="0 0 72 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 0H52C63.0457 0 72 8.95431 72 20V52H20C8.95431 52 0 43.0457 0 32V0Z" fill="white"/>
                        <g clip-path="url(#clip0_1167_98972)">
                            <path d="M45.7076 34.2926C45.8005 34.3855 45.8742 34.4958 45.9245 34.6172C45.9747 34.7386 46.0006 34.8687 46.0006 35.0001C46.0006 35.1315 45.9747 35.2616 45.9245 35.383C45.8742 35.5044 45.8005 35.6147 45.7076 35.7076C45.6147 35.8005 45.5044 35.8742 45.383 35.9245C45.2616 35.9747 45.1315 36.0006 45.0001 36.0006C44.8687 36.0006 44.7386 35.9747 44.6172 35.9245C44.4958 35.8742 44.3855 35.8005 44.2926 35.7076L36.0001 27.4138L27.7076 35.7076C27.5199 35.8952 27.2654 36.0006 27.0001 36.0006C26.7347 36.0006 26.4802 35.8952 26.2926 35.7076C26.1049 35.5199 25.9995 35.2654 25.9995 35.0001C25.9995 34.7347 26.1049 34.4802 26.2926 34.2926L34.5863 26.0001L26.2926 17.7076C26.1049 17.5199 25.9995 17.2654 25.9995 17.0001C25.9995 16.7347 26.1049 16.4802 26.2926 16.2926C26.4802 16.1049 26.7347 15.9995 27.0001 15.9995C27.2654 15.9995 27.5199 16.1049 27.7076 16.2926L36.0001 24.5863L44.2926 16.2926C44.4802 16.1049 44.7347 15.9995 45.0001 15.9995C45.2654 15.9995 45.5199 16.1049 45.7076 16.2926C45.8952 16.4802 46.0006 16.7347 46.0006 17.0001C46.0006 17.2654 45.8952 17.5199 45.7076 17.7076L37.4138 26.0001L45.7076 34.2926Z"
                                  fill="#222222"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_1167_98972">
                                <rect width="32" height="32" fill="white" transform="translate(20 10)"/>
                            </clipPath>
                        </defs>
                    </svg>

                </div>
            </div>
        </div>
    </div>
    <div class="modal" data-id="contact_form_thank_you">
        <div class="modal_header">
            <h4><?php echo pll_e('Îți multumim pentru mesaj!') ?></h4>
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
        </div>
        <div class="modal_content">
            <p><?php echo pll_e('În cel mai scurt timp un reprezentat o sa vă contacteze!') ?></p>
        </div>
        <div class="modal_footer">
            <span class="close"><?php echo pll_e('Închide') ?></span>
        </div>
    </div>
    <div class="modal" data-id="newsletter_thank_you" id="newsletter_thank_you">
        <div class="modal_header">
            <h4><?php echo pll_e('Mulțumesc!') ?></h4>
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
        </div>
        <div class="modal_content">
            <p><?php echo pll_e('Îți multumim pentru abonare!') ?></p>
        </div>
        <div class="modal_footer">
            <span class="close"><?php echo pll_e('Închide') ?></span>
        </div>
    </div>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>

