<?php
/**
 * Template name: Retete
 *  Template post type: page
 */
?>
<?php get_header() ?>
<div class="archive_recipes">
    <div class="custom_recipe_header">
        <img src="/wp-content/themes/victor-child/assets/img/cart_header.webp" alt="cart_header.png"  loading="lazy">
    </div>
    <div class="breadcrumbs">
        <div class="container">
            <ul>
                <li><a href="/">Promez</a></li>
                <li>|</li>
                <li><a href="<?php if (pll_current_language() == 'ro') {
                        echo "/retete";
                    } elseif (pll_current_language() == 'en') {
                        echo "/en/recipes/";
                    } ?>"><?php echo pll_e('Rețete') ?></a>
                </li>
                <li>|</li>
                <li><span><?php the_category() ?></span></li>
            </ul>
        </div>
    </div>
    <div class="prod_page_recipes_wrap">
        <div class="container">
            <h3><?php echo pll_e('Rețete') ?></h3>
            <div class="prod_page_recipes">
                <div class="recipes">
                    <?php $paged = (get_query_var('paged')) ? get_query_var('paged') : 1; ?>
                    <?php
                    $category = get_queried_object(); // Obiectul categoriei curente

                    $data = new WP_Query(array(
                        'post_type' => 'post', // your post type name
                        'posts_per_page' => -1, // post per page
                        'paged' => $paged,
                        'order' => 'ASC',
                        'cat' => $category->term_id // filtrare după categoria actuală

                    ));
                    if ($data->have_posts()) :
                        while ($data->have_posts())  :
                            $data->the_post();
                            global $post; ?>
                            <div class="single_project" data-id="<?php
                            $terms = get_the_category();
                            foreach ($terms as $category) {
                                if ($category->cat_name == "grill") {
                                    echo "grill";
                                } elseif ($category->cat_name == "oven") {
                                    echo "oven";
                                } elseif ($category->cat_name == "Frying pan") {
                                    echo "frying-pan";
                                }
                            }
                            ?>">
                                <a href="<?php echo get_permalink() ?>" class="single_block">
                                    <div class="img_block">
                                        <?php if (has_post_thumbnail($data->ID)): ?>
                                            <?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($data->ID), 'single-post-thumbnail'); ?>
                                            <img src="<?php echo $image[0]; ?>" alt="" class="event-icon"  loading="lazy">
                                        <?php endif; ?>
                                    </div>
                                </a>

                                <div class="content">
                                    <div class="badge"><?php echo pll_e('Rețetă nouă') ?></div>
                                    <h4 class="title"><?= the_title() ?></h4>
                                    <div class="short_desc">
                                        <?php the_excerpt() ?>
                                    </div>
                                    <div class="recipe_by">
                                        <p><?php echo pll_e('Rețetă de') ?><?php the_field('recipe_by') ?></p>
                                        <span><?php the_field('recipe_by'); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    <?php endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php get_template_part('section-newsletter'); ?>
</div>
<?php get_footer() ?>
