jQuery(function ($) {
    $(document).ready(function () {

        var $miniCart = $('.woocommerce-mini-cart');
        var $arrows = $('.mini_cart .next, .mini_cart .prev'); // Selectează săgețile

        function toggleArrows() {
            // Verifică câte produse există în coș
            var productCount = $miniCart.find('.mini_cart_item').length;

            if (productCount < 2) {
                $arrows.hide(); // Ascunde săgețile
            } else {
                $arrows.show(); // Afișează săgețile
            }
        }

        toggleArrows();


        // Când un buton de adăugare în coș este apăsat
        $(document).on('click', '.add-to-cart-button', function () {

            var product_id = $(this).data('product-id');
            var quantity = $(this).data('quantity');
            $('#loading-spinner').show();
            $('.mobile_block').addClass('active')

            $.ajax({
                type: 'POST',
                url: '/wp-admin/admin-ajax.php',
                data: {
                    action: 'add_to_cart',
                    product_id: product_id,
                    quantity: quantity,
                },
                success: function (response) {
                    if (response.success) {
                        var new_quantity = response.data.new_quantity;
                        var subtotal = response.data.subtotal;
                        // console.log(product_id)
                        $('input[data-id=quantity_' + product_id + ']').val(new_quantity);
                        $('.product_notification_wrap[data-product_id="' + product_id + '"]').addClass('active')
                        $('.product_notification_wrap[data-product_id="' + product_id + '"] b').text(new_quantity)
                        $('.subtotal_notification.subtotal[data-product_id="' + product_id + '"]').addClass('active')
                        $('.subtotal_notification.subtotal[data-product_id="' + product_id + '"] ul li.quantity').text(new_quantity)
                        $('.subtotal_notification.subtotal[data-product_id="' + product_id + '"] ul li.price b').html(subtotal)
                        $('.cart_header .count').text(response.data.total_products);
                        $('.mini_cart_header span span').text(response.data.total_products);
                        $('.woocommerce-mini-cart__total span').html(response.data.cart_total);
                        $('.cart_header span.toatal').html(response.data.cart_total);
                        console.log(response.data.cart_total)

                        setTimeout(function () {
                            // $('.mini_cart').slideToggle();
                            var scrollAmount = 130; // Scroll fix de 131px

                            // Scroll "Next" (în jos)
                            $('.next').on('click', function () {
                                var $miniCart = $('.woocommerce-mini-cart');
                                var currentScrollTop = $miniCart.scrollTop();
                                var maxScrollTop = $miniCart[0].scrollHeight - $miniCart.outerHeight();

                                if (currentScrollTop < maxScrollTop) {
                                    $miniCart.stop(true).animate({
                                        scrollTop: currentScrollTop + scrollAmount
                                    }, 400); // 400ms pentru animația scroll-ului (poți ajusta timpul)
                                }
                            });

                            // Scroll "Prev" (în sus)
                            $('.prev').on('click', function () {
                                var $miniCart = $('.woocommerce-mini-cart');
                                var currentScrollTop = $miniCart.scrollTop();
                                if (currentScrollTop > 0) {
                                    $miniCart.stop(true).animate({
                                        scrollTop: currentScrollTop - scrollAmount
                                    }, 400); // 400ms pentru animația scroll-ului
                                }
                            });

                        }, 100); // Ajustează timeout-ul dacă este nevoie (0.5s)

                        $.ajax({
                            url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_refreshed_fragments'),
                            type: 'POST',
                            success: function (data) {
                                if (data && data.fragments) {
                                    $.each(data.fragments, function (key, value) {
                                        $('.mini_cart_body').html(value);
                                        $(key).replaceWith(value); // Înlocuiește fragmentul găsit
                                    });
                                    // Reîmprospătează mini coșul și alte elemente legate de coș
                                    $(document.body).trigger('wc_fragments_refreshed');
                                }
                            }
                        });

                        setTimeout(function () {
                            $('.subtotal_notification[data-product_id="' + product_id + '"]').removeClass('active');
                        }, 5000);
                    } else {
                        if (response.data && response.data.message) {
                            let stock = response.data.stock_quantity;
                            let current = response.data.current_quantity;
                            $('.stock_notification .stock_quantity').text(stock)
                            $('.stock_notification .in_cart').text(current)
                            $('.stock_notification[data-product_id="' + response.data.product_id + '"]').addClass('active')

                            setTimeout(function () {
                                $('.stock_notification[data-product_id="' + response.data.product_id + '"]').removeClass('active');
                            }, 7000);
                        }
                    }
                },
                complete: function () {
                    // Ascundem spinnerul când apelul AJAX este finalizat
                    $('#loading-spinner').hide();
                    $('.mobile_block').removeClass('active')

                }
            });

        });

        $(document).on('click', '.quantity-plus', function () {
            const productId = $(this).data('product-id');
            let qtyInput = $('input[data-id=quantity_' + productId + ']');
            let currentQty = parseInt(qtyInput.val());
            $('#loading-spinner').show();
            $('.mobile_block').addClass('active')

            // Verificăm dacă cantitatea curentă este 0
            if (currentQty === 0) {
                currentQty = 1; // Setăm la 1 dacă era 0
            } else {
                currentQty++; // Incrementăm cantitatea existentă
            }
            // Trimitem cererea AJAX
            $.ajax({
                url: '/wp-admin/admin-ajax.php', // URL-ul AJAX corect
                type: 'POST',
                data: {
                    action: 'update_cart_quantity',
                    product_id: productId,
                    quantity: currentQty
                },
                success: function (response) {
                    if (response.success) {
                        var subtotal = response.data.subtotal;
                        qtyInput.val(currentQty);
                        $('.product_notification_wrap[data-product_id="' + productId + '"]').addClass('active')
                        $('.product_notification_wrap[data-product_id="' + productId + '"] b').text(currentQty)
                        $('.subtotal_notification.subtotal[data-product_id="' + productId + '"]').addClass('active')
                        $('.subtotal_notification.subtotal[data-product_id="' + productId + '"] ul li.quantity').text(currentQty)
                        $('.subtotal_notification.subtotal[data-product_id="' + productId + '"] ul li.price b').html(subtotal)
                        $('.cart_header .count').text(response.data.total_products);
                        $('.woocommerce-mini-cart__total span').html(response.data.cart_total)
                        $('.mini_cart_header span span').text(response.data.total_products);
                        $('.cart_header span.toatal').html(response.data.cart_total)
                        $('body').trigger('update_checkout');


                        setTimeout(function () {

                            var scrollAmount = 130; // Scroll fix de 131px
                            // Scroll "Next" (în jos)
                            $('.next').on('click', function () {
                                var $miniCart = $('.woocommerce-mini-cart');
                                var currentScrollTop = $miniCart.scrollTop();
                                var maxScrollTop = $miniCart[0].scrollHeight - $miniCart.outerHeight();

                                if (currentScrollTop < maxScrollTop) {
                                    $miniCart.stop(true).animate({
                                        scrollTop: currentScrollTop + scrollAmount
                                    }, 400); // 400ms pentru animația scroll-ului (poți ajusta timpul)
                                }
                            });

                            // Scroll "Prev" (în sus)
                            $('.prev').on('click', function () {
                                var $miniCart = $('.woocommerce-mini-cart');
                                var currentScrollTop = $miniCart.scrollTop();
                                if (currentScrollTop > 0) {
                                    $miniCart.stop(true).animate({
                                        scrollTop: currentScrollTop - scrollAmount
                                    }, 400); // 400ms pentru animația scroll-ului
                                }
                            });


                        }, 100); // Ajustează timeout-ul dacă este nevoie (0.5s)

                        $.ajax({
                            url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_refreshed_fragments'),
                            type: 'POST',
                            success: function (data) {

                                if (data && data.fragments) {

                                    $.each(data.fragments, function (key, value) {
                                        $('.mini_cart_body').html(value);
                                        $(key).replaceWith(value); // Înlocuiește fragmentul găsit
                                    });
                                    // Reîmprospătează mini coșul și alte elemente legate de coș
                                    $(document.body).trigger('wc_fragments_refreshed');
                                }
                            }
                        });
                        setTimeout(function () {
                            $('.subtotal_notification[data-product_id="' + productId + '"]').removeClass('active');
                        }, 5000);
                    } else {
                        alert('A apărut o eroare.');
                    }
                },
                error: function (xhr, status, error) {
                    console.log('AJAX error:', xhr, status, error);
                },
                complete: function () {
                    // Ascundem spinnerul când apelul AJAX este finalizat
                    $('#loading-spinner').hide();
                    $('.mobile_block').removeClass('active')

                }
            });
        });

        $(document).on('click', '.quantity-minus', function () {
            const productId = $(this).data('product-id');
            let qtyInput = $('input[data-id=quantity_' + productId + ']');
            let currentQty = parseInt(qtyInput.val());
            $('.mobile_block').addClass('active')

            // Decrementăm doar dacă cantitatea este mai mare de 0
            if (currentQty > 0) {
                $('#loading-spinner').show();
                currentQty--; // Decrementăm cantitatea existentă
                // Trimitem cererea AJAX doar dacă cantitatea rămâne pozitivă
                $.ajax({
                    url: '/wp-admin/admin-ajax.php',
                    type: 'POST',
                    data: {
                        action: 'update_cart_quantity',
                        product_id: productId,
                        quantity: currentQty
                    },
                    success: function (response) {

                        if (response.success) {
                            var subtotal = response.data.subtotal;
                            qtyInput.val(currentQty);
                            $('.product_notification_wrap[data-product_id="' + productId + '"]').addClass('active')
                            $('.product_notification_wrap[data-product_id="' + productId + '"] b').text(currentQty)
                            $('.cart_header .count').text(response.data.total_products);
                            $('.subtotal_notification.subtotal[data-product_id="' + productId + '"] ul li.quantity').text(currentQty)
                            $('.subtotal_notification.subtotal[data-product_id="' + productId + '"] ul li.price b').html(subtotal)
                            $('.mini_cart_header span span').text(response.data.total_products);
                            $('.woocommerce-mini-cart__total span').html(response.data.cart_total)
                            $('.cart_header  span.toatal').html(response.data.cart_total)
                            $('.subtotal_notification.subtotal[data-product_id="' + productId + '"]').addClass('active')
                            $('body').trigger('update_checkout');

                            if (currentQty === 0) {
                                $('.product_notification_wrap[data-product_id="' + productId + '"]').removeClass('active')
                                $('.subtotal_notification.subtotal[data-product_id="' + productId + '"]').removeClass('active')
                                $('.mini_cart_body .woocommerce-mini-cart-item[data-product-id=' + productId + ']').remove();

                            }
                            $.ajax({
                                url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_refreshed_fragments'),
                                type: 'POST',
                                success: function (data) {

                                    if (data && data.fragments) {

                                        $.each(data.fragments, function (key, value) {
                                            $('.mini_cart_body').html(value);
                                            $(key).replaceWith(value); // Înlocuiește fragmentul găsit
                                        });
                                        // Reîmprospătează mini coșul și alte elemente legate de coș
                                        $(document.body).trigger('wc_fragments_refreshed');
                                    }
                                }
                            });
                        } else {
                            alert('A apărut o eroare.');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log('AJAX error:', xhr, status, error);
                        alert('A apărut o eroare: ' + error);
                    },
                    complete: function () {
                        // Ascundem spinnerul când apelul AJAX este finalizat
                        $('#loading-spinner').hide();
                        $('.mobile_block').removeClass('active')

                    }
                });
            }
        });


        // Când utilizatorul face click pe butonul de ștergere
        $(document).on('click', '.custom_remove_button', function (e) {
            e.preventDefault();
            $('#loading-spinner').show();
            $('.mobile_block').addClass('active')

            var product_id = $(this).data('product_id'); // Presupunem că ai product_id ca atribut de date

            $.ajax({
                type: 'POST',
                url: '/wp-admin/admin-ajax.php', // URL-ul AJAX în WooCommerce
                data: {
                    action: 'remove_product_from_cart',
                    product_id: product_id
                },
                success: function (response) {
                    if (response.success) {
                        $('.mini_cart_header span span').text(response.data.total_products);
                        $('.mini_cart_body .woocommerce-mini-cart-item[data-product-id=' + product_id + ']').remove();
                        $('.product_notification_wrap[data-product_id="' + product_id + '"]').removeClass('active')
                        $('.subtotal_notification[data-product_id="' + product_id + '"]').removeClass('active')
                        $('input[data-id=quantity_' + product_id + ']').val('0');
                        $('.woocommerce-mini-cart__total span').html(response.data.cart_total)
                        $('.cart_header .count').text(response.data.total_products);
                        $('.cart_header  span.toatal').html(response.data.cart_total)

                    } else {
                        alert('Eroare: ' + response.data);
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Eroare AJAX: ' + error);
                },
                complete: function () {
                    // Ascundem spinnerul când apelul AJAX este finalizat
                    $('#loading-spinner').hide();
                    $('.mobile_block').removeClass('active')

                }
            });
        });
    });
})
