jQuery(document).ready(function ($) {
    $('#custom_apply_coupon').on('click', function () {
        const couponCode = $('#custom_coupon_code').val();
        const feedback = $('#coupon_feedback');

        feedback.hide().text('');

        if (!couponCode) {
            feedback.text('Te rog introdu un cod de cupon.').show();
            return;
        }

        $.ajax({
            url: wc_checkout_params.ajax_url,
            type: 'POST',
            data: {
                action: 'custom_apply_coupon',
                coupon_code: couponCode,
                security: wc_checkout_params.apply_coupon_nonce // Nonce generat de WooCommerce
            },
            success: function (response) {
                if (response.success) {
                    feedback.css('color', 'green').text(response.data).show();
                    $(document.body).trigger('update_checkout'); // Actualizează checkout-ul
                } else {
                    feedback.css('color', 'red').text(response.data).show();
                }
            },
            error: function () {
                feedback.css('color', 'red').text('A apărut o eroare. Te rog încearcă din nou.').show();
            }
        });
    });
});
